# 0.7.92

https://github.com/spellcheck-ko/hunspell-dict-ko/releases/tag/0.7.92

내부적인 단어 정보 정리를 테스트하는 버전입니다.

## 변경 사항

- 데이터 정리
  - 단어 정보 처리 스크립트 정리
    - 불규칙용언 찾기, 합성용언 찾기, 제외할 단어 찾기, 단위명사 찾기
  - 한국어기초사전 업데이트 2019/08/13
  - 구 갈퀴 단어의 일부를 표준국어대사전 및 우리말샘 단어로 대체
    - 표준국어대사전 2019/06/25
    - 우리말샘 2019/08/21
    - 대체하는 과정에서 발견된 잘못된 항목 바로잡음
    - MPL/GPL/LGPL에서 라이선스 전환하지 않은 단어 22개
    - CC BY SA 라이선스로 전환한 단어 427개

- 기타
  - testsuite를 호스트에 설치된 hunspell 사전에 대해 실행할 수 있도록 조정
    - make hosttest HOST_DICT_PATH=/usr/share/hunspell/ko
    - 데비안 패키지 테스트 중 하나인 autopkgtest에서 사용
  - 문서 정리

# 0.7.91

https://github.com/spellcheck-ko/hunspell-dict-ko/releases/tag/0.7.91

내부적인 단어 정보 정리를 테스트하는 버전입니다. 기능상으로는 0.7.1과 큰
차이가 없습니다.

## 변경 사항

- 데이터 정리
  - 내부 포맷을 YAML로 통일
  - 단어 파일 수가 너무 많아서 첫 음절 기준으로 합침

- 활용
  - 호환 자모 뒤에 조사 ('ㄱ이', 'ㅏ는')

# 0.7.90

https://github.com/spellcheck-ko/hunspell-dict-ko/releases/tag/0.7.90

내부적인 단어 정보 정리를 테스트하는 버전입니다. 기능상으로는 0.7.1과 큰
차이가 없습니다.

## 변경 사항

- 단어 데이터 업데이트 (53833 단어)
  - 한국어기초사전: 2019년 6월 25일 기준
  - 중복, 쓰이지 않는 단어 제거 후 단어

- 외부 웹사이트를 통한 단어 데이터 관리 방식을 멈추고 모든 원본 단어 데이터를
  소스 코드에 포함.
  (https://github.com/spellcheck-ko/hunspell-dict-ko/issues/38)
  - https://github.com/spellcheck-ko/hunspell-dict-ko/tree/master/data/entries
  - 이제 수동 입력한 단어는 얼마 되지 않고 대부분의 단어가 국립국어원 사전에서
    가져온 단어라 다량의 데이터를 입력할 일이 적고, 0.7.0에서 개편한
    시맨틱위키 사용법이 오히려 참여의 장벽으로 작용하는 점이 있어 앞으로는
    github PR을 통해 받습니다.

# 0.7.1

https://github.com/spellcheck-ko/hunspell-dict-ko/releases/tag/0.7.1

## 변경 사항

- 보조용언 미리 만들지 않고 처리, 사전 크기 감소 및 효율 개선
- 복수접미사 '-들' 붙은 형태 미리 만들지 않고 처리, 사전 크기 감소 및 효율 개선
- 대명사 뒤에 붙는 특별한 조사 형태 추가 ('저' + '에게' -> '제게' 등)
- 0.6.2 이후 오류로 취급되는 단위 명사 붙여 쓰기 바로잡음
- 항상 같은 결과를 빌드하도록 (reproducible build) 개선
  - 랜덤한 파이썬 hash 결과에 따라 순서가 달라지지 않도록

## 기타

총 5개의 라이선스가 있는 상황을 단순화하기 위해 CC BY 4.0 및 CC BY-SA 2.0 KR
라이선스를 호환되는 CC BY-SA 4.0으로 업그레이드합니다.

0.7.0 버전 이후 hunspell 1.3.1 이상이 필요하고 hunspell 1.2.14 미만에서 사용할
수 있는 버전은 별도로 빌드해 릴리스하지 않습니다. 1.2.14 미만 버전에서 그대로
이용하면 hunspell이 이상 중지되거나 제대로 동작하지 않는 일이 발생합니다.
MacOS에 내장된 hunspell 1.2.8을 이용하려면 소스에서 config.py의 최소 버전을
수정해 빌드하십시오. 단 기능이 제한될 수 있습니다.

이 프로젝트에 대한 공개SW개발자Lab 글로벌오픈프론티어 프로그램의 지원은
2017년으로 종료됩니다.


# 0.7.0

https://github.com/spellcheck-ko/hunspell-dict-ko/releases/tag/0.7.0

## 변경 사항

- 갈퀴 업데이트 (53821 단어)
  - 국립국어원의 한국어기초사전 데이터 추가, 새로 추가된 단어는 약 22000 단어
  - 기타 어휘 정리

- 명사 및 보조사 세부 분류/속성에 대한 제한 완화 (#36)
  - 모든 명사에 '-들' 접사 허용
  - 모든 부사에 보조사 허용

-어/아로 시작하는 어미 정리
  - 으불규칙 별도로 기재하지 않아도 동작
    - 형태만 보고 동작할 수 있으므로 별도로 기재할 필요가 없다
  - '-하다' 형태 동사에 (여불규칙) '-았다' 동작하지 않도록
  - '오았다', '가았다' 등 허용
    - 일반적으로 쓰이지 않는 형태지만 문법상 가능한 활용

- hunspell 구 버전에서 오류 바로잡음: AM, AF 개수가 0이면 포함하지 않기 (#33)

## 기타

이제 기존의 MPL/GPL/LGPL 라이선스와 CC BY 4.0 라이선스에 더해, 국립국어원의
데이터가 포함되면서 크리에이티브 커먼즈 저작자표시-비영리-동일조건변경허락 (CC
BY-SA) 2.0 대한민국 라이선스도 사용됩니다.

이제 hunspell 1.2.14 미만에서 사용할 수 있는 버전은 별도로 빌드해 릴리스하지
않습니다. 1.2.14 미만 버전에서 그대로 이용하면 hunspell이 이상 중지되거나
제대로 동작하지 않는 일이 발생합니다. MacOS에 내장된 hunspell 1.2.8을
이용하려면 소스에서 config.py의 최소 버전을 수정해 빌드하십시오.

이제 갈퀴 사이트는 시맨틱 미디어위키 확장을 이용한 위키 사이트로 운영됩니다.
https://galkwi.pyok.org/


# 0.6.4

0.6.2에서 생긴 문제점을 바로잡는 릴리스 입니다.

https://github.com/spellcheck-ko/hunspell-dict-ko/releases/tag/0.6.4

## 변경 사항

- 누락된 숫자 + 조사, 알파벳 + 조사, 수사 + 조사
- VERSION에 프로젝트 URL (https://spellcheck-ko.github.io) 추가
- 유니코드 아닌 로캘에서 빌드 추가로 바로잡음

MacOS의 경우 아직도 hunspell 1.2.8 버전을 내장하고 있습니다. MacOS 내장 버전의
hunspell을 이용하려면 ko-aff-dic-0.6.4-for-hunspell-1.2.8.zip 파일을
이용하십시오.

# 0.6.3

- 0.6.2에서 생긴 문제점을 바로잡는 릴리스 입니다.
- 누락된 명사 + 조사 수정
- 누락된 명사 복수형 '-들' 수정

MacOS의 경우 아직도 hunspell 1.2.8 버전을 내장하고 있습니다. MacOS 내장 버전의
hunspell을 이용하려면 ko-aff-dic-0.6.3-for-hunspell-1.2.8.zip 파일을
이용하십시오.

# 0.6.2

https://github.com/spellcheck-ko/hunspell-dict-ko/releases

## 변경사항

- 갈퀴 데이터 업데이트 (32132 단어)

- 용언 활용 추가
  - 종결: '-냐',
  - '-어서였-', '-어서겠-': '-어서'에 과거/미래 선어말 어미가 붙은 형태
  - '-에나', '-에까지': '-에'에 보조사 붙은 형태
  - '-는지' 뒤에 조사

- 조사 추가
  - '-에의'
  - '-서'가 받침이 있는 숫자 뒤에 '-이서' 형태로 붙는 경우 ('둘이서' 등)
    (https://github.com/spellcheck-ko/hunspell-dict-ko/issues/16)
  - '-에나', '-에까지': 보조사 붙은 형태

## 사용과 무관한 사항

- 기타 문서 업데이트
- 단어 세부분류 반영 (https://github.com/spellcheck-ko/galkwi/issues/19)

# 0.6.1

변경 사항
---------

- 갈퀴 데이터 업데이트 (31979 단어)

- UTF-8이 아닌 로캘에서 빌드 바로잡음 (#26)


사용과 무관한 사항
-----------------

- 정리
  - 소스코드 정리
  - 문서 정리
  - 테스트 케이스 정리
  - 안 쓰는 파일 및 기능 제거
  - 홈페이지 URL 변경 <https://spellcheck-ko.github.io>

- 라이선스 변경
  - 기존 MPL/GPL/LGPL 라이선스 사전 항목과 CC-BY 4.0 라이선스 사전 항목 분리

- 개발 중인 내부 인코딩 기능


hunspell 1.2.8에서 사용하려면 ko-aff-dic-0.6.1-for-hunspell-1.2.8.zip
파일을 사용하십시오. MacOS 시스템에 있는 hunspell과 같이 사용하려면 이
버전을 사용하십시오.


# 0.6.0

- 갈퀴 데이터 업데이트 (31923 단어)
- 소스 코드
  - python3 사용
  - 프로젝트 페이지 변경
  - json 사용

이제 결과물인 ko.aff 및 ko.dic 파일은 hunspell 1.2.14 이상에 맞게
빌드합니다.

hunspell 1.2.8에서 사용하려면 ko-aff-dic-0.6.0-for-hunspell-1.2.8.zip
파일을 사용하십시오. MacOS 시스템에 있는 hunspell과 같이 사용하려면 이
버전을 사용하십시오.


# 0.5.6

- 갈퀴 데이터 업데이트 (31736 단어)
- 용언 활용 추가
  - 종결: -다네 (형용사에 대해)
- 소스 압축 형식 xz 포맷으로 변경

아직 ko.aff/ko.dic 파일은 1.2.8에 맞게 빌드한 버전입니다. 1.2.14 이상 버
전에서 사용할 수 있는 기능을 이용하려면 소스에서 빌드하십시오.


# 0.5.5

- 갈퀴 데이터 업데이트 (31507 단어)
  - 2011년 8월 31일 국어대사전 추가 내용 (짜장면 등)
- 용언 활용 추가
  - 연결: -길래 (2011년 8월 31일 국어대사전 추가)

아직 ko.aff/ko.dic 파일은 1.2.8에 맞게 빌드한 버전입니다. 1.2.14 이상 버
전에서 사용할 수 있는 기능을 이용하려면 소스에서 빌드하십시오.


# 0.5.4

- 갈퀴 데이터 업데이트 (31425 단어)
- 순우리말 수사 붙여쓰기
  - '스물여섯' 등
  - 갈퀴 데이터에서 해당 단어 제외
- 용언 활용 추가
  - 종결: -(으)리
  - 연결: -은들(ㄴ들)

아직 ko.aff/ko.dic 파일은 1.2.8에 맞게 빌드한 버전입니다. 1.2.14 이상 버
전에서 사용할 수 있는 기능을 이용하려면 소스에서 빌드하십시오. 


# 0.5.3

- 갈퀴 데이터 업데이트 (31217 단어)
- 조사 추가
  - '-(으)로밖에'
- 대치어 규칙 추가
  - 사이시옷 관련 (숫개 -> 수캐, 숫돼지 -> 수퇘지)
  - 두음법칙 관련
- 용언 활용
  - 으불규칙 예외로 '*트다' 추가 (싹트다 -> 싹텄다)

아직 ko.aff/ko.dic 파일은 1.2.8에 맞게 빌드한 버전입니다. 1.2.14 이상 버
전에서 사용할 수 있는 기능을 이용하려면 소스에서 빌드하십시오. 


# 0.5.2

- 갈퀴 데이터 업데이트 (31111 단어)
- 조사 추가
  - 에야
  - 보조사 추가 형태: '-(으)로의', '-(으)로서의', '-(으)로부터의',
    '-(으)로부터도', '-에라도'
- 용언 활용 추가
  - 종결: -대, -더구나, -(으)라면서
  - 연결: -자 (형용사 및 '이다'), -다느니, -는다느니, -다가는, -다기보다는
  - 종결: -(으)라며, -던가
  - 받침으로 끝나는 준말 용언 뒤에 모음으로 시작하는 금지 어미 추가

소스 코드:
- 숫자 만 단위 띄어쓰기 사용
  - hunspell 1.2.14 이상 필요
- 빌드할 때 필요한 최소 hunspell 버전 지정 기능
- 보조 용언 확장할 때 빌드 속도 향상

참고로 아직 ko.aff/ko.dic 파일은 1.2.8에 맞게 빌드했습니다. hunspell 커
맨드라인을 실행하면 다음과 같이 최소 버전을 알 수 있습니다.

$ hunspell -d ko
Hunspell 1.2.14 - hunspell-dict-ko 0.5.2 (requires Hunspell 1.2.8)


# 0.5.1

- 갈퀴 데이터 업데이트 (30997 단어) 


# 0.5.0

- 갈퀴 데이터 업데이트 (30721 단어)


# 0.4.3

- 갈퀴 데이터 업데이트 (30419 단어)
- 대치어 규칙 추가
  - '-고픈' => '-고 싶은'
  - '-다더니' => '-다 하더니'
  - ㅊ 받침, ㄹㄱ 받침
- 용언 활용 추가
  - 연결: -고서, -고자, -건, -(으)라면, -던지
  - 종결: -는대, -데, -(으)마, -던지
- 조사 추가
  - '은(는)커녕', '(이)야말로', '끼리', '만큼', '커녕'
- 일반 명사에 대해 '-ㄴ', '-ㄹ' 등 받침만 있는 구어체 조사 허용
- 준말용언 속성 구현
  - '준말용언' 속성이 들어간 용언은 모음으로 시작하는 어미 금지


# 0.4.2

- 갈퀴 데이터 업데이트 (30229단어)


# 0.4.1

- 갈퀴 데이터 업데이트 (전체 29789 단어)
- '하다'의 준말 형태에서 앞의 음절 유성음/무성음 구별 누락된 부분 수정
  - -하기, -하기로, -하도록, -하지, -하지만
- '-있다' 형태 형용사에 '-ㅣㅆ다'만 검사 ('재밌는')


# 0.4.0

- 갈퀴 데이터 업데이트 (전체 28677 단어)
- 입력된 데이터에 한해 부사 뒤에 보조사 동작


# 0.3.5

0.3.4는 없습니다.
- 갈퀴 데이터 업데이트
- 부사 뒤에 보조사 허용 규칙 추가 (동작하려면 앞으로 부사 세부 분류 입력
  필요)
  - 상태부사, 성상부사, 정도부사, 양태부사만 보조사 허용
  - 부사 세부 분류 필요
- 품사 및 속성 설명 개선, 품사 세부 분류 설명 추가
- 아라비아 숫자+만 단위 규칙 추가
  - "300만", "50억"
  - tokenizer에서 아라비아 숫자를 포함하지 않는 (대부분) 프로그램은 해
    당 없음


# 0.3.3

- 갈퀴 DB 데이터 업데이트
- 두벌식 오타 추천 규칙 추가  
  - ㅇ벗어 => 없어, 젭라 => 제발
  - 테스트 케이스 추가


# 0.3.2

- 갈퀴 DB 데이터 업데이트
- 이름은 CREDITS 파일에 통일, 소스 파일마다 표기하지 않도록
- 조사 추가
- 용언 활용 업데이트
  - 보조사 '는'이 'ㄴ' 받침으로 줄여진 형태
  - 유성음/무성음에 따라 달라지는 활용
    - '-하게'가 '-케'가 되는 유성음 뒤에서만 일어나도록
    - 어미 '-건대' 추가, 마찬가지로 유성음 뒤에서만 '-하건대'를 '-컨대'
      로 줄임.
- 대치 규칙 추가
- 정리
  - 테스트 프로그램 다시 작성
  - 코드에 아직 남아 있는 유니코드 값을 이름으로 변경


# 0.3.1

- 갈퀴 DB 데이터 업데이트
  - credit 관리를 위해 <editors> 태그에 과거 편집자 기록
- 대치어 규칙 추가
  - ㅂ불규칙: 으 -> 우
  - ㅅㅎ -> ㅌ
- 용언 활용 업데이트
  - 어미 추가: '-답니다', '-는답니다', '-을세', '-요', '-을라'
  - 모음이 'ㅑ' 음절인 뒤에 '-어'가 아니라 '-아' 어미로 바로잡음
  - 보조사 '-는'이 붙은 준말 형태 추가
  - '-으래도' 불규칙 활용 잘못된 부분 바로잡음
  - 보조사 붙은 형태 추가
- 조사 규칙 업데이트
  - '저'+'가' => '제가', '저'+'의' => '제'
  - '누구'+'가' => '누가'


# 0.3.0

- 갈퀴 데이터 업데이트
- 용언 활용 규칙 추가
- 대치 규칙 추가
- 앞에 오는 단어의 종류에 따라 (특히 대명사) 조사 허용 여부가 달라짐.
  (너+가 => 너가(x)/네가(o) 등)
- 표준어 규정에 따라 용언+용언 형태의 합성 용언의 경우 보조 용언 붙여
  쓰기를 금지. '용언합성' 속성 필요.


# 0.2.4

- 갈퀴 데이터 업데이트
- 어미 규칙 추가
- 연철/분철 발음을 혼동할 때 나타나는 오타 대치어


# 0.2.3

- 갈퀴 데이터 업데이트
- 보조사 추가
- 두벌식 오타에 대한 대치어 추가


# 0.2.2

- 갈퀴 DB에서 용어 업데이트
- 조사 추가
- 용언 활용 추가
- 대치어 개선 - 잘못 쓴 불규칙용언 활용의 대치어 추가
- 대치어 개선 - 중성 자모를 초/중성보다 우선 순위가 높게 대치


# 0.2.1

- 데이터 업데이트
- 거라불규칙/너라불규칙 삭제하고 규칙 허용, "-거라" 어미 추가 (#3)
- 아라비아 숫자에 대해 조사 허용 ("3을")
- README 설명 추가
- 용언 활용 개선 및 추가
- "-하빈다", "-스빈다" 두벌식 오타에 대한 대치어, 빈 => ㅂ니 (#11)
- "특수:단위" 품사 삭제, "단위명사" 속성으로 대체. 맞게 데이터 업데이트
- twofold suffix class flag에도 alias 적용, 명사형+조사 다시 동작 (#10)


# 0.2.0

- 단어 업데이트
- aff/dic 파일 생성 하나로 통일, AF 사용해 사전 파일 크기 줄임 (#9)
- 리을탈락 누락된 부분 보충 & '오아' 형태는 '와'로 축약된 형태만 허용

