; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main -mattr=+mve -verify-machineinstrs -o - %s | FileCheck %s

define i64 @test_asrl(i64 %value, i32 %shift) {
; CHECK-LABEL: test_asrl:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    asrl r0, r1, r2
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %value, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %value to i32
  %3 = call { i32, i32 } @llvm.arm.mve.asrl(i32 %2, i32 %1, i32 %shift)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

declare { i32, i32 } @llvm.arm.mve.asrl(i32, i32, i32)

define i64 @test_lsll(i64 %value, i32 %shift) {
; CHECK-LABEL: test_lsll:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    lsll r0, r1, r2
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %value, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %value to i32
  %3 = call { i32, i32 } @llvm.arm.mve.lsll(i32 %2, i32 %1, i32 %shift)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

declare { i32, i32 } @llvm.arm.mve.lsll(i32, i32, i32)

define i32 @test_sqrshr(i32 %value, i32 %shift) {
; CHECK-LABEL: test_sqrshr:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    sqrshr r0, r1
; CHECK-NEXT:    bx lr
entry:
  %0 = call i32 @llvm.arm.mve.sqrshr(i32 %value, i32 %shift)
  ret i32 %0
}

declare i32 @llvm.arm.mve.sqrshr(i32, i32)

define i64 @test_sqrshrl(i64 %value, i32 %shift) {
; CHECK-LABEL: test_sqrshrl:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    sqrshrl r0, r1, #64, r2
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %value, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %value to i32
  %3 = call { i32, i32 } @llvm.arm.mve.sqrshrl(i32 %2, i32 %1, i32 %shift, i32 64)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

declare { i32, i32 } @llvm.arm.mve.sqrshrl(i32, i32, i32, i32)

define i64 @test_sqrshrl_sat48(i64 %value, i32 %shift) {
; CHECK-LABEL: test_sqrshrl_sat48:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    sqrshrl r0, r1, #48, r2
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %value, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %value to i32
  %3 = call { i32, i32 } @llvm.arm.mve.sqrshrl(i32 %2, i32 %1, i32 %shift, i32 48)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

define i32 @test_sqshl(i32 %value) {
; CHECK-LABEL: test_sqshl:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    sqshl r0, #2
; CHECK-NEXT:    bx lr
entry:
  %0 = call i32 @llvm.arm.mve.sqshl(i32 %value, i32 2)
  ret i32 %0
}

declare i32 @llvm.arm.mve.sqshl(i32, i32)

define i64 @test_sqshll(i64 %value) {
; CHECK-LABEL: test_sqshll:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    sqshll r0, r1, #17
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %value, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %value to i32
  %3 = call { i32, i32 } @llvm.arm.mve.sqshll(i32 %2, i32 %1, i32 17)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

declare { i32, i32 } @llvm.arm.mve.sqshll(i32, i32, i32)

define i32 @test_srshr(i32 %value) {
; CHECK-LABEL: test_srshr:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    srshr r0, #6
; CHECK-NEXT:    bx lr
entry:
  %0 = call i32 @llvm.arm.mve.srshr(i32 %value, i32 6)
  ret i32 %0
}

declare i32 @llvm.arm.mve.srshr(i32, i32)

define i64 @test_srshrl(i64 %value) {
; CHECK-LABEL: test_srshrl:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    srshrl r0, r1, #26
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %value, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %value to i32
  %3 = call { i32, i32 } @llvm.arm.mve.srshrl(i32 %2, i32 %1, i32 26)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

declare { i32, i32 } @llvm.arm.mve.srshrl(i32, i32, i32)

define i32 @test_uqrshl(i32 %value, i32 %shift) {
; CHECK-LABEL: test_uqrshl:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    uqrshl r0, r1
; CHECK-NEXT:    bx lr
entry:
  %0 = call i32 @llvm.arm.mve.uqrshl(i32 %value, i32 %shift)
  ret i32 %0
}

declare i32 @llvm.arm.mve.uqrshl(i32, i32)

define i64 @test_uqrshll(i64 %value, i32 %shift) {
; CHECK-LABEL: test_uqrshll:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    uqrshll r0, r1, #64, r2
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %value, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %value to i32
  %3 = call { i32, i32 } @llvm.arm.mve.uqrshll(i32 %2, i32 %1, i32 %shift, i32 64)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

declare { i32, i32 } @llvm.arm.mve.uqrshll(i32, i32, i32, i32)

define i64 @test_uqrshll_sat48(i64 %value, i32 %shift) {
; CHECK-LABEL: test_uqrshll_sat48:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    uqrshll r0, r1, #48, r2
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %value, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %value to i32
  %3 = call { i32, i32 } @llvm.arm.mve.uqrshll(i32 %2, i32 %1, i32 %shift, i32 48)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

define i32 @test_uqshl(i32 %value) {
; CHECK-LABEL: test_uqshl:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    uqshl r0, #21
; CHECK-NEXT:    bx lr
entry:
  %0 = call i32 @llvm.arm.mve.uqshl(i32 %value, i32 21)
  ret i32 %0
}

declare i32 @llvm.arm.mve.uqshl(i32, i32)

define i64 @test_uqshll(i64 %value) {
; CHECK-LABEL: test_uqshll:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    uqshll r0, r1, #16
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %value, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %value to i32
  %3 = call { i32, i32 } @llvm.arm.mve.uqshll(i32 %2, i32 %1, i32 16)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

declare { i32, i32 } @llvm.arm.mve.uqshll(i32, i32, i32)

define i32 @test_urshr(i32 %value) {
; CHECK-LABEL: test_urshr:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    urshr r0, #22
; CHECK-NEXT:    bx lr
entry:
  %0 = call i32 @llvm.arm.mve.urshr(i32 %value, i32 22)
  ret i32 %0
}

declare i32 @llvm.arm.mve.urshr(i32, i32)

define i64 @test_urshrl(i64 %value) {
; CHECK-LABEL: test_urshrl:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    urshrl r0, r1, #6
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %value, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %value to i32
  %3 = call { i32, i32 } @llvm.arm.mve.urshrl(i32 %2, i32 %1, i32 6)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

declare { i32, i32 } @llvm.arm.mve.urshrl(i32, i32, i32)
