; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=x86-64 -mattr=+ssse3 | FileCheck %s --check-prefix=CHECK --check-prefix=GENERIC
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=atom | FileCheck %s --check-prefix=CHECK --check-prefix=ATOM
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=slm | FileCheck %s --check-prefix=CHECK --check-prefix=SLM
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=sandybridge | FileCheck %s --check-prefix=CHECK --check-prefix=SANDY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=ivybridge | FileCheck %s --check-prefix=CHECK --check-prefix=SANDY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=haswell | FileCheck %s --check-prefix=CHECK --check-prefix=HASWELL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=broadwell | FileCheck %s --check-prefix=CHECK --check-prefix=BROADWELL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skylake | FileCheck %s --check-prefix=CHECK --check-prefix=SKYLAKE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skx | FileCheck %s --check-prefix=CHECK --check-prefix=SKX
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=btver2 | FileCheck %s --check-prefix=CHECK --check-prefix=BTVER2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=znver1 | FileCheck %s --check-prefix=CHECK --check-prefix=ZNVER1

define i64 @test_cvtpd2pi(<2 x double> %a0, <2 x double>* %a1) optsize {
; GENERIC-LABEL: test_cvtpd2pi:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    cvtpd2pi (%rdi), %mm0 # sched: [10:1.00]
; GENERIC-NEXT:    cvtpd2pi %xmm0, %mm1 # sched: [4:1.00]
; GENERIC-NEXT:    por %mm1, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cvtpd2pi:
; ATOM:       # %bb.0:
; ATOM-NEXT:    cvtpd2pi (%rdi), %mm0 # sched: [8:4.00]
; ATOM-NEXT:    cvtpd2pi %xmm0, %mm1 # sched: [7:3.50]
; ATOM-NEXT:    por %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cvtpd2pi:
; SLM:       # %bb.0:
; SLM-NEXT:    cvtpd2pi (%rdi), %mm1 # sched: [7:1.00]
; SLM-NEXT:    cvtpd2pi %xmm0, %mm0 # sched: [4:0.50]
; SLM-NEXT:    por %mm0, %mm1 # sched: [1:0.50]
; SLM-NEXT:    movd %mm1, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_cvtpd2pi:
; SANDY:       # %bb.0:
; SANDY-NEXT:    cvtpd2pi (%rdi), %mm0 # sched: [10:1.00]
; SANDY-NEXT:    cvtpd2pi %xmm0, %mm1 # sched: [4:1.00]
; SANDY-NEXT:    por %mm1, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cvtpd2pi:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    cvtpd2pi (%rdi), %mm0 # sched: [10:1.00]
; HASWELL-NEXT:    cvtpd2pi %xmm0, %mm1 # sched: [4:1.00]
; HASWELL-NEXT:    por %mm1, %mm0 # sched: [1:0.33]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cvtpd2pi:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    cvtpd2pi %xmm0, %mm0 # sched: [4:1.00]
; BROADWELL-NEXT:    cvtpd2pi (%rdi), %mm1 # sched: [9:1.00]
; BROADWELL-NEXT:    por %mm0, %mm1 # sched: [1:0.33]
; BROADWELL-NEXT:    movd %mm1, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cvtpd2pi:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    cvtpd2pi %xmm0, %mm0 # sched: [5:1.00]
; SKYLAKE-NEXT:    cvtpd2pi (%rdi), %mm1 # sched: [11:1.00]
; SKYLAKE-NEXT:    por %mm0, %mm1 # sched: [1:0.50]
; SKYLAKE-NEXT:    movd %mm1, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cvtpd2pi:
; SKX:       # %bb.0:
; SKX-NEXT:    cvtpd2pi %xmm0, %mm0 # sched: [5:1.00]
; SKX-NEXT:    cvtpd2pi (%rdi), %mm1 # sched: [11:1.00]
; SKX-NEXT:    por %mm0, %mm1 # sched: [1:0.50]
; SKX-NEXT:    movd %mm1, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_cvtpd2pi:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    cvtpd2pi (%rdi), %mm1 # sched: [8:1.00]
; BTVER2-NEXT:    cvtpd2pi %xmm0, %mm0 # sched: [3:1.00]
; BTVER2-NEXT:    por %mm0, %mm1 # sched: [1:0.50]
; BTVER2-NEXT:    movd %mm1, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cvtpd2pi:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    cvtpd2pi (%rdi), %mm1 # sched: [12:1.00]
; ZNVER1-NEXT:    cvtpd2pi %xmm0, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    por %mm0, %mm1 # sched: [1:0.25]
; ZNVER1-NEXT:    movd %mm1, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.sse.cvtpd2pi(<2 x double> %a0)
  %2 = load <2 x double>, <2 x double> *%a1, align 16
  %3 = call x86_mmx @llvm.x86.sse.cvtpd2pi(<2 x double> %2)
  %4 = call x86_mmx @llvm.x86.mmx.por(x86_mmx %1, x86_mmx %3)
  %5 = bitcast x86_mmx %4 to i64
  ret i64 %5
}
declare x86_mmx @llvm.x86.sse.cvtpd2pi(<2 x double>) nounwind readnone

define <2 x double> @test_cvtpi2pd(x86_mmx %a0, x86_mmx* %a1) optsize {
; GENERIC-LABEL: test_cvtpi2pd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    cvtpi2pd %mm0, %xmm1 # sched: [4:1.00]
; GENERIC-NEXT:    cvtpi2pd (%rdi), %xmm0 # sched: [10:1.00]
; GENERIC-NEXT:    addpd %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cvtpi2pd:
; ATOM:       # %bb.0:
; ATOM-NEXT:    cvtpi2pd (%rdi), %xmm0 # sched: [8:4.00]
; ATOM-NEXT:    cvtpi2pd %mm0, %xmm1 # sched: [7:3.50]
; ATOM-NEXT:    addpd %xmm1, %xmm0 # sched: [6:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cvtpi2pd:
; SLM:       # %bb.0:
; SLM-NEXT:    cvtpi2pd (%rdi), %xmm0 # sched: [7:1.00]
; SLM-NEXT:    cvtpi2pd %mm0, %xmm1 # sched: [4:0.50]
; SLM-NEXT:    addpd %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_cvtpi2pd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    cvtpi2pd %mm0, %xmm0 # sched: [4:1.00]
; SANDY-NEXT:    cvtpi2pd (%rdi), %xmm1 # sched: [10:1.00]
; SANDY-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cvtpi2pd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    cvtpi2pd %mm0, %xmm0 # sched: [4:1.00]
; HASWELL-NEXT:    cvtpi2pd (%rdi), %xmm1 # sched: [9:1.00]
; HASWELL-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cvtpi2pd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    cvtpi2pd (%rdi), %xmm0 # sched: [9:1.00]
; BROADWELL-NEXT:    cvtpi2pd %mm0, %xmm1 # sched: [4:1.00]
; BROADWELL-NEXT:    vaddpd %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cvtpi2pd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    cvtpi2pd %mm0, %xmm0 # sched: [5:1.00]
; SKYLAKE-NEXT:    cvtpi2pd (%rdi), %xmm1 # sched: [10:1.00]
; SKYLAKE-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cvtpi2pd:
; SKX:       # %bb.0:
; SKX-NEXT:    cvtpi2pd %mm0, %xmm0 # sched: [5:1.00]
; SKX-NEXT:    cvtpi2pd (%rdi), %xmm1 # sched: [10:1.00]
; SKX-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [4:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_cvtpi2pd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    cvtpi2pd (%rdi), %xmm1 # sched: [8:1.00]
; BTVER2-NEXT:    cvtpi2pd %mm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cvtpi2pd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    cvtpi2pd (%rdi), %xmm1 # sched: [12:1.00]
; ZNVER1-NEXT:    cvtpi2pd %mm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vaddpd %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <2 x double> @llvm.x86.sse.cvtpi2pd(x86_mmx %a0)
  %2 = load x86_mmx, x86_mmx *%a1, align 8
  %3 = call <2 x double> @llvm.x86.sse.cvtpi2pd(x86_mmx %2)
  %4 = fadd <2 x double> %1, %3
  ret <2 x double> %4
}
declare <2 x double> @llvm.x86.sse.cvtpi2pd(x86_mmx) nounwind readnone

define <4 x float> @test_cvtpi2ps(x86_mmx %a0, x86_mmx* %a1, <4 x float> %a2, <4 x float> %a3) optsize {
; GENERIC-LABEL: test_cvtpi2ps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    cvtpi2ps %mm0, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    cvtpi2ps (%rdi), %xmm1 # sched: [9:1.00]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cvtpi2ps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    cvtpi2ps (%rdi), %xmm1
; ATOM-NEXT:    cvtpi2ps %mm0, %xmm0
; ATOM-NEXT:    addps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cvtpi2ps:
; SLM:       # %bb.0:
; SLM-NEXT:    cvtpi2ps (%rdi), %xmm1 # sched: [7:1.00]
; SLM-NEXT:    cvtpi2ps %mm0, %xmm0 # sched: [4:0.50]
; SLM-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_cvtpi2ps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    cvtpi2ps %mm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    cvtpi2ps (%rdi), %xmm1 # sched: [9:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cvtpi2ps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    cvtpi2ps %mm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    cvtpi2ps (%rdi), %xmm1 # sched: [8:1.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cvtpi2ps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    cvtpi2ps %mm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    cvtpi2ps (%rdi), %xmm1 # sched: [8:1.00]
; BROADWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cvtpi2ps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    cvtpi2ps %mm0, %xmm0 # sched: [6:2.00]
; SKYLAKE-NEXT:    cvtpi2ps (%rdi), %xmm1 # sched: [9:1.00]
; SKYLAKE-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cvtpi2ps:
; SKX:       # %bb.0:
; SKX-NEXT:    cvtpi2ps %mm0, %xmm0 # sched: [6:2.00]
; SKX-NEXT:    cvtpi2ps (%rdi), %xmm1 # sched: [9:1.00]
; SKX-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_cvtpi2ps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    cvtpi2ps (%rdi), %xmm1 # sched: [8:1.00]
; BTVER2-NEXT:    cvtpi2ps %mm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cvtpi2ps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    cvtpi2ps (%rdi), %xmm1 # sched: [12:1.00]
; ZNVER1-NEXT:    cvtpi2ps %mm0, %xmm0 # sched: [5:1.00]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x float> @llvm.x86.sse.cvtpi2ps(<4 x float> %a2, x86_mmx %a0)
  %2 = load x86_mmx, x86_mmx *%a1, align 8
  %3 = call <4 x float> @llvm.x86.sse.cvtpi2ps(<4 x float> %a3, x86_mmx %2)
  %4 = fadd <4 x float> %1, %3
  ret <4 x float> %4
}
declare <4 x float> @llvm.x86.sse.cvtpi2ps(<4 x float>, x86_mmx) nounwind readnone

define i64 @test_cvtps2pi(<4 x float> %a0, <4 x float>* %a1) optsize {
; GENERIC-LABEL: test_cvtps2pi:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    cvtps2pi %xmm0, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    cvtps2pi (%rdi), %mm1 # sched: [9:1.00]
; GENERIC-NEXT:    por %mm0, %mm1 # sched: [1:1.00]
; GENERIC-NEXT:    movd %mm1, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cvtps2pi:
; ATOM:       # %bb.0:
; ATOM-NEXT:    cvtps2pi %xmm0, %mm0 # sched: [5:5.00]
; ATOM-NEXT:    cvtps2pi (%rdi), %mm1 # sched: [5:5.00]
; ATOM-NEXT:    por %mm0, %mm1 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm1, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cvtps2pi:
; SLM:       # %bb.0:
; SLM-NEXT:    cvtps2pi (%rdi), %mm1 # sched: [7:1.00]
; SLM-NEXT:    cvtps2pi %xmm0, %mm0 # sched: [4:0.50]
; SLM-NEXT:    por %mm0, %mm1 # sched: [1:0.50]
; SLM-NEXT:    movd %mm1, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_cvtps2pi:
; SANDY:       # %bb.0:
; SANDY-NEXT:    cvtps2pi %xmm0, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    cvtps2pi (%rdi), %mm1 # sched: [9:1.00]
; SANDY-NEXT:    por %mm0, %mm1 # sched: [1:1.00]
; SANDY-NEXT:    movd %mm1, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cvtps2pi:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    cvtps2pi %xmm0, %mm0 # sched: [4:1.00]
; HASWELL-NEXT:    cvtps2pi (%rdi), %mm1 # sched: [8:1.00]
; HASWELL-NEXT:    por %mm0, %mm1 # sched: [1:0.33]
; HASWELL-NEXT:    movd %mm1, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cvtps2pi:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    cvtps2pi %xmm0, %mm0 # sched: [4:1.00]
; BROADWELL-NEXT:    cvtps2pi (%rdi), %mm1 # sched: [8:1.00]
; BROADWELL-NEXT:    por %mm0, %mm1 # sched: [1:0.33]
; BROADWELL-NEXT:    movd %mm1, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cvtps2pi:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    cvtps2pi %xmm0, %mm0 # sched: [5:1.00]
; SKYLAKE-NEXT:    cvtps2pi (%rdi), %mm1 # sched: [9:0.50]
; SKYLAKE-NEXT:    por %mm0, %mm1 # sched: [1:0.50]
; SKYLAKE-NEXT:    movd %mm1, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cvtps2pi:
; SKX:       # %bb.0:
; SKX-NEXT:    cvtps2pi %xmm0, %mm0 # sched: [5:1.00]
; SKX-NEXT:    cvtps2pi (%rdi), %mm1 # sched: [9:0.50]
; SKX-NEXT:    por %mm0, %mm1 # sched: [1:0.50]
; SKX-NEXT:    movd %mm1, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_cvtps2pi:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    cvtps2pi (%rdi), %mm1 # sched: [8:1.00]
; BTVER2-NEXT:    cvtps2pi %xmm0, %mm0 # sched: [3:1.00]
; BTVER2-NEXT:    por %mm0, %mm1 # sched: [1:0.50]
; BTVER2-NEXT:    movd %mm1, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cvtps2pi:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    cvtps2pi (%rdi), %mm1 # sched: [12:1.00]
; ZNVER1-NEXT:    cvtps2pi %xmm0, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    por %mm0, %mm1 # sched: [1:0.25]
; ZNVER1-NEXT:    movd %mm1, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.sse.cvtps2pi(<4 x float> %a0)
  %2 = load <4 x float>, <4 x float> *%a1, align 16
  %3 = call x86_mmx @llvm.x86.sse.cvtps2pi(<4 x float> %2)
  %4 = call x86_mmx @llvm.x86.mmx.por(x86_mmx %1, x86_mmx %3)
  %5 = bitcast x86_mmx %4 to i64
  ret i64 %5
}
declare x86_mmx @llvm.x86.sse.cvtps2pi(<4 x float>) nounwind readnone

define i64 @test_cvttpd2pi(<2 x double> %a0, <2 x double>* %a1) optsize {
; GENERIC-LABEL: test_cvttpd2pi:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    cvttpd2pi (%rdi), %mm0 # sched: [10:1.00]
; GENERIC-NEXT:    cvttpd2pi %xmm0, %mm1 # sched: [4:1.00]
; GENERIC-NEXT:    por %mm1, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cvttpd2pi:
; ATOM:       # %bb.0:
; ATOM-NEXT:    cvttpd2pi (%rdi), %mm0 # sched: [8:4.00]
; ATOM-NEXT:    cvttpd2pi %xmm0, %mm1 # sched: [7:3.50]
; ATOM-NEXT:    por %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cvttpd2pi:
; SLM:       # %bb.0:
; SLM-NEXT:    cvttpd2pi (%rdi), %mm1 # sched: [7:1.00]
; SLM-NEXT:    cvttpd2pi %xmm0, %mm0 # sched: [4:0.50]
; SLM-NEXT:    por %mm0, %mm1 # sched: [1:0.50]
; SLM-NEXT:    movd %mm1, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_cvttpd2pi:
; SANDY:       # %bb.0:
; SANDY-NEXT:    cvttpd2pi (%rdi), %mm0 # sched: [10:1.00]
; SANDY-NEXT:    cvttpd2pi %xmm0, %mm1 # sched: [4:1.00]
; SANDY-NEXT:    por %mm1, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cvttpd2pi:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    cvttpd2pi (%rdi), %mm0 # sched: [10:1.00]
; HASWELL-NEXT:    cvttpd2pi %xmm0, %mm1 # sched: [4:1.00]
; HASWELL-NEXT:    por %mm1, %mm0 # sched: [1:0.33]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cvttpd2pi:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    cvttpd2pi %xmm0, %mm0 # sched: [4:1.00]
; BROADWELL-NEXT:    cvttpd2pi (%rdi), %mm1 # sched: [9:1.00]
; BROADWELL-NEXT:    por %mm0, %mm1 # sched: [1:0.33]
; BROADWELL-NEXT:    movd %mm1, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cvttpd2pi:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    cvttpd2pi %xmm0, %mm0 # sched: [5:1.00]
; SKYLAKE-NEXT:    cvttpd2pi (%rdi), %mm1 # sched: [11:1.00]
; SKYLAKE-NEXT:    por %mm0, %mm1 # sched: [1:0.50]
; SKYLAKE-NEXT:    movd %mm1, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cvttpd2pi:
; SKX:       # %bb.0:
; SKX-NEXT:    cvttpd2pi %xmm0, %mm0 # sched: [5:1.00]
; SKX-NEXT:    cvttpd2pi (%rdi), %mm1 # sched: [11:1.00]
; SKX-NEXT:    por %mm0, %mm1 # sched: [1:0.50]
; SKX-NEXT:    movd %mm1, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_cvttpd2pi:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    cvttpd2pi (%rdi), %mm1 # sched: [8:1.00]
; BTVER2-NEXT:    cvttpd2pi %xmm0, %mm0 # sched: [3:1.00]
; BTVER2-NEXT:    por %mm0, %mm1 # sched: [1:0.50]
; BTVER2-NEXT:    movd %mm1, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cvttpd2pi:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    cvttpd2pi (%rdi), %mm1 # sched: [12:1.00]
; ZNVER1-NEXT:    cvttpd2pi %xmm0, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    por %mm0, %mm1 # sched: [1:0.25]
; ZNVER1-NEXT:    movd %mm1, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.sse.cvttpd2pi(<2 x double> %a0)
  %2 = load <2 x double>, <2 x double> *%a1, align 16
  %3 = call x86_mmx @llvm.x86.sse.cvttpd2pi(<2 x double> %2)
  %4 = call x86_mmx @llvm.x86.mmx.por(x86_mmx %1, x86_mmx %3)
  %5 = bitcast x86_mmx %4 to i64
  ret i64 %5
}
declare x86_mmx @llvm.x86.sse.cvttpd2pi(<2 x double>) nounwind readnone

define i64 @test_cvttps2pi(<4 x float> %a0, <4 x float>* %a1) optsize {
; GENERIC-LABEL: test_cvttps2pi:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    cvttps2pi %xmm0, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    cvttps2pi (%rdi), %mm1 # sched: [9:1.00]
; GENERIC-NEXT:    por %mm0, %mm1 # sched: [1:1.00]
; GENERIC-NEXT:    movd %mm1, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cvttps2pi:
; ATOM:       # %bb.0:
; ATOM-NEXT:    cvttps2pi %xmm0, %mm0 # sched: [5:5.00]
; ATOM-NEXT:    cvttps2pi (%rdi), %mm1 # sched: [5:5.00]
; ATOM-NEXT:    por %mm0, %mm1 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm1, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cvttps2pi:
; SLM:       # %bb.0:
; SLM-NEXT:    cvttps2pi (%rdi), %mm1 # sched: [7:1.00]
; SLM-NEXT:    cvttps2pi %xmm0, %mm0 # sched: [4:0.50]
; SLM-NEXT:    por %mm0, %mm1 # sched: [1:0.50]
; SLM-NEXT:    movd %mm1, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_cvttps2pi:
; SANDY:       # %bb.0:
; SANDY-NEXT:    cvttps2pi %xmm0, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    cvttps2pi (%rdi), %mm1 # sched: [9:1.00]
; SANDY-NEXT:    por %mm0, %mm1 # sched: [1:1.00]
; SANDY-NEXT:    movd %mm1, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cvttps2pi:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    cvttps2pi %xmm0, %mm0 # sched: [4:1.00]
; HASWELL-NEXT:    cvttps2pi (%rdi), %mm1 # sched: [8:1.00]
; HASWELL-NEXT:    por %mm0, %mm1 # sched: [1:0.33]
; HASWELL-NEXT:    movd %mm1, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cvttps2pi:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    cvttps2pi %xmm0, %mm0 # sched: [4:1.00]
; BROADWELL-NEXT:    cvttps2pi (%rdi), %mm1 # sched: [8:1.00]
; BROADWELL-NEXT:    por %mm0, %mm1 # sched: [1:0.33]
; BROADWELL-NEXT:    movd %mm1, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cvttps2pi:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    cvttps2pi %xmm0, %mm0 # sched: [5:1.00]
; SKYLAKE-NEXT:    cvttps2pi (%rdi), %mm1 # sched: [9:0.50]
; SKYLAKE-NEXT:    por %mm0, %mm1 # sched: [1:0.50]
; SKYLAKE-NEXT:    movd %mm1, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cvttps2pi:
; SKX:       # %bb.0:
; SKX-NEXT:    cvttps2pi %xmm0, %mm0 # sched: [5:1.00]
; SKX-NEXT:    cvttps2pi (%rdi), %mm1 # sched: [9:0.50]
; SKX-NEXT:    por %mm0, %mm1 # sched: [1:0.50]
; SKX-NEXT:    movd %mm1, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_cvttps2pi:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    cvttps2pi (%rdi), %mm1 # sched: [8:1.00]
; BTVER2-NEXT:    cvttps2pi %xmm0, %mm0 # sched: [3:1.00]
; BTVER2-NEXT:    por %mm0, %mm1 # sched: [1:0.50]
; BTVER2-NEXT:    movd %mm1, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cvttps2pi:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    cvttps2pi (%rdi), %mm1 # sched: [12:1.00]
; ZNVER1-NEXT:    cvttps2pi %xmm0, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    por %mm0, %mm1 # sched: [1:0.25]
; ZNVER1-NEXT:    movd %mm1, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.sse.cvttps2pi(<4 x float> %a0)
  %2 = load <4 x float>, <4 x float> *%a1, align 16
  %3 = call x86_mmx @llvm.x86.sse.cvttps2pi(<4 x float> %2)
  %4 = call x86_mmx @llvm.x86.mmx.por(x86_mmx %1, x86_mmx %3)
  %5 = bitcast x86_mmx %4 to i64
  ret i64 %5
}
declare x86_mmx @llvm.x86.sse.cvttps2pi(<4 x float>) nounwind readnone

define void @test_emms() optsize {
; GENERIC-LABEL: test_emms:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    emms
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_emms:
; ATOM:       # %bb.0:
; ATOM-NEXT:    emms # sched: [5:2.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_emms:
; SLM:       # %bb.0:
; SLM-NEXT:    emms
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_emms:
; SANDY:       # %bb.0:
; SANDY-NEXT:    emms
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_emms:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    emms # sched: [31:10.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_emms:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    emms # sched: [31:10.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_emms:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    emms # sched: [10:4.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_emms:
; SKX:       # %bb.0:
; SKX-NEXT:    emms # sched: [10:4.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_emms:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    emms
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_emms:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    emms
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  call void @llvm.x86.mmx.emms()
  ret void
}
declare void @llvm.x86.mmx.emms()

define void @test_maskmovq(x86_mmx %a0, x86_mmx %a1, i8* %a2) optsize {
; GENERIC-LABEL: test_maskmovq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    maskmovq %mm1, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_maskmovq:
; ATOM:       # %bb.0:
; ATOM-NEXT:    maskmovq %mm1, %mm0 # sched: [1:1.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_maskmovq:
; SLM:       # %bb.0:
; SLM-NEXT:    maskmovq %mm1, %mm0 # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_maskmovq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    maskmovq %mm1, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_maskmovq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    maskmovq %mm1, %mm0 # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_maskmovq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    maskmovq %mm1, %mm0 # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_maskmovq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    maskmovq %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_maskmovq:
; SKX:       # %bb.0:
; SKX-NEXT:    maskmovq %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_maskmovq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    maskmovq %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_maskmovq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    maskmovq %mm1, %mm0 # sched: [100:?]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  call void @llvm.x86.mmx.maskmovq(x86_mmx %a0, x86_mmx %a1, i8* %a2)
  ret void
}
declare void @llvm.x86.mmx.maskmovq(x86_mmx, x86_mmx, i8*) nounwind

define i32 @test_movd(x86_mmx %a0, i32 %a1, i32 *%a2) {
; GENERIC-LABEL: test_movd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movd %edi, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    movq %xmm0, -{{[0-9]+}}(%rsp) # sched: [5:1.00]
; GENERIC-NEXT:    movq -{{[0-9]+}}(%rsp), %mm1 # sched: [4:0.50]
; GENERIC-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [6:0.50]
; GENERIC-NEXT:    movlps %xmm0, -{{[0-9]+}}(%rsp) # sched: [5:1.00]
; GENERIC-NEXT:    paddd -{{[0-9]+}}(%rsp), %mm1 # sched: [7:1.00]
; GENERIC-NEXT:    paddd %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    movd %mm1, %ecx # sched: [1:0.33]
; GENERIC-NEXT:    movd %mm0, %eax # sched: [1:0.33]
; GENERIC-NEXT:    movl %ecx, (%rsi) # sched: [5:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movd:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movd %edi, %xmm0 # sched: [1:1.00]
; ATOM-NEXT:    movq %xmm0, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; ATOM-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [1:1.00]
; ATOM-NEXT:    movq -{{[0-9]+}}(%rsp), %mm1 # sched: [1:1.00]
; ATOM-NEXT:    movlps %xmm0, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; ATOM-NEXT:    paddd -{{[0-9]+}}(%rsp), %mm1 # sched: [1:1.00]
; ATOM-NEXT:    paddd %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm1, %ecx # sched: [3:3.00]
; ATOM-NEXT:    movd %mm0, %eax # sched: [3:3.00]
; ATOM-NEXT:    movl %ecx, (%rsi) # sched: [1:1.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movd:
; SLM:       # %bb.0:
; SLM-NEXT:    movd %edi, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    movq %xmm0, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; SLM-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [3:1.00]
; SLM-NEXT:    movq -{{[0-9]+}}(%rsp), %mm1 # sched: [3:1.00]
; SLM-NEXT:    movlps %xmm0, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; SLM-NEXT:    paddd -{{[0-9]+}}(%rsp), %mm1 # sched: [4:1.00]
; SLM-NEXT:    paddd %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    movd %mm1, %ecx # sched: [1:0.50]
; SLM-NEXT:    movd %mm0, %eax # sched: [1:0.50]
; SLM-NEXT:    movl %ecx, (%rsi) # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_movd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmovd %edi, %xmm0 # sched: [1:1.00]
; SANDY-NEXT:    vmovq %xmm0, -{{[0-9]+}}(%rsp) # sched: [5:1.00]
; SANDY-NEXT:    movq -{{[0-9]+}}(%rsp), %mm1 # sched: [4:0.50]
; SANDY-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [6:0.50]
; SANDY-NEXT:    vmovlps %xmm0, -{{[0-9]+}}(%rsp) # sched: [5:1.00]
; SANDY-NEXT:    paddd -{{[0-9]+}}(%rsp), %mm1 # sched: [7:1.00]
; SANDY-NEXT:    paddd %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    movd %mm1, %ecx # sched: [1:0.33]
; SANDY-NEXT:    movd %mm0, %eax # sched: [1:0.33]
; SANDY-NEXT:    movl %ecx, (%rsi) # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmovd %edi, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    vmovq %xmm0, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; HASWELL-NEXT:    movq -{{[0-9]+}}(%rsp), %mm1 # sched: [5:0.50]
; HASWELL-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [5:0.50]
; HASWELL-NEXT:    vmovlps %xmm0, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; HASWELL-NEXT:    paddd -{{[0-9]+}}(%rsp), %mm1 # sched: [6:0.50]
; HASWELL-NEXT:    paddd %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    movd %mm1, %ecx # sched: [1:1.00]
; HASWELL-NEXT:    movd %mm0, %eax # sched: [1:1.00]
; HASWELL-NEXT:    movl %ecx, (%rsi) # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmovd %edi, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vmovq %xmm0, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; BROADWELL-NEXT:    movq -{{[0-9]+}}(%rsp), %mm1 # sched: [5:0.50]
; BROADWELL-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [5:0.50]
; BROADWELL-NEXT:    vmovlps %xmm0, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; BROADWELL-NEXT:    paddd -{{[0-9]+}}(%rsp), %mm1 # sched: [6:0.50]
; BROADWELL-NEXT:    paddd %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    movd %mm1, %ecx # sched: [1:1.00]
; BROADWELL-NEXT:    movd %mm0, %eax # sched: [1:1.00]
; BROADWELL-NEXT:    movl %ecx, (%rsi) # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmovd %edi, %xmm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    vmovq %xmm0, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; SKYLAKE-NEXT:    movq -{{[0-9]+}}(%rsp), %mm1 # sched: [5:0.50]
; SKYLAKE-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [5:0.50]
; SKYLAKE-NEXT:    vmovlps %xmm0, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; SKYLAKE-NEXT:    paddd -{{[0-9]+}}(%rsp), %mm1 # sched: [6:0.50]
; SKYLAKE-NEXT:    paddd %mm1, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    movd %mm1, %ecx # sched: [2:1.00]
; SKYLAKE-NEXT:    movd %mm0, %eax # sched: [2:1.00]
; SKYLAKE-NEXT:    movl %ecx, (%rsi) # sched: [1:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movd:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovd %edi, %xmm0 # sched: [1:1.00]
; SKX-NEXT:    vpmovqd %xmm0, -{{[0-9]+}}(%rsp) # sched: [4:1.00]
; SKX-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [5:0.50]
; SKX-NEXT:    movq -{{[0-9]+}}(%rsp), %mm1 # sched: [5:0.50]
; SKX-NEXT:    vpmovqd %xmm0, -{{[0-9]+}}(%rsp) # sched: [4:1.00]
; SKX-NEXT:    paddd -{{[0-9]+}}(%rsp), %mm1 # sched: [6:0.50]
; SKX-NEXT:    paddd %mm1, %mm0 # sched: [1:0.50]
; SKX-NEXT:    movd %mm1, %ecx # sched: [2:1.00]
; SKX-NEXT:    movd %mm0, %eax # sched: [2:1.00]
; SKX-NEXT:    movl %ecx, (%rsi) # sched: [1:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_movd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovd %edi, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vmovq %xmm0, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; BTVER2-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [5:1.00]
; BTVER2-NEXT:    movq -{{[0-9]+}}(%rsp), %mm1 # sched: [5:1.00]
; BTVER2-NEXT:    vmovlps %xmm0, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; BTVER2-NEXT:    paddd -{{[0-9]+}}(%rsp), %mm1 # sched: [6:1.00]
; BTVER2-NEXT:    paddd %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    movd %mm1, %ecx # sched: [1:0.50]
; BTVER2-NEXT:    movd %mm0, %eax # sched: [1:0.50]
; BTVER2-NEXT:    movl %ecx, (%rsi) # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovd %edi, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmovq %xmm0, -{{[0-9]+}}(%rsp) # sched: [1:0.50]
; ZNVER1-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [8:0.50]
; ZNVER1-NEXT:    movq -{{[0-9]+}}(%rsp), %mm1 # sched: [8:0.50]
; ZNVER1-NEXT:    vmovlps %xmm0, -{{[0-9]+}}(%rsp) # sched: [1:0.50]
; ZNVER1-NEXT:    paddd -{{[0-9]+}}(%rsp), %mm1 # sched: [8:0.50]
; ZNVER1-NEXT:    paddd %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    movd %mm1, %ecx # sched: [2:1.00]
; ZNVER1-NEXT:    movd %mm0, %eax # sched: [2:1.00]
; ZNVER1-NEXT:    movl %ecx, (%rsi) # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1  = insertelement <2 x i32> undef, i32 %a1, i32 0
  %2  = bitcast <2 x i32> %1 to x86_mmx
  %3  = load i32, i32 *%a2
  %4  = insertelement <2 x i32> undef, i32 %3, i32 0
  %5  = bitcast <2 x i32> %4 to x86_mmx
  %6  = call x86_mmx @llvm.x86.mmx.padd.d(x86_mmx %2, x86_mmx %5)
  %7  = call x86_mmx @llvm.x86.mmx.padd.d(x86_mmx %a0, x86_mmx %6)
  %8  = bitcast x86_mmx %6 to <2 x i32>
  %9  = bitcast x86_mmx %7 to <2 x i32>
  %10 = extractelement <2 x i32> %8, i32 0
  %11 = extractelement <2 x i32> %9, i32 0
  store i32 %10, i32* %a2
  ret i32 %11
}

define i64 @test_movdq2q(<2 x i64> %a0) optsize {
; GENERIC-LABEL: test_movdq2q:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movdq2q %xmm0, %mm0 # sched: [2:1.00]
; GENERIC-NEXT:    paddd %mm0, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movdq2q:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movdq2q %xmm0, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    paddd %mm0, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movdq2q:
; SLM:       # %bb.0:
; SLM-NEXT:    movdq2q %xmm0, %mm0 # sched: [1:0.50]
; SLM-NEXT:    paddd %mm0, %mm0 # sched: [1:0.50]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_movdq2q:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movdq2q %xmm0, %mm0 # sched: [2:1.00]
; SANDY-NEXT:    paddd %mm0, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movdq2q:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movdq2q %xmm0, %mm0 # sched: [2:0.67]
; HASWELL-NEXT:    paddd %mm0, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movdq2q:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movdq2q %xmm0, %mm0 # sched: [2:0.67]
; BROADWELL-NEXT:    paddd %mm0, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movdq2q:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movdq2q %xmm0, %mm0 # sched: [2:1.00]
; SKYLAKE-NEXT:    paddd %mm0, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movdq2q:
; SKX:       # %bb.0:
; SKX-NEXT:    movdq2q %xmm0, %mm0 # sched: [2:1.00]
; SKX-NEXT:    paddd %mm0, %mm0 # sched: [1:0.50]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_movdq2q:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movdq2q %xmm0, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    paddd %mm0, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movdq2q:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movdq2q %xmm0, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    paddd %mm0, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = extractelement <2 x i64> %a0, i32 0
  %2 = bitcast i64 %1 to x86_mmx
  %3 = call x86_mmx @llvm.x86.mmx.padd.d(x86_mmx %2, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}

define void @test_movntq(x86_mmx* %a0, x86_mmx %a1) optsize {
; GENERIC-LABEL: test_movntq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movntq %mm0, (%rdi) # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movntq:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movntq %mm0, (%rdi) # sched: [1:1.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movntq:
; SLM:       # %bb.0:
; SLM-NEXT:    movntq %mm0, (%rdi) # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_movntq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movntq %mm0, (%rdi) # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movntq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movntq %mm0, (%rdi) # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movntq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movntq %mm0, (%rdi) # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movntq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movntq %mm0, (%rdi) # sched: [1:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movntq:
; SKX:       # %bb.0:
; SKX-NEXT:    movntq %mm0, (%rdi) # sched: [1:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_movntq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movntq %mm0, (%rdi) # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movntq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movntq %mm0, (%rdi) # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  call void @llvm.x86.mmx.movnt.dq(x86_mmx* %a0, x86_mmx %a1)
  ret void
}
declare void @llvm.x86.mmx.movnt.dq(x86_mmx*, x86_mmx) nounwind

define void @test_movq(i64 *%a0) {
; GENERIC-LABEL: test_movq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movq (%rdi), %mm0 # sched: [4:0.50]
; GENERIC-NEXT:    paddd %mm0, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    movq %mm0, (%rdi) # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movq:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movq (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    paddd %mm0, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movq %mm0, (%rdi) # sched: [1:1.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movq:
; SLM:       # %bb.0:
; SLM-NEXT:    movq (%rdi), %mm0 # sched: [3:1.00]
; SLM-NEXT:    paddd %mm0, %mm0 # sched: [1:0.50]
; SLM-NEXT:    movq %mm0, (%rdi) # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_movq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movq (%rdi), %mm0 # sched: [4:0.50]
; SANDY-NEXT:    paddd %mm0, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    movq %mm0, (%rdi) # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movq (%rdi), %mm0 # sched: [5:0.50]
; HASWELL-NEXT:    paddd %mm0, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    movq %mm0, (%rdi) # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movq (%rdi), %mm0 # sched: [5:0.50]
; BROADWELL-NEXT:    paddd %mm0, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    movq %mm0, (%rdi) # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movq (%rdi), %mm0 # sched: [5:0.50]
; SKYLAKE-NEXT:    paddd %mm0, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    movq %mm0, (%rdi) # sched: [1:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movq:
; SKX:       # %bb.0:
; SKX-NEXT:    movq (%rdi), %mm0 # sched: [5:0.50]
; SKX-NEXT:    paddd %mm0, %mm0 # sched: [1:0.50]
; SKX-NEXT:    movq %mm0, (%rdi) # sched: [1:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_movq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movq (%rdi), %mm0 # sched: [5:1.00]
; BTVER2-NEXT:    paddd %mm0, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    movq %mm0, (%rdi) # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movq (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    paddd %mm0, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    movq %mm0, (%rdi) # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = load i64, i64* %a0, align 8
  %2 = bitcast i64 %1 to x86_mmx
  %3 = call x86_mmx @llvm.x86.mmx.padd.d(x86_mmx %2, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  store i64 %4, i64* %a0, align 8
  ret void
}

define <2 x i64> @test_movq2dq(x86_mmx %a0) optsize {
; GENERIC-LABEL: test_movq2dq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movq2dq %mm0, %xmm0 # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movq2dq:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movq2dq %mm0, %xmm0
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movq2dq:
; SLM:       # %bb.0:
; SLM-NEXT:    movq2dq %mm0, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_movq2dq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movq2dq %mm0, %xmm0 # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_movq2dq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movq2dq %mm0, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movq2dq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movq2dq %mm0, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movq2dq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movq2dq %mm0, %xmm0 # sched: [2:2.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movq2dq:
; SKX:       # %bb.0:
; SKX-NEXT:    movq2dq %mm0, %xmm0 # sched: [2:2.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_movq2dq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movq2dq %mm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_movq2dq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movq2dq %mm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = bitcast x86_mmx %a0 to i64
  %2 = insertelement <2 x i64> undef, i64 %1, i32 0
  ret <2 x i64> %2
}

define i64 @test_pabsb(x86_mmx *%a0) optsize {
; GENERIC-LABEL: test_pabsb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pabsb (%rdi), %mm0 # sched: [6:0.50]
; GENERIC-NEXT:    pabsb %mm0, %mm0 # sched: [1:0.50]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pabsb:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pabsb (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    pabsb %mm0, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pabsb:
; SLM:       # %bb.0:
; SLM-NEXT:    pabsb (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    pabsb %mm0, %mm0 # sched: [1:0.50]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pabsb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pabsb (%rdi), %mm0 # sched: [6:0.50]
; SANDY-NEXT:    pabsb %mm0, %mm0 # sched: [1:0.50]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pabsb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pabsb (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    pabsb %mm0, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pabsb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pabsb (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    pabsb %mm0, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pabsb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pabsb (%rdi), %mm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    pabsb %mm0, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pabsb:
; SKX:       # %bb.0:
; SKX-NEXT:    pabsb (%rdi), %mm0 # sched: [6:0.50]
; SKX-NEXT:    pabsb %mm0, %mm0 # sched: [1:0.50]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pabsb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pabsb (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    pabsb %mm0, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pabsb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pabsb (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    pabsb %mm0, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = load x86_mmx, x86_mmx *%a0, align 8
  %2 = call x86_mmx @llvm.x86.ssse3.pabs.b(x86_mmx %1)
  %3 = call x86_mmx @llvm.x86.ssse3.pabs.b(x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.ssse3.pabs.b(x86_mmx) nounwind readnone

define i64 @test_pabsd(x86_mmx *%a0) optsize {
; GENERIC-LABEL: test_pabsd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pabsd (%rdi), %mm0 # sched: [6:0.50]
; GENERIC-NEXT:    pabsd %mm0, %mm0 # sched: [1:0.50]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pabsd:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pabsd (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    pabsd %mm0, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pabsd:
; SLM:       # %bb.0:
; SLM-NEXT:    pabsd (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    pabsd %mm0, %mm0 # sched: [1:0.50]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pabsd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pabsd (%rdi), %mm0 # sched: [6:0.50]
; SANDY-NEXT:    pabsd %mm0, %mm0 # sched: [1:0.50]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pabsd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pabsd (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    pabsd %mm0, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pabsd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pabsd (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    pabsd %mm0, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pabsd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pabsd (%rdi), %mm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    pabsd %mm0, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pabsd:
; SKX:       # %bb.0:
; SKX-NEXT:    pabsd (%rdi), %mm0 # sched: [6:0.50]
; SKX-NEXT:    pabsd %mm0, %mm0 # sched: [1:0.50]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pabsd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pabsd (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    pabsd %mm0, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pabsd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pabsd (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    pabsd %mm0, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = load x86_mmx, x86_mmx *%a0, align 8
  %2 = call x86_mmx @llvm.x86.ssse3.pabs.d(x86_mmx %1)
  %3 = call x86_mmx @llvm.x86.ssse3.pabs.d(x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.ssse3.pabs.d(x86_mmx) nounwind readnone

define i64 @test_pabsw(x86_mmx *%a0) optsize {
; GENERIC-LABEL: test_pabsw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pabsw (%rdi), %mm0 # sched: [6:0.50]
; GENERIC-NEXT:    pabsw %mm0, %mm0 # sched: [1:0.50]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pabsw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pabsw (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    pabsw %mm0, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pabsw:
; SLM:       # %bb.0:
; SLM-NEXT:    pabsw (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    pabsw %mm0, %mm0 # sched: [1:0.50]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pabsw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pabsw (%rdi), %mm0 # sched: [6:0.50]
; SANDY-NEXT:    pabsw %mm0, %mm0 # sched: [1:0.50]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pabsw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pabsw (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    pabsw %mm0, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pabsw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pabsw (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    pabsw %mm0, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pabsw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pabsw (%rdi), %mm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    pabsw %mm0, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pabsw:
; SKX:       # %bb.0:
; SKX-NEXT:    pabsw (%rdi), %mm0 # sched: [6:0.50]
; SKX-NEXT:    pabsw %mm0, %mm0 # sched: [1:0.50]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pabsw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pabsw (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    pabsw %mm0, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pabsw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pabsw (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    pabsw %mm0, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = load x86_mmx, x86_mmx *%a0, align 8
  %2 = call x86_mmx @llvm.x86.ssse3.pabs.w(x86_mmx %1)
  %3 = call x86_mmx @llvm.x86.ssse3.pabs.w(x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.ssse3.pabs.w(x86_mmx) nounwind readnone

define i64 @test_packssdw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_packssdw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    packssdw %mm1, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    packssdw (%rdi), %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_packssdw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    packssdw %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    packssdw (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_packssdw:
; SLM:       # %bb.0:
; SLM-NEXT:    packssdw %mm1, %mm0 # sched: [1:1.00]
; SLM-NEXT:    packssdw (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_packssdw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    packssdw %mm1, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    packssdw (%rdi), %mm0 # sched: [5:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_packssdw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    packssdw %mm1, %mm0 # sched: [3:2.00]
; HASWELL-NEXT:    packssdw (%rdi), %mm0 # sched: [7:2.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_packssdw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    packssdw %mm1, %mm0 # sched: [3:2.00]
; BROADWELL-NEXT:    packssdw (%rdi), %mm0 # sched: [7:2.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_packssdw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    packssdw %mm1, %mm0 # sched: [3:2.00]
; SKYLAKE-NEXT:    packssdw (%rdi), %mm0 # sched: [7:2.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_packssdw:
; SKX:       # %bb.0:
; SKX-NEXT:    packssdw %mm1, %mm0 # sched: [3:2.00]
; SKX-NEXT:    packssdw (%rdi), %mm0 # sched: [7:2.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_packssdw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    packssdw %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    packssdw (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_packssdw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    packssdw %mm1, %mm0 # sched: [1:0.50]
; ZNVER1-NEXT:    packssdw (%rdi), %mm0 # sched: [1:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.packssdw(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.packssdw(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.packssdw(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_packsswb(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_packsswb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    packsswb %mm1, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    packsswb (%rdi), %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_packsswb:
; ATOM:       # %bb.0:
; ATOM-NEXT:    packsswb %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    packsswb (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_packsswb:
; SLM:       # %bb.0:
; SLM-NEXT:    packsswb %mm1, %mm0 # sched: [1:1.00]
; SLM-NEXT:    packsswb (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_packsswb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    packsswb %mm1, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    packsswb (%rdi), %mm0 # sched: [5:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_packsswb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    packsswb %mm1, %mm0 # sched: [3:2.00]
; HASWELL-NEXT:    packsswb (%rdi), %mm0 # sched: [7:2.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_packsswb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    packsswb %mm1, %mm0 # sched: [3:2.00]
; BROADWELL-NEXT:    packsswb (%rdi), %mm0 # sched: [7:2.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_packsswb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    packsswb %mm1, %mm0 # sched: [3:2.00]
; SKYLAKE-NEXT:    packsswb (%rdi), %mm0 # sched: [7:2.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_packsswb:
; SKX:       # %bb.0:
; SKX-NEXT:    packsswb %mm1, %mm0 # sched: [3:2.00]
; SKX-NEXT:    packsswb (%rdi), %mm0 # sched: [7:2.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_packsswb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    packsswb %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    packsswb (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_packsswb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    packsswb %mm1, %mm0 # sched: [1:0.50]
; ZNVER1-NEXT:    packsswb (%rdi), %mm0 # sched: [1:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.packsswb(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.packsswb(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.packsswb(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_packuswb(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_packuswb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    packuswb %mm1, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    packuswb (%rdi), %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_packuswb:
; ATOM:       # %bb.0:
; ATOM-NEXT:    packuswb %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    packuswb (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_packuswb:
; SLM:       # %bb.0:
; SLM-NEXT:    packuswb %mm1, %mm0 # sched: [1:1.00]
; SLM-NEXT:    packuswb (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_packuswb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    packuswb %mm1, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    packuswb (%rdi), %mm0 # sched: [5:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_packuswb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    packuswb %mm1, %mm0 # sched: [3:2.00]
; HASWELL-NEXT:    packuswb (%rdi), %mm0 # sched: [7:2.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_packuswb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    packuswb %mm1, %mm0 # sched: [3:2.00]
; BROADWELL-NEXT:    packuswb (%rdi), %mm0 # sched: [7:2.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_packuswb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    packuswb %mm1, %mm0 # sched: [3:2.00]
; SKYLAKE-NEXT:    packuswb (%rdi), %mm0 # sched: [7:2.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_packuswb:
; SKX:       # %bb.0:
; SKX-NEXT:    packuswb %mm1, %mm0 # sched: [3:2.00]
; SKX-NEXT:    packuswb (%rdi), %mm0 # sched: [7:2.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_packuswb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    packuswb %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    packuswb (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_packuswb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    packuswb %mm1, %mm0 # sched: [1:0.50]
; ZNVER1-NEXT:    packuswb (%rdi), %mm0 # sched: [1:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.packuswb(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.packuswb(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.packuswb(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_paddb(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_paddb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    paddb %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    paddb (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_paddb:
; ATOM:       # %bb.0:
; ATOM-NEXT:    paddb %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    paddb (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_paddb:
; SLM:       # %bb.0:
; SLM-NEXT:    paddb %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    paddb (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_paddb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    paddb %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    paddb (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_paddb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    paddb %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    paddb (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_paddb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    paddb %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    paddb (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_paddb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    paddb %mm1, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    paddb (%rdi), %mm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_paddb:
; SKX:       # %bb.0:
; SKX-NEXT:    paddb %mm1, %mm0 # sched: [1:0.50]
; SKX-NEXT:    paddb (%rdi), %mm0 # sched: [6:0.50]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_paddb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    paddb %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    paddb (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_paddb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    paddb %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    paddb (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.padd.b(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.padd.b(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.padd.b(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_paddd(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_paddd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    paddd %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    paddd (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_paddd:
; ATOM:       # %bb.0:
; ATOM-NEXT:    paddd %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    paddd (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_paddd:
; SLM:       # %bb.0:
; SLM-NEXT:    paddd %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    paddd (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_paddd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    paddd %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    paddd (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_paddd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    paddd %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    paddd (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_paddd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    paddd %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    paddd (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_paddd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    paddd %mm1, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    paddd (%rdi), %mm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_paddd:
; SKX:       # %bb.0:
; SKX-NEXT:    paddd %mm1, %mm0 # sched: [1:0.50]
; SKX-NEXT:    paddd (%rdi), %mm0 # sched: [6:0.50]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_paddd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    paddd %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    paddd (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_paddd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    paddd %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    paddd (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.padd.d(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.padd.d(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.padd.d(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_paddq(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_paddq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    paddq %mm1, %mm0 # sched: [1:0.50]
; GENERIC-NEXT:    paddq (%rdi), %mm0 # sched: [7:0.50]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_paddq:
; ATOM:       # %bb.0:
; ATOM-NEXT:    paddq %mm1, %mm0 # sched: [2:1.00]
; ATOM-NEXT:    paddq (%rdi), %mm0 # sched: [3:1.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_paddq:
; SLM:       # %bb.0:
; SLM-NEXT:    paddq %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    paddq (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_paddq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    paddq %mm1, %mm0 # sched: [1:0.50]
; SANDY-NEXT:    paddq (%rdi), %mm0 # sched: [7:0.50]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_paddq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    paddq %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    paddq (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_paddq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    paddq %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    paddq (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_paddq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    paddq %mm1, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    paddq (%rdi), %mm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_paddq:
; SKX:       # %bb.0:
; SKX-NEXT:    paddq %mm1, %mm0 # sched: [1:0.50]
; SKX-NEXT:    paddq (%rdi), %mm0 # sched: [6:0.50]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_paddq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    paddq %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    paddq (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_paddq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    paddq %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    paddq (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.padd.q(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.padd.q(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.padd.q(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_paddsb(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_paddsb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    paddsb %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    paddsb (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_paddsb:
; ATOM:       # %bb.0:
; ATOM-NEXT:    paddsb %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    paddsb (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_paddsb:
; SLM:       # %bb.0:
; SLM-NEXT:    paddsb %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    paddsb (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_paddsb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    paddsb %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    paddsb (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_paddsb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    paddsb %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    paddsb (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_paddsb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    paddsb %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    paddsb (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_paddsb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    paddsb %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    paddsb (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_paddsb:
; SKX:       # %bb.0:
; SKX-NEXT:    paddsb %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    paddsb (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_paddsb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    paddsb %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    paddsb (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_paddsb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    paddsb %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    paddsb (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.padds.b(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.padds.b(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.padds.b(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_paddsw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_paddsw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    paddsw %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    paddsw (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_paddsw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    paddsw %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    paddsw (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_paddsw:
; SLM:       # %bb.0:
; SLM-NEXT:    paddsw %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    paddsw (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_paddsw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    paddsw %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    paddsw (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_paddsw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    paddsw %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    paddsw (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_paddsw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    paddsw %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    paddsw (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_paddsw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    paddsw %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    paddsw (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_paddsw:
; SKX:       # %bb.0:
; SKX-NEXT:    paddsw %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    paddsw (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_paddsw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    paddsw %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    paddsw (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_paddsw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    paddsw %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    paddsw (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.padds.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.padds.w(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.padds.w(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_paddusb(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_paddusb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    paddusb %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    paddusb (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_paddusb:
; ATOM:       # %bb.0:
; ATOM-NEXT:    paddusb %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    paddusb (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_paddusb:
; SLM:       # %bb.0:
; SLM-NEXT:    paddusb %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    paddusb (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_paddusb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    paddusb %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    paddusb (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_paddusb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    paddusb %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    paddusb (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_paddusb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    paddusb %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    paddusb (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_paddusb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    paddusb %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    paddusb (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_paddusb:
; SKX:       # %bb.0:
; SKX-NEXT:    paddusb %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    paddusb (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_paddusb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    paddusb %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    paddusb (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_paddusb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    paddusb %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    paddusb (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.paddus.b(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.paddus.b(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.paddus.b(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_paddusw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_paddusw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    paddusw %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    paddusw (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_paddusw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    paddusw %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    paddusw (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_paddusw:
; SLM:       # %bb.0:
; SLM-NEXT:    paddusw %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    paddusw (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_paddusw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    paddusw %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    paddusw (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_paddusw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    paddusw %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    paddusw (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_paddusw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    paddusw %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    paddusw (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_paddusw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    paddusw %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    paddusw (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_paddusw:
; SKX:       # %bb.0:
; SKX-NEXT:    paddusw %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    paddusw (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_paddusw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    paddusw %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    paddusw (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_paddusw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    paddusw %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    paddusw (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.paddus.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.paddus.w(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.paddus.w(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_paddw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_paddw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    paddw %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    paddw (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_paddw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    paddw %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    paddw (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_paddw:
; SLM:       # %bb.0:
; SLM-NEXT:    paddw %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    paddw (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_paddw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    paddw %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    paddw (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_paddw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    paddw %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    paddw (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_paddw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    paddw %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    paddw (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_paddw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    paddw %mm1, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    paddw (%rdi), %mm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_paddw:
; SKX:       # %bb.0:
; SKX-NEXT:    paddw %mm1, %mm0 # sched: [1:0.50]
; SKX-NEXT:    paddw (%rdi), %mm0 # sched: [6:0.50]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_paddw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    paddw %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    paddw (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_paddw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    paddw %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    paddw (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.padd.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.padd.w(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.padd.w(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_palignr(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_palignr:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    palignr $1, %mm1, %mm0 # sched: [1:0.50]
; GENERIC-NEXT:    palignr $1, (%rdi), %mm0 # sched: [6:0.50]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_palignr:
; ATOM:       # %bb.0:
; ATOM-NEXT:    palignr $1, %mm1, %mm0
; ATOM-NEXT:    palignr $1, (%rdi), %mm0
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_palignr:
; SLM:       # %bb.0:
; SLM-NEXT:    palignr $1, %mm1, %mm0 # sched: [1:1.00]
; SLM-NEXT:    palignr $1, (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_palignr:
; SANDY:       # %bb.0:
; SANDY-NEXT:    palignr $1, %mm1, %mm0 # sched: [1:0.50]
; SANDY-NEXT:    palignr $1, (%rdi), %mm0 # sched: [6:0.50]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_palignr:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    palignr $1, %mm1, %mm0 # sched: [1:1.00]
; HASWELL-NEXT:    palignr $1, (%rdi), %mm0 # sched: [6:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_palignr:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    palignr $1, %mm1, %mm0 # sched: [1:1.00]
; BROADWELL-NEXT:    palignr $1, (%rdi), %mm0 # sched: [6:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_palignr:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    palignr $1, %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    palignr $1, (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_palignr:
; SKX:       # %bb.0:
; SKX-NEXT:    palignr $1, %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    palignr $1, (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_palignr:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    palignr $1, %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    palignr $1, (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_palignr:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    palignr $1, %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    palignr $1, (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.palignr.b(x86_mmx %a0, x86_mmx %a1, i8 1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.palignr.b(x86_mmx %1, x86_mmx %2, i8 1)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.palignr.b(x86_mmx, x86_mmx, i8) nounwind readnone

define i64 @test_pand(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pand:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pand %mm1, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    pand (%rdi), %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pand:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pand %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    pand (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pand:
; SLM:       # %bb.0:
; SLM-NEXT:    pand %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    pand (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pand:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pand %mm1, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    pand (%rdi), %mm0 # sched: [5:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pand:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pand %mm1, %mm0 # sched: [1:0.33]
; HASWELL-NEXT:    pand (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pand:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pand %mm1, %mm0 # sched: [1:0.33]
; BROADWELL-NEXT:    pand (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pand:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pand %mm1, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    pand (%rdi), %mm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pand:
; SKX:       # %bb.0:
; SKX-NEXT:    pand %mm1, %mm0 # sched: [1:0.50]
; SKX-NEXT:    pand (%rdi), %mm0 # sched: [6:0.50]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pand:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pand %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    pand (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pand:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pand %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    pand (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pand(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pand(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pand(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pandn(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pandn:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pandn %mm1, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    pandn (%rdi), %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pandn:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pandn %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    pandn (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pandn:
; SLM:       # %bb.0:
; SLM-NEXT:    pandn %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    pandn (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pandn:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pandn %mm1, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    pandn (%rdi), %mm0 # sched: [5:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pandn:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pandn %mm1, %mm0 # sched: [1:0.33]
; HASWELL-NEXT:    pandn (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pandn:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pandn %mm1, %mm0 # sched: [1:0.33]
; BROADWELL-NEXT:    pandn (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pandn:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pandn %mm1, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    pandn (%rdi), %mm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pandn:
; SKX:       # %bb.0:
; SKX-NEXT:    pandn %mm1, %mm0 # sched: [1:0.50]
; SKX-NEXT:    pandn (%rdi), %mm0 # sched: [6:0.50]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pandn:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pandn %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    pandn (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pandn:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pandn %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    pandn (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pandn(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pandn(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pandn(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pavgb(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pavgb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pavgb %mm1, %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    pavgb (%rdi), %mm0 # sched: [9:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pavgb:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pavgb %mm1, %mm0 # sched: [1:1.00]
; ATOM-NEXT:    pavgb (%rdi), %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pavgb:
; SLM:       # %bb.0:
; SLM-NEXT:    pavgb %mm1, %mm0 # sched: [4:1.00]
; SLM-NEXT:    pavgb (%rdi), %mm0 # sched: [7:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pavgb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pavgb %mm1, %mm0 # sched: [5:1.00]
; SANDY-NEXT:    pavgb (%rdi), %mm0 # sched: [9:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pavgb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pavgb %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    pavgb (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pavgb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pavgb %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    pavgb (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pavgb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pavgb %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    pavgb (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pavgb:
; SKX:       # %bb.0:
; SKX-NEXT:    pavgb %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    pavgb (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pavgb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pavgb %mm1, %mm0 # sched: [2:1.00]
; BTVER2-NEXT:    pavgb (%rdi), %mm0 # sched: [7:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pavgb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pavgb %mm1, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    pavgb (%rdi), %mm0 # sched: [11:1.00]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pavg.b(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pavg.b(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pavg.b(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pavgw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pavgw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pavgw %mm1, %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    pavgw (%rdi), %mm0 # sched: [9:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pavgw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pavgw %mm1, %mm0 # sched: [1:1.00]
; ATOM-NEXT:    pavgw (%rdi), %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pavgw:
; SLM:       # %bb.0:
; SLM-NEXT:    pavgw %mm1, %mm0 # sched: [4:1.00]
; SLM-NEXT:    pavgw (%rdi), %mm0 # sched: [7:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pavgw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pavgw %mm1, %mm0 # sched: [5:1.00]
; SANDY-NEXT:    pavgw (%rdi), %mm0 # sched: [9:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pavgw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pavgw %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    pavgw (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pavgw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pavgw %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    pavgw (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pavgw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pavgw %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    pavgw (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pavgw:
; SKX:       # %bb.0:
; SKX-NEXT:    pavgw %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    pavgw (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pavgw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pavgw %mm1, %mm0 # sched: [2:1.00]
; BTVER2-NEXT:    pavgw (%rdi), %mm0 # sched: [7:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pavgw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pavgw %mm1, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    pavgw (%rdi), %mm0 # sched: [11:1.00]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pavg.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pavg.w(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pavg.w(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pcmpeqb(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pcmpeqb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pcmpeqb %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    pcmpeqb (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pcmpeqb:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pcmpeqb %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    pcmpeqb (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pcmpeqb:
; SLM:       # %bb.0:
; SLM-NEXT:    pcmpeqb %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    pcmpeqb (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pcmpeqb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pcmpeqb %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    pcmpeqb (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pcmpeqb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pcmpeqb %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    pcmpeqb (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pcmpeqb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pcmpeqb %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    pcmpeqb (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pcmpeqb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pcmpeqb %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    pcmpeqb (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pcmpeqb:
; SKX:       # %bb.0:
; SKX-NEXT:    pcmpeqb %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    pcmpeqb (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pcmpeqb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pcmpeqb %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    pcmpeqb (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pcmpeqb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pcmpeqb %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    pcmpeqb (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pcmpeq.b(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pcmpeq.b(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pcmpeq.b(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pcmpeqd(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pcmpeqd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pcmpeqd %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    pcmpeqd (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pcmpeqd:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pcmpeqd %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    pcmpeqd (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pcmpeqd:
; SLM:       # %bb.0:
; SLM-NEXT:    pcmpeqd %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    pcmpeqd (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pcmpeqd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pcmpeqd %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    pcmpeqd (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pcmpeqd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pcmpeqd %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    pcmpeqd (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pcmpeqd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pcmpeqd %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    pcmpeqd (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pcmpeqd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pcmpeqd %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    pcmpeqd (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pcmpeqd:
; SKX:       # %bb.0:
; SKX-NEXT:    pcmpeqd %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    pcmpeqd (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pcmpeqd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pcmpeqd %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    pcmpeqd (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pcmpeqd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pcmpeqd %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    pcmpeqd (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pcmpeq.d(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pcmpeq.d(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pcmpeq.d(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pcmpeqw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pcmpeqw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pcmpeqw %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    pcmpeqw (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pcmpeqw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pcmpeqw %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    pcmpeqw (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pcmpeqw:
; SLM:       # %bb.0:
; SLM-NEXT:    pcmpeqw %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    pcmpeqw (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pcmpeqw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pcmpeqw %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    pcmpeqw (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pcmpeqw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pcmpeqw %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    pcmpeqw (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pcmpeqw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pcmpeqw %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    pcmpeqw (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pcmpeqw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pcmpeqw %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    pcmpeqw (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pcmpeqw:
; SKX:       # %bb.0:
; SKX-NEXT:    pcmpeqw %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    pcmpeqw (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pcmpeqw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pcmpeqw %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    pcmpeqw (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pcmpeqw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pcmpeqw %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    pcmpeqw (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pcmpeq.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pcmpeq.w(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pcmpeq.w(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pcmpgtb(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pcmpgtb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pcmpgtb %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    pcmpgtb (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pcmpgtb:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pcmpgtb %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    pcmpgtb (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pcmpgtb:
; SLM:       # %bb.0:
; SLM-NEXT:    pcmpgtb %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    pcmpgtb (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pcmpgtb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pcmpgtb %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    pcmpgtb (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pcmpgtb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pcmpgtb %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    pcmpgtb (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pcmpgtb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pcmpgtb %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    pcmpgtb (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pcmpgtb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pcmpgtb %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    pcmpgtb (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pcmpgtb:
; SKX:       # %bb.0:
; SKX-NEXT:    pcmpgtb %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    pcmpgtb (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pcmpgtb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pcmpgtb %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    pcmpgtb (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pcmpgtb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pcmpgtb %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    pcmpgtb (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pcmpgt.b(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pcmpgt.b(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pcmpgt.b(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pcmpgtd(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pcmpgtd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pcmpgtd %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    pcmpgtd (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pcmpgtd:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pcmpgtd %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    pcmpgtd (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pcmpgtd:
; SLM:       # %bb.0:
; SLM-NEXT:    pcmpgtd %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    pcmpgtd (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pcmpgtd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pcmpgtd %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    pcmpgtd (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pcmpgtd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pcmpgtd %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    pcmpgtd (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pcmpgtd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pcmpgtd %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    pcmpgtd (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pcmpgtd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pcmpgtd %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    pcmpgtd (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pcmpgtd:
; SKX:       # %bb.0:
; SKX-NEXT:    pcmpgtd %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    pcmpgtd (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pcmpgtd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pcmpgtd %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    pcmpgtd (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pcmpgtd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pcmpgtd %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    pcmpgtd (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pcmpgt.d(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pcmpgt.d(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pcmpgt.d(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pcmpgtw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pcmpgtw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pcmpgtw %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    pcmpgtw (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pcmpgtw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pcmpgtw %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    pcmpgtw (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pcmpgtw:
; SLM:       # %bb.0:
; SLM-NEXT:    pcmpgtw %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    pcmpgtw (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pcmpgtw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pcmpgtw %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    pcmpgtw (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pcmpgtw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pcmpgtw %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    pcmpgtw (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pcmpgtw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pcmpgtw %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    pcmpgtw (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pcmpgtw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pcmpgtw %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    pcmpgtw (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pcmpgtw:
; SKX:       # %bb.0:
; SKX-NEXT:    pcmpgtw %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    pcmpgtw (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pcmpgtw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pcmpgtw %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    pcmpgtw (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pcmpgtw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pcmpgtw %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    pcmpgtw (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pcmpgt.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pcmpgt.w(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pcmpgt.w(x86_mmx, x86_mmx) nounwind readnone

define i32 @test_pextrw(x86_mmx %a0) optsize {
; GENERIC-LABEL: test_pextrw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pextrw $0, %mm0, %eax # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pextrw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pextrw $0, %mm0, %eax # sched: [4:2.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pextrw:
; SLM:       # %bb.0:
; SLM-NEXT:    pextrw $0, %mm0, %eax # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pextrw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pextrw $0, %mm0, %eax # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pextrw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pextrw $0, %mm0, %eax # sched: [2:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pextrw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pextrw $0, %mm0, %eax # sched: [2:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pextrw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pextrw $0, %mm0, %eax # sched: [3:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pextrw:
; SKX:       # %bb.0:
; SKX-NEXT:    pextrw $0, %mm0, %eax # sched: [3:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pextrw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pextrw $0, %mm0, %eax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pextrw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pextrw $0, %mm0, %eax # sched: [2:2.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call i32 @llvm.x86.mmx.pextr.w(x86_mmx %a0, i32 0)
  ret i32 %1
}
declare i32 @llvm.x86.mmx.pextr.w(x86_mmx, i32) nounwind readnone

define i64 @test_phaddd(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_phaddd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    phaddd %mm1, %mm0 # sched: [3:1.50]
; GENERIC-NEXT:    phaddd (%rdi), %mm0 # sched: [8:1.50]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_phaddd:
; ATOM:       # %bb.0:
; ATOM-NEXT:    phaddd %mm1, %mm0 # sched: [3:1.50]
; ATOM-NEXT:    phaddd (%rdi), %mm0 # sched: [4:2.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_phaddd:
; SLM:       # %bb.0:
; SLM-NEXT:    phaddd %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    phaddd (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_phaddd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    phaddd %mm1, %mm0 # sched: [3:1.50]
; SANDY-NEXT:    phaddd (%rdi), %mm0 # sched: [8:1.50]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_phaddd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    phaddd %mm1, %mm0 # sched: [3:2.00]
; HASWELL-NEXT:    phaddd (%rdi), %mm0 # sched: [8:2.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_phaddd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    phaddd %mm1, %mm0 # sched: [3:2.00]
; BROADWELL-NEXT:    phaddd (%rdi), %mm0 # sched: [8:2.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_phaddd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    phaddd %mm1, %mm0 # sched: [3:2.00]
; SKYLAKE-NEXT:    phaddd (%rdi), %mm0 # sched: [8:2.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_phaddd:
; SKX:       # %bb.0:
; SKX-NEXT:    phaddd %mm1, %mm0 # sched: [3:2.00]
; SKX-NEXT:    phaddd (%rdi), %mm0 # sched: [8:2.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_phaddd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    phaddd %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    phaddd (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_phaddd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    phaddd %mm1, %mm0 # sched: [100:?]
; ZNVER1-NEXT:    phaddd (%rdi), %mm0 # sched: [100:?]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.ssse3.phadd.d(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.ssse3.phadd.d(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.ssse3.phadd.d(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_phaddsw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_phaddsw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    phaddsw %mm1, %mm0 # sched: [3:1.50]
; GENERIC-NEXT:    phaddsw (%rdi), %mm0 # sched: [8:1.50]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_phaddsw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    phaddsw %mm1, %mm0 # sched: [5:2.50]
; ATOM-NEXT:    phaddsw (%rdi), %mm0 # sched: [6:3.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_phaddsw:
; SLM:       # %bb.0:
; SLM-NEXT:    phaddsw %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    phaddsw (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_phaddsw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    phaddsw %mm1, %mm0 # sched: [3:1.50]
; SANDY-NEXT:    phaddsw (%rdi), %mm0 # sched: [8:1.50]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_phaddsw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    phaddsw %mm1, %mm0 # sched: [3:2.00]
; HASWELL-NEXT:    phaddsw (%rdi), %mm0 # sched: [8:2.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_phaddsw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    phaddsw %mm1, %mm0 # sched: [3:2.00]
; BROADWELL-NEXT:    phaddsw (%rdi), %mm0 # sched: [8:2.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_phaddsw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    phaddsw %mm1, %mm0 # sched: [3:2.00]
; SKYLAKE-NEXT:    phaddsw (%rdi), %mm0 # sched: [8:2.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_phaddsw:
; SKX:       # %bb.0:
; SKX-NEXT:    phaddsw %mm1, %mm0 # sched: [3:2.00]
; SKX-NEXT:    phaddsw (%rdi), %mm0 # sched: [8:2.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_phaddsw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    phaddsw %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    phaddsw (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_phaddsw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    phaddsw %mm1, %mm0 # sched: [100:?]
; ZNVER1-NEXT:    phaddsw (%rdi), %mm0 # sched: [100:?]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.ssse3.phadd.sw(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.ssse3.phadd.sw(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.ssse3.phadd.sw(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_phaddw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_phaddw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    phaddw %mm1, %mm0 # sched: [3:1.50]
; GENERIC-NEXT:    phaddw (%rdi), %mm0 # sched: [8:1.50]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_phaddw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    phaddw %mm1, %mm0 # sched: [5:2.50]
; ATOM-NEXT:    phaddw (%rdi), %mm0 # sched: [6:3.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_phaddw:
; SLM:       # %bb.0:
; SLM-NEXT:    phaddw %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    phaddw (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_phaddw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    phaddw %mm1, %mm0 # sched: [3:1.50]
; SANDY-NEXT:    phaddw (%rdi), %mm0 # sched: [8:1.50]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_phaddw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    phaddw %mm1, %mm0 # sched: [3:2.00]
; HASWELL-NEXT:    phaddw (%rdi), %mm0 # sched: [8:2.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_phaddw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    phaddw %mm1, %mm0 # sched: [3:2.00]
; BROADWELL-NEXT:    phaddw (%rdi), %mm0 # sched: [8:2.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_phaddw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    phaddw %mm1, %mm0 # sched: [3:2.00]
; SKYLAKE-NEXT:    phaddw (%rdi), %mm0 # sched: [8:2.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_phaddw:
; SKX:       # %bb.0:
; SKX-NEXT:    phaddw %mm1, %mm0 # sched: [3:2.00]
; SKX-NEXT:    phaddw (%rdi), %mm0 # sched: [8:2.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_phaddw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    phaddw %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    phaddw (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_phaddw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    phaddw %mm1, %mm0 # sched: [100:?]
; ZNVER1-NEXT:    phaddw (%rdi), %mm0 # sched: [100:?]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.ssse3.phadd.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.ssse3.phadd.w(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.ssse3.phadd.w(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_phsubd(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_phsubd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    phsubd %mm1, %mm0 # sched: [3:1.50]
; GENERIC-NEXT:    phsubd (%rdi), %mm0 # sched: [8:1.50]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_phsubd:
; ATOM:       # %bb.0:
; ATOM-NEXT:    phsubd %mm1, %mm0 # sched: [3:1.50]
; ATOM-NEXT:    phsubd (%rdi), %mm0 # sched: [4:2.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_phsubd:
; SLM:       # %bb.0:
; SLM-NEXT:    phsubd %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    phsubd (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_phsubd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    phsubd %mm1, %mm0 # sched: [3:1.50]
; SANDY-NEXT:    phsubd (%rdi), %mm0 # sched: [8:1.50]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_phsubd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    phsubd %mm1, %mm0 # sched: [3:2.00]
; HASWELL-NEXT:    phsubd (%rdi), %mm0 # sched: [8:2.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_phsubd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    phsubd %mm1, %mm0 # sched: [3:2.00]
; BROADWELL-NEXT:    phsubd (%rdi), %mm0 # sched: [8:2.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_phsubd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    phsubd %mm1, %mm0 # sched: [3:2.00]
; SKYLAKE-NEXT:    phsubd (%rdi), %mm0 # sched: [8:2.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_phsubd:
; SKX:       # %bb.0:
; SKX-NEXT:    phsubd %mm1, %mm0 # sched: [3:2.00]
; SKX-NEXT:    phsubd (%rdi), %mm0 # sched: [8:2.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_phsubd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    phsubd %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    phsubd (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_phsubd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    phsubd %mm1, %mm0 # sched: [100:?]
; ZNVER1-NEXT:    phsubd (%rdi), %mm0 # sched: [100:?]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.ssse3.phsub.d(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.ssse3.phsub.d(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.ssse3.phsub.d(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_phsubsw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_phsubsw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    phsubsw %mm1, %mm0 # sched: [3:1.50]
; GENERIC-NEXT:    phsubsw (%rdi), %mm0 # sched: [8:1.50]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_phsubsw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    phsubsw %mm1, %mm0 # sched: [5:2.50]
; ATOM-NEXT:    phsubsw (%rdi), %mm0 # sched: [6:3.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_phsubsw:
; SLM:       # %bb.0:
; SLM-NEXT:    phsubsw %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    phsubsw (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_phsubsw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    phsubsw %mm1, %mm0 # sched: [3:1.50]
; SANDY-NEXT:    phsubsw (%rdi), %mm0 # sched: [8:1.50]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_phsubsw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    phsubsw %mm1, %mm0 # sched: [3:2.00]
; HASWELL-NEXT:    phsubsw (%rdi), %mm0 # sched: [8:2.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_phsubsw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    phsubsw %mm1, %mm0 # sched: [3:2.00]
; BROADWELL-NEXT:    phsubsw (%rdi), %mm0 # sched: [8:2.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_phsubsw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    phsubsw %mm1, %mm0 # sched: [3:2.00]
; SKYLAKE-NEXT:    phsubsw (%rdi), %mm0 # sched: [8:2.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_phsubsw:
; SKX:       # %bb.0:
; SKX-NEXT:    phsubsw %mm1, %mm0 # sched: [3:2.00]
; SKX-NEXT:    phsubsw (%rdi), %mm0 # sched: [8:2.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_phsubsw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    phsubsw %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    phsubsw (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_phsubsw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    phsubsw %mm1, %mm0 # sched: [100:?]
; ZNVER1-NEXT:    phsubsw (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.ssse3.phsub.sw(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.ssse3.phsub.sw(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.ssse3.phsub.sw(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_phsubw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_phsubw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    phsubw %mm1, %mm0 # sched: [3:1.50]
; GENERIC-NEXT:    phsubw (%rdi), %mm0 # sched: [8:1.50]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_phsubw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    phsubw %mm1, %mm0 # sched: [5:2.50]
; ATOM-NEXT:    phsubw (%rdi), %mm0 # sched: [6:3.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_phsubw:
; SLM:       # %bb.0:
; SLM-NEXT:    phsubw %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    phsubw (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_phsubw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    phsubw %mm1, %mm0 # sched: [3:1.50]
; SANDY-NEXT:    phsubw (%rdi), %mm0 # sched: [8:1.50]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_phsubw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    phsubw %mm1, %mm0 # sched: [3:2.00]
; HASWELL-NEXT:    phsubw (%rdi), %mm0 # sched: [8:2.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_phsubw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    phsubw %mm1, %mm0 # sched: [3:2.00]
; BROADWELL-NEXT:    phsubw (%rdi), %mm0 # sched: [8:2.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_phsubw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    phsubw %mm1, %mm0 # sched: [3:2.00]
; SKYLAKE-NEXT:    phsubw (%rdi), %mm0 # sched: [8:2.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_phsubw:
; SKX:       # %bb.0:
; SKX-NEXT:    phsubw %mm1, %mm0 # sched: [3:2.00]
; SKX-NEXT:    phsubw (%rdi), %mm0 # sched: [8:2.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_phsubw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    phsubw %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    phsubw (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_phsubw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    phsubw %mm1, %mm0 # sched: [100:?]
; ZNVER1-NEXT:    phsubw (%rdi), %mm0 # sched: [100:?]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.ssse3.phsub.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.ssse3.phsub.w(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.ssse3.phsub.w(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pinsrw(x86_mmx %a0, i32 %a1, i16* %a2) optsize {
; GENERIC-LABEL: test_pinsrw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pinsrw $0, %edi, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    movswl (%rsi), %eax # sched: [5:0.50]
; GENERIC-NEXT:    pinsrw $1, %eax, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pinsrw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movswl (%rsi), %eax # sched: [1:1.00]
; ATOM-NEXT:    pinsrw $0, %edi, %mm0 # sched: [1:1.00]
; ATOM-NEXT:    pinsrw $1, %eax, %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pinsrw:
; SLM:       # %bb.0:
; SLM-NEXT:    movswl (%rsi), %eax # sched: [4:1.00]
; SLM-NEXT:    pinsrw $0, %edi, %mm0 # sched: [1:1.00]
; SLM-NEXT:    pinsrw $1, %eax, %mm0 # sched: [1:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pinsrw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pinsrw $0, %edi, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    movswl (%rsi), %eax # sched: [5:0.50]
; SANDY-NEXT:    pinsrw $1, %eax, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pinsrw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pinsrw $0, %edi, %mm0 # sched: [2:2.00]
; HASWELL-NEXT:    movswl (%rsi), %eax # sched: [5:0.50]
; HASWELL-NEXT:    pinsrw $1, %eax, %mm0 # sched: [2:2.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pinsrw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pinsrw $0, %edi, %mm0 # sched: [2:2.00]
; BROADWELL-NEXT:    movswl (%rsi), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    pinsrw $1, %eax, %mm0 # sched: [2:2.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pinsrw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pinsrw $0, %edi, %mm0 # sched: [2:2.00]
; SKYLAKE-NEXT:    movswl (%rsi), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    pinsrw $1, %eax, %mm0 # sched: [2:2.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pinsrw:
; SKX:       # %bb.0:
; SKX-NEXT:    pinsrw $0, %edi, %mm0 # sched: [2:2.00]
; SKX-NEXT:    movswl (%rsi), %eax # sched: [5:0.50]
; SKX-NEXT:    pinsrw $1, %eax, %mm0 # sched: [2:2.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pinsrw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movswl (%rsi), %eax # sched: [4:1.00]
; BTVER2-NEXT:    pinsrw $0, %edi, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    pinsrw $1, %eax, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pinsrw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movswl (%rsi), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    pinsrw $0, %edi, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    pinsrw $1, %eax, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pinsr.w(x86_mmx %a0, i32 %a1, i32 0)
  %2 = load i16, i16 *%a2, align 2
  %3 = sext i16 %2 to i32
  %4 = call x86_mmx @llvm.x86.mmx.pinsr.w(x86_mmx %1, i32 %3, i32 1)
  %5 = bitcast x86_mmx %4 to i64
  ret i64 %5
}
declare x86_mmx @llvm.x86.mmx.pinsr.w(x86_mmx, i32, i32) nounwind readnone

define i64 @test_pmaddwd(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pmaddwd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmaddwd %mm1, %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    pmaddwd (%rdi), %mm0 # sched: [9:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pmaddwd:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pmaddwd %mm1, %mm0 # sched: [4:4.00]
; ATOM-NEXT:    pmaddwd (%rdi), %mm0 # sched: [4:4.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pmaddwd:
; SLM:       # %bb.0:
; SLM-NEXT:    pmaddwd %mm1, %mm0 # sched: [4:1.00]
; SLM-NEXT:    pmaddwd (%rdi), %mm0 # sched: [7:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pmaddwd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pmaddwd %mm1, %mm0 # sched: [5:1.00]
; SANDY-NEXT:    pmaddwd (%rdi), %mm0 # sched: [9:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pmaddwd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pmaddwd %mm1, %mm0 # sched: [5:1.00]
; HASWELL-NEXT:    pmaddwd (%rdi), %mm0 # sched: [10:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmaddwd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pmaddwd %mm1, %mm0 # sched: [5:1.00]
; BROADWELL-NEXT:    pmaddwd (%rdi), %mm0 # sched: [10:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmaddwd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pmaddwd %mm1, %mm0 # sched: [4:1.00]
; SKYLAKE-NEXT:    pmaddwd (%rdi), %mm0 # sched: [9:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmaddwd:
; SKX:       # %bb.0:
; SKX-NEXT:    pmaddwd %mm1, %mm0 # sched: [4:1.00]
; SKX-NEXT:    pmaddwd (%rdi), %mm0 # sched: [9:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pmaddwd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pmaddwd %mm1, %mm0 # sched: [2:1.00]
; BTVER2-NEXT:    pmaddwd (%rdi), %mm0 # sched: [7:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pmaddwd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pmaddwd %mm1, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    pmaddwd (%rdi), %mm0 # sched: [11:1.00]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pmadd.wd(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pmadd.wd(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pmadd.wd(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pmaddubsw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pmaddubsw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmaddubsw %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    pmaddubsw (%rdi), %mm0 # sched: [8:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pmaddubsw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pmaddubsw %mm1, %mm0 # sched: [4:4.00]
; ATOM-NEXT:    pmaddubsw (%rdi), %mm0 # sched: [4:4.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pmaddubsw:
; SLM:       # %bb.0:
; SLM-NEXT:    pmaddubsw %mm1, %mm0 # sched: [4:1.00]
; SLM-NEXT:    pmaddubsw (%rdi), %mm0 # sched: [7:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pmaddubsw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pmaddubsw %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    pmaddubsw (%rdi), %mm0 # sched: [8:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pmaddubsw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pmaddubsw %mm1, %mm0 # sched: [5:1.00]
; HASWELL-NEXT:    pmaddubsw (%rdi), %mm0 # sched: [10:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmaddubsw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pmaddubsw %mm1, %mm0 # sched: [5:1.00]
; BROADWELL-NEXT:    pmaddubsw (%rdi), %mm0 # sched: [10:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmaddubsw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pmaddubsw %mm1, %mm0 # sched: [4:1.00]
; SKYLAKE-NEXT:    pmaddubsw (%rdi), %mm0 # sched: [9:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmaddubsw:
; SKX:       # %bb.0:
; SKX-NEXT:    pmaddubsw %mm1, %mm0 # sched: [4:1.00]
; SKX-NEXT:    pmaddubsw (%rdi), %mm0 # sched: [9:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pmaddubsw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pmaddubsw %mm1, %mm0 # sched: [2:1.00]
; BTVER2-NEXT:    pmaddubsw (%rdi), %mm0 # sched: [7:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pmaddubsw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pmaddubsw %mm1, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    pmaddubsw (%rdi), %mm0 # sched: [11:1.00]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.ssse3.pmadd.ub.sw(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.ssse3.pmadd.ub.sw(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.ssse3.pmadd.ub.sw(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pmaxsw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pmaxsw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmaxsw %mm1, %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    pmaxsw (%rdi), %mm0 # sched: [9:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pmaxsw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pmaxsw %mm1, %mm0 # sched: [1:1.00]
; ATOM-NEXT:    pmaxsw (%rdi), %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pmaxsw:
; SLM:       # %bb.0:
; SLM-NEXT:    pmaxsw %mm1, %mm0 # sched: [4:1.00]
; SLM-NEXT:    pmaxsw (%rdi), %mm0 # sched: [7:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pmaxsw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pmaxsw %mm1, %mm0 # sched: [5:1.00]
; SANDY-NEXT:    pmaxsw (%rdi), %mm0 # sched: [9:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pmaxsw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pmaxsw %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    pmaxsw (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmaxsw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pmaxsw %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    pmaxsw (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmaxsw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pmaxsw %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    pmaxsw (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmaxsw:
; SKX:       # %bb.0:
; SKX-NEXT:    pmaxsw %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    pmaxsw (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pmaxsw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pmaxsw %mm1, %mm0 # sched: [2:1.00]
; BTVER2-NEXT:    pmaxsw (%rdi), %mm0 # sched: [7:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pmaxsw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pmaxsw %mm1, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    pmaxsw (%rdi), %mm0 # sched: [11:1.00]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pmaxs.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pmaxs.w(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pmaxs.w(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pmaxub(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pmaxub:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmaxub %mm1, %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    pmaxub (%rdi), %mm0 # sched: [9:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pmaxub:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pmaxub %mm1, %mm0 # sched: [1:1.00]
; ATOM-NEXT:    pmaxub (%rdi), %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pmaxub:
; SLM:       # %bb.0:
; SLM-NEXT:    pmaxub %mm1, %mm0 # sched: [4:1.00]
; SLM-NEXT:    pmaxub (%rdi), %mm0 # sched: [7:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pmaxub:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pmaxub %mm1, %mm0 # sched: [5:1.00]
; SANDY-NEXT:    pmaxub (%rdi), %mm0 # sched: [9:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pmaxub:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pmaxub %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    pmaxub (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmaxub:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pmaxub %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    pmaxub (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmaxub:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pmaxub %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    pmaxub (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmaxub:
; SKX:       # %bb.0:
; SKX-NEXT:    pmaxub %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    pmaxub (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pmaxub:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pmaxub %mm1, %mm0 # sched: [2:1.00]
; BTVER2-NEXT:    pmaxub (%rdi), %mm0 # sched: [7:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pmaxub:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pmaxub %mm1, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    pmaxub (%rdi), %mm0 # sched: [11:1.00]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pmaxu.b(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pmaxu.b(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pmaxu.b(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pminsw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pminsw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pminsw %mm1, %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    pminsw (%rdi), %mm0 # sched: [9:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pminsw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pminsw %mm1, %mm0 # sched: [1:1.00]
; ATOM-NEXT:    pminsw (%rdi), %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pminsw:
; SLM:       # %bb.0:
; SLM-NEXT:    pminsw %mm1, %mm0 # sched: [4:1.00]
; SLM-NEXT:    pminsw (%rdi), %mm0 # sched: [7:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pminsw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pminsw %mm1, %mm0 # sched: [5:1.00]
; SANDY-NEXT:    pminsw (%rdi), %mm0 # sched: [9:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pminsw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pminsw %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    pminsw (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pminsw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pminsw %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    pminsw (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pminsw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pminsw %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    pminsw (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pminsw:
; SKX:       # %bb.0:
; SKX-NEXT:    pminsw %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    pminsw (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pminsw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pminsw %mm1, %mm0 # sched: [2:1.00]
; BTVER2-NEXT:    pminsw (%rdi), %mm0 # sched: [7:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pminsw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pminsw %mm1, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    pminsw (%rdi), %mm0 # sched: [11:1.00]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pmins.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pmins.w(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pmins.w(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pminub(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pminub:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pminub %mm1, %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    pminub (%rdi), %mm0 # sched: [9:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pminub:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pminub %mm1, %mm0 # sched: [1:1.00]
; ATOM-NEXT:    pminub (%rdi), %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pminub:
; SLM:       # %bb.0:
; SLM-NEXT:    pminub %mm1, %mm0 # sched: [4:1.00]
; SLM-NEXT:    pminub (%rdi), %mm0 # sched: [7:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pminub:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pminub %mm1, %mm0 # sched: [5:1.00]
; SANDY-NEXT:    pminub (%rdi), %mm0 # sched: [9:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pminub:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pminub %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    pminub (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pminub:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pminub %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    pminub (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pminub:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pminub %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    pminub (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pminub:
; SKX:       # %bb.0:
; SKX-NEXT:    pminub %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    pminub (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pminub:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pminub %mm1, %mm0 # sched: [2:1.00]
; BTVER2-NEXT:    pminub (%rdi), %mm0 # sched: [7:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pminub:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pminub %mm1, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    pminub (%rdi), %mm0 # sched: [11:1.00]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pminu.b(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pminu.b(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pminu.b(x86_mmx, x86_mmx) nounwind readnone

define i32 @test_pmovmskb(x86_mmx %a0) optsize {
; GENERIC-LABEL: test_pmovmskb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmovmskb %mm0, %eax # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pmovmskb:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pmovmskb %mm0, %eax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pmovmskb:
; SLM:       # %bb.0:
; SLM-NEXT:    pmovmskb %mm0, %eax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pmovmskb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pmovmskb %mm0, %eax # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pmovmskb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pmovmskb %mm0, %eax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmovmskb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pmovmskb %mm0, %eax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmovmskb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pmovmskb %mm0, %eax # sched: [2:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmovmskb:
; SKX:       # %bb.0:
; SKX-NEXT:    pmovmskb %mm0, %eax # sched: [2:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pmovmskb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pmovmskb %mm0, %eax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pmovmskb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pmovmskb %mm0, %eax # sched: [1:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call i32 @llvm.x86.mmx.pmovmskb(x86_mmx %a0)
  ret i32 %1
}
declare i32 @llvm.x86.mmx.pmovmskb(x86_mmx) nounwind readnone

define i64 @test_pmulhrsw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pmulhrsw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmulhrsw %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    pmulhrsw (%rdi), %mm0 # sched: [8:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pmulhrsw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pmulhrsw %mm1, %mm0 # sched: [4:4.00]
; ATOM-NEXT:    pmulhrsw (%rdi), %mm0 # sched: [4:4.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pmulhrsw:
; SLM:       # %bb.0:
; SLM-NEXT:    pmulhrsw %mm1, %mm0 # sched: [4:1.00]
; SLM-NEXT:    pmulhrsw (%rdi), %mm0 # sched: [7:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pmulhrsw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pmulhrsw %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    pmulhrsw (%rdi), %mm0 # sched: [8:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pmulhrsw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pmulhrsw %mm1, %mm0 # sched: [5:1.00]
; HASWELL-NEXT:    pmulhrsw (%rdi), %mm0 # sched: [10:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmulhrsw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pmulhrsw %mm1, %mm0 # sched: [5:1.00]
; BROADWELL-NEXT:    pmulhrsw (%rdi), %mm0 # sched: [10:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmulhrsw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pmulhrsw %mm1, %mm0 # sched: [4:1.00]
; SKYLAKE-NEXT:    pmulhrsw (%rdi), %mm0 # sched: [9:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmulhrsw:
; SKX:       # %bb.0:
; SKX-NEXT:    pmulhrsw %mm1, %mm0 # sched: [4:1.00]
; SKX-NEXT:    pmulhrsw (%rdi), %mm0 # sched: [9:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pmulhrsw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pmulhrsw %mm1, %mm0 # sched: [2:1.00]
; BTVER2-NEXT:    pmulhrsw (%rdi), %mm0 # sched: [7:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pmulhrsw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pmulhrsw %mm1, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    pmulhrsw (%rdi), %mm0 # sched: [11:1.00]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.ssse3.pmul.hr.sw(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.ssse3.pmul.hr.sw(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.ssse3.pmul.hr.sw(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pmulhw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pmulhw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmulhw %mm1, %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    pmulhw (%rdi), %mm0 # sched: [9:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pmulhw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pmulhw %mm1, %mm0 # sched: [4:4.00]
; ATOM-NEXT:    pmulhw (%rdi), %mm0 # sched: [4:4.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pmulhw:
; SLM:       # %bb.0:
; SLM-NEXT:    pmulhw %mm1, %mm0 # sched: [4:1.00]
; SLM-NEXT:    pmulhw (%rdi), %mm0 # sched: [7:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pmulhw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pmulhw %mm1, %mm0 # sched: [5:1.00]
; SANDY-NEXT:    pmulhw (%rdi), %mm0 # sched: [9:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pmulhw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pmulhw %mm1, %mm0 # sched: [5:1.00]
; HASWELL-NEXT:    pmulhw (%rdi), %mm0 # sched: [10:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmulhw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pmulhw %mm1, %mm0 # sched: [5:1.00]
; BROADWELL-NEXT:    pmulhw (%rdi), %mm0 # sched: [10:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmulhw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pmulhw %mm1, %mm0 # sched: [4:1.00]
; SKYLAKE-NEXT:    pmulhw (%rdi), %mm0 # sched: [9:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmulhw:
; SKX:       # %bb.0:
; SKX-NEXT:    pmulhw %mm1, %mm0 # sched: [4:1.00]
; SKX-NEXT:    pmulhw (%rdi), %mm0 # sched: [9:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pmulhw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pmulhw %mm1, %mm0 # sched: [2:1.00]
; BTVER2-NEXT:    pmulhw (%rdi), %mm0 # sched: [7:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pmulhw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pmulhw %mm1, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    pmulhw (%rdi), %mm0 # sched: [11:1.00]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pmulh.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pmulh.w(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pmulh.w(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pmulhuw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pmulhuw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmulhuw %mm1, %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    pmulhuw (%rdi), %mm0 # sched: [9:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pmulhuw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pmulhuw %mm1, %mm0 # sched: [4:4.00]
; ATOM-NEXT:    pmulhuw (%rdi), %mm0 # sched: [4:4.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pmulhuw:
; SLM:       # %bb.0:
; SLM-NEXT:    pmulhuw %mm1, %mm0 # sched: [4:1.00]
; SLM-NEXT:    pmulhuw (%rdi), %mm0 # sched: [7:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pmulhuw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pmulhuw %mm1, %mm0 # sched: [5:1.00]
; SANDY-NEXT:    pmulhuw (%rdi), %mm0 # sched: [9:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pmulhuw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pmulhuw %mm1, %mm0 # sched: [5:1.00]
; HASWELL-NEXT:    pmulhuw (%rdi), %mm0 # sched: [10:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmulhuw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pmulhuw %mm1, %mm0 # sched: [5:1.00]
; BROADWELL-NEXT:    pmulhuw (%rdi), %mm0 # sched: [10:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmulhuw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pmulhuw %mm1, %mm0 # sched: [4:1.00]
; SKYLAKE-NEXT:    pmulhuw (%rdi), %mm0 # sched: [9:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmulhuw:
; SKX:       # %bb.0:
; SKX-NEXT:    pmulhuw %mm1, %mm0 # sched: [4:1.00]
; SKX-NEXT:    pmulhuw (%rdi), %mm0 # sched: [9:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pmulhuw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pmulhuw %mm1, %mm0 # sched: [2:1.00]
; BTVER2-NEXT:    pmulhuw (%rdi), %mm0 # sched: [7:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pmulhuw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pmulhuw %mm1, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    pmulhuw (%rdi), %mm0 # sched: [11:1.00]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pmulhu.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pmulhu.w(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pmulhu.w(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pmullw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pmullw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmullw %mm1, %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    pmullw (%rdi), %mm0 # sched: [9:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pmullw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pmullw %mm1, %mm0 # sched: [4:4.00]
; ATOM-NEXT:    pmullw (%rdi), %mm0 # sched: [4:4.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pmullw:
; SLM:       # %bb.0:
; SLM-NEXT:    pmullw %mm1, %mm0 # sched: [4:1.00]
; SLM-NEXT:    pmullw (%rdi), %mm0 # sched: [7:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pmullw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pmullw %mm1, %mm0 # sched: [5:1.00]
; SANDY-NEXT:    pmullw (%rdi), %mm0 # sched: [9:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pmullw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pmullw %mm1, %mm0 # sched: [5:1.00]
; HASWELL-NEXT:    pmullw (%rdi), %mm0 # sched: [10:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmullw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pmullw %mm1, %mm0 # sched: [5:1.00]
; BROADWELL-NEXT:    pmullw (%rdi), %mm0 # sched: [10:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmullw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pmullw %mm1, %mm0 # sched: [4:1.00]
; SKYLAKE-NEXT:    pmullw (%rdi), %mm0 # sched: [9:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmullw:
; SKX:       # %bb.0:
; SKX-NEXT:    pmullw %mm1, %mm0 # sched: [4:1.00]
; SKX-NEXT:    pmullw (%rdi), %mm0 # sched: [9:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pmullw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pmullw %mm1, %mm0 # sched: [2:1.00]
; BTVER2-NEXT:    pmullw (%rdi), %mm0 # sched: [7:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pmullw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pmullw %mm1, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    pmullw (%rdi), %mm0 # sched: [11:1.00]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pmull.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pmull.w(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pmull.w(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pmuludq(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pmuludq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pmuludq %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    pmuludq (%rdi), %mm0 # sched: [9:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pmuludq:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pmuludq %mm1, %mm0 # sched: [4:4.00]
; ATOM-NEXT:    pmuludq (%rdi), %mm0 # sched: [4:4.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pmuludq:
; SLM:       # %bb.0:
; SLM-NEXT:    pmuludq %mm1, %mm0 # sched: [4:1.00]
; SLM-NEXT:    pmuludq (%rdi), %mm0 # sched: [7:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pmuludq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pmuludq %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    pmuludq (%rdi), %mm0 # sched: [9:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pmuludq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pmuludq %mm1, %mm0 # sched: [5:1.00]
; HASWELL-NEXT:    pmuludq (%rdi), %mm0 # sched: [10:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pmuludq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pmuludq %mm1, %mm0 # sched: [5:1.00]
; BROADWELL-NEXT:    pmuludq (%rdi), %mm0 # sched: [10:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pmuludq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pmuludq %mm1, %mm0 # sched: [4:1.00]
; SKYLAKE-NEXT:    pmuludq (%rdi), %mm0 # sched: [9:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pmuludq:
; SKX:       # %bb.0:
; SKX-NEXT:    pmuludq %mm1, %mm0 # sched: [4:1.00]
; SKX-NEXT:    pmuludq (%rdi), %mm0 # sched: [9:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pmuludq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pmuludq %mm1, %mm0 # sched: [2:1.00]
; BTVER2-NEXT:    pmuludq (%rdi), %mm0 # sched: [7:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pmuludq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pmuludq %mm1, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    pmuludq (%rdi), %mm0 # sched: [11:1.00]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pmulu.dq(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pmulu.dq(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pmulu.dq(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_por(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_por:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    por %mm1, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    por (%rdi), %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_por:
; ATOM:       # %bb.0:
; ATOM-NEXT:    por %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    por (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_por:
; SLM:       # %bb.0:
; SLM-NEXT:    por %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    por (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_por:
; SANDY:       # %bb.0:
; SANDY-NEXT:    por %mm1, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    por (%rdi), %mm0 # sched: [5:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_por:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    por %mm1, %mm0 # sched: [1:0.33]
; HASWELL-NEXT:    por (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_por:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    por %mm1, %mm0 # sched: [1:0.33]
; BROADWELL-NEXT:    por (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_por:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    por %mm1, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    por (%rdi), %mm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_por:
; SKX:       # %bb.0:
; SKX-NEXT:    por %mm1, %mm0 # sched: [1:0.50]
; SKX-NEXT:    por (%rdi), %mm0 # sched: [6:0.50]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_por:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    por %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    por (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_por:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    por %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    por (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.por(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.por(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.por(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_psadbw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_psadbw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    psadbw %mm1, %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    psadbw (%rdi), %mm0 # sched: [9:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_psadbw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    psadbw %mm1, %mm0 # sched: [4:2.00]
; ATOM-NEXT:    psadbw (%rdi), %mm0 # sched: [4:2.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_psadbw:
; SLM:       # %bb.0:
; SLM-NEXT:    psadbw %mm1, %mm0 # sched: [4:1.00]
; SLM-NEXT:    psadbw (%rdi), %mm0 # sched: [7:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_psadbw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    psadbw %mm1, %mm0 # sched: [5:1.00]
; SANDY-NEXT:    psadbw (%rdi), %mm0 # sched: [9:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_psadbw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    psadbw %mm1, %mm0 # sched: [5:1.00]
; HASWELL-NEXT:    psadbw (%rdi), %mm0 # sched: [10:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_psadbw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    psadbw %mm1, %mm0 # sched: [5:1.00]
; BROADWELL-NEXT:    psadbw (%rdi), %mm0 # sched: [10:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_psadbw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    psadbw %mm1, %mm0 # sched: [3:1.00]
; SKYLAKE-NEXT:    psadbw (%rdi), %mm0 # sched: [8:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_psadbw:
; SKX:       # %bb.0:
; SKX-NEXT:    psadbw %mm1, %mm0 # sched: [3:1.00]
; SKX-NEXT:    psadbw (%rdi), %mm0 # sched: [8:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_psadbw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    psadbw %mm1, %mm0 # sched: [2:1.00]
; BTVER2-NEXT:    psadbw (%rdi), %mm0 # sched: [7:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_psadbw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    psadbw %mm1, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    psadbw (%rdi), %mm0 # sched: [11:1.00]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.psad.bw(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.psad.bw(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.psad.bw(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pshufb(x86_mmx %a0, x86_mmx %a1, x86_mmx *%a2) optsize {
; GENERIC-LABEL: test_pshufb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pshufb %mm1, %mm0 # sched: [1:0.50]
; GENERIC-NEXT:    pshufb (%rdi), %mm0 # sched: [6:0.50]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pshufb:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pshufb %mm1, %mm0 # sched: [1:1.00]
; ATOM-NEXT:    pshufb (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pshufb:
; SLM:       # %bb.0:
; SLM-NEXT:    pshufb %mm1, %mm0 # sched: [1:1.00]
; SLM-NEXT:    pshufb (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pshufb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pshufb %mm1, %mm0 # sched: [1:0.50]
; SANDY-NEXT:    pshufb (%rdi), %mm0 # sched: [6:0.50]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pshufb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pshufb %mm1, %mm0 # sched: [1:1.00]
; HASWELL-NEXT:    pshufb (%rdi), %mm0 # sched: [6:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pshufb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pshufb %mm1, %mm0 # sched: [1:1.00]
; BROADWELL-NEXT:    pshufb (%rdi), %mm0 # sched: [6:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pshufb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pshufb %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    pshufb (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pshufb:
; SKX:       # %bb.0:
; SKX-NEXT:    pshufb %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    pshufb (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pshufb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pshufb %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    pshufb (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pshufb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pshufb %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    pshufb (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.ssse3.pshuf.b(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.ssse3.pshuf.b(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.ssse3.pshuf.b(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pshufw(x86_mmx *%a0) optsize {
; GENERIC-LABEL: test_pshufw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pshufw $0, (%rdi), %mm0 # mm0 = mem[0,0,0,0] sched: [5:1.00]
; GENERIC-NEXT:    pshufw $0, %mm0, %mm0 # mm0 = mm0[0,0,0,0] sched: [1:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pshufw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pshufw $0, (%rdi), %mm0 # mm0 = mem[0,0,0,0] sched: [1:1.00]
; ATOM-NEXT:    pshufw $0, %mm0, %mm0 # mm0 = mm0[0,0,0,0] sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pshufw:
; SLM:       # %bb.0:
; SLM-NEXT:    pshufw $0, (%rdi), %mm0 # mm0 = mem[0,0,0,0] sched: [4:1.00]
; SLM-NEXT:    pshufw $0, %mm0, %mm0 # mm0 = mm0[0,0,0,0] sched: [1:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pshufw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pshufw $0, (%rdi), %mm0 # mm0 = mem[0,0,0,0] sched: [5:1.00]
; SANDY-NEXT:    pshufw $0, %mm0, %mm0 # mm0 = mm0[0,0,0,0] sched: [1:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pshufw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pshufw $0, (%rdi), %mm0 # mm0 = mem[0,0,0,0] sched: [6:1.00]
; HASWELL-NEXT:    pshufw $0, %mm0, %mm0 # mm0 = mm0[0,0,0,0] sched: [1:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pshufw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pshufw $0, (%rdi), %mm0 # mm0 = mem[0,0,0,0] sched: [6:1.00]
; BROADWELL-NEXT:    pshufw $0, %mm0, %mm0 # mm0 = mm0[0,0,0,0] sched: [1:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pshufw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pshufw $0, (%rdi), %mm0 # mm0 = mem[0,0,0,0] sched: [6:1.00]
; SKYLAKE-NEXT:    pshufw $0, %mm0, %mm0 # mm0 = mm0[0,0,0,0] sched: [1:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pshufw:
; SKX:       # %bb.0:
; SKX-NEXT:    pshufw $0, (%rdi), %mm0 # mm0 = mem[0,0,0,0] sched: [6:1.00]
; SKX-NEXT:    pshufw $0, %mm0, %mm0 # mm0 = mm0[0,0,0,0] sched: [1:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pshufw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pshufw $0, (%rdi), %mm0 # mm0 = mem[0,0,0,0] sched: [6:1.00]
; BTVER2-NEXT:    pshufw $0, %mm0, %mm0 # mm0 = mm0[0,0,0,0] sched: [1:0.50]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pshufw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pshufw $0, (%rdi), %mm0 # mm0 = mem[0,0,0,0] sched: [8:0.50]
; ZNVER1-NEXT:    pshufw $0, %mm0, %mm0 # mm0 = mm0[0,0,0,0] sched: [1:0.25]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = load x86_mmx, x86_mmx *%a0, align 8
  %2 = call x86_mmx @llvm.x86.sse.pshuf.w(x86_mmx %1, i8 0)
  %3 = call x86_mmx @llvm.x86.sse.pshuf.w(x86_mmx %2, i8 0)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.sse.pshuf.w(x86_mmx, i8) nounwind readnone

define i64 @test_psignb(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_psignb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    psignb %mm1, %mm0 # sched: [1:0.50]
; GENERIC-NEXT:    psignb (%rdi), %mm0 # sched: [6:0.50]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_psignb:
; ATOM:       # %bb.0:
; ATOM-NEXT:    psignb %mm1, %mm0 # sched: [1:1.00]
; ATOM-NEXT:    psignb (%rdi), %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_psignb:
; SLM:       # %bb.0:
; SLM-NEXT:    psignb %mm1, %mm0 # sched: [4:1.00]
; SLM-NEXT:    psignb (%rdi), %mm0 # sched: [7:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_psignb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    psignb %mm1, %mm0 # sched: [1:0.50]
; SANDY-NEXT:    psignb (%rdi), %mm0 # sched: [6:0.50]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_psignb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    psignb %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    psignb (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_psignb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    psignb %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    psignb (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_psignb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    psignb %mm1, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    psignb (%rdi), %mm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_psignb:
; SKX:       # %bb.0:
; SKX-NEXT:    psignb %mm1, %mm0 # sched: [1:0.50]
; SKX-NEXT:    psignb (%rdi), %mm0 # sched: [6:0.50]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_psignb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    psignb %mm1, %mm0 # sched: [2:1.00]
; BTVER2-NEXT:    psignb (%rdi), %mm0 # sched: [7:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_psignb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    psignb %mm1, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    psignb (%rdi), %mm0 # sched: [11:1.00]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.ssse3.psign.b(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.ssse3.psign.b(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.ssse3.psign.b(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_psignd(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_psignd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    psignd %mm1, %mm0 # sched: [1:0.50]
; GENERIC-NEXT:    psignd (%rdi), %mm0 # sched: [6:0.50]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_psignd:
; ATOM:       # %bb.0:
; ATOM-NEXT:    psignd %mm1, %mm0 # sched: [1:1.00]
; ATOM-NEXT:    psignd (%rdi), %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_psignd:
; SLM:       # %bb.0:
; SLM-NEXT:    psignd %mm1, %mm0 # sched: [4:1.00]
; SLM-NEXT:    psignd (%rdi), %mm0 # sched: [7:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_psignd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    psignd %mm1, %mm0 # sched: [1:0.50]
; SANDY-NEXT:    psignd (%rdi), %mm0 # sched: [6:0.50]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_psignd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    psignd %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    psignd (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_psignd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    psignd %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    psignd (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_psignd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    psignd %mm1, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    psignd (%rdi), %mm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_psignd:
; SKX:       # %bb.0:
; SKX-NEXT:    psignd %mm1, %mm0 # sched: [1:0.50]
; SKX-NEXT:    psignd (%rdi), %mm0 # sched: [6:0.50]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_psignd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    psignd %mm1, %mm0 # sched: [2:1.00]
; BTVER2-NEXT:    psignd (%rdi), %mm0 # sched: [7:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_psignd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    psignd %mm1, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    psignd (%rdi), %mm0 # sched: [11:1.00]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.ssse3.psign.d(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.ssse3.psign.d(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.ssse3.psign.d(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_psignw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_psignw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    psignw %mm1, %mm0 # sched: [1:0.50]
; GENERIC-NEXT:    psignw (%rdi), %mm0 # sched: [6:0.50]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_psignw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    psignw %mm1, %mm0 # sched: [1:1.00]
; ATOM-NEXT:    psignw (%rdi), %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_psignw:
; SLM:       # %bb.0:
; SLM-NEXT:    psignw %mm1, %mm0 # sched: [4:1.00]
; SLM-NEXT:    psignw (%rdi), %mm0 # sched: [7:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_psignw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    psignw %mm1, %mm0 # sched: [1:0.50]
; SANDY-NEXT:    psignw (%rdi), %mm0 # sched: [6:0.50]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_psignw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    psignw %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    psignw (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_psignw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    psignw %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    psignw (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_psignw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    psignw %mm1, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    psignw (%rdi), %mm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_psignw:
; SKX:       # %bb.0:
; SKX-NEXT:    psignw %mm1, %mm0 # sched: [1:0.50]
; SKX-NEXT:    psignw (%rdi), %mm0 # sched: [6:0.50]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_psignw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    psignw %mm1, %mm0 # sched: [2:1.00]
; BTVER2-NEXT:    psignw (%rdi), %mm0 # sched: [7:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_psignw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    psignw %mm1, %mm0 # sched: [4:1.00]
; ZNVER1-NEXT:    psignw (%rdi), %mm0 # sched: [11:1.00]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.ssse3.psign.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.ssse3.psign.w(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.ssse3.psign.w(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pslld(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pslld:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pslld %mm1, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    pslld (%rdi), %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    pslld $7, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pslld:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pslld %mm1, %mm0 # sched: [2:1.00]
; ATOM-NEXT:    pslld (%rdi), %mm0 # sched: [3:1.50]
; ATOM-NEXT:    pslld $7, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pslld:
; SLM:       # %bb.0:
; SLM-NEXT:    pslld %mm1, %mm0 # sched: [1:1.00]
; SLM-NEXT:    pslld (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    pslld $7, %mm0 # sched: [1:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pslld:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pslld %mm1, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    pslld (%rdi), %mm0 # sched: [5:1.00]
; SANDY-NEXT:    pslld $7, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pslld:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pslld %mm1, %mm0 # sched: [1:1.00]
; HASWELL-NEXT:    pslld (%rdi), %mm0 # sched: [6:1.00]
; HASWELL-NEXT:    pslld $7, %mm0 # sched: [1:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pslld:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pslld %mm1, %mm0 # sched: [1:1.00]
; BROADWELL-NEXT:    pslld (%rdi), %mm0 # sched: [6:1.00]
; BROADWELL-NEXT:    pslld $7, %mm0 # sched: [1:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pslld:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pslld %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    pslld (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    pslld $7, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pslld:
; SKX:       # %bb.0:
; SKX-NEXT:    pslld %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    pslld (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    pslld $7, %mm0 # sched: [1:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pslld:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pslld %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    pslld (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    pslld $7, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pslld:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pslld %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    pslld (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    pslld $7, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.psll.d(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.psll.d(x86_mmx %1, x86_mmx %2)
  %4 = call x86_mmx @llvm.x86.mmx.pslli.d(x86_mmx %3, i32 7)
  %5 = bitcast x86_mmx %4 to i64
  ret i64 %5
}
declare x86_mmx @llvm.x86.mmx.psll.d(x86_mmx, x86_mmx) nounwind readnone
declare x86_mmx @llvm.x86.mmx.pslli.d(x86_mmx, i32) nounwind readnone

define i64 @test_psllq(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_psllq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    psllq %mm1, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    psllq (%rdi), %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    psllq $7, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_psllq:
; ATOM:       # %bb.0:
; ATOM-NEXT:    psllq %mm1, %mm0 # sched: [2:1.00]
; ATOM-NEXT:    psllq (%rdi), %mm0 # sched: [3:1.50]
; ATOM-NEXT:    psllq $7, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_psllq:
; SLM:       # %bb.0:
; SLM-NEXT:    psllq %mm1, %mm0 # sched: [1:1.00]
; SLM-NEXT:    psllq (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    psllq $7, %mm0 # sched: [1:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_psllq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    psllq %mm1, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    psllq (%rdi), %mm0 # sched: [5:1.00]
; SANDY-NEXT:    psllq $7, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_psllq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    psllq %mm1, %mm0 # sched: [1:1.00]
; HASWELL-NEXT:    psllq (%rdi), %mm0 # sched: [6:1.00]
; HASWELL-NEXT:    psllq $7, %mm0 # sched: [1:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_psllq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    psllq %mm1, %mm0 # sched: [1:1.00]
; BROADWELL-NEXT:    psllq (%rdi), %mm0 # sched: [6:1.00]
; BROADWELL-NEXT:    psllq $7, %mm0 # sched: [1:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_psllq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    psllq %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    psllq (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    psllq $7, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_psllq:
; SKX:       # %bb.0:
; SKX-NEXT:    psllq %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    psllq (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    psllq $7, %mm0 # sched: [1:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_psllq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    psllq %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    psllq (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    psllq $7, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_psllq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    psllq %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    psllq (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    psllq $7, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.psll.q(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.psll.q(x86_mmx %1, x86_mmx %2)
  %4 = call x86_mmx @llvm.x86.mmx.pslli.q(x86_mmx %3, i32 7)
  %5 = bitcast x86_mmx %4 to i64
  ret i64 %5
}
declare x86_mmx @llvm.x86.mmx.psll.q(x86_mmx, x86_mmx) nounwind readnone
declare x86_mmx @llvm.x86.mmx.pslli.q(x86_mmx, i32) nounwind readnone

define i64 @test_psllw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_psllw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    psllw %mm1, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    psllw (%rdi), %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    psllw $7, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_psllw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    psllw %mm1, %mm0 # sched: [2:1.00]
; ATOM-NEXT:    psllw (%rdi), %mm0 # sched: [3:1.50]
; ATOM-NEXT:    psllw $7, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_psllw:
; SLM:       # %bb.0:
; SLM-NEXT:    psllw %mm1, %mm0 # sched: [1:1.00]
; SLM-NEXT:    psllw (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    psllw $7, %mm0 # sched: [1:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_psllw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    psllw %mm1, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    psllw (%rdi), %mm0 # sched: [5:1.00]
; SANDY-NEXT:    psllw $7, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_psllw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    psllw %mm1, %mm0 # sched: [1:1.00]
; HASWELL-NEXT:    psllw (%rdi), %mm0 # sched: [6:1.00]
; HASWELL-NEXT:    psllw $7, %mm0 # sched: [1:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_psllw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    psllw %mm1, %mm0 # sched: [1:1.00]
; BROADWELL-NEXT:    psllw (%rdi), %mm0 # sched: [6:1.00]
; BROADWELL-NEXT:    psllw $7, %mm0 # sched: [1:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_psllw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    psllw %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    psllw (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    psllw $7, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_psllw:
; SKX:       # %bb.0:
; SKX-NEXT:    psllw %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    psllw (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    psllw $7, %mm0 # sched: [1:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_psllw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    psllw %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    psllw (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    psllw $7, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_psllw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    psllw %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    psllw (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    psllw $7, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.psll.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.psll.w(x86_mmx %1, x86_mmx %2)
  %4 = call x86_mmx @llvm.x86.mmx.pslli.w(x86_mmx %3, i32 7)
  %5 = bitcast x86_mmx %4 to i64
  ret i64 %5
}
declare x86_mmx @llvm.x86.mmx.psll.w(x86_mmx, x86_mmx) nounwind readnone
declare x86_mmx @llvm.x86.mmx.pslli.w(x86_mmx, i32) nounwind readnone

define i64 @test_psrad(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_psrad:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    psrad %mm1, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    psrad (%rdi), %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    psrad $7, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_psrad:
; ATOM:       # %bb.0:
; ATOM-NEXT:    psrad %mm1, %mm0 # sched: [2:1.00]
; ATOM-NEXT:    psrad (%rdi), %mm0 # sched: [3:1.50]
; ATOM-NEXT:    psrad $7, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_psrad:
; SLM:       # %bb.0:
; SLM-NEXT:    psrad %mm1, %mm0 # sched: [1:1.00]
; SLM-NEXT:    psrad (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    psrad $7, %mm0 # sched: [1:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_psrad:
; SANDY:       # %bb.0:
; SANDY-NEXT:    psrad %mm1, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    psrad (%rdi), %mm0 # sched: [5:1.00]
; SANDY-NEXT:    psrad $7, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_psrad:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    psrad %mm1, %mm0 # sched: [1:1.00]
; HASWELL-NEXT:    psrad (%rdi), %mm0 # sched: [6:1.00]
; HASWELL-NEXT:    psrad $7, %mm0 # sched: [1:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_psrad:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    psrad %mm1, %mm0 # sched: [1:1.00]
; BROADWELL-NEXT:    psrad (%rdi), %mm0 # sched: [6:1.00]
; BROADWELL-NEXT:    psrad $7, %mm0 # sched: [1:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_psrad:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    psrad %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    psrad (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    psrad $7, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_psrad:
; SKX:       # %bb.0:
; SKX-NEXT:    psrad %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    psrad (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    psrad $7, %mm0 # sched: [1:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_psrad:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    psrad %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    psrad (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    psrad $7, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_psrad:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    psrad %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    psrad (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    psrad $7, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.psra.d(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.psra.d(x86_mmx %1, x86_mmx %2)
  %4 = call x86_mmx @llvm.x86.mmx.psrai.d(x86_mmx %3, i32 7)
  %5 = bitcast x86_mmx %4 to i64
  ret i64 %5
}
declare x86_mmx @llvm.x86.mmx.psra.d(x86_mmx, x86_mmx) nounwind readnone
declare x86_mmx @llvm.x86.mmx.psrai.d(x86_mmx, i32) nounwind readnone

define i64 @test_psraw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_psraw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    psraw %mm1, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    psraw (%rdi), %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    psraw $7, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_psraw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    psraw %mm1, %mm0 # sched: [2:1.00]
; ATOM-NEXT:    psraw (%rdi), %mm0 # sched: [3:1.50]
; ATOM-NEXT:    psraw $7, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_psraw:
; SLM:       # %bb.0:
; SLM-NEXT:    psraw %mm1, %mm0 # sched: [1:1.00]
; SLM-NEXT:    psraw (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    psraw $7, %mm0 # sched: [1:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_psraw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    psraw %mm1, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    psraw (%rdi), %mm0 # sched: [5:1.00]
; SANDY-NEXT:    psraw $7, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_psraw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    psraw %mm1, %mm0 # sched: [1:1.00]
; HASWELL-NEXT:    psraw (%rdi), %mm0 # sched: [6:1.00]
; HASWELL-NEXT:    psraw $7, %mm0 # sched: [1:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_psraw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    psraw %mm1, %mm0 # sched: [1:1.00]
; BROADWELL-NEXT:    psraw (%rdi), %mm0 # sched: [6:1.00]
; BROADWELL-NEXT:    psraw $7, %mm0 # sched: [1:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_psraw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    psraw %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    psraw (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    psraw $7, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_psraw:
; SKX:       # %bb.0:
; SKX-NEXT:    psraw %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    psraw (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    psraw $7, %mm0 # sched: [1:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_psraw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    psraw %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    psraw (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    psraw $7, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_psraw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    psraw %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    psraw (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    psraw $7, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.psra.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.psra.w(x86_mmx %1, x86_mmx %2)
  %4 = call x86_mmx @llvm.x86.mmx.psrai.w(x86_mmx %3, i32 7)
  %5 = bitcast x86_mmx %4 to i64
  ret i64 %5
}
declare x86_mmx @llvm.x86.mmx.psra.w(x86_mmx, x86_mmx) nounwind readnone
declare x86_mmx @llvm.x86.mmx.psrai.w(x86_mmx, i32) nounwind readnone

define i64 @test_psrld(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_psrld:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    psrld %mm1, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    psrld (%rdi), %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    psrld $7, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_psrld:
; ATOM:       # %bb.0:
; ATOM-NEXT:    psrld %mm1, %mm0 # sched: [2:1.00]
; ATOM-NEXT:    psrld (%rdi), %mm0 # sched: [3:1.50]
; ATOM-NEXT:    psrld $7, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_psrld:
; SLM:       # %bb.0:
; SLM-NEXT:    psrld %mm1, %mm0 # sched: [1:1.00]
; SLM-NEXT:    psrld (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    psrld $7, %mm0 # sched: [1:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_psrld:
; SANDY:       # %bb.0:
; SANDY-NEXT:    psrld %mm1, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    psrld (%rdi), %mm0 # sched: [5:1.00]
; SANDY-NEXT:    psrld $7, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_psrld:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    psrld %mm1, %mm0 # sched: [1:1.00]
; HASWELL-NEXT:    psrld (%rdi), %mm0 # sched: [6:1.00]
; HASWELL-NEXT:    psrld $7, %mm0 # sched: [1:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_psrld:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    psrld %mm1, %mm0 # sched: [1:1.00]
; BROADWELL-NEXT:    psrld (%rdi), %mm0 # sched: [6:1.00]
; BROADWELL-NEXT:    psrld $7, %mm0 # sched: [1:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_psrld:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    psrld %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    psrld (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    psrld $7, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_psrld:
; SKX:       # %bb.0:
; SKX-NEXT:    psrld %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    psrld (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    psrld $7, %mm0 # sched: [1:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_psrld:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    psrld %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    psrld (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    psrld $7, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_psrld:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    psrld %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    psrld (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    psrld $7, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.psrl.d(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.psrl.d(x86_mmx %1, x86_mmx %2)
  %4 = call x86_mmx @llvm.x86.mmx.psrli.d(x86_mmx %3, i32 7)
  %5 = bitcast x86_mmx %4 to i64
  ret i64 %5
}
declare x86_mmx @llvm.x86.mmx.psrl.d(x86_mmx, x86_mmx) nounwind readnone
declare x86_mmx @llvm.x86.mmx.psrli.d(x86_mmx, i32) nounwind readnone

define i64 @test_psrlq(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_psrlq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    psrlq %mm1, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    psrlq (%rdi), %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    psrlq $7, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_psrlq:
; ATOM:       # %bb.0:
; ATOM-NEXT:    psrlq %mm1, %mm0 # sched: [2:1.00]
; ATOM-NEXT:    psrlq (%rdi), %mm0 # sched: [3:1.50]
; ATOM-NEXT:    psrlq $7, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_psrlq:
; SLM:       # %bb.0:
; SLM-NEXT:    psrlq %mm1, %mm0 # sched: [1:1.00]
; SLM-NEXT:    psrlq (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    psrlq $7, %mm0 # sched: [1:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_psrlq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    psrlq %mm1, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    psrlq (%rdi), %mm0 # sched: [5:1.00]
; SANDY-NEXT:    psrlq $7, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_psrlq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    psrlq %mm1, %mm0 # sched: [1:1.00]
; HASWELL-NEXT:    psrlq (%rdi), %mm0 # sched: [6:1.00]
; HASWELL-NEXT:    psrlq $7, %mm0 # sched: [1:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_psrlq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    psrlq %mm1, %mm0 # sched: [1:1.00]
; BROADWELL-NEXT:    psrlq (%rdi), %mm0 # sched: [6:1.00]
; BROADWELL-NEXT:    psrlq $7, %mm0 # sched: [1:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_psrlq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    psrlq %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    psrlq (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    psrlq $7, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_psrlq:
; SKX:       # %bb.0:
; SKX-NEXT:    psrlq %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    psrlq (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    psrlq $7, %mm0 # sched: [1:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_psrlq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    psrlq %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    psrlq (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    psrlq $7, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_psrlq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    psrlq %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    psrlq (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    psrlq $7, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.psrl.q(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.psrl.q(x86_mmx %1, x86_mmx %2)
  %4 = call x86_mmx @llvm.x86.mmx.psrli.q(x86_mmx %3, i32 7)
  %5 = bitcast x86_mmx %4 to i64
  ret i64 %5
}
declare x86_mmx @llvm.x86.mmx.psrl.q(x86_mmx, x86_mmx) nounwind readnone
declare x86_mmx @llvm.x86.mmx.psrli.q(x86_mmx, i32) nounwind readnone

define i64 @test_psrlw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_psrlw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    psrlw %mm1, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    psrlw (%rdi), %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    psrlw $7, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_psrlw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    psrlw %mm1, %mm0 # sched: [2:1.00]
; ATOM-NEXT:    psrlw (%rdi), %mm0 # sched: [3:1.50]
; ATOM-NEXT:    psrlw $7, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_psrlw:
; SLM:       # %bb.0:
; SLM-NEXT:    psrlw %mm1, %mm0 # sched: [1:1.00]
; SLM-NEXT:    psrlw (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    psrlw $7, %mm0 # sched: [1:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_psrlw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    psrlw %mm1, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    psrlw (%rdi), %mm0 # sched: [5:1.00]
; SANDY-NEXT:    psrlw $7, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_psrlw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    psrlw %mm1, %mm0 # sched: [1:1.00]
; HASWELL-NEXT:    psrlw (%rdi), %mm0 # sched: [6:1.00]
; HASWELL-NEXT:    psrlw $7, %mm0 # sched: [1:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_psrlw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    psrlw %mm1, %mm0 # sched: [1:1.00]
; BROADWELL-NEXT:    psrlw (%rdi), %mm0 # sched: [6:1.00]
; BROADWELL-NEXT:    psrlw $7, %mm0 # sched: [1:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_psrlw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    psrlw %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    psrlw (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    psrlw $7, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_psrlw:
; SKX:       # %bb.0:
; SKX-NEXT:    psrlw %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    psrlw (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    psrlw $7, %mm0 # sched: [1:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_psrlw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    psrlw %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    psrlw (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    psrlw $7, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_psrlw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    psrlw %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    psrlw (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    psrlw $7, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.psrl.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.psrl.w(x86_mmx %1, x86_mmx %2)
  %4 = call x86_mmx @llvm.x86.mmx.psrli.w(x86_mmx %3, i32 7)
  %5 = bitcast x86_mmx %4 to i64
  ret i64 %5
}
declare x86_mmx @llvm.x86.mmx.psrl.w(x86_mmx, x86_mmx) nounwind readnone
declare x86_mmx @llvm.x86.mmx.psrli.w(x86_mmx, i32) nounwind readnone

define i64 @test_psubb(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_psubb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    psubb %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    psubb (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_psubb:
; ATOM:       # %bb.0:
; ATOM-NEXT:    psubb %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    psubb (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_psubb:
; SLM:       # %bb.0:
; SLM-NEXT:    psubb %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    psubb (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_psubb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    psubb %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    psubb (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_psubb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    psubb %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    psubb (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_psubb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    psubb %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    psubb (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_psubb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    psubb %mm1, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    psubb (%rdi), %mm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_psubb:
; SKX:       # %bb.0:
; SKX-NEXT:    psubb %mm1, %mm0 # sched: [1:0.50]
; SKX-NEXT:    psubb (%rdi), %mm0 # sched: [6:0.50]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_psubb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    psubb %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    psubb (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_psubb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    psubb %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    psubb (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.psub.b(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.psub.b(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.psub.b(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_psubd(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_psubd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    psubd %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    psubd (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_psubd:
; ATOM:       # %bb.0:
; ATOM-NEXT:    psubd %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    psubd (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_psubd:
; SLM:       # %bb.0:
; SLM-NEXT:    psubd %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    psubd (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_psubd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    psubd %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    psubd (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_psubd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    psubd %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    psubd (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_psubd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    psubd %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    psubd (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_psubd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    psubd %mm1, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    psubd (%rdi), %mm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_psubd:
; SKX:       # %bb.0:
; SKX-NEXT:    psubd %mm1, %mm0 # sched: [1:0.50]
; SKX-NEXT:    psubd (%rdi), %mm0 # sched: [6:0.50]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_psubd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    psubd %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    psubd (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_psubd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    psubd %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    psubd (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.psub.d(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.psub.d(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.psub.d(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_psubq(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_psubq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    psubq %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    psubq (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_psubq:
; ATOM:       # %bb.0:
; ATOM-NEXT:    psubq %mm1, %mm0 # sched: [2:1.00]
; ATOM-NEXT:    psubq (%rdi), %mm0 # sched: [3:1.50]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_psubq:
; SLM:       # %bb.0:
; SLM-NEXT:    psubq %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    psubq (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_psubq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    psubq %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    psubq (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_psubq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    psubq %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    psubq (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_psubq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    psubq %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    psubq (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_psubq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    psubq %mm1, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    psubq (%rdi), %mm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_psubq:
; SKX:       # %bb.0:
; SKX-NEXT:    psubq %mm1, %mm0 # sched: [1:0.50]
; SKX-NEXT:    psubq (%rdi), %mm0 # sched: [6:0.50]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_psubq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    psubq %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    psubq (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_psubq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    psubq %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    psubq (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.psub.q(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.psub.q(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.psub.q(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_psubsb(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_psubsb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    psubsb %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    psubsb (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_psubsb:
; ATOM:       # %bb.0:
; ATOM-NEXT:    psubsb %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    psubsb (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_psubsb:
; SLM:       # %bb.0:
; SLM-NEXT:    psubsb %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    psubsb (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_psubsb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    psubsb %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    psubsb (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_psubsb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    psubsb %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    psubsb (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_psubsb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    psubsb %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    psubsb (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_psubsb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    psubsb %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    psubsb (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_psubsb:
; SKX:       # %bb.0:
; SKX-NEXT:    psubsb %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    psubsb (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_psubsb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    psubsb %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    psubsb (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_psubsb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    psubsb %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    psubsb (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.psubs.b(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.psubs.b(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.psubs.b(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_psubsw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_psubsw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    psubsw %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    psubsw (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_psubsw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    psubsw %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    psubsw (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_psubsw:
; SLM:       # %bb.0:
; SLM-NEXT:    psubsw %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    psubsw (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_psubsw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    psubsw %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    psubsw (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_psubsw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    psubsw %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    psubsw (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_psubsw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    psubsw %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    psubsw (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_psubsw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    psubsw %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    psubsw (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_psubsw:
; SKX:       # %bb.0:
; SKX-NEXT:    psubsw %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    psubsw (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_psubsw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    psubsw %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    psubsw (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_psubsw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    psubsw %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    psubsw (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.psubs.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.psubs.w(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.psubs.w(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_psubusb(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_psubusb:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    psubusb %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    psubusb (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_psubusb:
; ATOM:       # %bb.0:
; ATOM-NEXT:    psubusb %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    psubusb (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_psubusb:
; SLM:       # %bb.0:
; SLM-NEXT:    psubusb %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    psubusb (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_psubusb:
; SANDY:       # %bb.0:
; SANDY-NEXT:    psubusb %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    psubusb (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_psubusb:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    psubusb %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    psubusb (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_psubusb:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    psubusb %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    psubusb (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_psubusb:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    psubusb %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    psubusb (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_psubusb:
; SKX:       # %bb.0:
; SKX-NEXT:    psubusb %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    psubusb (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_psubusb:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    psubusb %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    psubusb (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_psubusb:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    psubusb %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    psubusb (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.psubus.b(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.psubus.b(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.psubus.b(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_psubusw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_psubusw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    psubusw %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    psubusw (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_psubusw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    psubusw %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    psubusw (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_psubusw:
; SLM:       # %bb.0:
; SLM-NEXT:    psubusw %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    psubusw (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_psubusw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    psubusw %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    psubusw (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_psubusw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    psubusw %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    psubusw (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_psubusw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    psubusw %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    psubusw (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_psubusw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    psubusw %mm1, %mm0 # sched: [1:1.00]
; SKYLAKE-NEXT:    psubusw (%rdi), %mm0 # sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_psubusw:
; SKX:       # %bb.0:
; SKX-NEXT:    psubusw %mm1, %mm0 # sched: [1:1.00]
; SKX-NEXT:    psubusw (%rdi), %mm0 # sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_psubusw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    psubusw %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    psubusw (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_psubusw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    psubusw %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    psubusw (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.psubus.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.psubus.w(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.psubus.w(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_psubw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_psubw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    psubw %mm1, %mm0 # sched: [3:1.00]
; GENERIC-NEXT:    psubw (%rdi), %mm0 # sched: [7:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_psubw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    psubw %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    psubw (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_psubw:
; SLM:       # %bb.0:
; SLM-NEXT:    psubw %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    psubw (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_psubw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    psubw %mm1, %mm0 # sched: [3:1.00]
; SANDY-NEXT:    psubw (%rdi), %mm0 # sched: [7:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_psubw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    psubw %mm1, %mm0 # sched: [1:0.50]
; HASWELL-NEXT:    psubw (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_psubw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    psubw %mm1, %mm0 # sched: [1:0.50]
; BROADWELL-NEXT:    psubw (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_psubw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    psubw %mm1, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    psubw (%rdi), %mm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_psubw:
; SKX:       # %bb.0:
; SKX-NEXT:    psubw %mm1, %mm0 # sched: [1:0.50]
; SKX-NEXT:    psubw (%rdi), %mm0 # sched: [6:0.50]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_psubw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    psubw %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    psubw (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_psubw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    psubw %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    psubw (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.psub.w(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.psub.w(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.psub.w(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_punpckhbw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_punpckhbw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    punpckhbw %mm1, %mm0 # mm0 = mm0[4],mm1[4],mm0[5],mm1[5],mm0[6],mm1[6],mm0[7],mm1[7] sched: [1:1.00]
; GENERIC-NEXT:    punpckhbw (%rdi), %mm0 # mm0 = mm0[4],mem[4],mm0[5],mem[5],mm0[6],mem[6],mm0[7],mem[7] sched: [5:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_punpckhbw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    punpckhbw %mm1, %mm0 # mm0 = mm0[4],mm1[4],mm0[5],mm1[5],mm0[6],mm1[6],mm0[7],mm1[7] sched: [1:0.50]
; ATOM-NEXT:    punpckhbw (%rdi), %mm0 # mm0 = mm0[4],mem[4],mm0[5],mem[5],mm0[6],mem[6],mm0[7],mem[7] sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_punpckhbw:
; SLM:       # %bb.0:
; SLM-NEXT:    punpckhbw %mm1, %mm0 # mm0 = mm0[4],mm1[4],mm0[5],mm1[5],mm0[6],mm1[6],mm0[7],mm1[7] sched: [1:1.00]
; SLM-NEXT:    punpckhbw (%rdi), %mm0 # mm0 = mm0[4],mem[4],mm0[5],mem[5],mm0[6],mem[6],mm0[7],mem[7] sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_punpckhbw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    punpckhbw %mm1, %mm0 # mm0 = mm0[4],mm1[4],mm0[5],mm1[5],mm0[6],mm1[6],mm0[7],mm1[7] sched: [1:1.00]
; SANDY-NEXT:    punpckhbw (%rdi), %mm0 # mm0 = mm0[4],mem[4],mm0[5],mem[5],mm0[6],mem[6],mm0[7],mem[7] sched: [5:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_punpckhbw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    punpckhbw %mm1, %mm0 # mm0 = mm0[4],mm1[4],mm0[5],mm1[5],mm0[6],mm1[6],mm0[7],mm1[7] sched: [1:1.00]
; HASWELL-NEXT:    punpckhbw (%rdi), %mm0 # mm0 = mm0[4],mem[4],mm0[5],mem[5],mm0[6],mem[6],mm0[7],mem[7] sched: [6:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_punpckhbw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    punpckhbw %mm1, %mm0 # mm0 = mm0[4],mm1[4],mm0[5],mm1[5],mm0[6],mm1[6],mm0[7],mm1[7] sched: [1:1.00]
; BROADWELL-NEXT:    punpckhbw (%rdi), %mm0 # mm0 = mm0[4],mem[4],mm0[5],mem[5],mm0[6],mem[6],mm0[7],mem[7] sched: [6:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_punpckhbw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    punpckhbw %mm1, %mm0 # mm0 = mm0[4],mm1[4],mm0[5],mm1[5],mm0[6],mm1[6],mm0[7],mm1[7] sched: [1:1.00]
; SKYLAKE-NEXT:    punpckhbw (%rdi), %mm0 # mm0 = mm0[4],mem[4],mm0[5],mem[5],mm0[6],mem[6],mm0[7],mem[7] sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_punpckhbw:
; SKX:       # %bb.0:
; SKX-NEXT:    punpckhbw %mm1, %mm0 # mm0 = mm0[4],mm1[4],mm0[5],mm1[5],mm0[6],mm1[6],mm0[7],mm1[7] sched: [1:1.00]
; SKX-NEXT:    punpckhbw (%rdi), %mm0 # mm0 = mm0[4],mem[4],mm0[5],mem[5],mm0[6],mem[6],mm0[7],mem[7] sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_punpckhbw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    punpckhbw %mm1, %mm0 # mm0 = mm0[4],mm1[4],mm0[5],mm1[5],mm0[6],mm1[6],mm0[7],mm1[7] sched: [1:0.50]
; BTVER2-NEXT:    punpckhbw (%rdi), %mm0 # mm0 = mm0[4],mem[4],mm0[5],mem[5],mm0[6],mem[6],mm0[7],mem[7] sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_punpckhbw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    punpckhbw %mm1, %mm0 # mm0 = mm0[4],mm1[4],mm0[5],mm1[5],mm0[6],mm1[6],mm0[7],mm1[7] sched: [1:0.25]
; ZNVER1-NEXT:    punpckhbw (%rdi), %mm0 # mm0 = mm0[4],mem[4],mm0[5],mem[5],mm0[6],mem[6],mm0[7],mem[7] sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.punpckhbw(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.punpckhbw(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.punpckhbw(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_punpckhdq(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_punpckhdq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    punpckhdq %mm1, %mm0 # mm0 = mm0[1],mm1[1] sched: [1:1.00]
; GENERIC-NEXT:    punpckhdq (%rdi), %mm0 # mm0 = mm0[1],mem[1] sched: [5:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_punpckhdq:
; ATOM:       # %bb.0:
; ATOM-NEXT:    punpckhdq %mm1, %mm0 # mm0 = mm0[1],mm1[1] sched: [1:0.50]
; ATOM-NEXT:    punpckhdq (%rdi), %mm0 # mm0 = mm0[1],mem[1] sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_punpckhdq:
; SLM:       # %bb.0:
; SLM-NEXT:    punpckhdq %mm1, %mm0 # mm0 = mm0[1],mm1[1] sched: [1:1.00]
; SLM-NEXT:    punpckhdq (%rdi), %mm0 # mm0 = mm0[1],mem[1] sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_punpckhdq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    punpckhdq %mm1, %mm0 # mm0 = mm0[1],mm1[1] sched: [1:1.00]
; SANDY-NEXT:    punpckhdq (%rdi), %mm0 # mm0 = mm0[1],mem[1] sched: [5:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_punpckhdq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    punpckhdq %mm1, %mm0 # mm0 = mm0[1],mm1[1] sched: [1:1.00]
; HASWELL-NEXT:    punpckhdq (%rdi), %mm0 # mm0 = mm0[1],mem[1] sched: [6:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_punpckhdq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    punpckhdq %mm1, %mm0 # mm0 = mm0[1],mm1[1] sched: [1:1.00]
; BROADWELL-NEXT:    punpckhdq (%rdi), %mm0 # mm0 = mm0[1],mem[1] sched: [6:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_punpckhdq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    punpckhdq %mm1, %mm0 # mm0 = mm0[1],mm1[1] sched: [1:1.00]
; SKYLAKE-NEXT:    punpckhdq (%rdi), %mm0 # mm0 = mm0[1],mem[1] sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_punpckhdq:
; SKX:       # %bb.0:
; SKX-NEXT:    punpckhdq %mm1, %mm0 # mm0 = mm0[1],mm1[1] sched: [1:1.00]
; SKX-NEXT:    punpckhdq (%rdi), %mm0 # mm0 = mm0[1],mem[1] sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_punpckhdq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    punpckhdq %mm1, %mm0 # mm0 = mm0[1],mm1[1] sched: [1:0.50]
; BTVER2-NEXT:    punpckhdq (%rdi), %mm0 # mm0 = mm0[1],mem[1] sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_punpckhdq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    punpckhdq %mm1, %mm0 # mm0 = mm0[1],mm1[1] sched: [1:0.25]
; ZNVER1-NEXT:    punpckhdq (%rdi), %mm0 # mm0 = mm0[1],mem[1] sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.punpckhdq(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.punpckhdq(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.punpckhdq(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_punpckhwd(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_punpckhwd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    punpckhwd %mm1, %mm0 # mm0 = mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:1.00]
; GENERIC-NEXT:    punpckhwd (%rdi), %mm0 # mm0 = mm0[2],mem[2],mm0[3],mem[3] sched: [5:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_punpckhwd:
; ATOM:       # %bb.0:
; ATOM-NEXT:    punpckhwd %mm1, %mm0 # mm0 = mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:0.50]
; ATOM-NEXT:    punpckhwd (%rdi), %mm0 # mm0 = mm0[2],mem[2],mm0[3],mem[3] sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_punpckhwd:
; SLM:       # %bb.0:
; SLM-NEXT:    punpckhwd %mm1, %mm0 # mm0 = mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:1.00]
; SLM-NEXT:    punpckhwd (%rdi), %mm0 # mm0 = mm0[2],mem[2],mm0[3],mem[3] sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_punpckhwd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    punpckhwd %mm1, %mm0 # mm0 = mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:1.00]
; SANDY-NEXT:    punpckhwd (%rdi), %mm0 # mm0 = mm0[2],mem[2],mm0[3],mem[3] sched: [5:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_punpckhwd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    punpckhwd %mm1, %mm0 # mm0 = mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:1.00]
; HASWELL-NEXT:    punpckhwd (%rdi), %mm0 # mm0 = mm0[2],mem[2],mm0[3],mem[3] sched: [6:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_punpckhwd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    punpckhwd %mm1, %mm0 # mm0 = mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:1.00]
; BROADWELL-NEXT:    punpckhwd (%rdi), %mm0 # mm0 = mm0[2],mem[2],mm0[3],mem[3] sched: [6:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_punpckhwd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    punpckhwd %mm1, %mm0 # mm0 = mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:1.00]
; SKYLAKE-NEXT:    punpckhwd (%rdi), %mm0 # mm0 = mm0[2],mem[2],mm0[3],mem[3] sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_punpckhwd:
; SKX:       # %bb.0:
; SKX-NEXT:    punpckhwd %mm1, %mm0 # mm0 = mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:1.00]
; SKX-NEXT:    punpckhwd (%rdi), %mm0 # mm0 = mm0[2],mem[2],mm0[3],mem[3] sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_punpckhwd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    punpckhwd %mm1, %mm0 # mm0 = mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:0.50]
; BTVER2-NEXT:    punpckhwd (%rdi), %mm0 # mm0 = mm0[2],mem[2],mm0[3],mem[3] sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_punpckhwd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    punpckhwd %mm1, %mm0 # mm0 = mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:0.25]
; ZNVER1-NEXT:    punpckhwd (%rdi), %mm0 # mm0 = mm0[2],mem[2],mm0[3],mem[3] sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.punpckhwd(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.punpckhwd(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.punpckhwd(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_punpcklbw(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_punpcklbw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    punpcklbw %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1],mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:1.00]
; GENERIC-NEXT:    punpcklbw (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1],mm0[2],mem[2],mm0[3],mem[3] sched: [5:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_punpcklbw:
; ATOM:       # %bb.0:
; ATOM-NEXT:    punpcklbw %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1],mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:1.00]
; ATOM-NEXT:    punpcklbw (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1],mm0[2],mem[2],mm0[3],mem[3] sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_punpcklbw:
; SLM:       # %bb.0:
; SLM-NEXT:    punpcklbw %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1],mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:1.00]
; SLM-NEXT:    punpcklbw (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1],mm0[2],mem[2],mm0[3],mem[3] sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_punpcklbw:
; SANDY:       # %bb.0:
; SANDY-NEXT:    punpcklbw %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1],mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:1.00]
; SANDY-NEXT:    punpcklbw (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1],mm0[2],mem[2],mm0[3],mem[3] sched: [5:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_punpcklbw:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    punpcklbw %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1],mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:1.00]
; HASWELL-NEXT:    punpcklbw (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1],mm0[2],mem[2],mm0[3],mem[3] sched: [6:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_punpcklbw:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    punpcklbw %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1],mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:1.00]
; BROADWELL-NEXT:    punpcklbw (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1],mm0[2],mem[2],mm0[3],mem[3] sched: [6:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_punpcklbw:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    punpcklbw %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1],mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:1.00]
; SKYLAKE-NEXT:    punpcklbw (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1],mm0[2],mem[2],mm0[3],mem[3] sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_punpcklbw:
; SKX:       # %bb.0:
; SKX-NEXT:    punpcklbw %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1],mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:1.00]
; SKX-NEXT:    punpcklbw (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1],mm0[2],mem[2],mm0[3],mem[3] sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_punpcklbw:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    punpcklbw %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1],mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:0.50]
; BTVER2-NEXT:    punpcklbw (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1],mm0[2],mem[2],mm0[3],mem[3] sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_punpcklbw:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    punpcklbw %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1],mm0[2],mm1[2],mm0[3],mm1[3] sched: [1:0.25]
; ZNVER1-NEXT:    punpcklbw (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1],mm0[2],mem[2],mm0[3],mem[3] sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.punpcklbw(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.punpcklbw(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.punpcklbw(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_punpckldq(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_punpckldq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    punpckldq %mm1, %mm0 # mm0 = mm0[0],mm1[0] sched: [1:1.00]
; GENERIC-NEXT:    punpckldq (%rdi), %mm0 # mm0 = mm0[0],mem[0] sched: [5:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_punpckldq:
; ATOM:       # %bb.0:
; ATOM-NEXT:    punpckldq %mm1, %mm0 # mm0 = mm0[0],mm1[0] sched: [1:1.00]
; ATOM-NEXT:    punpckldq (%rdi), %mm0 # mm0 = mm0[0],mem[0] sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_punpckldq:
; SLM:       # %bb.0:
; SLM-NEXT:    punpckldq %mm1, %mm0 # mm0 = mm0[0],mm1[0] sched: [1:1.00]
; SLM-NEXT:    punpckldq (%rdi), %mm0 # mm0 = mm0[0],mem[0] sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_punpckldq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    punpckldq %mm1, %mm0 # mm0 = mm0[0],mm1[0] sched: [1:1.00]
; SANDY-NEXT:    punpckldq (%rdi), %mm0 # mm0 = mm0[0],mem[0] sched: [5:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_punpckldq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    punpckldq %mm1, %mm0 # mm0 = mm0[0],mm1[0] sched: [1:1.00]
; HASWELL-NEXT:    punpckldq (%rdi), %mm0 # mm0 = mm0[0],mem[0] sched: [6:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_punpckldq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    punpckldq %mm1, %mm0 # mm0 = mm0[0],mm1[0] sched: [1:1.00]
; BROADWELL-NEXT:    punpckldq (%rdi), %mm0 # mm0 = mm0[0],mem[0] sched: [6:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_punpckldq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    punpckldq %mm1, %mm0 # mm0 = mm0[0],mm1[0] sched: [1:1.00]
; SKYLAKE-NEXT:    punpckldq (%rdi), %mm0 # mm0 = mm0[0],mem[0] sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_punpckldq:
; SKX:       # %bb.0:
; SKX-NEXT:    punpckldq %mm1, %mm0 # mm0 = mm0[0],mm1[0] sched: [1:1.00]
; SKX-NEXT:    punpckldq (%rdi), %mm0 # mm0 = mm0[0],mem[0] sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_punpckldq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    punpckldq %mm1, %mm0 # mm0 = mm0[0],mm1[0] sched: [1:0.50]
; BTVER2-NEXT:    punpckldq (%rdi), %mm0 # mm0 = mm0[0],mem[0] sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_punpckldq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    punpckldq %mm1, %mm0 # mm0 = mm0[0],mm1[0] sched: [1:0.25]
; ZNVER1-NEXT:    punpckldq (%rdi), %mm0 # mm0 = mm0[0],mem[0] sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.punpckldq(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.punpckldq(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.punpckldq(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_punpcklwd(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_punpcklwd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    punpcklwd %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1] sched: [1:1.00]
; GENERIC-NEXT:    punpcklwd (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1] sched: [5:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_punpcklwd:
; ATOM:       # %bb.0:
; ATOM-NEXT:    punpcklwd %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1] sched: [1:1.00]
; ATOM-NEXT:    punpcklwd (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1] sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_punpcklwd:
; SLM:       # %bb.0:
; SLM-NEXT:    punpcklwd %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1] sched: [1:1.00]
; SLM-NEXT:    punpcklwd (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1] sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_punpcklwd:
; SANDY:       # %bb.0:
; SANDY-NEXT:    punpcklwd %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1] sched: [1:1.00]
; SANDY-NEXT:    punpcklwd (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1] sched: [5:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_punpcklwd:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    punpcklwd %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1] sched: [1:1.00]
; HASWELL-NEXT:    punpcklwd (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1] sched: [6:1.00]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_punpcklwd:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    punpcklwd %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1] sched: [1:1.00]
; BROADWELL-NEXT:    punpcklwd (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1] sched: [6:1.00]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_punpcklwd:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    punpcklwd %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1] sched: [1:1.00]
; SKYLAKE-NEXT:    punpcklwd (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1] sched: [6:1.00]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_punpcklwd:
; SKX:       # %bb.0:
; SKX-NEXT:    punpcklwd %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1] sched: [1:1.00]
; SKX-NEXT:    punpcklwd (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1] sched: [6:1.00]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_punpcklwd:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    punpcklwd %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1] sched: [1:0.50]
; BTVER2-NEXT:    punpcklwd (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1] sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_punpcklwd:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    punpcklwd %mm1, %mm0 # mm0 = mm0[0],mm1[0],mm0[1],mm1[1] sched: [1:0.25]
; ZNVER1-NEXT:    punpcklwd (%rdi), %mm0 # mm0 = mm0[0],mem[0],mm0[1],mem[1] sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.punpcklwd(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.punpcklwd(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.punpcklwd(x86_mmx, x86_mmx) nounwind readnone

define i64 @test_pxor(x86_mmx %a0, x86_mmx %a1, x86_mmx* %a2) optsize {
; GENERIC-LABEL: test_pxor:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    pxor %mm1, %mm0 # sched: [1:1.00]
; GENERIC-NEXT:    pxor (%rdi), %mm0 # sched: [5:1.00]
; GENERIC-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_pxor:
; ATOM:       # %bb.0:
; ATOM-NEXT:    pxor %mm1, %mm0 # sched: [1:0.50]
; ATOM-NEXT:    pxor (%rdi), %mm0 # sched: [1:1.00]
; ATOM-NEXT:    movd %mm0, %rax # sched: [3:3.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_pxor:
; SLM:       # %bb.0:
; SLM-NEXT:    pxor %mm1, %mm0 # sched: [1:0.50]
; SLM-NEXT:    pxor (%rdi), %mm0 # sched: [4:1.00]
; SLM-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_pxor:
; SANDY:       # %bb.0:
; SANDY-NEXT:    pxor %mm1, %mm0 # sched: [1:1.00]
; SANDY-NEXT:    pxor (%rdi), %mm0 # sched: [5:1.00]
; SANDY-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_pxor:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    pxor %mm1, %mm0 # sched: [1:0.33]
; HASWELL-NEXT:    pxor (%rdi), %mm0 # sched: [6:0.50]
; HASWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_pxor:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    pxor %mm1, %mm0 # sched: [1:0.33]
; BROADWELL-NEXT:    pxor (%rdi), %mm0 # sched: [6:0.50]
; BROADWELL-NEXT:    movd %mm0, %rax # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_pxor:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    pxor %mm1, %mm0 # sched: [1:0.50]
; SKYLAKE-NEXT:    pxor (%rdi), %mm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_pxor:
; SKX:       # %bb.0:
; SKX-NEXT:    pxor %mm1, %mm0 # sched: [1:0.50]
; SKX-NEXT:    pxor (%rdi), %mm0 # sched: [6:0.50]
; SKX-NEXT:    movd %mm0, %rax # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_pxor:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    pxor %mm1, %mm0 # sched: [1:0.50]
; BTVER2-NEXT:    pxor (%rdi), %mm0 # sched: [6:1.00]
; BTVER2-NEXT:    movd %mm0, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_pxor:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    pxor %mm1, %mm0 # sched: [1:0.25]
; ZNVER1-NEXT:    pxor (%rdi), %mm0 # sched: [8:0.50]
; ZNVER1-NEXT:    movd %mm0, %rax # sched: [2:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call x86_mmx @llvm.x86.mmx.pxor(x86_mmx %a0, x86_mmx %a1)
  %2 = load x86_mmx, x86_mmx *%a2, align 8
  %3 = call x86_mmx @llvm.x86.mmx.pxor(x86_mmx %1, x86_mmx %2)
  %4 = bitcast x86_mmx %3 to i64
  ret i64 %4
}
declare x86_mmx @llvm.x86.mmx.pxor(x86_mmx, x86_mmx) nounwind readnone
