/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Lib;

public class IteratorCons<T>
implements Iterator<T>,
Iterable<T> {
    private Iterator<? extends T> iter1;
    private Iterator<? extends T> iter2;
    private Iterator<? extends T> removeFrom;

    public static <X> Iterator<X> create(Iterator<? extends X> iter1, Iterator<? extends X> iter2) {
        if (iter1 == null && iter2 == null) {
            return Iter.nullIterator();
        }
        if (iter1 == null) {
            Iterator<? extends X> x = iter2;
            return x;
        }
        if (iter2 == null) {
            Iterator<? extends X> x = iter1;
            return x;
        }
        return new IteratorCons<X>(iter1, iter2);
    }

    private IteratorCons(Iterator<? extends T> iter1, Iterator<? extends T> iter2) {
        this.iter1 = iter1;
        this.iter2 = iter2;
    }

    @Override
    public boolean hasNext() {
        if (this.iter1 != null) {
            if (this.iter1.hasNext()) {
                return true;
            }
            this.iter1 = null;
        }
        if (this.iter2 != null) {
            if (this.iter2.hasNext()) {
                return true;
            }
            this.iter2 = null;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException(Lib.className(this) + ".next");
        }
        if (this.iter1 != null) {
            this.removeFrom = this.iter1;
            return this.iter1.next();
        }
        if (this.iter2 != null) {
            this.removeFrom = this.iter2;
            return this.iter2.next();
        }
        throw new Error(Lib.className(this) + ".next (two null iterators)");
    }

    @Override
    public void remove() {
        if (null == this.removeFrom) {
            throw new IllegalStateException("no calls to next() since last call to remove()");
        }
        this.removeFrom.remove();
        this.removeFrom = null;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

