/* SortedList.c generated by valac 0.36.6, the Vala compiler
 * generated from SortedList.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>


#define TYPE_SORTED_LIST (sorted_list_get_type ())
#define SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTED_LIST, SortedList))
#define SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTED_LIST, SortedListClass))
#define IS_SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTED_LIST))
#define IS_SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTED_LIST))
#define SORTED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTED_LIST, SortedListClass))

typedef struct _SortedList SortedList;
typedef struct _SortedListClass SortedListClass;
typedef struct _SortedListPrivate SortedListPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
struct _SortedList {
	GObject parent_instance;
	SortedListPrivate * priv;
};

struct _SortedListClass {
	GObjectClass parent_class;
};

struct _SortedListPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeArrayList* list;
	Comparator cmp;
	gpointer cmp_target;
};


static gpointer sorted_list_parent_class = NULL;
static GeeTraversableIface * sorted_list_gee_traversable_parent_iface = NULL;
static GeeIterableIface * sorted_list_gee_iterable_parent_iface = NULL;
static GeeCollectionIface * sorted_list_gee_collection_parent_iface = NULL;

GType sorted_list_get_type (void) G_GNUC_CONST;
#define SORTED_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SORTED_LIST, SortedListPrivate))
enum  {
	SORTED_LIST_DUMMY_PROPERTY,
	SORTED_LIST_G_TYPE,
	SORTED_LIST_G_DUP_FUNC,
	SORTED_LIST_G_DESTROY_FUNC,
	SORTED_LIST_ELEMENT_TYPE_PROPERTY,
	SORTED_LIST_READ_ONLY_PROPERTY,
	SORTED_LIST_IS_EMPTY_PROPERTY,
	SORTED_LIST_SIZE_PROPERTY,
	SORTED_LIST_READ_ONLY_VIEW_PROPERTY,
	SORTED_LIST_READ_ONLY_VIEW_AS_LIST_PROPERTY
};
SortedList* sorted_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, Comparator cmp, void* cmp_target);
SortedList* sorted_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, Comparator cmp, void* cmp_target);
static GeeIterator* sorted_list_real_iterator (GeeIterable* base);
static gboolean sorted_list_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target);
static gboolean sorted_list_real_add (GeeCollection* base, gconstpointer item);
static gint sorted_list_get_sorted_insert_pos (SortedList* self, gconstpointer item);
static gboolean sorted_list_real_add_all (GeeCollection* base, GeeCollection* collection);
gboolean sorted_list_add_list (SortedList* self, GeeList* items);
static gboolean sorted_list_merge_sort (SortedList* self, GeeList* add);
static void sorted_list_real_clear (GeeCollection* base);
static gboolean sorted_list_real_contains (GeeCollection* base, gconstpointer item);
static gboolean sorted_list_real_contains_all (GeeCollection* base, GeeCollection* collection);
static gboolean sorted_list_real_remove (GeeCollection* base, gconstpointer item);
static gboolean sorted_list_real_remove_all (GeeCollection* base, GeeCollection* collection);
static gboolean sorted_list_real_retain_all (GeeCollection* base, GeeCollection* collection);
gint sorted_list_get_count (SortedList* self);
gpointer sorted_list_get_at (SortedList* self, gint index);
static gint sorted_list_binary_search (SortedList* self, gconstpointer search, GEqualFunc equal_func);
gint sorted_list_index_of (SortedList* self, gconstpointer search);
gint sorted_list_locate (SortedList* self, gconstpointer search, gboolean altered, GEqualFunc equal_func);
gpointer sorted_list_remove_at (SortedList* self, gint index);
static gpointer* sorted_list_real_to_array (GeeCollection* base, int* result_length1);
void sorted_list_resort (SortedList* self, Comparator new_cmp, void* new_cmp_target);
gboolean sorted_list_resort_item (SortedList* self, gconstpointer item);
SortedList* sorted_list_copy (SortedList* self);
static void _sorted_list_merge_sort (SortedList* self, gpointer* array, int array_length1, gpointer* scratch, int scratch_length1, gint start_index, gint end_index);
static void sorted_list_merge (SortedList* self, gpointer* array, int array_length1, gpointer* scratch, int scratch_length1, gint start_index, gint middle_index, gint end_index);
GeeList* sorted_list_get_read_only_view_as_list (SortedList* self);
static void sorted_list_finalize (GObject * obj);
static void _vala_sorted_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sorted_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


SortedList* sorted_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, Comparator cmp, void* cmp_target) {
	SortedList * self = NULL;
	GeeArrayList* _tmp0_;
	Comparator _tmp1_;
	void* _tmp1__target;
#line 13 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = (SortedList*) g_object_new (object_type, NULL);
#line 13 "/home/jens/Source/shotwell/src/SortedList.vala"
	self->priv->g_type = g_type;
#line 13 "/home/jens/Source/shotwell/src/SortedList.vala"
	self->priv->g_dup_func = g_dup_func;
#line 13 "/home/jens/Source/shotwell/src/SortedList.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 14 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = gee_array_list_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, NULL, NULL, NULL);
#line 14 "/home/jens/Source/shotwell/src/SortedList.vala"
	_g_object_unref0 (self->priv->list);
#line 14 "/home/jens/Source/shotwell/src/SortedList.vala"
	self->priv->list = _tmp0_;
#line 15 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = cmp;
#line 15 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1__target = cmp_target;
#line 15 "/home/jens/Source/shotwell/src/SortedList.vala"
	self->priv->cmp = _tmp1_;
#line 15 "/home/jens/Source/shotwell/src/SortedList.vala"
	self->priv->cmp_target = _tmp1__target;
#line 13 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self;
#line 135 "SortedList.c"
}


SortedList* sorted_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, Comparator cmp, void* cmp_target) {
#line 13 "/home/jens/Source/shotwell/src/SortedList.vala"
	return sorted_list_construct (TYPE_SORTED_LIST, g_type, g_dup_func, g_destroy_func, cmp, cmp_target);
#line 142 "SortedList.c"
}


static GeeIterator* sorted_list_real_iterator (GeeIterable* base) {
	SortedList * self;
	GeeIterator* result = NULL;
	GeeArrayList* _tmp0_;
	GeeIterator* _tmp1_;
#line 26 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 27 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 27 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 27 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp1_;
#line 27 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 161 "SortedList.c"
}


static gboolean sorted_list_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target) {
	SortedList * self;
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
	GeeForallFunc _tmp1_;
	void* _tmp1__target;
	gboolean _tmp2_;
#line 30 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 31 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 31 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = f;
#line 31 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1__target = f_target;
#line 31 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_abstract_collection_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_, _tmp1__target);
#line 31 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 31 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 186 "SortedList.c"
}


static gboolean sorted_list_real_add (GeeCollection* base, gconstpointer item) {
	SortedList * self;
	gboolean result = FALSE;
	Comparator _tmp0_;
	void* _tmp0__target;
#line 34 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 35 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->cmp;
#line 35 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0__target = self->priv->cmp_target;
#line 35 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp0_ == NULL) {
#line 203 "SortedList.c"
		GeeArrayList* _tmp1_;
		gconstpointer _tmp2_;
#line 36 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp1_ = self->priv->list;
#line 36 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp2_ = item;
#line 36 "/home/jens/Source/shotwell/src/SortedList.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp2_);
#line 212 "SortedList.c"
	} else {
		GeeArrayList* _tmp3_;
		gconstpointer _tmp4_;
		gint _tmp5_;
		gconstpointer _tmp6_;
#line 38 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp3_ = self->priv->list;
#line 38 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp4_ = item;
#line 38 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp5_ = sorted_list_get_sorted_insert_pos (self, _tmp4_);
#line 38 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp6_ = item;
#line 38 "/home/jens/Source/shotwell/src/SortedList.vala"
		gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp5_, _tmp6_);
#line 228 "SortedList.c"
	}
#line 44 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = TRUE;
#line 44 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 234 "SortedList.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 51 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self ? g_object_ref (self) : NULL;
#line 241 "SortedList.c"
}


static gboolean sorted_list_real_add_all (GeeCollection* base, GeeCollection* collection) {
	SortedList * self;
	gboolean result = FALSE;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeList* as_list = NULL;
	GeeCollection* _tmp3_;
	GeeList* _tmp4_;
	GeeList* _tmp5_;
	Comparator _tmp8_;
	void* _tmp8__target;
	gboolean changed = FALSE;
	GeeCollection* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
#line 47 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 47 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (collection), FALSE);
#line 48 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = collection;
#line 48 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 48 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = _tmp1_;
#line 48 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp2_ == 0) {
#line 49 "/home/jens/Source/shotwell/src/SortedList.vala"
		result = FALSE;
#line 49 "/home/jens/Source/shotwell/src/SortedList.vala"
		return result;
#line 277 "SortedList.c"
	}
#line 51 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp3_ = collection;
#line 51 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GEE_TYPE_LIST) ? ((GeeList*) _tmp3_) : NULL);
#line 51 "/home/jens/Source/shotwell/src/SortedList.vala"
	as_list = _tmp4_;
#line 52 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp5_ = as_list;
#line 52 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp5_ != NULL) {
#line 289 "SortedList.c"
		GeeList* _tmp6_;
		gboolean _tmp7_;
#line 53 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp6_ = as_list;
#line 53 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp7_ = sorted_list_add_list (self, _tmp6_);
#line 53 "/home/jens/Source/shotwell/src/SortedList.vala"
		result = _tmp7_;
#line 53 "/home/jens/Source/shotwell/src/SortedList.vala"
		_g_object_unref0 (as_list);
#line 53 "/home/jens/Source/shotwell/src/SortedList.vala"
		return result;
#line 302 "SortedList.c"
	}
#line 55 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp8_ = self->priv->cmp;
#line 55 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp8__target = self->priv->cmp_target;
#line 55 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp8_ == NULL) {
#line 310 "SortedList.c"
		GeeArrayList* _tmp9_;
		GeeCollection* _tmp10_;
		gboolean _tmp11_;
#line 56 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp9_ = self->priv->list;
#line 56 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp10_ = collection;
#line 56 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp11_ = gee_array_list_add_all (_tmp9_, _tmp10_);
#line 56 "/home/jens/Source/shotwell/src/SortedList.vala"
		result = _tmp11_;
#line 56 "/home/jens/Source/shotwell/src/SortedList.vala"
		_g_object_unref0 (as_list);
#line 56 "/home/jens/Source/shotwell/src/SortedList.vala"
		return result;
#line 326 "SortedList.c"
	}
#line 58 "/home/jens/Source/shotwell/src/SortedList.vala"
	changed = FALSE;
#line 59 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp12_ = collection;
#line 59 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp13_ = gee_collection_get_size (_tmp12_);
#line 59 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp14_ = _tmp13_;
#line 59 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp14_ == 1) {
#line 338 "SortedList.c"
		GeeIterator* iter = NULL;
		GeeCollection* _tmp15_;
		GeeIterator* _tmp16_;
		GeeIterator* _tmp17_;
		gpointer item = NULL;
		GeeIterator* _tmp18_;
		gpointer _tmp19_;
		GeeArrayList* _tmp20_;
		gconstpointer _tmp21_;
		gint _tmp22_;
		gconstpointer _tmp23_;
#line 60 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp15_ = collection;
#line 60 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp16_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ITERABLE, GeeIterable));
#line 60 "/home/jens/Source/shotwell/src/SortedList.vala"
		iter = _tmp16_;
#line 61 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp17_ = iter;
#line 61 "/home/jens/Source/shotwell/src/SortedList.vala"
		gee_iterator_next (_tmp17_);
#line 62 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp18_ = iter;
#line 62 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp19_ = gee_iterator_get (_tmp18_);
#line 62 "/home/jens/Source/shotwell/src/SortedList.vala"
		item = _tmp19_;
#line 64 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp20_ = self->priv->list;
#line 64 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp21_ = item;
#line 64 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp22_ = sorted_list_get_sorted_insert_pos (self, _tmp21_);
#line 64 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp23_ = item;
#line 64 "/home/jens/Source/shotwell/src/SortedList.vala"
		gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp22_, _tmp23_);
#line 65 "/home/jens/Source/shotwell/src/SortedList.vala"
		changed = TRUE;
#line 59 "/home/jens/Source/shotwell/src/SortedList.vala"
		((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 59 "/home/jens/Source/shotwell/src/SortedList.vala"
		_g_object_unref0 (iter);
#line 382 "SortedList.c"
	} else {
		GeeList* items = NULL;
		GeeArrayList* _tmp24_;
		GeeList* _tmp25_;
		GeeCollection* _tmp26_;
		GeeList* _tmp27_;
		gboolean _tmp28_;
#line 67 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp24_ = gee_array_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, NULL, NULL, NULL);
#line 67 "/home/jens/Source/shotwell/src/SortedList.vala"
		items = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_LIST, GeeList);
#line 68 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp25_ = items;
#line 68 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp26_ = collection;
#line 68 "/home/jens/Source/shotwell/src/SortedList.vala"
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COLLECTION, GeeCollection), _tmp26_);
#line 70 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp27_ = items;
#line 70 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp28_ = sorted_list_merge_sort (self, _tmp27_);
#line 70 "/home/jens/Source/shotwell/src/SortedList.vala"
		changed = _tmp28_;
#line 59 "/home/jens/Source/shotwell/src/SortedList.vala"
		_g_object_unref0 (items);
#line 408 "SortedList.c"
	}
#line 76 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = changed;
#line 76 "/home/jens/Source/shotwell/src/SortedList.vala"
	_g_object_unref0 (as_list);
#line 76 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 416 "SortedList.c"
}


gboolean sorted_list_add_list (SortedList* self, GeeList* items) {
	gboolean result = FALSE;
	gboolean added = FALSE;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 79 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), FALSE);
#line 79 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (GEE_IS_LIST (items), FALSE);
#line 80 "/home/jens/Source/shotwell/src/SortedList.vala"
	added = FALSE;
#line 81 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = items;
#line 81 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 81 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = _tmp1_;
#line 81 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp2_ == 0) {
#line 440 "SortedList.c"
	} else {
		Comparator _tmp3_;
		void* _tmp3__target;
#line 83 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp3_ = self->priv->cmp;
#line 83 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp3__target = self->priv->cmp_target;
#line 83 "/home/jens/Source/shotwell/src/SortedList.vala"
		if (_tmp3_ != NULL) {
#line 450 "SortedList.c"
			GeeList* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
#line 86 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp4_ = items;
#line 86 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp5_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
#line 86 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp6_ = _tmp5_;
#line 86 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (_tmp6_ == 1) {
#line 462 "SortedList.c"
				GeeArrayList* _tmp7_;
				GeeList* _tmp8_;
				gpointer _tmp9_;
				gpointer _tmp10_;
				gint _tmp11_;
				GeeList* _tmp12_;
				gpointer _tmp13_;
				gpointer _tmp14_;
#line 87 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp7_ = self->priv->list;
#line 87 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp8_ = items;
#line 87 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp9_ = gee_list_get (_tmp8_, 0);
#line 87 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp10_ = _tmp9_;
#line 87 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp11_ = sorted_list_get_sorted_insert_pos (self, _tmp10_);
#line 87 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp12_ = items;
#line 87 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp13_ = gee_list_get (_tmp12_, 0);
#line 87 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp14_ = _tmp13_;
#line 87 "/home/jens/Source/shotwell/src/SortedList.vala"
				gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp11_, _tmp14_);
#line 87 "/home/jens/Source/shotwell/src/SortedList.vala"
				((_tmp14_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp14_ = (self->priv->g_destroy_func (_tmp14_), NULL));
#line 87 "/home/jens/Source/shotwell/src/SortedList.vala"
				((_tmp10_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp10_ = (self->priv->g_destroy_func (_tmp10_), NULL));
#line 88 "/home/jens/Source/shotwell/src/SortedList.vala"
				added = TRUE;
#line 495 "SortedList.c"
			} else {
				GeeList* _tmp15_;
				gboolean _tmp16_;
#line 90 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp15_ = items;
#line 90 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp16_ = sorted_list_merge_sort (self, _tmp15_);
#line 90 "/home/jens/Source/shotwell/src/SortedList.vala"
				added = _tmp16_;
#line 505 "SortedList.c"
			}
		} else {
			GeeArrayList* _tmp17_;
			GeeList* _tmp18_;
			gboolean _tmp19_;
#line 93 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp17_ = self->priv->list;
#line 93 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp18_ = items;
#line 93 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp19_ = gee_array_list_add_all (_tmp17_, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection));
#line 93 "/home/jens/Source/shotwell/src/SortedList.vala"
			added = _tmp19_;
#line 519 "SortedList.c"
		}
	}
#line 100 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = added;
#line 100 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 526 "SortedList.c"
}


static void sorted_list_real_clear (GeeCollection* base) {
	SortedList * self;
	GeeArrayList* _tmp0_;
#line 103 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 104 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 104 "/home/jens/Source/shotwell/src/SortedList.vala"
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 539 "SortedList.c"
}


static gboolean sorted_list_real_contains (GeeCollection* base, gconstpointer item) {
	SortedList * self;
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
	gconstpointer _tmp1_;
	gboolean _tmp2_;
#line 107 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 108 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 108 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = item;
#line 108 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_);
#line 108 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 108 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 561 "SortedList.c"
}


static gboolean sorted_list_real_contains_all (GeeCollection* base, GeeCollection* collection) {
	SortedList * self;
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean _tmp2_;
#line 111 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 111 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (collection), FALSE);
#line 112 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 112 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = collection;
#line 112 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_collection_contains_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _tmp1_);
#line 112 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 112 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 585 "SortedList.c"
}


static gboolean sorted_list_real_remove (GeeCollection* base, gconstpointer item) {
	SortedList * self;
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
	gconstpointer _tmp1_;
	gboolean _tmp2_;
#line 121 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 122 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 122 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = item;
#line 122 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_);
#line 122 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 122 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 607 "SortedList.c"
}


static gboolean sorted_list_real_remove_all (GeeCollection* base, GeeCollection* collection) {
	SortedList * self;
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean _tmp2_;
#line 125 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 125 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (collection), FALSE);
#line 126 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 126 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = collection;
#line 126 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_collection_remove_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _tmp1_);
#line 126 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 126 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 631 "SortedList.c"
}


static gboolean sorted_list_real_retain_all (GeeCollection* base, GeeCollection* collection) {
	SortedList * self;
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean _tmp2_;
#line 129 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 129 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (collection), FALSE);
#line 130 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 130 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = collection;
#line 130 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_collection_retain_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _tmp1_);
#line 130 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 130 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 655 "SortedList.c"
}


inline gint sorted_list_get_count (SortedList* self) {
	gint result = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 137 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), 0);
#line 138 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 138 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 138 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = _tmp1_;
#line 138 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 138 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 676 "SortedList.c"
}


gpointer sorted_list_get_at (SortedList* self, gint index) {
	gpointer result = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gpointer _tmp2_;
#line 141 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), NULL);
#line 142 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 142 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = index;
#line 142 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp1_);
#line 142 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 142 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 697 "SortedList.c"
}


static gint sorted_list_binary_search (SortedList* self, gconstpointer search, GEqualFunc equal_func) {
	gint result = 0;
	Comparator _tmp0_;
	void* _tmp0__target;
	gint min = 0;
	gint max = 0;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
#line 145 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), 0);
#line 146 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->cmp;
#line 146 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0__target = self->priv->cmp_target;
#line 146 "/home/jens/Source/shotwell/src/SortedList.vala"
	_vala_assert (_tmp0_ != NULL, "cmp != null");
#line 148 "/home/jens/Source/shotwell/src/SortedList.vala"
	min = 0;
#line 149 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = self->priv->list;
#line 149 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 149 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp3_ = _tmp2_;
#line 149 "/home/jens/Source/shotwell/src/SortedList.vala"
	max = _tmp3_;
#line 728 "SortedList.c"
	{
		gboolean _tmp4_ = FALSE;
#line 150 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp4_ = TRUE;
#line 150 "/home/jens/Source/shotwell/src/SortedList.vala"
		while (TRUE) {
#line 735 "SortedList.c"
			gint mid = 0;
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gpointer item = NULL;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			GEqualFunc _tmp12_;
			gint64 compare = 0LL;
			Comparator _tmp17_;
			void* _tmp17__target;
			gconstpointer _tmp18_;
			gconstpointer _tmp19_;
			gint64 _tmp20_;
			gint64 _tmp21_;
			gint _tmp25_;
			gint _tmp26_;
#line 150 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (!_tmp4_) {
#line 757 "SortedList.c"
			}
#line 150 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp4_ = FALSE;
#line 151 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp5_ = min;
#line 151 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp6_ = max;
#line 151 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp7_ = min;
#line 151 "/home/jens/Source/shotwell/src/SortedList.vala"
			mid = _tmp5_ + ((_tmp6_ - _tmp7_) / 2);
#line 152 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp8_ = self->priv->list;
#line 152 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp9_ = mid;
#line 152 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp10_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp9_);
#line 152 "/home/jens/Source/shotwell/src/SortedList.vala"
			item = _tmp10_;
#line 154 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp12_ = equal_func;
#line 154 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (_tmp12_ != NULL) {
#line 781 "SortedList.c"
				GEqualFunc _tmp13_;
				gconstpointer _tmp14_;
				gconstpointer _tmp15_;
				gboolean _tmp16_;
#line 154 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp13_ = equal_func;
#line 154 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp14_ = item;
#line 154 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp15_ = search;
#line 154 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp16_ = _tmp13_ (_tmp14_, _tmp15_);
#line 154 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp11_ = _tmp16_;
#line 796 "SortedList.c"
			} else {
#line 154 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp11_ = FALSE;
#line 800 "SortedList.c"
			}
#line 154 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (_tmp11_) {
#line 155 "/home/jens/Source/shotwell/src/SortedList.vala"
				result = mid;
#line 155 "/home/jens/Source/shotwell/src/SortedList.vala"
				((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 155 "/home/jens/Source/shotwell/src/SortedList.vala"
				return result;
#line 810 "SortedList.c"
			}
#line 157 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp17_ = self->priv->cmp;
#line 157 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp17__target = self->priv->cmp_target;
#line 157 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp18_ = item;
#line 157 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp19_ = search;
#line 157 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp20_ = _tmp17_ (_tmp18_, _tmp19_, _tmp17__target);
#line 157 "/home/jens/Source/shotwell/src/SortedList.vala"
			compare = _tmp20_;
#line 158 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp21_ = compare;
#line 158 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (_tmp21_ == ((gint64) 0)) {
#line 159 "/home/jens/Source/shotwell/src/SortedList.vala"
				result = mid;
#line 159 "/home/jens/Source/shotwell/src/SortedList.vala"
				((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 159 "/home/jens/Source/shotwell/src/SortedList.vala"
				return result;
#line 834 "SortedList.c"
			} else {
				gint64 _tmp22_;
#line 160 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp22_ = compare;
#line 160 "/home/jens/Source/shotwell/src/SortedList.vala"
				if (_tmp22_ > ((gint64) 0)) {
#line 841 "SortedList.c"
					gint _tmp23_;
#line 161 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp23_ = mid;
#line 161 "/home/jens/Source/shotwell/src/SortedList.vala"
					max = _tmp23_ - 1;
#line 847 "SortedList.c"
				} else {
					gint _tmp24_;
#line 163 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp24_ = mid;
#line 163 "/home/jens/Source/shotwell/src/SortedList.vala"
					min = _tmp24_ + 1;
#line 854 "SortedList.c"
				}
			}
#line 165 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp25_ = min;
#line 165 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp26_ = max;
#line 165 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (_tmp25_ > _tmp26_) {
#line 166 "/home/jens/Source/shotwell/src/SortedList.vala"
				((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 166 "/home/jens/Source/shotwell/src/SortedList.vala"
				break;
#line 867 "SortedList.c"
			}
#line 150 "/home/jens/Source/shotwell/src/SortedList.vala"
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 871 "SortedList.c"
		}
	}
#line 169 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = -1;
#line 169 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 878 "SortedList.c"
}


gint sorted_list_index_of (SortedList* self, gconstpointer search) {
	gint result = 0;
	gint _tmp0_ = 0;
	Comparator _tmp1_;
	void* _tmp1__target;
#line 179 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), 0);
#line 180 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = self->priv->cmp;
#line 180 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1__target = self->priv->cmp_target;
#line 180 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp1_ != NULL) {
#line 895 "SortedList.c"
		gconstpointer _tmp2_;
		gint _tmp3_;
#line 180 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp2_ = search;
#line 180 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp3_ = sorted_list_binary_search (self, _tmp2_, NULL);
#line 180 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp0_ = _tmp3_;
#line 904 "SortedList.c"
	} else {
		gconstpointer _tmp4_;
		GEqualFunc _tmp5_;
		gint _tmp6_;
#line 180 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp4_ = search;
#line 180 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp5_ = g_direct_equal;
#line 180 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp6_ = sorted_list_locate (self, _tmp4_, FALSE, _tmp5_);
#line 180 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp0_ = _tmp6_;
#line 917 "SortedList.c"
	}
#line 180 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp0_;
#line 180 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 923 "SortedList.c"
}


gint sorted_list_locate (SortedList* self, gconstpointer search, gboolean altered, GEqualFunc equal_func) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	Comparator _tmp1_;
	void* _tmp1__target;
	gconstpointer _tmp18_;
	GEqualFunc _tmp19_;
	gint _tmp20_;
#line 184 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), 0);
#line 185 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = self->priv->cmp;
#line 185 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1__target = self->priv->cmp_target;
#line 185 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp1_ == NULL) {
#line 185 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp0_ = TRUE;
#line 945 "SortedList.c"
	} else {
		gboolean _tmp2_;
#line 185 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp2_ = altered;
#line 185 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp0_ = _tmp2_;
#line 952 "SortedList.c"
	}
#line 185 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp0_) {
#line 956 "SortedList.c"
		gint count = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 186 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp3_ = self->priv->list;
#line 186 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp4_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 186 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp5_ = _tmp4_;
#line 186 "/home/jens/Source/shotwell/src/SortedList.vala"
		count = _tmp5_;
#line 969 "SortedList.c"
		{
			gint ctr = 0;
#line 187 "/home/jens/Source/shotwell/src/SortedList.vala"
			ctr = 0;
#line 974 "SortedList.c"
			{
				gboolean _tmp6_ = FALSE;
#line 187 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp6_ = TRUE;
#line 187 "/home/jens/Source/shotwell/src/SortedList.vala"
				while (TRUE) {
#line 981 "SortedList.c"
					gint _tmp8_;
					gint _tmp9_;
					GEqualFunc _tmp10_;
					GeeArrayList* _tmp11_;
					gint _tmp12_;
					gpointer _tmp13_;
					gpointer _tmp14_;
					gconstpointer _tmp15_;
					gboolean _tmp16_;
					gboolean _tmp17_;
#line 187 "/home/jens/Source/shotwell/src/SortedList.vala"
					if (!_tmp6_) {
#line 994 "SortedList.c"
						gint _tmp7_;
#line 187 "/home/jens/Source/shotwell/src/SortedList.vala"
						_tmp7_ = ctr;
#line 187 "/home/jens/Source/shotwell/src/SortedList.vala"
						ctr = _tmp7_ + 1;
#line 1000 "SortedList.c"
					}
#line 187 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp6_ = FALSE;
#line 187 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp8_ = ctr;
#line 187 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp9_ = count;
#line 187 "/home/jens/Source/shotwell/src/SortedList.vala"
					if (!(_tmp8_ < _tmp9_)) {
#line 187 "/home/jens/Source/shotwell/src/SortedList.vala"
						break;
#line 1012 "SortedList.c"
					}
#line 188 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp10_ = equal_func;
#line 188 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp11_ = self->priv->list;
#line 188 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp12_ = ctr;
#line 188 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp13_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp12_);
#line 188 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp14_ = _tmp13_;
#line 188 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp15_ = search;
#line 188 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp16_ = _tmp10_ (_tmp14_, _tmp15_);
#line 188 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp17_ = _tmp16_;
#line 188 "/home/jens/Source/shotwell/src/SortedList.vala"
					((_tmp14_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp14_ = (self->priv->g_destroy_func (_tmp14_), NULL));
#line 188 "/home/jens/Source/shotwell/src/SortedList.vala"
					if (_tmp17_) {
#line 189 "/home/jens/Source/shotwell/src/SortedList.vala"
						result = ctr;
#line 189 "/home/jens/Source/shotwell/src/SortedList.vala"
						return result;
#line 1038 "SortedList.c"
					}
				}
			}
		}
#line 192 "/home/jens/Source/shotwell/src/SortedList.vala"
		result = -1;
#line 192 "/home/jens/Source/shotwell/src/SortedList.vala"
		return result;
#line 1047 "SortedList.c"
	}
#line 195 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp18_ = search;
#line 195 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp19_ = equal_func;
#line 195 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp20_ = sorted_list_binary_search (self, _tmp18_, _tmp19_);
#line 195 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp20_;
#line 195 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 1059 "SortedList.c"
}


gpointer sorted_list_remove_at (SortedList* self, gint index) {
	gpointer result = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gpointer _tmp2_;
#line 210 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), NULL);
#line 211 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 211 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = index;
#line 211 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp1_);
#line 211 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 211 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 1080 "SortedList.c"
}


static gpointer* sorted_list_real_to_array (GeeCollection* base, int* result_length1) {
	SortedList * self;
	gpointer* result = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gpointer* _tmp2_;
	gpointer* _tmp3_;
	gint _tmp3__length1;
#line 214 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 215 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 215 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_collection_to_array (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), &_tmp1_);
#line 215 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp3_ = _tmp2_;
#line 215 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp3__length1 = _tmp1_;
#line 215 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (result_length1) {
#line 215 "/home/jens/Source/shotwell/src/SortedList.vala"
		*result_length1 = _tmp3__length1;
#line 1106 "SortedList.c"
	}
#line 215 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp3_;
#line 215 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 1112 "SortedList.c"
}


void sorted_list_resort (SortedList* self, Comparator new_cmp, void* new_cmp_target) {
	Comparator _tmp0_;
	void* _tmp0__target;
#line 218 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_if_fail (IS_SORTED_LIST (self));
#line 219 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = new_cmp;
#line 219 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0__target = new_cmp_target;
#line 219 "/home/jens/Source/shotwell/src/SortedList.vala"
	self->priv->cmp = _tmp0_;
#line 219 "/home/jens/Source/shotwell/src/SortedList.vala"
	self->priv->cmp_target = _tmp0__target;
#line 221 "/home/jens/Source/shotwell/src/SortedList.vala"
	sorted_list_merge_sort (self, NULL);
#line 1131 "SortedList.c"
}


gboolean sorted_list_resort_item (SortedList* self, gconstpointer item) {
	gboolean result = FALSE;
	gint index = 0;
	gconstpointer _tmp0_;
	GEqualFunc _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint new_index = 0;
	gconstpointer _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
#line 229 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), FALSE);
#line 230 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = item;
#line 230 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = g_direct_equal;
#line 230 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = sorted_list_locate (self, _tmp0_, TRUE, _tmp1_);
#line 230 "/home/jens/Source/shotwell/src/SortedList.vala"
	index = _tmp2_;
#line 231 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp3_ = index;
#line 231 "/home/jens/Source/shotwell/src/SortedList.vala"
	_vala_assert (_tmp3_ >= 0, "index >= 0");
#line 233 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp4_ = item;
#line 233 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp5_ = sorted_list_get_sorted_insert_pos (self, _tmp4_);
#line 233 "/home/jens/Source/shotwell/src/SortedList.vala"
	new_index = _tmp5_;
#line 235 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp6_ = index;
#line 235 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp7_ = new_index;
#line 235 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp6_ == _tmp7_) {
#line 236 "/home/jens/Source/shotwell/src/SortedList.vala"
		result = FALSE;
#line 236 "/home/jens/Source/shotwell/src/SortedList.vala"
		return result;
#line 1179 "SortedList.c"
	}
#line 240 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp8_ = new_index;
#line 240 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp9_ = index;
#line 240 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp8_ > _tmp9_) {
#line 1187 "SortedList.c"
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gconstpointer _tmp12_;
		gpointer removed_item = NULL;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gpointer _tmp15_;
		gconstpointer _tmp16_;
		gconstpointer _tmp17_;
#line 241 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp10_ = self->priv->list;
#line 241 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp11_ = new_index;
#line 241 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp12_ = item;
#line 241 "/home/jens/Source/shotwell/src/SortedList.vala"
		gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp11_, _tmp12_);
#line 242 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp13_ = self->priv->list;
#line 242 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp14_ = index;
#line 242 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp15_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp14_);
#line 242 "/home/jens/Source/shotwell/src/SortedList.vala"
		removed_item = _tmp15_;
#line 243 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp16_ = item;
#line 243 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp17_ = removed_item;
#line 243 "/home/jens/Source/shotwell/src/SortedList.vala"
		_vala_assert (_tmp16_ == _tmp17_, "item == removed_item");
#line 240 "/home/jens/Source/shotwell/src/SortedList.vala"
		((removed_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (removed_item = (self->priv->g_destroy_func (removed_item), NULL));
#line 1221 "SortedList.c"
	} else {
		gpointer removed_item = NULL;
		GeeArrayList* _tmp18_;
		gint _tmp19_;
		gpointer _tmp20_;
		gconstpointer _tmp21_;
		gconstpointer _tmp22_;
		GeeArrayList* _tmp23_;
		gint _tmp24_;
		gconstpointer _tmp25_;
#line 245 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp18_ = self->priv->list;
#line 245 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp19_ = index;
#line 245 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp20_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp19_);
#line 245 "/home/jens/Source/shotwell/src/SortedList.vala"
		removed_item = _tmp20_;
#line 246 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp21_ = item;
#line 246 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp22_ = removed_item;
#line 246 "/home/jens/Source/shotwell/src/SortedList.vala"
		_vala_assert (_tmp21_ == _tmp22_, "item == removed_item");
#line 247 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp23_ = self->priv->list;
#line 247 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp24_ = new_index;
#line 247 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp25_ = item;
#line 247 "/home/jens/Source/shotwell/src/SortedList.vala"
		gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp24_, _tmp25_);
#line 240 "/home/jens/Source/shotwell/src/SortedList.vala"
		((removed_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (removed_item = (self->priv->g_destroy_func (removed_item), NULL));
#line 1256 "SortedList.c"
	}
#line 254 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = TRUE;
#line 254 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 1262 "SortedList.c"
}


static gint sorted_list_get_sorted_insert_pos (SortedList* self, gconstpointer item) {
	gint result = 0;
	gint low = 0;
	gint high = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 257 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), 0);
#line 258 "/home/jens/Source/shotwell/src/SortedList.vala"
	low = 0;
#line 259 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 259 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 259 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = _tmp1_;
#line 259 "/home/jens/Source/shotwell/src/SortedList.vala"
	high = _tmp2_;
#line 1285 "SortedList.c"
	{
		gboolean _tmp3_ = FALSE;
#line 260 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp3_ = TRUE;
#line 260 "/home/jens/Source/shotwell/src/SortedList.vala"
		while (TRUE) {
#line 1292 "SortedList.c"
			gint _tmp4_;
			gint _tmp5_;
			gint mid = 0;
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gpointer cmp_item = NULL;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			gconstpointer _tmp12_;
			gconstpointer _tmp13_;
			gint64 _result_ = 0LL;
			Comparator _tmp24_;
			void* _tmp24__target;
			gconstpointer _tmp25_;
			gconstpointer _tmp26_;
			gint64 _tmp27_;
			gint64 _tmp28_;
#line 260 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (!_tmp3_) {
#line 1314 "SortedList.c"
			}
#line 260 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp3_ = FALSE;
#line 261 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp4_ = low;
#line 261 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp5_ = high;
#line 261 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (_tmp4_ == _tmp5_) {
#line 262 "/home/jens/Source/shotwell/src/SortedList.vala"
				result = low;
#line 262 "/home/jens/Source/shotwell/src/SortedList.vala"
				return result;
#line 1328 "SortedList.c"
			}
#line 264 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp6_ = low;
#line 264 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp7_ = high;
#line 264 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp8_ = low;
#line 264 "/home/jens/Source/shotwell/src/SortedList.vala"
			mid = _tmp6_ + ((_tmp7_ - _tmp8_) / 2);
#line 268 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp9_ = self->priv->list;
#line 268 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp10_ = mid;
#line 268 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp11_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp10_);
#line 268 "/home/jens/Source/shotwell/src/SortedList.vala"
			cmp_item = _tmp11_;
#line 269 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp12_ = item;
#line 269 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp13_ = cmp_item;
#line 269 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (_tmp12_ == _tmp13_) {
#line 1352 "SortedList.c"
				gint _tmp14_;
				GeeArrayList* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				GeeArrayList* _tmp21_;
				gint _tmp22_;
				gpointer _tmp23_;
#line 271 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp14_ = mid;
#line 271 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp15_ = self->priv->list;
#line 271 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp16_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 271 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp17_ = _tmp16_;
#line 271 "/home/jens/Source/shotwell/src/SortedList.vala"
				if (_tmp14_ >= (_tmp17_ - 1)) {
#line 1370 "SortedList.c"
					GeeArrayList* _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
#line 272 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp18_ = self->priv->list;
#line 272 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp19_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 272 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp20_ = _tmp19_;
#line 272 "/home/jens/Source/shotwell/src/SortedList.vala"
					result = _tmp20_;
#line 272 "/home/jens/Source/shotwell/src/SortedList.vala"
					((cmp_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (cmp_item = (self->priv->g_destroy_func (cmp_item), NULL));
#line 272 "/home/jens/Source/shotwell/src/SortedList.vala"
					return result;
#line 1386 "SortedList.c"
				}
#line 274 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp21_ = self->priv->list;
#line 274 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp22_ = mid;
#line 274 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp23_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp22_ + 1);
#line 274 "/home/jens/Source/shotwell/src/SortedList.vala"
				((cmp_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (cmp_item = (self->priv->g_destroy_func (cmp_item), NULL));
#line 274 "/home/jens/Source/shotwell/src/SortedList.vala"
				cmp_item = _tmp23_;
#line 1398 "SortedList.c"
			}
#line 277 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp24_ = self->priv->cmp;
#line 277 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp24__target = self->priv->cmp_target;
#line 277 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp25_ = item;
#line 277 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp26_ = cmp_item;
#line 277 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp27_ = _tmp24_ (_tmp25_, _tmp26_, _tmp24__target);
#line 277 "/home/jens/Source/shotwell/src/SortedList.vala"
			_result_ = _tmp27_;
#line 278 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp28_ = _result_;
#line 278 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (_tmp28_ < ((gint64) 0)) {
#line 1416 "SortedList.c"
				gint _tmp29_;
#line 279 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp29_ = mid;
#line 279 "/home/jens/Source/shotwell/src/SortedList.vala"
				high = _tmp29_;
#line 1422 "SortedList.c"
			} else {
				gint64 _tmp30_;
#line 280 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp30_ = _result_;
#line 280 "/home/jens/Source/shotwell/src/SortedList.vala"
				if (_tmp30_ > ((gint64) 0)) {
#line 1429 "SortedList.c"
					gint _tmp31_;
#line 281 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp31_ = mid;
#line 281 "/home/jens/Source/shotwell/src/SortedList.vala"
					low = _tmp31_ + 1;
#line 1435 "SortedList.c"
				} else {
#line 283 "/home/jens/Source/shotwell/src/SortedList.vala"
					result = mid;
#line 283 "/home/jens/Source/shotwell/src/SortedList.vala"
					((cmp_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (cmp_item = (self->priv->g_destroy_func (cmp_item), NULL));
#line 283 "/home/jens/Source/shotwell/src/SortedList.vala"
					return result;
#line 1443 "SortedList.c"
				}
			}
#line 260 "/home/jens/Source/shotwell/src/SortedList.vala"
			((cmp_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (cmp_item = (self->priv->g_destroy_func (cmp_item), NULL));
#line 1448 "SortedList.c"
		}
	}
}


SortedList* sorted_list_copy (SortedList* self) {
	SortedList* result = NULL;
	SortedList* copy = NULL;
	Comparator _tmp0_;
	void* _tmp0__target;
	SortedList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
#line 287 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), NULL);
#line 288 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->cmp;
#line 288 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0__target = self->priv->cmp_target;
#line 288 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = sorted_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, _tmp0_, _tmp0__target);
#line 288 "/home/jens/Source/shotwell/src/SortedList.vala"
	copy = _tmp1_;
#line 290 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = copy->priv->list;
#line 290 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp3_ = self->priv->list;
#line 290 "/home/jens/Source/shotwell/src/SortedList.vala"
	gee_array_list_add_all (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
#line 292 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = copy;
#line 292 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 1482 "SortedList.c"
}


static gboolean sorted_list_merge_sort (SortedList* self, GeeList* add) {
	gboolean result = FALSE;
	Comparator _tmp0_;
	void* _tmp0__target;
	gint list_count = 0;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_ = 0;
	GeeList* _tmp5_;
	gint add_count = 0;
	gint count = 0;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gpointer* array = NULL;
	gint _tmp12_;
	gpointer* _tmp13_;
	gint array_length1;
	gint _array_size_;
	gint offset = 0;
	GeeList* _tmp23_;
	gint _tmp33_;
	gint _tmp34_;
	gpointer* _tmp35_;
	gint _tmp35__length1;
	gint _tmp36_;
	gpointer* _tmp37_;
	gpointer* _tmp38_;
	gint _tmp38__length1;
	gint _tmp39_;
#line 313 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), FALSE);
#line 313 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail ((add == NULL) || GEE_IS_LIST (add), FALSE);
#line 314 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->cmp;
#line 314 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0__target = self->priv->cmp_target;
#line 314 "/home/jens/Source/shotwell/src/SortedList.vala"
	_vala_assert (_tmp0_ != NULL, "cmp != null");
#line 316 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = self->priv->list;
#line 316 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 316 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp3_ = _tmp2_;
#line 316 "/home/jens/Source/shotwell/src/SortedList.vala"
	list_count = _tmp3_;
#line 317 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp5_ = add;
#line 317 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp5_ != NULL) {
#line 1539 "SortedList.c"
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
#line 317 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp6_ = add;
#line 317 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
#line 317 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp8_ = _tmp7_;
#line 317 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp4_ = _tmp8_;
#line 1551 "SortedList.c"
	} else {
#line 317 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp4_ = 0;
#line 1555 "SortedList.c"
	}
#line 317 "/home/jens/Source/shotwell/src/SortedList.vala"
	add_count = _tmp4_;
#line 319 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp9_ = list_count;
#line 319 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp10_ = add_count;
#line 319 "/home/jens/Source/shotwell/src/SortedList.vala"
	count = _tmp9_ + _tmp10_;
#line 320 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp11_ = count;
#line 320 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp11_ == 0) {
#line 321 "/home/jens/Source/shotwell/src/SortedList.vala"
		result = FALSE;
#line 321 "/home/jens/Source/shotwell/src/SortedList.vala"
		return result;
#line 1573 "SortedList.c"
	}
#line 325 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp12_ = count;
#line 325 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp13_ = g_new0 (gpointer, _tmp12_);
#line 325 "/home/jens/Source/shotwell/src/SortedList.vala"
	array = _tmp13_;
#line 325 "/home/jens/Source/shotwell/src/SortedList.vala"
	array_length1 = _tmp12_;
#line 325 "/home/jens/Source/shotwell/src/SortedList.vala"
	_array_size_ = array_length1;
#line 326 "/home/jens/Source/shotwell/src/SortedList.vala"
	offset = 0;
#line 328 "/home/jens/Source/shotwell/src/SortedList.vala"
	while (TRUE) {
#line 1589 "SortedList.c"
		gint _tmp14_;
		gint _tmp15_;
		gpointer* _tmp16_;
		gint _tmp16__length1;
		gint _tmp17_;
		GeeArrayList* _tmp18_;
		gint _tmp19_;
		gpointer _tmp20_;
		gpointer _tmp21_;
		gint _tmp22_;
#line 328 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp14_ = offset;
#line 328 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp15_ = list_count;
#line 328 "/home/jens/Source/shotwell/src/SortedList.vala"
		if (!(_tmp14_ < _tmp15_)) {
#line 328 "/home/jens/Source/shotwell/src/SortedList.vala"
			break;
#line 1608 "SortedList.c"
		}
#line 329 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp16_ = array;
#line 329 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp16__length1 = array_length1;
#line 329 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp17_ = offset;
#line 329 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp18_ = self->priv->list;
#line 329 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp19_ = offset;
#line 329 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp20_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp19_);
#line 329 "/home/jens/Source/shotwell/src/SortedList.vala"
		((_tmp16_[_tmp17_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp16_[_tmp17_] = (self->priv->g_destroy_func (_tmp16_[_tmp17_]), NULL));
#line 329 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp16_[_tmp17_] = _tmp20_;
#line 329 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp21_ = _tmp16_[_tmp17_];
#line 330 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp22_ = offset;
#line 330 "/home/jens/Source/shotwell/src/SortedList.vala"
		offset = _tmp22_ + 1;
#line 1632 "SortedList.c"
	}
#line 333 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp23_ = add;
#line 333 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp23_ != NULL) {
#line 1638 "SortedList.c"
		gint add_ctr = 0;
#line 334 "/home/jens/Source/shotwell/src/SortedList.vala"
		add_ctr = 0;
#line 335 "/home/jens/Source/shotwell/src/SortedList.vala"
		while (TRUE) {
#line 1644 "SortedList.c"
			gint _tmp24_;
			gint _tmp25_;
			gpointer* _tmp26_;
			gint _tmp26__length1;
			gint _tmp27_;
			GeeList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_;
			gpointer _tmp31_;
			gint _tmp32_;
#line 335 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp24_ = offset;
#line 335 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp25_ = count;
#line 335 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (!(_tmp24_ < _tmp25_)) {
#line 335 "/home/jens/Source/shotwell/src/SortedList.vala"
				break;
#line 1663 "SortedList.c"
			}
#line 336 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp26_ = array;
#line 336 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp26__length1 = array_length1;
#line 336 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp27_ = offset;
#line 336 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp28_ = add;
#line 336 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp29_ = add_ctr;
#line 336 "/home/jens/Source/shotwell/src/SortedList.vala"
			add_ctr = _tmp29_ + 1;
#line 336 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp30_ = gee_list_get (_tmp28_, _tmp29_);
#line 336 "/home/jens/Source/shotwell/src/SortedList.vala"
			((_tmp26_[_tmp27_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp26_[_tmp27_] = (self->priv->g_destroy_func (_tmp26_[_tmp27_]), NULL));
#line 336 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp26_[_tmp27_] = _tmp30_;
#line 336 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp31_ = _tmp26_[_tmp27_];
#line 337 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp32_ = offset;
#line 337 "/home/jens/Source/shotwell/src/SortedList.vala"
			offset = _tmp32_ + 1;
#line 1689 "SortedList.c"
		}
	}
#line 341 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp33_ = offset;
#line 341 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp34_ = count;
#line 341 "/home/jens/Source/shotwell/src/SortedList.vala"
	_vala_assert (_tmp33_ == _tmp34_, "offset == count");
#line 343 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp35_ = array;
#line 343 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp35__length1 = array_length1;
#line 343 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp36_ = count;
#line 343 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp37_ = g_new0 (gpointer, _tmp36_);
#line 343 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp38_ = _tmp37_;
#line 343 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp38__length1 = _tmp36_;
#line 343 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp39_ = count;
#line 343 "/home/jens/Source/shotwell/src/SortedList.vala"
	_sorted_list_merge_sort (self, _tmp35_, _tmp35__length1, _tmp38_, _tmp36_, 0, _tmp39_ - 1);
#line 343 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp38_ = (_vala_array_free (_tmp38_, _tmp38__length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
#line 345 "/home/jens/Source/shotwell/src/SortedList.vala"
	offset = 0;
#line 346 "/home/jens/Source/shotwell/src/SortedList.vala"
	while (TRUE) {
#line 1720 "SortedList.c"
		gint _tmp40_;
		gint _tmp41_;
		GeeArrayList* _tmp42_;
		gint _tmp43_;
		gpointer* _tmp44_;
		gint _tmp44__length1;
		gint _tmp45_;
		gconstpointer _tmp46_;
		gint _tmp47_;
#line 346 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp40_ = offset;
#line 346 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp41_ = list_count;
#line 346 "/home/jens/Source/shotwell/src/SortedList.vala"
		if (!(_tmp40_ < _tmp41_)) {
#line 346 "/home/jens/Source/shotwell/src/SortedList.vala"
			break;
#line 1738 "SortedList.c"
		}
#line 347 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp42_ = self->priv->list;
#line 347 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp43_ = offset;
#line 347 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp44_ = array;
#line 347 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp44__length1 = array_length1;
#line 347 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp45_ = offset;
#line 347 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp46_ = _tmp44_[_tmp45_];
#line 347 "/home/jens/Source/shotwell/src/SortedList.vala"
		gee_abstract_list_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp43_, _tmp46_);
#line 348 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp47_ = offset;
#line 348 "/home/jens/Source/shotwell/src/SortedList.vala"
		offset = _tmp47_ + 1;
#line 1758 "SortedList.c"
	}
#line 351 "/home/jens/Source/shotwell/src/SortedList.vala"
	while (TRUE) {
#line 1762 "SortedList.c"
		gint _tmp48_;
		gint _tmp49_;
		GeeArrayList* _tmp50_;
		gint _tmp51_;
		gpointer* _tmp52_;
		gint _tmp52__length1;
		gint _tmp53_;
		gconstpointer _tmp54_;
		gint _tmp55_;
#line 351 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp48_ = offset;
#line 351 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp49_ = count;
#line 351 "/home/jens/Source/shotwell/src/SortedList.vala"
		if (!(_tmp48_ < _tmp49_)) {
#line 351 "/home/jens/Source/shotwell/src/SortedList.vala"
			break;
#line 1780 "SortedList.c"
		}
#line 352 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp50_ = self->priv->list;
#line 352 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp51_ = offset;
#line 352 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp52_ = array;
#line 352 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp52__length1 = array_length1;
#line 352 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp53_ = offset;
#line 352 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp54_ = _tmp52_[_tmp53_];
#line 352 "/home/jens/Source/shotwell/src/SortedList.vala"
		gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp51_, _tmp54_);
#line 353 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp55_ = offset;
#line 353 "/home/jens/Source/shotwell/src/SortedList.vala"
		offset = _tmp55_ + 1;
#line 1800 "SortedList.c"
	}
#line 356 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = TRUE;
#line 356 "/home/jens/Source/shotwell/src/SortedList.vala"
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
#line 356 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 1808 "SortedList.c"
}


static void _sorted_list_merge_sort (SortedList* self, gpointer* array, int array_length1, gpointer* scratch, int scratch_length1, gint start_index, gint end_index) {
	gint _tmp0_;
	gint _tmp1_;
	gint count = 0;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint middle_index = 0;
	gint _tmp5_;
	gint _tmp6_;
	gpointer* _tmp7_;
	gint _tmp7__length1;
	gpointer* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	gint _tmp10_;
	gpointer* _tmp11_;
	gint _tmp11__length1;
	gpointer* _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_;
	gint _tmp14_;
	Comparator _tmp15_;
	void* _tmp15__target;
	gpointer* _tmp16_;
	gint _tmp16__length1;
	gint _tmp17_;
	gconstpointer _tmp18_;
	gpointer* _tmp19_;
	gint _tmp19__length1;
	gint _tmp20_;
	gconstpointer _tmp21_;
	gint64 _tmp22_;
#line 359 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_if_fail (IS_SORTED_LIST (self));
#line 360 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = start_index;
#line 360 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = end_index;
#line 360 "/home/jens/Source/shotwell/src/SortedList.vala"
	_vala_assert (_tmp0_ <= _tmp1_, "start_index <= end_index");
#line 362 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = end_index;
#line 362 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp3_ = start_index;
#line 362 "/home/jens/Source/shotwell/src/SortedList.vala"
	count = (_tmp2_ - _tmp3_) + 1;
#line 363 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp4_ = count;
#line 363 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp4_ <= 1) {
#line 364 "/home/jens/Source/shotwell/src/SortedList.vala"
		return;
#line 1865 "SortedList.c"
	}
#line 366 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp5_ = start_index;
#line 366 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp6_ = count;
#line 366 "/home/jens/Source/shotwell/src/SortedList.vala"
	middle_index = _tmp5_ + (_tmp6_ / 2);
#line 368 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp7_ = array;
#line 368 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp7__length1 = array_length1;
#line 368 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp8_ = scratch;
#line 368 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp8__length1 = scratch_length1;
#line 368 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp9_ = start_index;
#line 368 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp10_ = middle_index;
#line 368 "/home/jens/Source/shotwell/src/SortedList.vala"
	_sorted_list_merge_sort (self, _tmp7_, _tmp7__length1, _tmp8_, _tmp8__length1, _tmp9_, _tmp10_ - 1);
#line 369 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp11_ = array;
#line 369 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp11__length1 = array_length1;
#line 369 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp12_ = scratch;
#line 369 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp12__length1 = scratch_length1;
#line 369 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp13_ = middle_index;
#line 369 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp14_ = end_index;
#line 369 "/home/jens/Source/shotwell/src/SortedList.vala"
	_sorted_list_merge_sort (self, _tmp11_, _tmp11__length1, _tmp12_, _tmp12__length1, _tmp13_, _tmp14_);
#line 371 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp15_ = self->priv->cmp;
#line 371 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp15__target = self->priv->cmp_target;
#line 371 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp16_ = array;
#line 371 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp16__length1 = array_length1;
#line 371 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp17_ = middle_index;
#line 371 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp18_ = _tmp16_[_tmp17_ - 1];
#line 371 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp19_ = array;
#line 371 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp19__length1 = array_length1;
#line 371 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp20_ = middle_index;
#line 371 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp21_ = _tmp19_[_tmp20_];
#line 371 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp22_ = _tmp15_ (_tmp18_, _tmp21_, _tmp15__target);
#line 371 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp22_ > ((gint64) 0)) {
#line 1925 "SortedList.c"
		gpointer* _tmp23_;
		gint _tmp23__length1;
		gpointer* _tmp24_;
		gint _tmp24__length1;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
#line 372 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp23_ = array;
#line 372 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp23__length1 = array_length1;
#line 372 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp24_ = scratch;
#line 372 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp24__length1 = scratch_length1;
#line 372 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp25_ = start_index;
#line 372 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp26_ = middle_index;
#line 372 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp27_ = end_index;
#line 372 "/home/jens/Source/shotwell/src/SortedList.vala"
		sorted_list_merge (self, _tmp23_, _tmp23__length1, _tmp24_, _tmp24__length1, _tmp25_, _tmp26_, _tmp27_);
#line 1949 "SortedList.c"
	}
}


static void sorted_list_merge (SortedList* self, gpointer* array, int array_length1, gpointer* scratch, int scratch_length1, gint start_index, gint middle_index, gint end_index) {
	gint _tmp0_;
	gint _tmp1_;
	gint count = 0;
	gint _tmp2_;
	gint _tmp3_;
	gint left_start = 0;
	gint _tmp4_;
	gint left_end = 0;
	gint _tmp5_;
	gint right_start = 0;
	gint _tmp6_;
	gint right_end = 0;
	gint _tmp7_;
	gpointer* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	gint scratch_index = 0;
	gint _tmp57_;
	gint _tmp58_;
#line 375 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_if_fail (IS_SORTED_LIST (self));
#line 376 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = start_index;
#line 376 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = end_index;
#line 376 "/home/jens/Source/shotwell/src/SortedList.vala"
	_vala_assert (_tmp0_ < _tmp1_, "start_index < end_index");
#line 378 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = end_index;
#line 378 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp3_ = start_index;
#line 378 "/home/jens/Source/shotwell/src/SortedList.vala"
	count = (_tmp2_ - _tmp3_) + 1;
#line 379 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp4_ = start_index;
#line 379 "/home/jens/Source/shotwell/src/SortedList.vala"
	left_start = _tmp4_;
#line 380 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp5_ = middle_index;
#line 380 "/home/jens/Source/shotwell/src/SortedList.vala"
	left_end = _tmp5_ - 1;
#line 381 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp6_ = middle_index;
#line 381 "/home/jens/Source/shotwell/src/SortedList.vala"
	right_start = _tmp6_;
#line 382 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp7_ = end_index;
#line 382 "/home/jens/Source/shotwell/src/SortedList.vala"
	right_end = _tmp7_;
#line 384 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp8_ = scratch;
#line 384 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp8__length1 = scratch_length1;
#line 384 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp9_ = count;
#line 384 "/home/jens/Source/shotwell/src/SortedList.vala"
	_vala_assert (_tmp8__length1 >= _tmp9_, "scratch.length >= count");
#line 385 "/home/jens/Source/shotwell/src/SortedList.vala"
	scratch_index = 0;
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
	while (TRUE) {
#line 2016 "SortedList.c"
		gboolean _tmp10_ = FALSE;
		gint _tmp11_;
		gint _tmp12_;
		gpointer left = NULL;
		gpointer* _tmp15_;
		gint _tmp15__length1;
		gint _tmp16_;
		gconstpointer _tmp17_;
		gpointer _tmp18_;
		gpointer right = NULL;
		gpointer* _tmp19_;
		gint _tmp19__length1;
		gint _tmp20_;
		gconstpointer _tmp21_;
		gpointer _tmp22_;
		Comparator _tmp23_;
		void* _tmp23__target;
		gconstpointer _tmp24_;
		gconstpointer _tmp25_;
		gint64 _tmp26_;
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp11_ = left_start;
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp12_ = left_end;
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
		if (_tmp11_ <= _tmp12_) {
#line 2043 "SortedList.c"
			gint _tmp13_;
			gint _tmp14_;
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp13_ = right_start;
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp14_ = right_end;
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp10_ = _tmp13_ <= _tmp14_;
#line 2052 "SortedList.c"
		} else {
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp10_ = FALSE;
#line 2056 "SortedList.c"
		}
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
		if (!_tmp10_) {
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
			break;
#line 2062 "SortedList.c"
		}
#line 388 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp15_ = array;
#line 388 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp15__length1 = array_length1;
#line 388 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp16_ = left_start;
#line 388 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp17_ = _tmp15_[_tmp16_];
#line 388 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp18_ = ((_tmp17_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp17_) : ((gpointer) _tmp17_);
#line 388 "/home/jens/Source/shotwell/src/SortedList.vala"
		left = _tmp18_;
#line 389 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp19_ = array;
#line 389 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp19__length1 = array_length1;
#line 389 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp20_ = right_start;
#line 389 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp21_ = _tmp19_[_tmp20_];
#line 389 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp22_ = ((_tmp21_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp21_) : ((gpointer) _tmp21_);
#line 389 "/home/jens/Source/shotwell/src/SortedList.vala"
		right = _tmp22_;
#line 391 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp23_ = self->priv->cmp;
#line 391 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp23__target = self->priv->cmp_target;
#line 391 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp24_ = left;
#line 391 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp25_ = right;
#line 391 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp26_ = _tmp23_ (_tmp24_, _tmp25_, _tmp23__target);
#line 391 "/home/jens/Source/shotwell/src/SortedList.vala"
		if (_tmp26_ <= ((gint64) 0)) {
#line 2100 "SortedList.c"
			gpointer* _tmp27_;
			gint _tmp27__length1;
			gint _tmp28_;
			gconstpointer _tmp29_;
			gpointer _tmp30_;
			gpointer _tmp31_;
			gint _tmp32_;
#line 392 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp27_ = scratch;
#line 392 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp27__length1 = scratch_length1;
#line 392 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp28_ = scratch_index;
#line 392 "/home/jens/Source/shotwell/src/SortedList.vala"
			scratch_index = _tmp28_ + 1;
#line 392 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp29_ = left;
#line 392 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp30_ = ((_tmp29_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp29_) : ((gpointer) _tmp29_);
#line 392 "/home/jens/Source/shotwell/src/SortedList.vala"
			((_tmp27_[_tmp28_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp27_[_tmp28_] = (self->priv->g_destroy_func (_tmp27_[_tmp28_]), NULL));
#line 392 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp27_[_tmp28_] = _tmp30_;
#line 392 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp31_ = _tmp27_[_tmp28_];
#line 393 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp32_ = left_start;
#line 393 "/home/jens/Source/shotwell/src/SortedList.vala"
			left_start = _tmp32_ + 1;
#line 2130 "SortedList.c"
		} else {
			gpointer* _tmp33_;
			gint _tmp33__length1;
			gint _tmp34_;
			gconstpointer _tmp35_;
			gpointer _tmp36_;
			gpointer _tmp37_;
			gint _tmp38_;
#line 395 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp33_ = scratch;
#line 395 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp33__length1 = scratch_length1;
#line 395 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp34_ = scratch_index;
#line 395 "/home/jens/Source/shotwell/src/SortedList.vala"
			scratch_index = _tmp34_ + 1;
#line 395 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp35_ = right;
#line 395 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp36_ = ((_tmp35_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp35_) : ((gpointer) _tmp35_);
#line 395 "/home/jens/Source/shotwell/src/SortedList.vala"
			((_tmp33_[_tmp34_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp33_[_tmp34_] = (self->priv->g_destroy_func (_tmp33_[_tmp34_]), NULL));
#line 395 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp33_[_tmp34_] = _tmp36_;
#line 395 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp37_ = _tmp33_[_tmp34_];
#line 396 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp38_ = right_start;
#line 396 "/home/jens/Source/shotwell/src/SortedList.vala"
			right_start = _tmp38_ + 1;
#line 2161 "SortedList.c"
		}
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
		((right == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (right = (self->priv->g_destroy_func (right), NULL));
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
		((left == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (left = (self->priv->g_destroy_func (left), NULL));
#line 2167 "SortedList.c"
	}
#line 400 "/home/jens/Source/shotwell/src/SortedList.vala"
	while (TRUE) {
#line 2171 "SortedList.c"
		gint _tmp39_;
		gint _tmp40_;
		gpointer* _tmp41_;
		gint _tmp41__length1;
		gint _tmp42_;
		gpointer* _tmp43_;
		gint _tmp43__length1;
		gint _tmp44_;
		gconstpointer _tmp45_;
		gpointer _tmp46_;
		gpointer _tmp47_;
#line 400 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp39_ = left_start;
#line 400 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp40_ = left_end;
#line 400 "/home/jens/Source/shotwell/src/SortedList.vala"
		if (!(_tmp39_ <= _tmp40_)) {
#line 400 "/home/jens/Source/shotwell/src/SortedList.vala"
			break;
#line 2191 "SortedList.c"
		}
#line 401 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp41_ = scratch;
#line 401 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp41__length1 = scratch_length1;
#line 401 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp42_ = scratch_index;
#line 401 "/home/jens/Source/shotwell/src/SortedList.vala"
		scratch_index = _tmp42_ + 1;
#line 401 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp43_ = array;
#line 401 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp43__length1 = array_length1;
#line 401 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp44_ = left_start;
#line 401 "/home/jens/Source/shotwell/src/SortedList.vala"
		left_start = _tmp44_ + 1;
#line 401 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp45_ = _tmp43_[_tmp44_];
#line 401 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp46_ = ((_tmp45_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp45_) : ((gpointer) _tmp45_);
#line 401 "/home/jens/Source/shotwell/src/SortedList.vala"
		((_tmp41_[_tmp42_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp41_[_tmp42_] = (self->priv->g_destroy_func (_tmp41_[_tmp42_]), NULL));
#line 401 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp41_[_tmp42_] = _tmp46_;
#line 401 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp47_ = _tmp41_[_tmp42_];
#line 2219 "SortedList.c"
	}
#line 403 "/home/jens/Source/shotwell/src/SortedList.vala"
	while (TRUE) {
#line 2223 "SortedList.c"
		gint _tmp48_;
		gint _tmp49_;
		gpointer* _tmp50_;
		gint _tmp50__length1;
		gint _tmp51_;
		gpointer* _tmp52_;
		gint _tmp52__length1;
		gint _tmp53_;
		gconstpointer _tmp54_;
		gpointer _tmp55_;
		gpointer _tmp56_;
#line 403 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp48_ = right_start;
#line 403 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp49_ = right_end;
#line 403 "/home/jens/Source/shotwell/src/SortedList.vala"
		if (!(_tmp48_ <= _tmp49_)) {
#line 403 "/home/jens/Source/shotwell/src/SortedList.vala"
			break;
#line 2243 "SortedList.c"
		}
#line 404 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp50_ = scratch;
#line 404 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp50__length1 = scratch_length1;
#line 404 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp51_ = scratch_index;
#line 404 "/home/jens/Source/shotwell/src/SortedList.vala"
		scratch_index = _tmp51_ + 1;
#line 404 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp52_ = array;
#line 404 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp52__length1 = array_length1;
#line 404 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp53_ = right_start;
#line 404 "/home/jens/Source/shotwell/src/SortedList.vala"
		right_start = _tmp53_ + 1;
#line 404 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp54_ = _tmp52_[_tmp53_];
#line 404 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp55_ = ((_tmp54_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp54_) : ((gpointer) _tmp54_);
#line 404 "/home/jens/Source/shotwell/src/SortedList.vala"
		((_tmp50_[_tmp51_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp50_[_tmp51_] = (self->priv->g_destroy_func (_tmp50_[_tmp51_]), NULL));
#line 404 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp50_[_tmp51_] = _tmp55_;
#line 404 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp56_ = _tmp50_[_tmp51_];
#line 2271 "SortedList.c"
	}
#line 406 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp57_ = scratch_index;
#line 406 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp58_ = count;
#line 406 "/home/jens/Source/shotwell/src/SortedList.vala"
	_vala_assert (_tmp57_ == _tmp58_, "scratch_index == count");
#line 408 "/home/jens/Source/shotwell/src/SortedList.vala"
	scratch_index = 0;
#line 2281 "SortedList.c"
	{
		gint list_index = 0;
		gint _tmp59_;
#line 409 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp59_ = start_index;
#line 409 "/home/jens/Source/shotwell/src/SortedList.vala"
		list_index = _tmp59_;
#line 2289 "SortedList.c"
		{
			gboolean _tmp60_ = FALSE;
#line 409 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp60_ = TRUE;
#line 409 "/home/jens/Source/shotwell/src/SortedList.vala"
			while (TRUE) {
#line 2296 "SortedList.c"
				gint _tmp62_;
				gint _tmp63_;
				gpointer* _tmp64_;
				gint _tmp64__length1;
				gint _tmp65_;
				gpointer* _tmp66_;
				gint _tmp66__length1;
				gint _tmp67_;
				gconstpointer _tmp68_;
				gpointer _tmp69_;
				gpointer _tmp70_;
#line 409 "/home/jens/Source/shotwell/src/SortedList.vala"
				if (!_tmp60_) {
#line 2310 "SortedList.c"
					gint _tmp61_;
#line 409 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp61_ = list_index;
#line 409 "/home/jens/Source/shotwell/src/SortedList.vala"
					list_index = _tmp61_ + 1;
#line 2316 "SortedList.c"
				}
#line 409 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp60_ = FALSE;
#line 409 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp62_ = list_index;
#line 409 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp63_ = end_index;
#line 409 "/home/jens/Source/shotwell/src/SortedList.vala"
				if (!(_tmp62_ <= _tmp63_)) {
#line 409 "/home/jens/Source/shotwell/src/SortedList.vala"
					break;
#line 2328 "SortedList.c"
				}
#line 410 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp64_ = array;
#line 410 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp64__length1 = array_length1;
#line 410 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp65_ = list_index;
#line 410 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp66_ = scratch;
#line 410 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp66__length1 = scratch_length1;
#line 410 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp67_ = scratch_index;
#line 410 "/home/jens/Source/shotwell/src/SortedList.vala"
				scratch_index = _tmp67_ + 1;
#line 410 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp68_ = _tmp66_[_tmp67_];
#line 410 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp69_ = ((_tmp68_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp68_) : ((gpointer) _tmp68_);
#line 410 "/home/jens/Source/shotwell/src/SortedList.vala"
				((_tmp64_[_tmp65_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp64_[_tmp65_] = (self->priv->g_destroy_func (_tmp64_[_tmp65_]), NULL));
#line 410 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp64_[_tmp65_] = _tmp69_;
#line 410 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp70_ = _tmp64_[_tmp65_];
#line 2354 "SortedList.c"
			}
		}
	}
}


static GType sorted_list_real_get_element_type (GeeTraversable* base) {
	GType result;
	SortedList* self;
#line 19 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 19 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = self->priv->g_type;
#line 19 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 2370 "SortedList.c"
}


static gboolean sorted_list_real_get_read_only (GeeCollection* base) {
	gboolean result;
	SortedList* self;
	GeeArrayList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 23 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 23 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 23 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_abstract_collection_get_read_only (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 23 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = _tmp1_;
#line 23 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 23 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 2392 "SortedList.c"
}


static gboolean sorted_list_real_get_is_empty (GeeCollection* base) {
	gboolean result;
	SortedList* self;
	GeeArrayList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 116 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 117 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 117 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 117 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = _tmp1_;
#line 117 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 117 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 2414 "SortedList.c"
}


static gint sorted_list_real_get_size (GeeCollection* base) {
	gint result;
	SortedList* self;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 134 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 134 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 134 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 134 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = _tmp1_;
#line 134 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 134 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 2436 "SortedList.c"
}


static GeeCollection* sorted_list_real_get_read_only_view (GeeCollection* base) {
	GeeCollection* result;
	SortedList* self;
	GeeArrayList* _tmp0_;
	GeeBidirList* _tmp1_;
	GeeBidirList* _tmp2_;
#line 199 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 200 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 200 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_abstract_bidir_list_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirList));
#line 200 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = _tmp1_;
#line 200 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
#line 200 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 2458 "SortedList.c"
}


GeeList* sorted_list_get_read_only_view_as_list (SortedList* self) {
	GeeList* result;
	GeeArrayList* _tmp0_;
	GeeBidirList* _tmp1_;
	GeeBidirList* _tmp2_;
#line 205 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), NULL);
#line 206 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 206 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_abstract_bidir_list_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirList));
#line 206 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = _tmp1_;
#line 206 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_LIST, GeeList);
#line 206 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 2479 "SortedList.c"
}


static void sorted_list_class_init (SortedListClass * klass) {
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	sorted_list_parent_class = g_type_class_peek_parent (klass);
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_type_class_add_private (klass, sizeof (SortedListPrivate));
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_sorted_list_get_property;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_sorted_list_set_property;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	G_OBJECT_CLASS (klass)->finalize = sorted_list_finalize;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_ELEMENT_TYPE_PROPERTY, g_param_spec_gtype ("element-type", "element-type", "element-type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_READ_ONLY_PROPERTY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_IS_EMPTY_PROPERTY, g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_SIZE_PROPERTY, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_READ_ONLY_VIEW_PROPERTY, g_param_spec_object ("read-only-view", "read-only-view", "read-only-view", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_READ_ONLY_VIEW_AS_LIST_PROPERTY, g_param_spec_object ("read-only-view-as-list", "read-only-view-as-list", "read-only-view-as-list", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2512 "SortedList.c"
}


static GType sorted_list_gee_traversable_get_g_type (SortedList* self) {
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self->priv->g_type;
#line 2519 "SortedList.c"
}


static GBoxedCopyFunc sorted_list_gee_traversable_get_g_dup_func (SortedList* self) {
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self->priv->g_dup_func;
#line 2526 "SortedList.c"
}


static GDestroyNotify sorted_list_gee_traversable_get_g_destroy_func (SortedList* self) {
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self->priv->g_destroy_func;
#line 2533 "SortedList.c"
}


static void sorted_list_gee_traversable_interface_init (GeeTraversableIface * iface) {
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	sorted_list_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->foreach = (gboolean (*) (GeeTraversable *, GeeForallFunc, void*)) sorted_list_real_foreach;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_g_type = (GType (*) (GeeTraversable *)) sorted_list_gee_traversable_get_g_type;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeTraversable *)) sorted_list_gee_traversable_get_g_dup_func;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeTraversable *)) sorted_list_gee_traversable_get_g_destroy_func;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_element_type = sorted_list_real_get_element_type;
#line 2550 "SortedList.c"
}


static GType sorted_list_gee_iterable_get_g_type (SortedList* self) {
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self->priv->g_type;
#line 2557 "SortedList.c"
}


static GBoxedCopyFunc sorted_list_gee_iterable_get_g_dup_func (SortedList* self) {
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self->priv->g_dup_func;
#line 2564 "SortedList.c"
}


static GDestroyNotify sorted_list_gee_iterable_get_g_destroy_func (SortedList* self) {
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self->priv->g_destroy_func;
#line 2571 "SortedList.c"
}


static void sorted_list_gee_iterable_interface_init (GeeIterableIface * iface) {
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	sorted_list_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->iterator = (GeeIterator* (*) (GeeIterable *)) sorted_list_real_iterator;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_g_type = (GType (*) (GeeIterable *)) sorted_list_gee_iterable_get_g_type;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeIterable *)) sorted_list_gee_iterable_get_g_dup_func;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeIterable *)) sorted_list_gee_iterable_get_g_destroy_func;
#line 2586 "SortedList.c"
}


static GType sorted_list_gee_collection_get_g_type (SortedList* self) {
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self->priv->g_type;
#line 2593 "SortedList.c"
}


static GBoxedCopyFunc sorted_list_gee_collection_get_g_dup_func (SortedList* self) {
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self->priv->g_dup_func;
#line 2600 "SortedList.c"
}


static GDestroyNotify sorted_list_gee_collection_get_g_destroy_func (SortedList* self) {
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self->priv->g_destroy_func;
#line 2607 "SortedList.c"
}


static void sorted_list_gee_collection_interface_init (GeeCollectionIface * iface) {
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	sorted_list_gee_collection_parent_iface = g_type_interface_peek_parent (iface);
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->add = (gboolean (*) (GeeCollection *, gconstpointer)) sorted_list_real_add;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->add_all = (gboolean (*) (GeeCollection *, GeeCollection*)) sorted_list_real_add_all;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->clear = (void (*) (GeeCollection *)) sorted_list_real_clear;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->contains = (gboolean (*) (GeeCollection *, gconstpointer)) sorted_list_real_contains;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->contains_all = (gboolean (*) (GeeCollection *, GeeCollection*)) sorted_list_real_contains_all;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->remove = (gboolean (*) (GeeCollection *, gconstpointer)) sorted_list_real_remove;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->remove_all = (gboolean (*) (GeeCollection *, GeeCollection*)) sorted_list_real_remove_all;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->retain_all = (gboolean (*) (GeeCollection *, GeeCollection*)) sorted_list_real_retain_all;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->to_array = (gpointer* (*) (GeeCollection *, int*)) sorted_list_real_to_array;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_g_type = (GType (*) (GeeCollection *)) sorted_list_gee_collection_get_g_type;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeCollection *)) sorted_list_gee_collection_get_g_dup_func;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeCollection *)) sorted_list_gee_collection_get_g_destroy_func;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_read_only = sorted_list_real_get_read_only;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_is_empty = sorted_list_real_get_is_empty;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_size = sorted_list_real_get_size;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_read_only_view = sorted_list_real_get_read_only_view;
#line 2646 "SortedList.c"
}


static void sorted_list_instance_init (SortedList * self) {
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	self->priv = SORTED_LIST_GET_PRIVATE (self);
#line 2653 "SortedList.c"
}


static void sorted_list_finalize (GObject * obj) {
	SortedList * self;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SORTED_LIST, SortedList);
#line 10 "/home/jens/Source/shotwell/src/SortedList.vala"
	_g_object_unref0 (self->priv->list);
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	G_OBJECT_CLASS (sorted_list_parent_class)->finalize (obj);
#line 2665 "SortedList.c"
}


GType sorted_list_get_type (void) {
	static volatile gsize sorted_list_type_id__volatile = 0;
	if (g_once_init_enter (&sorted_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SortedListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sorted_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SortedList), 0, (GInstanceInitFunc) sorted_list_instance_init, NULL };
		static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) sorted_list_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) sorted_list_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_collection_info = { (GInterfaceInitFunc) sorted_list_gee_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType sorted_list_type_id;
		sorted_list_type_id = g_type_register_static (G_TYPE_OBJECT, "SortedList", &g_define_type_info, 0);
		g_type_add_interface_static (sorted_list_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
		g_type_add_interface_static (sorted_list_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_type_add_interface_static (sorted_list_type_id, GEE_TYPE_COLLECTION, &gee_collection_info);
		g_once_init_leave (&sorted_list_type_id__volatile, sorted_list_type_id);
	}
	return sorted_list_type_id__volatile;
}


static void _vala_sorted_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SortedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SORTED_LIST, SortedList);
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	switch (property_id) {
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		case SORTED_LIST_ELEMENT_TYPE_PROPERTY:
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		g_value_set_gtype (value, gee_traversable_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_TRAVERSABLE, GeeTraversable)));
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		case SORTED_LIST_READ_ONLY_PROPERTY:
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		g_value_set_boolean (value, gee_collection_get_read_only (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection)));
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		case SORTED_LIST_IS_EMPTY_PROPERTY:
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		g_value_set_boolean (value, gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection)));
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		case SORTED_LIST_SIZE_PROPERTY:
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		g_value_set_int (value, gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection)));
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		case SORTED_LIST_READ_ONLY_VIEW_PROPERTY:
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		g_value_take_object (value, gee_collection_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection)));
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		case SORTED_LIST_READ_ONLY_VIEW_AS_LIST_PROPERTY:
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		g_value_take_object (value, sorted_list_get_read_only_view_as_list (self));
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 2728 "SortedList.c"
		default:
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 2734 "SortedList.c"
	}
}


static void _vala_sorted_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SortedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SORTED_LIST, SortedList);
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
	switch (property_id) {
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		case SORTED_LIST_G_TYPE:
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		self->priv->g_type = g_value_get_gtype (value);
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		case SORTED_LIST_G_DUP_FUNC:
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		self->priv->g_dup_func = g_value_get_pointer (value);
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		case SORTED_LIST_G_DESTROY_FUNC:
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		self->priv->g_destroy_func = g_value_get_pointer (value);
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 2762 "SortedList.c"
		default:
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 9 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 2768 "SortedList.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



