/*
 *  Copyright (C) 2015 Freescale Semiconductor, Inc
 *  Peng Fan <Peng.Fan@freescale.com>
 *
 * SPDX-License-Identifier:     GPL-2.0+
 */
#ifndef __PFUZE3000_PMIC_H_
#define __PFUZE3000_PMIC_H_

/* PFUZE3000 registers */
enum {
	PFUZE3000_DEVICEID	= 0x00,

	PFUZE3000_REVID		= 0x03,
	PFUZE3000_FABID		= 0x04,
	PFUZE3000_INTSTAT0	= 0x05,
	PFUZE3000_INTMASK0	= 0x06,
	PFUZE3000_INTSENSE0	= 0x07,
	PFUZE3000_INTSTAT1	= 0x08,
	PFUZE3000_INTMASK1	= 0x09,
	PFUZE3000_INTSENSE1	= 0x0A,

	PFUZE3000_INTSTAT3	= 0x0E,
	PFUZE3000_INTMASK3	= 0x0F,
	PFUZE3000_INTSENSE3	= 0x10,
	PFUZE3000_INTSTAT4	= 0x11,
	PFUZE3000_INTMASK4	= 0x12,
	PFUZE3000_INTSENSE4	= 0x13,

	PFUZE3000_COINCTL	= 0x1A,
	PFUZE3000_PWRCTL	= 0x1B,
	PFUZE3000_MEMA		= 0x1C,
	PFUZE3000_MEMB		= 0x1D,
	PFUZE3000_MEMC		= 0x1E,
	PFUZE3000_MEMD		= 0x1F,

	PFUZE3000_SW1AVOLT	= 0x20,
	PFUZE3000_SW1ASTBY	= 0x21,
	PFUZE3000_SW1AOFF	= 0x22,
	PFUZE3000_SW1AMODE	= 0x23,
	PFUZE3000_SW1ACONF	= 0x24,

	PFUZE3000_SW1BVOLT	= 0x2E,
	PFUZE3000_SW1BSTBY	= 0x2F,
	PFUZE3000_SW1BOFF	= 0x30,
	PFUZE3000_SW1BMODE	= 0x31,
	PFUZE3000_SW1BCONF	= 0x32,

	PFUZE3000_SW2VOLT	= 0x35,
	PFUZE3000_SW2STBY	= 0x36,
	PFUZE3000_SW2OFF	= 0x37,
	PFUZE3000_SW2MODE	= 0x38,
	PFUZE3000_SW2CONF	= 0x39,

	PFUZE3000_SW3VOLT	= 0x3C,
	PFUZE3000_SW3STBY	= 0x3D,
	PFUZE3000_SW3OFF	= 0x3E,
	PFUZE3000_SW3MODE	= 0x3F,
	PFUZE3000_SW3CONF	= 0x40,

	PFUZE3000_SWBSTCTL	= 0x66,

	PFUZE3000_LDOGCTL	= 0x69,
	PFUZE3000_VREFDDRCTL	= 0x6A,
	PFUZE3000_VSNVSCTL	= 0x6B,
	PFUZE3000_VLDO1CTL	= 0x6C,
	PFUZE3000_VLDO2CTL	= 0x6D,
	PFUZE3000_VCC_SDCTL	= 0x6E,
	PFUZE3000_V33CTL	= 0x6F,
	PFUZE3000_VLDO3CTL	= 0x70,
	PFUZE3000_VLD4CTL	= 0x71,

	PMIC_NUM_OF_REGS	= 0x7F,
};

int power_pfuze3000_init(unsigned char bus);

#endif
