/*
 * fpu/fpu_x86_asm.h - Extra Definitions for the X86 assembly FPU core
 *
 * Copyright (c) 2001-2004 Milan Jurik of ARAnyM dev team (see AUTHORS)
 * 
 * Inspired by Christian Bauer's Basilisk II
 *
 * This file is part of the ARAnyM project which builds a new and powerful
 * TOS/FreeMiNT compatible virtual machine running on almost any hardware.
 *
 * MC68881/68040 fpu emulation
 *
 * Original UAE FPU, copyright 1996 Herman ten Brugge
 * Rewrite for x86, copyright 1999-2001 Lauri Pesonen
 * New framework, copyright 2000-2001 Gwenole Beauchesne
 * Adapted for JIT compilation (c) Bernd Meyer, 2000-2001
 *
 * ARAnyM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * ARAnyM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ARAnyM; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#define DEFINE_X86_MACRO(name, value) \
  asm(".local " #name "\n\t" #name " = " #value)

DEFINE_X86_MACRO(BSUN, 0x00008000);
DEFINE_X86_MACRO(SNAN, 0x00004000);
DEFINE_X86_MACRO(OPERR, 0x00002000);
DEFINE_X86_MACRO(OVFL, 0x00001000);
DEFINE_X86_MACRO(UNFL, 0x00000800);
DEFINE_X86_MACRO(DZ, 0x00000400);
DEFINE_X86_MACRO(INEX2, 0x00000200);
DEFINE_X86_MACRO(INEX1, 0x00000100);
DEFINE_X86_MACRO(ACCR_IOP, 0x80);
DEFINE_X86_MACRO(ACCR_OVFL, 0x40);
DEFINE_X86_MACRO(ACCR_UNFL, 0x20);
DEFINE_X86_MACRO(ACCR_DZ, 0x10);
DEFINE_X86_MACRO(ACCR_INEX, 0x08);
DEFINE_X86_MACRO(ROUND_CONTROL_MASK, 0x30);
DEFINE_X86_MACRO(ROUND_TO_NEAREST, 0);
DEFINE_X86_MACRO(ROUND_TO_ZERO, 0x10);
DEFINE_X86_MACRO(ROUND_TO_NEGATIVE_INFINITY, 0x20);
DEFINE_X86_MACRO(ROUND_TO_POSITIVE_INFINITY, 0x30);
DEFINE_X86_MACRO(PRECISION_CONTROL_MASK, 0xC0);
DEFINE_X86_MACRO(PRECISION_CONTROL_EXTENDED, 0);
DEFINE_X86_MACRO(PRECISION_CONTROL_DOUBLE, 0x80);
DEFINE_X86_MACRO(PRECISION_CONTROL_SINGLE, 0x40);
DEFINE_X86_MACRO(PRECISION_CONTROL_UNDEFINED, 0xC0);
DEFINE_X86_MACRO(CW_RESET, 0x0040);
DEFINE_X86_MACRO(CW_FINIT, 0x037F);
DEFINE_X86_MACRO(SW_RESET, 0x0000);
DEFINE_X86_MACRO(SW_FINIT, 0x0000);
DEFINE_X86_MACRO(TW_RESET, 0x5555);
DEFINE_X86_MACRO(TW_FINIT, 0x0FFF);
DEFINE_X86_MACRO(CW_X, 0x1000);
DEFINE_X86_MACRO(CW_RC_ZERO, 0x0C00);
DEFINE_X86_MACRO(CW_RC_UP, 0x0800);
DEFINE_X86_MACRO(CW_RC_DOWN, 0x0400);
DEFINE_X86_MACRO(CW_RC_NEAR, 0x0000);
DEFINE_X86_MACRO(CW_PC_EXTENDED, 0x0300);
DEFINE_X86_MACRO(CW_PC_DOUBLE, 0x0200);
DEFINE_X86_MACRO(CW_PC_RESERVED, 0x0100);
DEFINE_X86_MACRO(CW_PC_SINGLE, 0x0000);
DEFINE_X86_MACRO(CW_PM, 0x0020);
DEFINE_X86_MACRO(CW_UM, 0x0010);
DEFINE_X86_MACRO(CW_OM, 0x0008);
DEFINE_X86_MACRO(CW_ZM, 0x0004);
DEFINE_X86_MACRO(CW_DM, 0x0002);
DEFINE_X86_MACRO(CW_IM, 0x0001);
DEFINE_X86_MACRO(SW_B, 0x8000);
DEFINE_X86_MACRO(SW_C3, 0x4000);
DEFINE_X86_MACRO(SW_TOP_7, 0x3800);
DEFINE_X86_MACRO(SW_TOP_6, 0x3000);
DEFINE_X86_MACRO(SW_TOP_5, 0x2800);
DEFINE_X86_MACRO(SW_TOP_4, 0x2000);
DEFINE_X86_MACRO(SW_TOP_3, 0x1800);
DEFINE_X86_MACRO(SW_TOP_2, 0x1000);
DEFINE_X86_MACRO(SW_TOP_1, 0x0800);
DEFINE_X86_MACRO(SW_TOP_0, 0x0000);
DEFINE_X86_MACRO(SW_C2, 0x0400);
DEFINE_X86_MACRO(SW_C1, 0x0200);
DEFINE_X86_MACRO(SW_C0, 0x0100);
DEFINE_X86_MACRO(SW_ES, 0x0080);
DEFINE_X86_MACRO(SW_SF, 0x0040);
DEFINE_X86_MACRO(SW_PE, 0x0020);
DEFINE_X86_MACRO(SW_UE, 0x0010);
DEFINE_X86_MACRO(SW_OE, 0x0008);
DEFINE_X86_MACRO(SW_ZE, 0x0004);
DEFINE_X86_MACRO(SW_DE, 0x0002);
DEFINE_X86_MACRO(SW_IE, 0x0001);
DEFINE_X86_MACRO(X86_ROUNDING_MODE, 0x0C00);
DEFINE_X86_MACRO(X86_ROUNDING_PRECISION, 0x0300);

#undef DEFINE_X86_MACRO
