/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.impl;

import com.google.gwt.logging.impl.LoggerImpl;
import com.google.gwt.logging.impl.LoggerWithExposedConstructor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggerImplRegular
implements LoggerImpl {
    private List<Handler> handlers = new ArrayList<Handler>();
    private Level level = null;
    private String name;
    private Logger parent;
    private boolean useParentHandlers = true;

    public void addHandler(Handler handler) {
        this.handlers.add(handler);
    }

    public void config(String msg) {
        this.log(Level.CONFIG, msg);
    }

    public void fine(String msg) {
        this.log(Level.FINE, msg);
    }

    public void finer(String msg) {
        this.log(Level.FINER, msg);
    }

    public void finest(String msg) {
        this.log(Level.FINEST, msg);
    }

    public Handler[] getHandlers() {
        if (this.handlers.size() > 0) {
            return this.handlers.toArray(new Handler[this.handlers.size()]);
        }
        return null;
    }

    public Level getLevel() {
        if (this.level != null) {
            return this.level;
        }
        return this.getParent().getLevel();
    }

    public Logger getLoggerHelper(String name) {
        LogManager manager = LogManager.getLogManager();
        Logger logger = manager.getLogger(name);
        if (logger == null) {
            LoggerWithExposedConstructor newLogger = new LoggerWithExposedConstructor(name);
            manager.addLogger(newLogger);
            return newLogger;
        }
        return logger;
    }

    public String getName() {
        return this.name;
    }

    public Logger getParent() {
        return this.parent;
    }

    public boolean getUseParentHandlers() {
        return this.useParentHandlers;
    }

    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public boolean isLoggable(Level messageLevel) {
        return this.getLevel().intValue() <= messageLevel.intValue();
    }

    public void log(Level level, String msg) {
        this.log(level, msg, null);
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            LogRecord record = new LogRecord(level, msg);
            record.setThrown(thrown);
            record.setLoggerName(this.getName());
            this.log(record);
        }
    }

    public void log(LogRecord record) {
        if (this.isLoggable(record.getLevel())) {
            for (Handler h : this.handlers) {
                h.publish(record);
            }
            if (this.useParentHandlers && this.parent != null) {
                this.parent.log(record);
            }
        }
    }

    public void removeHandler(Handler handler) {
        this.handlers.remove(handler);
    }

    public void setLevel(Level newLevel) {
        this.level = newLevel;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setParent(Logger newParent) {
        if (newParent != null) {
            this.parent = newParent;
        }
    }

    public void setUseParentHandlers(boolean newUseParentHandlers) {
        this.useParentHandlers = newUseParentHandlers;
    }

    public void severe(String msg) {
        this.log(Level.SEVERE, msg);
    }

    public void warning(String msg) {
        this.log(Level.WARNING, msg);
    }
}

