/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;

public class EnvironmentVariableCredentialsProvider
implements AWSCredentialsProvider {
    private static final String ACCESS_KEY_ENV_VAR = "AWS_ACCESS_KEY_ID";
    private static final String SECRET_KEY_ENV_VAR = "AWS_SECRET_KEY";

    @Override
    public AWSCredentials getCredentials() {
        if (System.getenv(ACCESS_KEY_ENV_VAR) != null && System.getenv(SECRET_KEY_ENV_VAR) != null) {
            return new BasicAWSCredentials(System.getenv(ACCESS_KEY_ENV_VAR), System.getenv(SECRET_KEY_ENV_VAR));
        }
        throw new AmazonClientException("Unable to load AWS credentials from environment variables (AWS_ACCESS_KEY_ID and AWS_SECRET_KEY)");
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

