/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public class TiffProfileDNG
extends TiffProfile {
    public static final int CFA = 32803;
    public static final int LINEAR_RAW = 34892;
    private boolean notDNG;
    private boolean photoInterpOK;
    private boolean orientationSeen;
    private boolean dngVersionSeen;
    private boolean uniqueCameraModelSeen;
    private boolean asShotNeutralSeen;
    private boolean asShotWhiteXYSeen;

    public TiffProfileDNG() {
        this._profileText = "DNG 1.0.0.0 (September 2004)";
        this.notDNG = false;
        this.photoInterpOK = false;
        this.orientationSeen = false;
        this.dngVersionSeen = false;
        this.uniqueCameraModelSeen = false;
    }

    @Override
    public boolean satisfiesThisProfile(IFD iFD) {
        int n;
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        int n2 = nisoImageMetadata.getColorSpace();
        if (n2 != 32803 && n2 != 34892) {
            return false;
        }
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (nArray != null) {
            n = nArray[0];
            if (n < 8 || n > 32) {
                return false;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (n == nArray[i]) continue;
                return false;
            }
        }
        if (n2 == 32803 && (tiffIFD.getCFAPlaneColor() == null || tiffIFD.getCFARepeatPatternDim() == null || tiffIFD.getCFAPattern() == null)) {
            return false;
        }
        if (nisoImageMetadata.getOrientation() == -1) {
            return false;
        }
        n = nisoImageMetadata.getCompressionScheme();
        return n == -1 || n == 1 || n == 7;
    }
}

