/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.connection;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.remote.connection.UserTerminatedException;
import com.nvidia.cuda.ide.remote.internal.connection.Activator;
import com.nvidia.cuda.ide.remote.internal.connection.StdoutListener;
import com.nvidia.cuda.ide.remote.internal.connection.StreamMonitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.shells.IHostShellOutputListener;
import org.eclipse.rse.services.shells.IShellService;

public final class RemoteShellProcess
implements IProcess,
IStreamsProxy {
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final StreamMonitor errorListener;
    private final ILaunch launch;
    private final String name;
    private final StdoutListener outputListener;
    private boolean terminatedByUser = false;

    public RemoteShellProcess(IShellService shellService, String name, String command, ILaunch launch, IProgressMonitor monitor) throws IOException, SystemMessageException {
        this.name = name;
        this.launch = launch;
        this.outputListener = new StdoutListener(shellService, monitor);
        this.errorListener = new StreamMonitor();
        this.outputListener.getShell().getStandardErrorReader().addOutputListener((IHostShellOutputListener)this.errorListener);
        this.outputListener.run(command);
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    protected synchronized void done() {
        if (this.done.compareAndSet(false, true)) {
            DebugPlugin plugin;
            if (this.outputListener.isActive()) {
                this.outputListener.exit();
            }
            if ((plugin = DebugPlugin.getDefault()) != null) {
                plugin.fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 8)});
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (IDebugTarget.class.equals((Object)adapter)) {
            return null;
        }
        if (Activator.TRACE_REMOTE_LAUNCH) {
            System.out.printf("[RemoteShellProcess::getAdapter] %s\n", adapter);
        }
        return null;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public IStreamMonitor getErrorStreamMonitor() {
        return this.errorListener;
    }

    public synchronized int getExitValue() throws DebugException {
        Integer errorCode;
        if (!this.isTerminated()) {
            throw new DebugException(CoreUtil.errorStatus((String)"Application is still running", (Object[])new Object[0]));
        }
        if (!this.done.get()) {
            this.done();
        }
        if ((errorCode = this.outputListener.getErrorCode()) == null) {
            throw new DebugException(CoreUtil.errorStatus((String)"Application terminated prematurely", (Object[])new Object[0]));
        }
        return errorCode;
    }

    public String getLabel() {
        return this.name;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public synchronized IStreamMonitor getOutputStreamMonitor() {
        return this.outputListener.getStreamMonitor();
    }

    public IStreamsProxy getStreamsProxy() {
        return this;
    }

    public boolean isTerminated() {
        if (this.done.get()) {
            return true;
        }
        if (!this.outputListener.isActive()) {
            this.done();
        }
        return false;
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public synchronized void terminate() throws DebugException {
        this.terminatedByUser = true;
        this.done();
    }

    public synchronized int waitFor(IProgressMonitor monitor) throws CoreException, UserTerminatedException {
        try {
            while (!this.isTerminated()) {
                if (monitor.isCanceled()) {
                    this.terminate();
                    continue;
                }
                this.wait(100L);
            }
            if (this.terminatedByUser) {
                throw new UserTerminatedException();
            }
            return this.getExitValue();
        }
        catch (InterruptedException e) {
            throw CoreUtil.coreException((Throwable)e);
        }
    }

    public void write(String input) throws IOException {
        this.outputListener.ignore(input);
        this.outputListener.getShell().writeToShell(input);
    }
}

