/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.ui;

import com.nvidia.common.ui.Messages;
import com.nvidia.common.util.SWTUtil;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.ui.connection.toolkits.IToolkitProperties;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class RemoteToolkitSingleGpuProperty
implements IToolkitProperties {
    private Button btnPreemption;

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 4, 1));
        group.setText(Messages.title_preemption);
        CLabel lblPreemptionWarn = new CLabel((Composite)group, 0);
        lblPreemptionWarn.setText(Messages.warning_preeption_is_beta);
        lblPreemptionWarn.setImage(SWTUtil.getImage((String)"IMG_OBJS_WARN_TSK"));
        this.btnPreemption = new Button((Composite)group, 32);
        this.btnPreemption.setText(Messages.checkbox_preemption);
        Label lblPreemptionDesc = new Label((Composite)group, 64);
        GridData gd_lblPreemptionDesc = new GridData(4, 0x1000000, true, false, 1, 1);
        String message = String.valueOf(Messages.message_preemption_is_awesome) + "\n" + Messages.warning_preemption_requires35;
        Point extent = SWTUtil.getTextExtent((Drawable)lblPreemptionDesc, (String)message);
        if (extent.x > 75) {
            gd_lblPreemptionDesc.widthHint = 60;
            gd_lblPreemptionDesc.heightHint = extent.y * 11 / 5;
        }
        lblPreemptionDesc.setLayoutData((Object)gd_lblPreemptionDesc);
        lblPreemptionDesc.setText(message);
    }

    public void bind(DataBindingContext context, IObservableValue connection) {
        if (this.btnPreemption != null) {
            context.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this.btnPreemption), (IObservableValue)new PreemptionObservable(connection));
        }
    }

    private final class PreemptionObservable
    extends ComputedValue {
        private final IObservableValue connection;

        public PreemptionObservable(IObservableValue connection) {
            this.connection = connection;
        }

        protected Object calculate() {
            IRemoteConnection conn = (IRemoteConnection)this.connection.getValue();
            if (conn != null && conn.getProperty("preemption", false)) {
                return true;
            }
            return false;
        }

        protected void doSetValue(Object value) {
            IRemoteConnection conn = (IRemoteConnection)this.connection.getValue();
            if (conn != null) {
                conn.setProperty("preemption", (Object)Boolean.TRUE.equals(value));
            }
        }
    }
}

