/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.wizard;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.DataBindingUtil;
import com.nvidia.common.wizards.WizardContext;
import com.nvidia.cuda.ide.remote.internal.Messages;
import com.nvidia.cuda.ide.remote.internal.wizard.AbstractRemoteDebugSession;
import com.nvidia.cuda.ide.remote.internal.wizard.RemoteLaunchMainWizardPage;
import com.nvidia.cuda.ide.remote.internal.wizard.RemoteRunDebugSession;
import com.nvidia.cuda.ide.remote.ui.launch.ICudaRemoteDebugConstants;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public final class RemoteDebugMainWizardPage
extends RemoteLaunchMainWizardPage {
    private Button[] transferButtons;
    private Spinner port;

    public RemoteDebugMainWizardPage(WizardContext context) {
        super(context, Messages.RemoteDebug_wizardPage_debug_title, Messages.RemoteDebug_wizardPage_debug_message, Messages.RemoteDebug_wizardPage_debug_description);
    }

    private String[] getUploadModeLabels() {
        return new String[]{Messages.RemoteDebug_mode_uploadExe, Messages.RemoteDebug_mode_downloadExe, Messages.RemoteDebug_mode_noTransferExe};
    }

    @Override
    protected void createAdditionalRemoteSystemControls(Composite composite) {
        Label lblPort = new Label(composite, 0);
        lblPort.setText(Messages.RemoteDebug_label_cudagdbserver_port);
        this.port = new Spinner(composite, 2048);
        this.port.setMaximum(65535);
    }

    @Override
    protected void setupBindings(WizardContext context, DataBindingContext bindingContext) {
        IObservableValue uploadProperty = context.observeProperty(RemoteRunDebugSession.PROPERTY_TRANSFER_EXECUTABLE);
        RadioButtonsEnumObservable btns = new RadioButtonsEnumObservable(ICudaRemoteDebugConstants.ExecutableTransferMode.class, this.transferButtons);
        bindingContext.bindValue(btns, uploadProperty);
        IObservableValue connection = context.observeProperty(AbstractRemoteDebugSession.PROPERTY_REMOTE_CONNECTION);
        bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this.port), context.observeProperty(AbstractRemoteDebugSession.PROPERTY_REMOTE_PORT));
        DataBindingUtil.bindEnablement((DataBindingContext)bindingContext, (IObservableValue)connection, (Control[])new Control[]{this.port});
    }

    @Override
    protected void createTopControls(Composite root) {
        this.transferButtons = this.createUploadModeButtons(root, this.getUploadModeLabels());
    }

    private Button[] createUploadModeButtons(Composite composite, String ... buttonLabels) {
        Composite buttonsPane = new Composite(composite, 0);
        GridLayout gl_composite_2 = new GridLayout(buttonLabels.length, true);
        gl_composite_2.marginWidth = 0;
        gl_composite_2.marginHeight = 0;
        buttonsPane.setLayout((Layout)gl_composite_2);
        buttonsPane.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        int i = 0;
        Button[] buttons = new Button[buttonLabels.length];
        String[] stringArray = buttonLabels;
        int n = buttonLabels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            Button btnUpload = new Button(buttonsPane, 16);
            btnUpload.setText(label);
            btnUpload.setLayoutData((Object)new GridData(768));
            buttons[i++] = btnUpload;
            ++n2;
        }
        new Label(buttonsPane, 0).setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, buttonLabels.length, 1));
        return buttons;
    }

    @Override
    protected IStatus validate() {
        IStatus status = super.validate();
        if (status.getSeverity() == 4) {
            return status;
        }
        ICudaRemoteDebugConstants.ExecutableTransferMode mode = (ICudaRemoteDebugConstants.ExecutableTransferMode)((Object)this.context.getProperty(RemoteRunDebugSession.PROPERTY_TRANSFER_EXECUTABLE));
        if (mode == null) {
            return CoreUtil.errorStatus((String)Messages.RemoteDebug_firstWizardPage_error_modeNotSelected, (Object[])new Object[0]);
        }
        if (mode != ICudaRemoteDebugConstants.ExecutableTransferMode.Download && (status = CoreUtil.moreSevere((IStatus)status, (IStatus)this.localPathField.validate())).getSeverity() == 4) {
            return status;
        }
        return CoreUtil.moreSevere((IStatus)status, (IStatus)this.remotePathField.validate(mode != ICudaRemoteDebugConstants.ExecutableTransferMode.Upload));
    }

    private static final class RadioButtonsEnumObservable<T extends Enum<T>>
    extends ComputedValue {
        private final T[] constants;
        private final IObservableValue[] values;

        private RadioButtonsEnumObservable(Class<T> enumType, Button ... radioButtons) {
            super(enumType);
            this.constants = (Enum[])enumType.getEnumConstants();
            this.values = new IObservableValue[radioButtons.length];
            int i = 0;
            while (i < radioButtons.length) {
                this.values[i] = SWTObservables.observeSelection((Control)radioButtons[i]);
                ++i;
            }
        }

        protected Object calculate() {
            Object result = null;
            int i = 0;
            while (i < this.constants.length && i < this.values.length) {
                if (Boolean.TRUE.equals(this.values[i].getValue())) {
                    result = this.constants[i];
                }
                ++i;
            }
            return result;
        }

        protected void doSetValue(Object value) {
            int i = 0;
            while (i < this.values.length) {
                this.values[i].setValue((Object)(value != null && value.equals(this.constants[i]) ? 1 : 0));
                ++i;
            }
        }
    }
}

