/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.ui.launch;

import com.nvidia.common.util.SWTUtil;
import com.nvidia.cuda.ide.remote.internal.Activator;
import com.nvidia.cuda.ide.remote.ui.launch.ICudaRemoteDebugConstants;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.CMainTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.widgets.Control;

public final class LocalExecutableTab
extends CMainTab {
    private boolean downloadExe = false;

    public void initializeFrom(ILaunchConfiguration config) {
        ICudaRemoteDebugConstants.ExecutableTransferMode mode = ICudaRemoteDebugConstants.ExecutableTransferMode.fromLaunchConfiguration(config);
        if (mode == ICudaRemoteDebugConstants.ExecutableTransferMode.Download) {
            this.downloadExe = true;
            SWTUtil.setEnabled((Control)this.getControl(), (boolean)false);
            this.fProgText.setText("");
            this.fProjText.setText("");
        } else {
            this.downloadExe = false;
            SWTUtil.setEnabled((Control)this.getControl(), (boolean)true);
            super.initializeFrom(config);
            try {
                if (config.getAttribute("com.nvidia.cuda.ide.remote.temporaryExe", false)) {
                    this.fProjText.setText("");
                    this.fProgText.setText("");
                }
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
        }
    }

    public String getErrorMessage() {
        return this.downloadExe ? null : super.getErrorMessage();
    }

    public boolean canSave() {
        return this.downloadExe || super.canSave();
    }

    public boolean isValid(ILaunchConfiguration config) {
        boolean bl = this.downloadExe = ICudaRemoteDebugConstants.ExecutableTransferMode.Download == ICudaRemoteDebugConstants.ExecutableTransferMode.fromLaunchConfiguration(config);
        return this.downloadExe || super.isValid(config);
    }

    protected void updateBuildConfigCombo(String selectedConfigID) {
        if (!this.downloadExe) {
            super.updateBuildConfigCombo(selectedConfigID);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        ICudaRemoteDebugConstants.ExecutableTransferMode mode = ICudaRemoteDebugConstants.ExecutableTransferMode.fromLaunchConfiguration((ILaunchConfiguration)config);
        if (mode != ICudaRemoteDebugConstants.ExecutableTransferMode.Download) {
            super.performApply(config);
        }
    }

    public String getName() {
        return "Local";
    }

    public String getId() {
        return "com.nsight.debug.remote.maintab";
    }
}

