/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.ui.launch;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.SWTUtil;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnectionsService;
import com.nvidia.cuda.ide.remote.connection.UnsupportedRemoteOperationException;
import com.nvidia.cuda.ide.remote.internal.Activator;
import org.eclipse.cdt.internal.launch.remote.Messages;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.cdt.launch.remote.RSEHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class RemoteLaunchHelper {
    private static final String PROP_UPLOAD_SAME_FILE = "upload.same.file";

    public static IPath downloadExecutable(IRemoteConnection connection, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        String remotePath = RemoteLaunchHelper.getRemoteFilePath(configuration);
        IFile file = connection.getFile(remotePath, monitor);
        return file != null ? file.getLocation() : null;
    }

    public static void fail(Exception e, String format, Object ... args) throws CoreException {
        throw CoreUtil.coreException((Throwable)e, (String)format, (Object[])args);
    }

    public static void fail(String format, Object ... args) throws CoreException {
        RemoteLaunchHelper.fail(null, format, args);
    }

    public static void fillServerProperties(ILaunchConfiguration config, IPath localExePath, boolean tempExe) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", true);
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", RSEHelper.getRemoteHostname((ILaunchConfiguration)config));
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_PORT, "2345"));
        if (tempExe) {
            wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", localExePath.toOSString());
            wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", localExePath.removeLastSegments(1).toOSString());
        }
        wc.setAttribute("com.nvidia.cuda.ide.remote.temporaryExe", tempExe);
        wc.doSave();
    }

    public static String getAttributeChecked(ILaunchConfiguration config, String attributeName, String humanReadableName) throws CoreException {
        if (!config.hasAttribute(attributeName)) {
            RemoteLaunchHelper.fail("%s is not set", humanReadableName);
        }
        return config.getAttribute(attributeName, null);
    }

    public static IRemoteConnection getRemoteConnection(ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        String connectionName = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_CONNECTION, null);
        return IRemoteConnectionsService.GetConnection.getConnection((String)connectionName, (IProgressMonitor)monitor);
    }

    private static String getRemoteFilePath(ILaunchConfiguration config) throws CoreException {
        return RemoteLaunchHelper.getAttributeChecked(config, IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, "Remote executable name");
    }

    public static void initRSE(IProgressMonitor monitor) throws CoreException {
        if (!RSECorePlugin.isInitComplete((int)1)) {
            monitor.subTask(Messages.RemoteRunLaunchDelegate_10);
            try {
                RSECorePlugin.waitForInitCompletion((int)1);
            }
            catch (InterruptedException e) {
                throw new CoreException((IStatus)new Status(4, "com.nvidia.cuda.ide.remote", 0, e.getLocalizedMessage(), (Throwable)e));
            }
        }
    }

    private static int potentialSameFilePrompt() {
        int returnCode;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (!store.isDefault(PROP_UPLOAD_SAME_FILE)) {
            return store.getInt(PROP_UPLOAD_SAME_FILE);
        }
        if (Display.getCurrent() == null) {
            final int[] result = new int[]{1};
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    result[0] = RemoteLaunchHelper.potentialSameFilePrompt();
                }
            });
            return result[0];
        }
        Shell shell = SWTUtil.getShell();
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(shell, "Nsight Remote Debug", null, "Local and remote file paths may be pointing to a same file. This may cause the Nsight to upload the file onto itself and corrupt the executable file.\n\nDo you still want to upload the executable to the remote system?", 4, new String[]{"Cancel debugging", "Do not upload executable", "Upload executable"}, 1, null, false);
        int result = dialog.open();
        int n = result == 257 ? 1 : (returnCode = result == 258 ? 0 : 7);
        if (dialog.getToggleState()) {
            store.setValue(PROP_UPLOAD_SAME_FILE, returnCode);
        }
        return returnCode;
    }

    public static IPath uploadExecutable(IRemoteConnection connection, ILaunchConfiguration config, IPath exePath, IProgressMonitor monitor) throws CoreException {
        String exePathString = exePath.toString();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)String.format("Preparing %s", exePathString), (int)25);
        String remotePath = RemoteLaunchHelper.getRemoteFilePath(config);
        try {
            if (connection.isSameFile(exePath.toString(), remotePath, (IProgressMonitor)subMonitor.newChild(10))) {
                switch (RemoteLaunchHelper.potentialSameFilePrompt()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        Path path = new Path(remotePath);
                        return path;
                    }
                    default: {
                        return null;
                    }
                }
            }
            try {
                connection.upload(exePathString, remotePath, true, (IProgressMonitor)subMonitor.newChild(10));
                connection.setPermissions(remotePath, 73, true, (IProgressMonitor)subMonitor.newChild(5));
            }
            catch (UnsupportedRemoteOperationException e) {
                throw CoreUtil.coreException((Throwable)e, (String)"File \"%s\" upload failed", (Object[])new Object[]{exePathString});
            }
            subMonitor.done();
            Path path = new Path(remotePath);
            return path;
        }
        finally {
            subMonitor.done();
        }
    }

    private RemoteLaunchHelper() {
    }
}

