/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.editor;

import com.nvidia.cuda.ide.editor.Activator;
import com.nvidia.cuda.ide.language.ast.KernelCallExpression;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.IBackgroundHighlight;
import org.eclipse.cdt.ui.text.ILineBackgroundPainter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class KernelInvocationBackground
implements IBackgroundHighlight,
IPropertyChangeListener {
    private static final String KEY = "kernelInvocationBkground";
    public static final String PREF_COLOR = "semanticHighlighting.kernelInvocationBkground.color";
    public static final String PREF_ENABLED = "semanticHighlighting.kernelInvocationBkground.enabled";
    private IDocument document;
    private ILineBackgroundPainter painter;
    private IPreferenceStore store;
    private boolean bkgroundEnabled;

    public List<Position> collectPositions(IASTTranslationUnit ast) {
        if (ast == null | !this.bkgroundEnabled) {
            return Collections.emptyList();
        }
        NamesVisitor visitor = new NamesVisitor(this.document);
        ast.accept((ASTVisitor)visitor);
        return visitor.getPositions();
    }

    public void install(IDocument document, ILineBackgroundPainter painter) {
        this.document = document;
        this.painter = painter;
        this.store = CUIPlugin.getDefault().getPreferenceStore();
        this.readPreferences();
        this.store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (PREF_COLOR.equals(event.getProperty()) || PREF_ENABLED.equals(event.getProperty())) {
            this.readPreferences();
            this.painter.refresh();
        }
    }

    private void readPreferences() {
        boolean enabled = this.store.getBoolean("semanticHighlighting.enabled");
        boolean bl = this.bkgroundEnabled = this.store.getBoolean(PREF_ENABLED) && enabled;
        if (this.bkgroundEnabled) {
            this.painter.setBackgroundColor(KEY, PreferenceConverter.getColor((IPreferenceStore)this.store, (String)PREF_COLOR));
        }
    }

    public void uninstall() {
        this.store.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    private static final class NamesVisitor
    extends ASTVisitor {
        private final IDocument doc;
        private final List<Position> positions = new LinkedList<Position>();

        public NamesVisitor(IDocument document) {
            this.doc = document;
            this.shouldVisitExpressions = true;
        }

        public int visit(IASTExpression expression) {
            if (expression instanceof KernelCallExpression) {
                this.addPosition((IASTNode)expression);
                return 1;
            }
            return 3;
        }

        private void addPosition(IASTNode node) {
            try {
                IASTFileLocation location = node.getFileLocation();
                int offset = this.doc.getLineOffset(location.getStartingLineNumber() - 1);
                int end = this.doc.getLineOffset(location.getEndingLineNumber()) - 1;
                TypedPosition position = new TypedPosition(offset, end - offset, KernelInvocationBackground.KEY);
                this.positions.add((Position)position);
            }
            catch (BadLocationException e) {
                Activator.log(e);
            }
        }

        public List<Position> getPositions() {
            return this.positions;
        }
    }
}

