/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import java.text.NumberFormat;

public class PowerFormatter {
    public static final String FORMAT_W = "W";
    public static final String FORMAT_KW = "kW";
    public static final String FORMAT_MW = "MW";
    public static final String FORMAT_GW = "GW";
    private String format = null;
    private long divisor = 1L;
    private static NumberFormat formatter = NumberFormat.getInstance();

    static {
        formatter.setMaximumFractionDigits(3);
    }

    public PowerFormatter() {
    }

    public PowerFormatter(long power) {
        this.initFormat(power);
    }

    public String format(double power) {
        return this.format(power, true);
    }

    public String format(double power, boolean group) {
        if (this.format == null) {
            this.initFormat((long)power);
        }
        formatter.setGroupingUsed(group);
        double fsize = power / (double)this.divisor;
        return String.valueOf(formatter.format(fsize)) + " " + this.format;
    }

    private void initFormat(long power) {
        if (power < 1000L) {
            this.format = FORMAT_W;
            this.divisor = 1L;
        } else if (power < 1000000L) {
            this.format = FORMAT_KW;
            this.divisor = 1000L;
        } else if (power < 1000000000L) {
            this.format = FORMAT_MW;
            this.divisor = 1000000L;
        } else {
            this.format = FORMAT_GW;
            this.divisor = 1000000000L;
        }
    }
}

