/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import com.nvidia.viper.activity.CuptiActivityBase;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.ICuptiActivity;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;

public class CuptiActivityAPI
extends CuptiActivityBase
implements ICuptiActivity {
    public int correlationId;
    public int processId;
    public int threadId;
    public int cbid;
    public long start;
    public long end;

    public CuptiActivityAPI() {
        this.kind = CuptiActivityKind.CUPTI_ACTIVITY_KIND_INVALID.getCode();
    }

    public CuptiActivityAPI(CuptiActivityKind kind, int correlationId, int processId, int threadId, int cbid, long start, long end) {
        this.kind = kind.getCode();
        this.correlationId = correlationId;
        this.processId = processId;
        this.threadId = threadId;
        this.cbid = cbid;
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return this.start > 0L && this.end > 0L && this.start <= this.end;
    }

    @Override
    public void appendToPDM(long hPdm) throws CuptiException {
        NativeCupti.cuptiPDMAppendActivity(hPdm, this);
    }
}

