/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import java.util.HashMap;
import java.util.Map;

public enum CuptiDeviceAttribute {
    CUPTI_DEVICE_ATTR_MAX_EVENT_ID(1),
    CUPTI_DEVICE_ATTR_MAX_EVENT_DOMAIN_ID(2),
    CUPTI_DEVICE_ATTR_GLOBAL_MEMORY_BANDWIDTH(3),
    CUPTI_DEVICE_ATTR_INSTRUCTION_PER_CYCLE(4),
    CUPTI_DEVICE_ATTR_INSTRUCTION_THROUGHPUT_SINGLE_PRECISION(5),
    CUPTI_DEVICE_ATTR_MAX_FRAME_BUFFERS(6),
    CUPTI_DEVICE_ATTR_PCIE_LINK_RATE(7),
    CUPTI_DEVICE_ATTR_PCIE_LINK_WIDTH(8),
    CUPTI_DEVICE_ATTR_PCIE_GEN(9),
    CUPTI_DEVICE_ATTR_DEVICE_CLASS(10),
    CUPTI_DEVICE_ATTR_FLOP_SP(11),
    CUPTI_DEVICE_ATTR_FLOP_DP(12),
    CUPTI_DEVICE_ATTR_MAX_L2_UNITS(13),
    CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_SHARED(14),
    CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_L1(15),
    CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_EQUAL(16),
    CUPTI_DEVICE_ATTR_FLOP_HP(17);

    private int code;
    private static Map<Integer, CuptiDeviceAttribute> codeMap;

    static {
        codeMap = new HashMap<Integer, CuptiDeviceAttribute>();
        CuptiDeviceAttribute[] cuptiDeviceAttributeArray = CuptiDeviceAttribute.values();
        int n = cuptiDeviceAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CuptiDeviceAttribute res = cuptiDeviceAttributeArray[n2];
            codeMap.put(res.getCode(), res);
            ++n2;
        }
    }

    private CuptiDeviceAttribute(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static CuptiDeviceAttribute valueOf(String string) {
        return Enum.valueOf(CuptiDeviceAttribute.class, string);
    }
}

