/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.MetricManager;
import com.nvidia.viper.activity.CuptiActivityFlag;
import com.nvidia.viper.activity.CuptiActivityMetric;
import com.nvidia.viper.analysis.AnalysisUtils;
import com.nvidia.viper.analysis.IAnalysis;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.TimelineIntervalKernel;
import java.util.List;
import java.util.Set;

public abstract class AnalysisBase
implements IAnalysis {
    protected static Metric getMetric(TimelineIntervalKernel kernel, String metricName) {
        Set<Metric> metrics = MetricManager.getMetrics(metricName);
        Metric metric = AnalysisUtils.getSingleIntersect(metrics, kernel.getAggregateMetrics());
        if (metric == null) {
            metric = AnalysisUtils.getSingleIntersect(metrics, kernel.getInstanceMetrics());
        }
        if (metric == null && metricName.equals("sm_efficiency_instance")) {
            return AnalysisBase.getMetric(kernel, "sm_efficiency");
        }
        return metric;
    }

    public static Number getAggregateMetricValue(TimelineIntervalKernel kernel, String metricName) {
        Metric metric = AnalysisBase.getMetric(kernel, metricName);
        return metric == null ? (Number)null : (Number)kernel.getAggregateMetricValue(metric);
    }

    protected Number deriveAggregateMetricValue(TimelineIntervalKernel kernel, String metricName, boolean update) {
        Metric metric = AnalysisBase.getMetric(kernel, metricName);
        if (metric == null) {
            return null;
        }
        return this.deriveAggregateMetricValue(kernel, metric, update);
    }

    protected Number deriveAggregateMetricValue(TimelineIntervalKernel kernel, Metric metric, boolean update) {
        List<CuptiActivityMetric> metrics = kernel.getInstanceMetricActivities(metric);
        if (metrics.isEmpty()) {
            return null;
        }
        Double val = null;
        if ("achieved_occupancy".equals(metric.getName())) {
            Double total = 0.0;
            for (CuptiActivityMetric activity : metrics) {
                total = total + (Double)activity.getValue();
            }
            val = total / (double)metrics.size();
            if (update) {
                kernel.setAggregateMetricActivity(metric, new CuptiActivityMetric(kernel.getPrimaryCorrelationId(), metric, metric.getValueKind(), val, CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_NONE));
            }
        }
        return val;
    }
}

