/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultKernelUnitBusy;
import com.nvidia.viper.analysis.KernelBoundsGraphicFactory;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class AnalysisResultKernelBounds
extends AnalysisResult {
    private static NumberFormat percentFormatter = NumberFormat.getPercentInstance();
    private final TimelineDevice device;
    private final TimelineIntervalKernel kernel;
    private final Bound bound;
    private final boolean isIssueSlotBound;
    private final double arithUtilization;
    private final double controlFlowUtilization;
    private final double loadStoreUtilization;
    private final double fuUtilization;
    private final AnalysisResultKernelUnitBusy.FunctionUnit fuBound;
    private final double memoryUtilization;
    private final MemBound memBound;

    static {
        percentFormatter.setMaximumFractionDigits(0);
        percentFormatter.setGroupingUsed(false);
    }

    public AnalysisResultKernelBounds(TimelineDevice device, TimelineIntervalKernel kernel, Bound bound, MemBound memBound, double arithUtilization, double controlFlowUtilization, double loadStoreUtilization, double memoryUtilization) {
        super(AnalysisDescriptor.KERNEL_BOUNDS);
        this.device = device;
        this.kernel = kernel;
        this.bound = bound;
        this.isIssueSlotBound = true;
        this.memBound = memBound;
        this.arithUtilization = arithUtilization;
        this.controlFlowUtilization = controlFlowUtilization;
        this.loadStoreUtilization = loadStoreUtilization;
        this.memoryUtilization = memoryUtilization;
        this.fuBound = null;
        this.fuUtilization = 0.0;
    }

    public AnalysisResultKernelBounds(TimelineDevice device, TimelineIntervalKernel kernel, Bound bound, AnalysisResultKernelUnitBusy.FunctionUnit fuBound, MemBound memBound, double fuUtilization, double memoryUtilization) {
        super(AnalysisDescriptor.KERNEL_BOUNDS);
        this.device = device;
        this.kernel = kernel;
        this.bound = bound;
        this.isIssueSlotBound = false;
        this.memBound = memBound;
        this.memoryUtilization = memoryUtilization;
        this.fuBound = fuBound;
        this.fuUtilization = fuUtilization;
        this.arithUtilization = 0.0;
        this.controlFlowUtilization = 0.0;
        this.loadStoreUtilization = 0.0;
    }

    @Override
    public String getLabel(ResultOutput otpt) {
        switch (this.bound) {
            case LATENCY: {
                return ViperMessages.KernelBounds_Latency_Label;
            }
            case COMPUTE: {
                return ViperMessages.KernelBounds_Compute_Label;
            }
            case MEMORY: {
                return ViperMessages.KernelBounds_Memory_Label;
            }
            case NONE: {
                return ViperMessages.KernelBounds_None_Label;
            }
            case BALANCED_COMPUTE_MEMORY: {
                return ViperMessages.KernelBounds_Balanced_Label;
            }
        }
        return super.getLabel(otpt);
    }

    @Override
    public String getDescription(ResultOutput otpt) {
        String desc = null;
        switch (this.bound) {
            case LATENCY: {
                desc = ViperMessages.KernelBounds_Latency_Desc;
                desc = desc.replace("%LATENCYTHRESHOLD%", percentFormatter.format(0.6));
                break;
            }
            case COMPUTE: {
                desc = ViperMessages.KernelBounds_Compute_Desc;
                break;
            }
            case MEMORY: {
                desc = ViperMessages.KernelBounds_MemorySystem_Desc;
                desc = this.memBound.isFuUnitBound() ? String.valueOf(desc) + " " + ViperMessages.KernelBounds_MemoryUnit_Desc : String.valueOf(desc) + " " + ViperMessages.KernelBounds_MemoryBandwidth_Desc;
                desc = desc.replace("%MEM%", this.memBound.toString());
                desc = desc.replace("%UNIT%", String.valueOf(this.memBound.toString().toLowerCase()) + "s");
                break;
            }
            case NONE: {
                desc = ViperMessages.KernelBounds_None_Desc;
                desc = desc.replace("%NOBOUNDTHRESHOLD%", percentFormatter.format(0.8));
                break;
            }
            default: {
                desc = ViperMessages.KernelBounds_Balanced_Desc;
            }
        }
        desc = desc.replace("%DEVICE%", "\"" + this.device.getName() + "\"");
        desc = desc.replace("%RLOC%", ResultOutput.REPORT.equals((Object)otpt) ? "below" : "at right");
        return desc;
    }

    public boolean isIssueSlotBound() {
        return this.isIssueSlotBound;
    }

    public Bound getBound() {
        return this.bound;
    }

    public MemBound getMemoryBound() {
        return this.memBound;
    }

    public double getMemoryUtilization() {
        return this.memoryUtilization;
    }

    public double getControlFlowUtilization() {
        return this.controlFlowUtilization;
    }

    public double getLoadStoreUtilization() {
        return this.loadStoreUtilization;
    }

    public double getArithUtilization() {
        return this.arithUtilization;
    }

    public double getFunctionUnitUtilization() {
        return this.fuUtilization;
    }

    public AnalysisResultKernelUnitBusy.FunctionUnit getFunctionUnitBound() {
        return this.fuBound;
    }

    @Override
    public List<TimelineIntervalPair> getAssociatedIntervals() {
        ArrayList<TimelineIntervalPair> pairs = new ArrayList<TimelineIntervalPair>(1);
        TimelineIntervalPair pair = new TimelineIntervalPair(this.kernel.getPrimaryTimeline(), this.kernel);
        pairs.add(pair);
        return pairs;
    }

    @Override
    public IAnalysisResultGraphicFactory getAnalysisResultFactory() {
        return new KernelBoundsGraphicFactory();
    }

    public static enum Bound {
        UNKNOWN,
        NONE,
        BALANCED_COMPUTE_MEMORY,
        COMPUTE,
        MEMORY,
        LATENCY;

    }

    public static enum MemBound {
        UNKNOWN,
        LDSTUNIT,
        TEXUNIT,
        L1SHARED,
        SHARED,
        L2,
        TEX,
        DRAM,
        SYSMEM;


        public boolean isFuUnitBound() {
            return LDSTUNIT.equals((Object)this) || TEXUNIT.equals((Object)this);
        }

        public String getLegendName() {
            return "(" + this.toString() + ")";
        }

        public String toString() {
            switch (this) {
                case LDSTUNIT: {
                    return "Load/Store Instruction Unit";
                }
                case TEXUNIT: {
                    return "Texture Instruction Unit";
                }
                case L1SHARED: {
                    return "L1/Shared";
                }
                case SHARED: {
                    return "Shared";
                }
                case L2: {
                    return "L2 Cache";
                }
                case TEX: {
                    return "Texture";
                }
                case DRAM: {
                    return "Device";
                }
                case SYSMEM: {
                    return "System";
                }
            }
            return "";
        }
    }
}

