/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.editor;

import com.nvidia.viper.TimeFormatter;
import com.nvidia.viper.analysis.AnalysisResultDivergentBranch;
import com.nvidia.viper.analysis.AnalysisResultInstructionExecution;
import com.nvidia.viper.analysis.AnalysisResultPCSampling;
import com.nvidia.viper.analysis.AnalysisResultSharedAccess;
import com.nvidia.viper.analysis.AnalysisResultSourceLevel;
import com.nvidia.viper.analysis.AnalysisResultUncoalescedGlobalMemory;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.SourceSassModel;
import com.nvidia.viper.model.TimelineIntervalKernel;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class SourceSassEditorInput
implements IEditorInput {
    private SourceSassModel sourceSassModel;
    private TimelineIntervalKernel kernelInterval;

    public SourceSassEditorInput(SourceSassModel sourceSassModel) {
        this.sourceSassModel = sourceSassModel;
        AnalysisResultSourceLevel result = sourceSassModel.getAnalysisResultSourceLevel();
        if (result != null) {
            this.kernelInterval = (TimelineIntervalKernel)result.getInterval();
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        String name;
        if (this.kernelInterval != null && (name = this.kernelInterval.getDisplayName()) != null) {
            int index = name.indexOf(40);
            if (index >= 0) {
                return name.substring(0, index);
            }
            return name;
        }
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        if (this.kernelInterval != null) {
            String name = this.kernelInterval.getDisplayName();
            AnalysisResultSourceLevel result = this.sourceSassModel.getAnalysisResultSourceLevel();
            String analysisName = "";
            if (result == null) {
                return null;
            }
            if (result instanceof AnalysisResultInstructionExecution) {
                analysisName = AnalysisStage.KERNEL_INSTANCE_INSTRUCTION_EXECUTION.getLabel();
            } else if (result instanceof AnalysisResultPCSampling) {
                analysisName = AnalysisStage.KERNEL_INSTANCE_PC_SAMPLING.getLabel();
            } else if (result instanceof AnalysisResultDivergentBranch) {
                analysisName = AnalysisStage.KERNEL_INSTANCE_DIVERGENT_BRANCH.getLabel();
            } else if (result instanceof AnalysisResultSharedAccess) {
                analysisName = AnalysisStage.KERNEL_INSTANCE_SHARED_ACCESS.getLabel();
            } else if (result instanceof AnalysisResultUncoalescedGlobalMemory) {
                analysisName = AnalysisStage.KERNEL_INSTANCE_UNCOALESCED_GLOBAL.getLabel();
            }
            if (name != null) {
                String startTime = new TimeFormatter().format(this.kernelInterval.getStart());
                return "The " + analysisName + " analysis for kernel " + name + ", started at " + startTime;
            }
        }
        return null;
    }

    public Session getSession() {
        if (this.sourceSassModel != null) {
            return this.sourceSassModel.getSession();
        }
        return null;
    }

    public AnalysisResultSourceLevel getAnalysisResultSourceLevel() {
        if (this.sourceSassModel != null) {
            return this.sourceSassModel.getAnalysisResultSourceLevel();
        }
        return null;
    }

    public SourceSassModel getSourceSassModel() {
        return this.sourceSassModel;
    }

    public TimelineIntervalKernel getKernelInterval() {
        return this.kernelInterval;
    }

    public void updateModel(SourceSassModel refModel) {
        this.sourceSassModel.update(refModel);
    }
}

