/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.fs;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.RegexIterator;
import com.nvidia.common.util.SingleArgumentFunction;
import com.nvidia.viper.EventManager;
import com.nvidia.viper.MetricManager;
import com.nvidia.viper.Viper;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.fs.IDevicesData;
import com.nvidia.viper.jni.CuptiEvent;
import com.nvidia.viper.jni.CuptiEventCategory;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.CuptiMetric;
import com.nvidia.viper.jni.CuptiMetricCategory;
import com.nvidia.viper.jni.NativeCupti;
import com.nvidia.viper.model.Event;
import com.nvidia.viper.model.EventCategory;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.MetricCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NvprofDeviceData
implements IDevicesData {
    public static final String NVPROF_FLAG = "--query-cuda-info";
    private static final Pattern DEVICE_STRING_FORMAT = Pattern.compile("^(\\d+)*/\\((.*)\\)$");
    private static final Pattern DEVICE_CC_STRING_FORMAT = Pattern.compile("^(\\d+)*/\\((.*)cc=(\\d+).(\\d+)\\)$");
    private static final Pattern EVENT_STRING_FORMAT = Pattern.compile("(\\d+)/(\\d+),");
    private static final Pattern METRIC_STRING_FORMAT = Pattern.compile("(\\d+),");
    private final Map<String, int[]> devices = new TreeMap<String, int[]>();
    private final Map<String, Collection<EventCategory>> eventCategories = new HashMap<String, Collection<EventCategory>>();
    private final Map<String, Collection<Event>> events = new HashMap<String, Collection<Event>>();
    private final Map<String, Collection<MetricCategory>> metricCategories = new HashMap<String, Collection<MetricCategory>>();
    private final Map<String, Map<String, Metric>> metrics = new HashMap<String, Map<String, Metric>>();
    private boolean turingOrOnwardFound = false;

    private static CuptiEventCategory getEventCategory(Collection<CuptiEvent> cuptiEvents, int domain, int id) {
        for (CuptiEvent cuptiEvent : cuptiEvents) {
            if (cuptiEvent.domain != domain || cuptiEvent.id != id) continue;
            return CuptiEventCategory.valueOf(cuptiEvent.category);
        }
        throw new IllegalStateException(String.format("Category for event %d/%d was not found", domain, id));
    }

    private static <R> R iterateCollectingInvalidInput(SingleArgumentFunction<R, String> function, Iterator<String> iterator, List<String> invalidOutput) throws ViperException {
        while (iterator.hasNext()) {
            String string = iterator.next();
            try {
                return (R)function.call((Object)string);
            }
            catch (IllegalArgumentException e) {
                ViperExceptionHandler.logError(e.getMessage(), null);
                invalidOutput.add(string);
            }
            catch (IllegalStateException e) {
                throw new ViperException(NvprofDeviceData.exceptionMessage(e.getMessage(), invalidOutput), e);
            }
        }
        throw new ViperException(NvprofDeviceData.exceptionMessage("Unable to parse nvprof output", invalidOutput));
    }

    private static String exceptionMessage(String message, List<String> droppedOutput) {
        if (droppedOutput.isEmpty()) {
            return message;
        }
        StringBuilder completeMessage = new StringBuilder(message);
        completeMessage.append("\n\nIgnored nvprof messages:");
        for (String dropped : droppedOutput) {
            completeMessage.append("\n").append(dropped);
        }
        return completeMessage.toString();
    }

    public NvprofDeviceData(String[] nvprofOutput) throws ViperException {
        nvprofOutput = this.mergeNvprofOutput(nvprofOutput);
        LinkedList<String> droppedOutput = new LinkedList<String>();
        Iterator<String> i = Arrays.asList(nvprofOutput).iterator();
        while (i.hasNext()) {
            final String type = NvprofDeviceData.iterateCollectingInvalidInput(new SingleArgumentFunction<String, String>(){

                public String call(String argument) {
                    return NvprofDeviceData.this.parseDevice(argument);
                }
            }, i, droppedOutput);
            if (this.turingOrOnwardFound) break;
            NvprofDeviceData.iterateCollectingInvalidInput(new SingleArgumentFunction<Object, String>(){

                public Object call(String argument) {
                    try {
                        NvprofDeviceData.this.parseEvents(type, argument);
                        return null;
                    }
                    catch (CuptiException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }, i, droppedOutput);
            NvprofDeviceData.iterateCollectingInvalidInput(new SingleArgumentFunction<Object, String>(){

                public Object call(String argument) {
                    try {
                        NvprofDeviceData.this.parseMetrics(type, argument);
                        return null;
                    }
                    catch (CuptiException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }, i, droppedOutput);
        }
        if (i.hasNext() && !this.turingOrOnwardFound) {
            StringBuilder builder = new StringBuilder("Trailing nvprof output:\n");
            while (i.hasNext()) {
                builder.append(i.next()).append("\n");
            }
            throw new ViperException(NvprofDeviceData.exceptionMessage(builder.toString(), droppedOutput));
        }
    }

    private String[] mergeNvprofOutput(String[] nvprofOutput) {
        ArrayList<String> mergedOutput = new ArrayList<String>();
        int index = 0;
        while (index < nvprofOutput.length) {
            if (!(DEVICE_CC_STRING_FORMAT.matcher(nvprofOutput[index]).matches() || DEVICE_STRING_FORMAT.matcher(nvprofOutput[index]).matches() || nvprofOutput[index].endsWith(",") || index >= nvprofOutput.length - 1)) {
                mergedOutput.add(nvprofOutput[index].concat(nvprofOutput[index + 1]));
                ++index;
            } else {
                mergedOutput.add(nvprofOutput[index]);
            }
            ++index;
        }
        return mergedOutput.toArray(new String[0]);
    }

    @Override
    public int[] getDeviceIds(String deviceType) {
        return this.devices.get(deviceType);
    }

    @Override
    public String[] getDeviceTypes() {
        Set<String> keys = this.devices.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    public Collection<EventCategory> getEventCategories(String deviceType) {
        return this.eventCategories.get(deviceType);
    }

    @Override
    public Collection<Event> getEvents(String deviceType) {
        return this.events.get(deviceType);
    }

    @Override
    public Metric getMetric(String deviceType, String metricName) {
        Map<String, Metric> allMetrics = this.metrics.get(deviceType);
        return allMetrics == null ? null : allMetrics.get(metricName);
    }

    private CuptiMetricCategory getMetricCategories(Collection<CuptiMetric> cuptiMetrics, int id) throws IllegalArgumentException {
        for (CuptiMetric cuptiMetric : cuptiMetrics) {
            if (cuptiMetric.id != id) continue;
            return CuptiMetricCategory.valueOf(cuptiMetric.category);
        }
        throw new IllegalStateException(String.format("Category for metric %d was not found", id));
    }

    @Override
    public Collection<MetricCategory> getMetricCategories(String deviceType) {
        return this.metricCategories.get(deviceType);
    }

    @Override
    public Collection<Metric> getMetrics(String deviceType) {
        Map<String, Metric> allMetrics = this.metrics.get(deviceType);
        return allMetrics == null ? null : allMetrics.values();
    }

    private String parseDevice(String string) {
        Matcher matcher = DEVICE_CC_STRING_FORMAT.matcher(string);
        if (!matcher.matches() && !(matcher = DEVICE_STRING_FORMAT.matcher(string)).matches()) {
            throw new IllegalArgumentException(String.format("Invalid device string: \"%s\"", string));
        }
        if (matcher.groupCount() >= 4) {
            int support;
            int ccMinor;
            int ccMajor = Integer.parseInt(matcher.group(3));
            if (Viper.isTuringAndOnward(ccMajor, ccMinor = Integer.parseInt(matcher.group(4)))) {
                this.turingOrOnwardFound = true;
            }
            if ((support = NativeCupti.checkSupportForComputeCapability(ccMajor, ccMinor)) == 0) {
                throw new IllegalStateException(String.format("Support for compute capability %d.%d is not available.", ccMajor, ccMinor));
            }
        }
        int id = Integer.valueOf(matcher.group(1));
        String type = String.format("[%d] %s", id, matcher.group(2).trim());
        int[] ids = this.devices.containsKey(type) ? this.devices.get(type) : new int[]{};
        this.devices.put(type, CoreUtil.append((int[])ids, (int[])new int[]{id}));
        return type;
    }

    private void parseEvents(String deviceType, String string) throws CuptiException {
        ArrayList<CuptiEvent> cuptiEvents = NativeCupti.cuptiGetEvents();
        HashSet<Event> deviceTypeEvents = new HashSet<Event>();
        HashMap<CuptiEventCategory, EventCategory> deviceTypeCategories = new HashMap<CuptiEventCategory, EventCategory>();
        for (String[] strings : new RegexIterator(EVENT_STRING_FORMAT, string)) {
            EventCategory category;
            int domain = Integer.valueOf(strings[0]);
            int id = Integer.valueOf(strings[1]);
            Event event = EventManager.getEvent(domain, id);
            deviceTypeEvents.add(event);
            CuptiEventCategory cuptiCategory = NvprofDeviceData.getEventCategory(cuptiEvents, domain, id);
            if (deviceTypeCategories.containsKey((Object)cuptiCategory)) {
                category = (EventCategory)deviceTypeCategories.get((Object)cuptiCategory);
            } else {
                category = new EventCategory(cuptiCategory);
                deviceTypeCategories.put(cuptiCategory, category);
            }
            category.addEvent(event);
        }
        this.events.put(deviceType, deviceTypeEvents);
        this.eventCategories.put(deviceType, deviceTypeCategories.values());
    }

    private void parseMetrics(String deviceType, String string) throws CuptiException {
        ArrayList<CuptiMetric> cuptiMetrics = NativeCupti.cuptiGetMetrics();
        HashMap<String, Metric> deviceTypeMetrics = new HashMap<String, Metric>();
        HashMap<CuptiMetricCategory, MetricCategory> categories = new HashMap<CuptiMetricCategory, MetricCategory>();
        for (String[] strings : new RegexIterator(METRIC_STRING_FORMAT, string)) {
            MetricCategory category;
            int id = Integer.valueOf(strings[0]);
            Metric metric = MetricManager.getMetric(id);
            if (metric == null) {
                throw new IllegalStateException(String.format("Metric %d not found", id));
            }
            deviceTypeMetrics.put(metric.getName(), metric);
            CuptiMetricCategory cuptiMetricCategory = this.getMetricCategories(cuptiMetrics, id);
            if (categories.containsKey((Object)cuptiMetricCategory)) {
                category = (MetricCategory)categories.get((Object)cuptiMetricCategory);
            } else {
                category = new MetricCategory(cuptiMetricCategory);
                categories.put(cuptiMetricCategory, category);
            }
            category.addMetric(metric);
        }
        this.metrics.put(deviceType, deviceTypeMetrics);
        this.metricCategories.put(deviceType, categories.values());
    }

    @Override
    public boolean isTuringOrOnwardFound() {
        return this.turingOrOnwardFound;
    }
}

