/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.report.util;

import com.nvidia.viper.report.util.IWTGraphicsObject;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class SwingGraphicsObject
implements IWTGraphicsObject {
    private static final int HEIGHT_PADDING = 2;
    protected Graphics2D g2d;
    protected GC gc;

    public static org.eclipse.swt.graphics.Color SwingToSWTColor(Color swingColor, GC gc) {
        org.eclipse.swt.graphics.Color swtColor = new org.eclipse.swt.graphics.Color(gc.getDevice(), swingColor.getRed(), swingColor.getGreen(), swingColor.getBlue());
        return swtColor;
    }

    public static Color SWTtoSwingColor(org.eclipse.swt.graphics.Color color) {
        Color swingColor = new Color(color.getRed(), color.getGreen(), color.getBlue());
        return swingColor;
    }

    public SwingGraphicsObject(Graphics2D g2d, GC gc) {
        this.g2d = g2d;
        this.gc = gc;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.g2d.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawRectangle(int x, int y, int width, int height) {
        this.g2d.drawRect(x, y, width, height);
    }

    @Override
    public void drawString(String text, int x, int y, boolean b) {
        Composite oldComposite = this.g2d.getComposite();
        if (b) {
            this.g2d.setComposite(AlphaComposite.SrcOver);
        }
        this.g2d.drawString(text, x, y + this.getFontHeight() - 2);
        if (b) {
            this.g2d.setComposite(oldComposite);
        }
    }

    @Override
    public void fillRectangle(int x, int y, int width, int height, org.eclipse.swt.graphics.Color color) {
        Color prevSWTColor = this.g2d.getColor();
        this.g2d.setColor(SwingGraphicsObject.SWTtoSwingColor(color));
        this.g2d.fillRect(x, y, width, height);
        this.g2d.setColor(prevSWTColor);
    }

    @Override
    public void fillRectangle(org.eclipse.swt.graphics.Rectangle clipping, org.eclipse.swt.graphics.Color color) {
        Color prevSWTColor = this.g2d.getColor();
        this.g2d.setColor(SwingGraphicsObject.SWTtoSwingColor(color));
        this.g2d.fillRect(clipping.x, clipping.y, clipping.width, clipping.height);
        this.g2d.setColor(prevSWTColor);
    }

    @Override
    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight, org.eclipse.swt.graphics.Color color) {
        Color prevSWTColor = this.g2d.getColor();
        this.g2d.setColor(SwingGraphicsObject.SWTtoSwingColor(color));
        this.g2d.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.g2d.setColor(prevSWTColor);
    }

    @Override
    public org.eclipse.swt.graphics.Color getBackground() {
        return SwingGraphicsObject.SwingToSWTColor(this.g2d.getBackground(), this.gc);
    }

    @Override
    public org.eclipse.swt.graphics.Color getColor(int SWTColorNum) {
        return this.gc.getDevice().getSystemColor(SWTColorNum);
    }

    @Override
    public int getFontHeight() {
        FontMetrics fm = this.g2d.getFontMetrics();
        return fm.getMaxAscent() + fm.getMaxDescent() + fm.getLeading() + 2;
    }

    @Override
    public org.eclipse.swt.graphics.Color getForeground() {
        Color swingColor = this.g2d.getColor();
        org.eclipse.swt.graphics.Color swtColor = SwingGraphicsObject.SwingToSWTColor(swingColor, this.gc);
        return swtColor;
    }

    @Override
    public void setBackground(org.eclipse.swt.graphics.Color color) {
        Color swingColor = SwingGraphicsObject.SWTtoSwingColor(color);
        this.g2d.setBackground(swingColor);
    }

    @Override
    public void setForeground(org.eclipse.swt.graphics.Color color) {
        Color swingColor = SwingGraphicsObject.SWTtoSwingColor(color);
        this.g2d.setColor(swingColor);
    }

    @Override
    public void setLineWidth(int i) {
        this.g2d.setStroke(new BasicStroke(i));
    }

    @Override
    public Point stringExtent(String text) {
        FontMetrics fmet = this.g2d.getFontMetrics();
        Rectangle2D r2d = fmet.getStringBounds(text, this.g2d);
        Rectangle rect = r2d.getBounds();
        Point point = new Point(rect.width, rect.height + 2);
        return point;
    }

    @Override
    public void drawImage(Image image, int x, int y) {
        this.gc.drawImage(image, x, y);
    }
}

