/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.StringUtils;
import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperImages;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.parts.VerticalRulerEditPart;
import com.nvidia.viper.ui.TimelineFigure;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.internal.ui.rulers.RulerFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class VerticalRulerFigure
extends RulerFigure {
    protected static final Color FG_COLOR = ColorConstants.black;
    protected static final Color BG_COLOR = ColorConstants.white;
    private static final int BORDER_WIDTH = 3;
    private static final int INSERT_LINE_WIDTH = 2;
    private static Image expandAllImage = ViperImages.get("icons/en/expand_all_timeline.png");
    private static Image expandImage = ViperImages.get("icons/en/expand_timeline.png");
    private static Image collapseImage = ViperImages.get("icons/en/collapse_timeline.png");
    private static Image leafTimelineImage = ViperImages.get("icons/en/leaf_timeline.png");
    private static Image includeImage = ViperImages.get("icons/en/include_timeline.png");
    private static Image excludeImage = ViperImages.get("icons/en/exclude_timeline.png");
    private List<LabelData> labels = Collections.emptyList();
    private Map<Timeline, LabelData> timelineLabelMap = new HashMap<Timeline, LabelData>();

    public VerticalRulerFigure() {
        super(false, 2);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension size = this.prefSize;
        if (size == null) {
            size = this.getSize();
        }
        return size;
    }

    public void setTimelines(List<Timeline> timelines, Font font) {
        this.labels = new LinkedList<LabelData>();
        for (Timeline tl : timelines) {
            LabelData label = new LabelData(this, font, tl);
            this.labels.add(label);
            this.timelineLabelMap.put(tl, label);
        }
    }

    public void setSelectedTimeline(Timeline selectedTimeline) {
        for (LabelData label : this.labels) {
            boolean bl = label.selected = label.timeline == selectedTimeline;
        }
    }

    public int setInsertLocation(VerticalRulerEditPart.InsertLocation insert) {
        LabelData label2;
        int insertY = -1;
        for (LabelData label2 : this.labels) {
            label2.insertMarker = 0;
        }
        if (insert != null && insert.timeline != null && (label2 = this.timelineLabelMap.get(insert.timeline)) != null) {
            if (insert.before) {
                label2.insertMarker = 1;
                insertY = label2.labelLoc.y;
            } else {
                List<Timeline> descendants = insert.timeline.getDescendants();
                Collections.reverse(descendants);
                descendants.add(insert.timeline);
                for (Timeline tl : descendants) {
                    if (!tl.isVisible()) continue;
                    LabelData dlabel = this.timelineLabelMap.get(tl);
                    if (dlabel == null) break;
                    dlabel.insertMarker = 2;
                    insertY = dlabel.labelLoc.y + dlabel.getHeight();
                    break;
                }
            }
        }
        return insertY;
    }

    public Rectangle getTimelineLabelBounds(Timeline timeline) {
        LabelData label = this.timelineLabelMap.get(timeline);
        if (label == null) {
            return null;
        }
        return label.getBounds(false);
    }

    public Timeline getTimelineAt(Point location) {
        for (LabelData label : this.labels) {
            Rectangle bounds = label.getBounds(false);
            if (bounds == null || !bounds.contains(location)) continue;
            return label.timeline;
        }
        return null;
    }

    public Timeline getTimelineExpandCollapseAt(Point location) {
        for (LabelData label : this.labels) {
            Rectangle bounds;
            if (!label.timeline.isContainer() || (bounds = label.getExpandCollapseImageBounds()) == null || !bounds.contains(location)) continue;
            return label.timeline;
        }
        return null;
    }

    public Timeline getTimelineFilterUnfilterAt(Point location) {
        for (LabelData label : this.labels) {
            Rectangle bounds;
            if (!label.timeline.getKind().isFilterable() || (bounds = label.getFilterImageBounds()) == null || !bounds.contains(location)) continue;
            return label.timeline;
        }
        return null;
    }

    public boolean isOverRightBorder(Point location) {
        Rectangle rect = this.getClientArea();
        if (rect.contains(location)) {
            rect.width -= 3;
            if (!rect.contains(location)) {
                return true;
            }
        }
        return false;
    }

    public void paintFigure(Graphics g) {
        Font font = this.getFont();
        Rectangle clip = g.getClip(new Rectangle());
        Rectangle clippedBounds = this.getClientArea();
        if (clip.x == 0) {
            clippedBounds.intersect(clip);
        }
        clippedBounds.width -= 3;
        if (clippedBounds.width <= 0) {
            return;
        }
        g.setForegroundColor(FG_COLOR);
        g.setBackgroundColor(BG_COLOR);
        g.fillRectangle(clippedBounds);
        int timelineY = 0;
        int startY = clippedBounds.y;
        int endY = startY + clippedBounds.height;
        for (LabelData label : this.labels) {
            label.setLocation(clippedBounds.x + this.textMargin, timelineY);
            int height = label.getHeight();
            if (timelineY + height >= startY && timelineY <= endY) {
                Point imageLoc;
                if (label.selected) {
                    g.setForegroundColor(ViperColors.TIMELINE_SELECTED_FONT_COLOR);
                    g.setBackgroundColor(ViperColors.TIMELINE_SELECTED_COLOR);
                } else {
                    g.setForegroundColor(FG_COLOR);
                    g.setBackgroundColor(label.timeline.getBackgroundColor());
                }
                Rectangle bounds = label.getBounds(false);
                if (bounds != null) {
                    bounds.intersect(clippedBounds);
                    g.fillRectangle(bounds);
                }
                Point textLoc = new Point(label.textLoc);
                textLoc.translate(clippedBounds.x + this.textMargin, timelineY);
                String boundedText = StringUtils.getBoundedText(label.timeline.getDisplayName(true), new Dimension(clippedBounds.width - textLoc.x, Integer.MAX_VALUE), font, 1);
                if (boundedText != null) {
                    g.drawText(boundedText, textLoc);
                }
                if (label.expandCollapseImage != null) {
                    imageLoc = new Point(label.expandCollapseImageLoc);
                    imageLoc.translate(clippedBounds.x + this.textMargin, timelineY);
                    g.drawImage(label.expandCollapseImage, imageLoc);
                }
                if (label.leafImage != null) {
                    imageLoc = new Point(label.leafImageLoc);
                    imageLoc.translate(clippedBounds.x + this.textMargin, timelineY);
                    g.drawImage(label.leafImage, imageLoc);
                }
                if (label.filterImage != null) {
                    imageLoc = new Point(label.filterImageLoc);
                    imageLoc.translate(clippedBounds.x + this.textMargin, timelineY);
                    g.drawImage(label.filterImage, imageLoc);
                }
                if (label.insertMarker != 0) {
                    int y = timelineY;
                    if (label.insertMarker == 2) {
                        y += height - 1;
                    }
                    int oldLineWidth = g.getLineWidth();
                    g.setLineWidth(2);
                    g.drawLine(bounds.x, y, bounds.x + bounds.width, y);
                    g.setLineWidth(oldLineWidth);
                }
            }
            timelineY += height;
        }
        clippedBounds.width += 3;
        g.setForegroundColor(ColorConstants.buttonDarker);
        g.drawLine(clippedBounds.getTopRight().translate(-1, -1), clippedBounds.getBottomRight().translate(-1, -1));
    }

    protected static class LabelData {
        public static final int INSERT_NONE = 0;
        public static final int INSERT_BEFORE = 1;
        public static final int INSERT_AFTER = 2;
        public static final int IMAGE_TEXT_MARGIN = 3;
        public static final int IMAGE_SELECTION_SLOP = 1;
        public Timeline timeline;
        public Dimension textSize;
        public Dimension expandCollapseImageSize;
        public Dimension leafImageSize;
        public Dimension filterImageSize;
        public Point textLoc;
        public Point expandCollapseImageLoc = null;
        public Point leafImageLoc = null;
        public Point filterImageLoc = null;
        public Image expandCollapseImage = null;
        public Image leafImage = null;
        public Image filterImage = null;
        public Point labelLoc = null;
        public boolean selected = false;
        public int insertMarker = 0;

        public LabelData(VerticalRulerFigure figure, Font font, Timeline timeline) {
            this.timeline = timeline;
            this.textSize = FigureUtilities.getStringExtents((String)timeline.getDisplayName(true), (Font)font);
            this.expandCollapseImageSize = new Dimension(expandImage.getBounds().width, expandImage.getBounds().height);
            this.leafImageSize = new Dimension(leafTimelineImage.getBounds().width, leafTimelineImage.getBounds().height);
            this.filterImageSize = new Dimension(includeImage.getBounds().width, includeImage.getBounds().height);
            int depth = 0;
            Timeline parent = timeline.getParent();
            while (parent != null) {
                ++depth;
                parent = parent.getParent();
            }
            int indent = depth * this.expandCollapseImageSize.width;
            int height = this.getHeight();
            if (timeline.isContainer()) {
                this.expandCollapseImageLoc = new Point(indent, (height - this.expandCollapseImageSize.height) / 2);
                indent += this.expandCollapseImageSize.width;
                switch (timeline.getContainerState()) {
                    case CLOSED: {
                        this.expandCollapseImage = timeline.getChildrenFiltered(false).isEmpty() ? expandAllImage : expandImage;
                        break;
                    }
                    case OPEN_NON_FILTERED: {
                        this.expandCollapseImage = expandAllImage;
                        break;
                    }
                    default: {
                        this.expandCollapseImage = collapseImage;
                        break;
                    }
                }
            } else if (timeline.getParent() != null) {
                this.leafImageLoc = new Point(indent, (height - this.leafImageSize.height) / 2);
                indent += this.leafImageSize.width;
                this.leafImage = leafTimelineImage;
            }
            if (timeline.getKind().isFilterable()) {
                this.filterImageLoc = new Point(indent, (height - this.filterImageSize.height) / 2);
                this.filterImage = timeline.isFiltered() ? excludeImage : includeImage;
                indent += this.filterImageSize.width;
            }
            this.textLoc = new Point(indent + 3, (height - this.textSize.height) / 2);
        }

        public void setLocation(int x, int y) {
            this.labelLoc = new Point(x, y);
        }

        public Rectangle getBounds(boolean textOnly) {
            if (this.labelLoc != null && this.timeline != null) {
                return new Rectangle(textOnly ? this.labelLoc.x + this.textLoc.x : 0, this.labelLoc.y, textOnly ? this.textSize.width : Integer.MAX_VALUE, this.getHeight());
            }
            return null;
        }

        public int getHeight() {
            return TimelineFigure.getScaledTimelineHeight(this.timeline);
        }

        public Rectangle getExpandCollapseImageBounds() {
            if (this.expandCollapseImage != null && this.expandCollapseImageLoc != null && this.labelLoc != null) {
                return new Rectangle(this.labelLoc.x + this.expandCollapseImageLoc.x - 1, this.labelLoc.y + this.expandCollapseImageLoc.y - 1, this.expandCollapseImageSize.width + 2, this.expandCollapseImageSize.height + 2);
            }
            return null;
        }

        public Rectangle getFilterImageBounds() {
            if (this.filterImage != null && this.filterImageLoc != null && this.labelLoc != null) {
                return new Rectangle(this.labelLoc.x + this.filterImageLoc.x - 1, this.labelLoc.y + this.filterImageLoc.y - 1, this.filterImageSize.width + 2, this.filterImageSize.height + 2);
            }
            return null;
        }
    }
}

