/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.editor;

import com.nvidia.viper.editor.ViperAnnotation;
import com.nvidia.viper.ui.ViperViewerBase;
import java.util.Iterator;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.AbstractRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class RulerColumnBase
extends AbstractRulerColumn {
    protected Control control;
    protected ViperViewerBase viewer;

    protected String getToolTipText(int lineNumber) {
        return null;
    }

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        this.control = super.createControl(parentRuler, parentControl);
        this.viewer = (ViperViewerBase)parentRuler.getTextViewer();
        final DefaultToolTip toolTip = new DefaultToolTip(this.control);
        this.control.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                int mouseLineNumber = RulerColumnBase.this.toDocumentLineNumber(e.y);
                String tooltipStr = RulerColumnBase.this.getToolTipText(mouseLineNumber);
                if (tooltipStr != null && !tooltipStr.isEmpty()) {
                    toolTip.activate();
                    toolTip.setText(tooltipStr);
                    toolTip.setShift(new Point(10, 0));
                } else {
                    toolTip.deactivate();
                }
            }
        });
        if (parentRuler != null) {
            this.viewer = (ViperViewerBase)parentRuler.getTextViewer();
            this.viewer.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    RulerColumnBase.this.updateColumn();
                }
            });
        }
        return this.control;
    }

    protected abstract void updateColumn();

    public abstract int getColumnIndex();

    protected abstract boolean isHotspotPresent();

    protected Color getMarkerForegroundColor(int lineNum, ViperViewerBase viewer) {
        Color color = null;
        IAnnotationModel annotationModel = viewer.getAnnotationModel();
        if (annotationModel != null) {
            Iterator ite = annotationModel.getAnnotationIterator();
            while (ite.hasNext()) {
                ViperAnnotation annotation = (ViperAnnotation)((Object)ite.next());
                if (annotation.getLine() != lineNum) continue;
                color = annotation.getColor();
                break;
            }
        }
        return color;
    }

    protected void drawMarkerAtEnd(int lineNum, GC gc, ViperViewerBase viewer, int x1, int y1, int x2, int y2) {
        Color foregroundColor;
        if (this.isHotspotPresent() && (foregroundColor = this.getMarkerForegroundColor(lineNum, viewer)) != null) {
            Color fore = gc.getForeground();
            int lineWidth = gc.getLineWidth();
            gc.setForeground(foregroundColor);
            gc.setLineWidth(3);
            gc.drawLine(x1, y1, x2, y2);
            gc.setForeground(fore);
            gc.setLineWidth(lineWidth);
        }
    }

    protected final void updateColumnWidth(int minimumWidth) {
        int currentWidth;
        int preferredWidth = minimumWidth + this.getExtraColumnWidth();
        if (preferredWidth > (currentWidth = this.getWidth())) {
            this.setWidth(preferredWidth);
            this.redraw();
        }
    }

    protected int getExtraColumnWidth() {
        return 10;
    }
}

