/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.expert.EventTableColumnProvider;
import com.nvidia.viper.jni.CuptiMetricValueKind;
import com.nvidia.viper.model.Event;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.ModelWithProperties;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.model.TimelineKernel;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.model.TimelineStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.Disposable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ExpertData
extends ModelWithProperties
implements Disposable {
    private boolean showFilteredTimelineData;
    private boolean showHiddenTimelineData;
    private boolean filterBySelection = true;
    public static final String PROPERTY_DATA = "expertdata";
    private Session session;
    private Mode mode;
    private Set<Event> events;
    private Set<Metric> metrics;
    private KernelAggregate[] orderedDisplayAggregates;
    private Long[] orderedDisplayIntervals;
    private Map<TimelineKernel, KernelAggregate> kernelAggregateMap;
    private Set<TimelineIntervalKind> intervalKinds;
    private boolean refreshEvents;
    private boolean refreshMetrics;
    private boolean refreshIntervals;
    private boolean refreshAggregate;
    private boolean pendingUpdate = false;

    public ExpertData(Session session) {
        this.session = session;
        this.mode = Mode.KERNEL_AGGREGATE;
        this.events = Collections.emptySet();
        this.metrics = Collections.emptySet();
        this.orderedDisplayIntervals = new Long[0];
        this.orderedDisplayAggregates = new KernelAggregate[0];
        this.kernelAggregateMap = new HashMap<TimelineKernel, KernelAggregate>();
        this.intervalKinds = new HashSet<TimelineIntervalKind>();
        this.showFilteredTimelineData = false;
        this.showHiddenTimelineData = false;
        this.filterBySelection = true;
    }

    public void dispose() {
        this.session.stopEventRefresh();
        this.session = null;
        this.orderedDisplayAggregates = null;
        this.orderedDisplayIntervals = null;
        this.kernelAggregateMap = null;
    }

    public Session getSession() {
        return this.session;
    }

    public void setShowFilteredTimelineData(boolean showFiltered) {
        this.showFilteredTimelineData = showFiltered;
    }

    public boolean isShowFilteredTimelineData() {
        return this.showFilteredTimelineData;
    }

    public void setFilterBySelection(boolean filterBySelection) {
        this.filterBySelection = filterBySelection;
    }

    public boolean isFilterBySelection() {
        return this.filterBySelection;
    }

    public void setShowHiddenTimelineData(boolean showHiddenTimelineData) {
        this.showHiddenTimelineData = showHiddenTimelineData;
    }

    public boolean isShowHiddenTimelineData() {
        return this.showHiddenTimelineData;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Event> getEvents() {
        ExpertData expertData = this;
        synchronized (expertData) {
            return this.events;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Metric> getMetrics() {
        ExpertData expertData = this;
        synchronized (expertData) {
            return this.metrics;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDisplayResultCnt() {
        ExpertData expertData = this;
        synchronized (expertData) {
            switch (this.mode) {
                case KERNEL_AGGREGATE: {
                    return this.orderedDisplayAggregates.length;
                }
            }
            return this.orderedDisplayIntervals.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getDisplayResults() {
        ExpertData expertData = this;
        synchronized (expertData) {
            switch (this.mode) {
                case KERNEL_AGGREGATE: {
                    return this.orderedDisplayAggregates;
                }
            }
            Object[] results = new ITimelineInterval[this.orderedDisplayIntervals.length];
            int index = 0;
            while (index < this.orderedDisplayIntervals.length) {
                results[index] = this.session.loadInterval(this.orderedDisplayIntervals[index], false);
                ++index;
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KernelAggregate getKernelAggregate(TimelineKernel timeline) {
        ExpertData expertData = this;
        synchronized (expertData) {
            return this.kernelAggregateMap.get(timeline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasIntervalKind(TimelineIntervalKind kind) {
        ExpertData expertData = this;
        synchronized (expertData) {
            return this.intervalKinds.contains((Object)kind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDisplayResult(int index) {
        ExpertData expertData = this;
        synchronized (expertData) {
            switch (this.mode) {
                case KERNEL_AGGREGATE: {
                    if (index < 0 || index >= this.orderedDisplayAggregates.length) break;
                    return this.orderedDisplayAggregates[index];
                }
                default: {
                    if (index < 0 || index >= this.orderedDisplayIntervals.length) break;
                    return this.session.loadInterval(this.orderedDisplayIntervals[index], true);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDisplayResultIndex(Object result) {
        ExpertData expertData = this;
        synchronized (expertData) {
            switch (this.mode) {
                case KERNEL_AGGREGATE: {
                    int i = 0;
                    while (i < this.orderedDisplayAggregates.length) {
                        if (result == this.orderedDisplayAggregates[i]) {
                            return i;
                        }
                        ++i;
                    }
                    break;
                }
                case INTERVAL: {
                    ITimelineInterval interval = (ITimelineInterval)result;
                    int i = 0;
                    while (i < this.orderedDisplayIntervals.length) {
                        if (interval.getID() == this.orderedDisplayIntervals[i].longValue()) {
                            return i;
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortDisplayAggregates(Comparator<Object> comparator) {
        ExpertData expertData = this;
        synchronized (expertData) {
            Arrays.sort(this.orderedDisplayAggregates, comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortDisplayIntervals(Comparator<Object> comparator) {
        ExpertData expertData = this;
        synchronized (expertData) {
            Arrays.sort(this.orderedDisplayIntervals, comparator);
        }
    }

    public void sortDisplayResults(Comparator<Object> comparator) {
        switch (this.mode) {
            case KERNEL_AGGREGATE: {
                this.sortDisplayAggregates(comparator);
                break;
            }
            default: {
                this.sortDisplayIntervals(comparator);
            }
        }
    }

    public void refreshEvents() {
        this.session.stopEventRefresh();
        this.refreshEvents = true;
        this.refreshAggregate = true;
        this.pendingUpdate = true;
    }

    public void refreshMetrics() {
        this.session.stopEventRefresh();
        this.refreshMetrics = true;
        this.refreshAggregate = true;
        this.pendingUpdate = true;
    }

    public void refreshIntervals() {
        this.session.stopEventRefresh();
        this.refreshIntervals = true;
        this.refreshAggregate = true;
        this.pendingUpdate = true;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart expertViewPart = page.findView("com.nvidia.viper.expertview");
        if (page.isPartVisible((IWorkbenchPart)expertViewPart)) {
            this.paintView();
        }
    }

    public void refreshAll() {
        this.session.stopEventRefresh();
        this.refreshEvents = true;
        this.refreshMetrics = true;
        this.refreshIntervals = true;
        this.refreshAggregate = true;
        this.pendingUpdate = true;
    }

    private Collection<Long> getDataIntervals() {
        HashSet<Long> ftl;
        block9: {
            ftl = new HashSet<Long>();
            this.intervalKinds.clear();
            if (this.session == null) break block9;
            Collection<TimelineIntervalPair> allSelected = this.session.getAllSelected();
            if (this.filterBySelection && allSelected != null) {
                for (TimelineIntervalPair selected : allSelected) {
                    Timeline timeline;
                    ITimelineInterval interval = selected.getInterval(this.session);
                    if (interval != null) {
                        if (!this.isDataTimeline(interval.getPrimaryTimeline(), this.showHiddenTimelineData, this.showFilteredTimelineData)) continue;
                        ftl.add(interval.getID());
                        this.intervalKinds.add(interval.getKind());
                        continue;
                    }
                    if (this.isDataTimeline(selected.getTimeline(), true, true)) {
                        timeline = selected.getTimeline();
                        int i = 0;
                        while (i < timeline.getIntervalIds().length) {
                            ftl.add(timeline.getIntervalIds()[i]);
                            ++i;
                        }
                        this.intervalKinds.addAll(timeline.getIntervalKinds());
                        continue;
                    }
                    timeline = selected.getTimeline();
                    if (!(timeline instanceof TimelineStream)) continue;
                    for (ITimelineInterval sInterval : timeline.getIntervals(false)) {
                        if (!this.isDataTimeline(sInterval.getPrimaryTimeline(), true, this.showFilteredTimelineData)) continue;
                        ftl.add(sInterval.getID());
                        this.intervalKinds.add(sInterval.getKind());
                    }
                }
            } else {
                for (Timeline timeline : this.session.getTimelines()) {
                    if (!this.isDataTimeline(timeline, this.showHiddenTimelineData, this.showFilteredTimelineData)) continue;
                    int i = 0;
                    while (i < timeline.getIntervalIds().length) {
                        ftl.add(timeline.getIntervalIds()[i]);
                        ++i;
                    }
                    this.intervalKinds.addAll(timeline.getIntervalKinds());
                }
            }
        }
        return ftl;
    }

    private Collection<TimelineIntervalPair> getAggregateDataIntervals() {
        HashSet<TimelineIntervalPair> ftl;
        block5: {
            ftl = new HashSet<TimelineIntervalPair>();
            this.intervalKinds.clear();
            if (this.session == null) break block5;
            Collection<TimelineIntervalPair> allSelected = this.session.getAllSelected();
            if (this.filterBySelection && allSelected != null) {
                for (TimelineIntervalPair selected : allSelected) {
                    ITimelineInterval interval = selected.getInterval(this.session);
                    if (interval != null) {
                        if (!this.isAggregateDataTimeline(interval.getPrimaryTimeline(), this.showHiddenTimelineData, this.showFilteredTimelineData)) continue;
                        ftl.add(new TimelineIntervalPair(interval.getPrimaryTimeline(), interval));
                        this.intervalKinds.add(interval.getKind());
                        continue;
                    }
                    if (!this.isAggregateDataTimeline(selected.getTimeline(), true, true)) continue;
                    ftl.add(new TimelineIntervalPair(selected.getTimeline(), null));
                    this.intervalKinds.addAll(selected.getTimeline().getIntervalKinds());
                }
            } else {
                for (Timeline timeline : this.session.getTimelines()) {
                    if (!this.isAggregateDataTimeline(timeline, this.showHiddenTimelineData, this.showFilteredTimelineData)) continue;
                    ftl.add(new TimelineIntervalPair(timeline, null));
                    this.intervalKinds.addAll(timeline.getIntervalKinds());
                }
            }
        }
        return ftl;
    }

    private boolean isDataTimeline(Timeline timeline, boolean ignoreVisible, boolean ignoreFilter) {
        if (timeline != null && (ignoreVisible || timeline.isVisible()) && (ignoreFilter || !timeline.isFiltered())) {
            switch (timeline.getKind()) {
                case MEMCPY_HTOD: 
                case MEMCPY_DTOH: 
                case MEMCPY_DTOD: 
                case MEMCPY_PTOP: 
                case KERNEL: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isAggregateDataTimeline(Timeline timeline, boolean ignoreVisible, boolean ignoreFilter) {
        return this.isDataTimeline(timeline, ignoreVisible, ignoreFilter) && TimelineKind.KERNEL.equals((Object)timeline.getKind());
    }

    public void paintView() {
        if (this.pendingUpdate) {
            this.session.startEventRefresh();
            this.pendingUpdate = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void refreshData() {
        block37: {
            block38: {
                block39: {
                    block35: {
                        block36: {
                            block33: {
                                block34: {
                                    block31: {
                                        block32: {
                                            block29: {
                                                block30: {
                                                    change = false;
                                                    if (this.refreshEvents) {
                                                        newEvents = new HashSet<Event>();
                                                        newEvents.addAll(this.session.getEvents());
                                                        var3_3 = this;
                                                        synchronized (var3_3) {
                                                            this.events = Collections.unmodifiableSet(newEvents);
                                                        }
                                                        this.refreshEvents = false;
                                                        change = true;
                                                    }
                                                    if (!Thread.currentThread().isInterrupted()) break block29;
                                                    if (!change) break block30;
                                                    Display.getDefault().asyncExec(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            ExpertData.this.firePropertyChange(ExpertData.PROPERTY_DATA);
                                                        }
                                                    });
                                                }
                                                return;
                                            }
                                            if (this.refreshMetrics) {
                                                newMetrics = new HashSet<Metric>();
                                                newMetrics.addAll(this.session.getAggregatedMetrics());
                                                var3_3 = this;
                                                synchronized (var3_3) {
                                                    this.metrics = Collections.unmodifiableSet(newMetrics);
                                                }
                                                this.refreshMetrics = false;
                                                change = true;
                                            }
                                            if (!Thread.currentThread().isInterrupted()) break block31;
                                            if (!change) break block32;
                                            Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                        }
                                        return;
                                    }
                                    if (!this.refreshIntervals || this.mode != Mode.INTERVAL) ** GOTO lbl64
                                    iset = this.getDataIntervals();
                                    if (!Thread.currentThread().isInterrupted()) break block33;
                                    if (!change) break block34;
                                    Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                }
                                return;
                            }
                            var3_3 = this;
                            synchronized (var3_3) {
                                this.orderedDisplayIntervals = new Long[iset.size()];
                                iset.toArray(this.orderedDisplayIntervals);
                                this.sortDisplayIntervals(EventTableColumnProvider.ColumnKind.START_TIME.getComparator(128, null, this.getSession()));
                            }
                            this.refreshIntervals = false;
                            change = true;
lbl64:
                            // 2 sources

                            if (!Thread.currentThread().isInterrupted()) break block35;
                            if (!change) break block36;
                            Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                        }
                        return;
                    }
                    if (!this.refreshAggregate || this.mode != Mode.KERNEL_AGGREGATE) break block37;
                    agg = new HashMap<String, KernelAggregate>();
                    for (TimelineIntervalPair pair : this.getAggregateDataIntervals()) {
                        if (pair.getTimeline() == null) continue;
                        timeline = pair.getTimeline();
                        ta = (KernelAggregate)agg.get(timeline.getIdentifyingName());
                        if (ta == null) {
                            ta = new KernelAggregate(timeline.getDisplayName(false));
                            agg.put(timeline.getIdentifyingName(), ta);
                        }
                        ta.addAggregateItem(pair);
                    }
                    if (!Thread.currentThread().isInterrupted()) break block38;
                    if (!change) break block39;
                    Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                }
                return;
            }
            try {
                try {
                    var3_3 = this;
                    synchronized (var3_3) {
                        this.kernelAggregateMap.clear();
                        for (KernelAggregate ta : agg.values()) {
                            ta.calcAggregate();
                            for (TimelineKernel timeline : ta.getTimelines()) {
                                this.kernelAggregateMap.put(timeline, ta);
                            }
                        }
                        this.orderedDisplayAggregates = agg.values().toArray(new KernelAggregate[0]);
                        this.sortDisplayAggregates(EventTableColumnProvider.ColumnKind.AVG_DURATION.getComparator(128, null, this.getSession()));
                    }
                    this.refreshAggregate = false;
                    change = true;
                }
                catch (Exception v4) {
                    if (!change) ** GOTO lbl122
                    Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                }
            }
            catch (Throwable var8_8) {
                if (change) {
                    Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                }
                throw var8_8;
            }
        }
        if (change) {
            Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
        }
lbl122:
        // 5 sources

    }

    public boolean isRefreshIntervals() {
        return this.refreshIntervals;
    }

    public boolean isRefreshAggregate() {
        return this.refreshAggregate;
    }

    public class KernelAggregate {
        private final String name;
        private Set<TimelineKernel> timelines = new HashSet<TimelineKernel>();
        private List<TimelineIntervalPair> aggregatePairs = new LinkedList<TimelineIntervalPair>();
        private int numIntervals;
        private long avgDuration;
        private Integer regsPerThread;
        private Integer staticSharedMemory;
        private Integer avgDynamicSharedMemory;
        private Map<Event, ValueRef> events;
        private Map<Metric, ValueRef> metrics;

        public KernelAggregate(String name) {
            this.name = name;
            this.events = new HashMap<Event, ValueRef>();
            this.metrics = new HashMap<Metric, ValueRef>();
        }

        public String getName() {
            return this.name;
        }

        public Collection<TimelineKernel> getTimelines() {
            return this.timelines;
        }

        public int getNumIntervals() {
            return this.numIntervals;
        }

        public long getAverageDuration() {
            return this.avgDuration;
        }

        public Integer getRegistersPerThread() {
            return this.regsPerThread;
        }

        public Integer getStaticSharedMemory() {
            return this.staticSharedMemory;
        }

        public Integer getAverageDynamicSharedMemory() {
            return this.avgDynamicSharedMemory;
        }

        public boolean addAggregateItem(TimelineIntervalPair pair) {
            Timeline timeline = pair.getTimeline();
            if (!(timeline instanceof TimelineKernel)) {
                return false;
            }
            this.timelines.add((TimelineKernel)timeline);
            return this.aggregatePairs.add(pair);
        }

        public void calcAggregate() {
            this.numIntervals = 0;
            this.avgDynamicSharedMemory = 0;
            this.avgDuration = this.avgDynamicSharedMemory.intValue();
            this.regsPerThread = this.staticSharedMemory = Integer.valueOf(0);
            this.events.clear();
            this.metrics.clear();
            for (TimelineIntervalPair pair : this.aggregatePairs) {
                if (pair.getInterval(ExpertData.this.session) == null) {
                    for (ITimelineInterval interval : pair.getTimeline().getIntervals(true)) {
                        this.calcAggregateInterval(interval);
                    }
                    continue;
                }
                this.calcAggregateInterval(pair.getInterval(ExpertData.this.session));
            }
            if (this.numIntervals > 0) {
                this.avgDuration /= (long)this.numIntervals;
                if (this.avgDynamicSharedMemory != null) {
                    this.avgDynamicSharedMemory = this.avgDynamicSharedMemory / this.numIntervals;
                }
            }
        }

        private void calcAggregateInterval(ITimelineInterval interval) {
            if (interval instanceof TimelineIntervalKernel) {
                ValueRef ev;
                TimelineIntervalKernel kernel = (TimelineIntervalKernel)interval;
                ++this.numIntervals;
                this.avgDuration += kernel.getDuration();
                if (this.avgDynamicSharedMemory != null) {
                    Integer n = this.avgDynamicSharedMemory = kernel.getDynamicSharedMemory() == null ? null : Integer.valueOf(this.avgDynamicSharedMemory + kernel.getDynamicSharedMemory());
                }
                if (this.regsPerThread != null) {
                    this.regsPerThread = kernel.getRegistersPerThread();
                }
                if (this.staticSharedMemory != null) {
                    this.staticSharedMemory = kernel.getStaticSharedMemory();
                }
                for (Event event : kernel.getEvents()) {
                    Long eventVal;
                    ev = this.events.get(event);
                    if (ev == null) {
                        ev = new ValueRef();
                        this.events.put(event, ev);
                    }
                    if ((eventVal = kernel.getEventValue(event)) == null || eventVal < 0L) continue;
                    ValueRef valueRef = ev;
                    valueRef.count = valueRef.count + 1L;
                    ValueRef valueRef2 = ev;
                    valueRef2.longValue = valueRef2.longValue + eventVal;
                }
                for (Metric metric : kernel.getAggregateMetrics()) {
                    Number metricVal;
                    ev = this.metrics.get(metric);
                    if (ev == null) {
                        ev = new ValueRef();
                        this.metrics.put(metric, ev);
                    }
                    if ((metricVal = kernel.getAggregateMetricValue(metric)) == null) continue;
                    if (metric.getValueKind().isLongValue()) {
                        if (metricVal.longValue() < 0L) continue;
                        ValueRef valueRef = ev;
                        valueRef.longValue = valueRef.longValue + metricVal.longValue();
                        ValueRef valueRef3 = ev;
                        valueRef3.count = valueRef3.count + 1L;
                        continue;
                    }
                    if (!(metricVal.doubleValue() >= 0.0)) continue;
                    ValueRef valueRef = ev;
                    valueRef.doubleValue = valueRef.doubleValue + metricVal.doubleValue();
                    ValueRef valueRef4 = ev;
                    valueRef4.count = valueRef4.count + 1L;
                }
            }
        }

        public Long getAverageEventValue(Event event) {
            ValueRef lr = this.events.get(event);
            if (lr != null) {
                if (lr.count <= 0L) {
                    return null;
                }
                return lr.longValue / lr.count;
            }
            return null;
        }

        public Number getAverageMetricValue(Metric metric) {
            ValueRef lr = this.metrics.get(metric);
            if (lr != null) {
                if (lr.count <= 0L) {
                    return null;
                }
                if (CuptiMetricValueKind.CUPTI_METRIC_VALUE_KIND_THROUGHPUT.equals((Object)metric.getValueKind())) {
                    long totalDuration = 0L;
                    long totalBytes = 0L;
                    for (TimelineIntervalPair pair : this.aggregatePairs) {
                        ITimelineInterval pairInterval = pair.getInterval(ExpertData.this.session);
                        if (pairInterval == null) {
                            for (ITimelineInterval interval : pair.getTimeline().getIntervals(true)) {
                                if (!(interval instanceof TimelineIntervalKernel)) continue;
                                TimelineIntervalKernel kernel = (TimelineIntervalKernel)interval;
                                totalDuration += interval.getDuration();
                                Number metricValue = kernel.getAggregateMetricValue(metric);
                                if (metricValue == null) continue;
                                totalBytes += metricValue.longValue() / 1000000L * kernel.getDuration();
                            }
                            continue;
                        }
                        if (!(pairInterval instanceof TimelineIntervalKernel)) continue;
                        TimelineIntervalKernel kernel = (TimelineIntervalKernel)pairInterval;
                        totalDuration += kernel.getDuration();
                        Number metricValue = kernel.getAggregateMetricValue(metric);
                        if (metricValue == null) continue;
                        totalBytes += metricValue.longValue() / 1000000L * kernel.getDuration();
                    }
                    if (totalDuration == 0L) {
                        return 0;
                    }
                    return totalBytes / totalDuration * 1000000L;
                }
                if (metric.getValueKind().isLongValue()) {
                    return lr.longValue / lr.count;
                }
                return lr.doubleValue / (double)lr.count;
            }
            return null;
        }

        private class ValueRef {
            private long count = 0L;
            private long longValue = 0L;
            private double doubleValue = 0.0;

            private ValueRef() {
            }
        }
    }

    public static enum Mode {
        INTERVAL,
        KERNEL_AGGREGATE;

    }
}

