/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityFlag;
import com.nvidia.viper.activity.CuptiActivityMemoryKind;
import com.nvidia.viper.activity.CuptiActivityMemset;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.TimelineIntervalHierarchy;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.value.ValueBandwidth;
import java.util.HashSet;
import java.util.Set;

public class TimelineIntervalMemset
extends TimelineIntervalHierarchy
implements IModel,
ITimelineInterval {
    protected CuptiActivityMemset activity;
    protected Set<Integer> correlationIds = new HashSet<Integer>();

    public TimelineIntervalMemset(CuptiActivityMemset activity) {
        super(TimelineIntervalKind.MEMSET, activity.start, activity.end, activity.getID());
        if (activity != null) {
            this.correlationIds.add(activity.correlationId);
        }
        this.activity = activity;
    }

    @Override
    public String getName() {
        if (this.activity.flags == -1) {
            return "memset (" + this.activity.value + ")";
        }
        return "memset [" + (this.isAsync() ? "async" : "sync") + "] (" + this.activity.value + ")";
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public Set<Integer> getCorrelationIds() {
        return this.correlationIds;
    }

    @Override
    public int getPrimaryCorrelationId() {
        return this.activity.correlationId;
    }

    public String getStreamName() {
        return this.getStreamName(this.activity.streamId);
    }

    public int getRuntimeCorrelationId() {
        return this.activity.runtimeCorrelationId;
    }

    @Override
    public ViperColors.GradientColors getColor(ViperColors.GradientColors colors) {
        return colors;
    }

    public boolean isAsync() {
        return CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MEMCPY_ASYNC.isSet(this.activity.flags);
    }

    public long getBytes() {
        return this.activity.bytes;
    }

    public long getThroughput() {
        return new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, this.activity.bytes, this.getDuration()).getBandwidth();
    }

    public CuptiActivityMemoryKind getMemoryKind() {
        return this.activity.getMemoryKind();
    }

    public int getValue() {
        return this.activity.value;
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        try {
            this.activity.appendToPDM(pdm.getNativeHandle());
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }

    public String getTooltip() {
        if (this.activity.flags == -1) {
            return this.getDisplayName();
        }
        return this.isAsync() ? "Asynchronous" : "Synchronous memset";
    }
}

