/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.common.util.SWTUtil;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.model.ExpertSystem;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.analysis.AnalysisResultControl;
import com.nvidia.viper.ui.analysis.AnalysisViewMode;
import com.nvidia.viper.ui.analysis.AnalysisViewModeDelegate;
import com.nvidia.viper.ui.analysis.GuidedAnalysisComposite;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public final class GuidedModeDelegate
implements AnalysisViewModeDelegate {
    private Session activeSession;
    private final Control buttons;
    private final GuidedAnalysisComposite guidedAnalysisComposite;
    private final Group resultsGroup;
    private final ScrolledComposite scrolledResultsComposite;
    private final Composite resultsComposite;

    private static boolean isChild(Control control, Control parent) {
        if (control == null || parent == null) {
            return false;
        }
        if (control == parent) {
            return true;
        }
        return GuidedModeDelegate.isChild((Control)control.getParent(), parent);
    }

    public GuidedModeDelegate(Composite buttonsParent, Composite outlineParent, Composite resultsParent) {
        this.guidedAnalysisComposite = new GuidedAnalysisComposite(buttonsParent, outlineParent, 0);
        this.buttons = this.guidedAnalysisComposite.getButtonsControl();
        this.resultsGroup = new Group(resultsParent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.resultsGroup.setLayout((Layout)gl);
        this.resultsGroup.setText("Results");
        this.scrolledResultsComposite = new ScrolledComposite((Composite)this.resultsGroup, 768);
        this.scrolledResultsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledResultsComposite.setExpandHorizontal(true);
        this.scrolledResultsComposite.setExpandVertical(true);
        this.resultsComposite = new Composite((Composite)this.scrolledResultsComposite, 0);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 2;
        gl.marginWidth = 5;
        gl.marginHeight = 5;
        this.resultsComposite.setLayout((Layout)gl);
        this.scrolledResultsComposite.setContent((Control)this.resultsComposite);
    }

    @Override
    public void activate() {
        this.refreshAnalysisResults();
    }

    @Override
    public AnalysisViewMode getAssociatedMode() {
        return AnalysisViewMode.guided;
    }

    @Override
    public Control getButtons() {
        return this.buttons;
    }

    @Override
    public Control getDetails() {
        return this.resultsGroup;
    }

    @Override
    public Control getOutline() {
        return this.guidedAnalysisComposite;
    }

    @Override
    public void handlePropertyChange(String propertyName) {
        if ("expertsystem:current".equals(propertyName)) {
            if (this.guidedAnalysisComposite != null) {
                this.guidedAnalysisComposite.refreshCurrentStage();
                this.refreshAnalysisResults();
            }
        } else if ("expertsystem:visited".equals(propertyName) || "expertsystem:stage".equals(propertyName)) {
            if (this.guidedAnalysisComposite != null) {
                this.guidedAnalysisComposite.refreshStages();
            }
        } else if ("expertsystem:results".equals(propertyName)) {
            this.refreshAnalysisResults();
        } else if ("session:timelines".equals(propertyName) || "session:timeline".equals(propertyName)) {
            if (this.guidedAnalysisComposite != null) {
                this.guidedAnalysisComposite.refreshStages();
            }
            this.refreshAnalysisResults();
        }
    }

    @Override
    public void setFocus() {
        this.guidedAnalysisComposite.setFocus();
    }

    @Override
    public void setSession(Session session) {
        this.activeSession = session;
        Control focusControl = Display.getDefault().getFocusControl();
        boolean focused = GuidedModeDelegate.isChild(focusControl, (Control)this.guidedAnalysisComposite);
        this.guidedAnalysisComposite.setExpertSystem(session == null ? null : session.getExpertSystem());
        this.refreshAnalysisResults();
        if (focused) {
            this.guidedAnalysisComposite.getParent().setFocus();
        }
    }

    private void refreshAnalysisResults() {
        Control[] controlArray = this.resultsComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        if (this.activeSession != null && this.activeSession.getExpertSystem() != null) {
            ExpertSystem expertSystem = this.activeSession.getExpertSystem();
            for (AnalysisResult result : expertSystem.getAnalysisResults()) {
                IAnalysisResultGraphicFactory aicFactory = result.getAnalysisResultFactory();
                AnalysisResultControl aic = aicFactory.construct(this.resultsComposite, result, this.activeSession);
                GridData layoutData = aic.grabsVerticalSpace() ? new GridData(1808) : new GridData(4, 128, true, false);
                aic.setLayoutData(layoutData);
            }
            this.scrolledResultsComposite.setMinSize(this.resultsComposite.computeSize(-1, -1));
            this.resultsComposite.layout(true);
        }
        if (!SWTUtil.isDisposed((Widget)this.guidedAnalysisComposite)) {
            this.guidedAnalysisComposite.refreshStages();
        }
    }
}

