/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.svg;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.device.svg.SVGGraphics2D;
import org.eclipse.birt.chart.device.svg.SVGRendererImpl;
import org.eclipse.birt.chart.device.util.ChartTextRenderer;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.LineAttributes;

public class SVGTextRenderer
extends ChartTextRenderer {
    public SVGTextRenderer(IDisplayServer dispServer) {
        super(dispServer);
    }

    protected void fillShadow(Graphics2D g2d, Shape shape) {
        ((SVGGraphics2D)((Object)g2d)).fill(shape, false);
    }

    protected void renderOutline(IPrimitiveRenderer renderer, LineAttributes lineAttribs, Rectangle2D.Double rect) {
        if (lineAttribs != null && lineAttribs.isVisible() && lineAttribs.getColor() != null) {
            SVGGraphics2D g2d = (SVGGraphics2D)((Object)((IDeviceRenderer)renderer).getGraphicsContext());
            Stroke sPrevious = null;
            ColorDefinition cd = lineAttribs.getColor();
            Stroke sCurrent = ((SVGRendererImpl)renderer).getCachedStroke(lineAttribs);
            if (sCurrent != null) {
                sPrevious = g2d.getStroke();
                g2d.setStroke(sCurrent);
            }
            g2d.setColor((Color)this._sxs.getColor(cd));
            g2d.draw(rect);
            g2d.setNoFillColor(g2d.getCurrentElement());
            if (sPrevious != null) {
                g2d.setStroke(sPrevious);
            }
        }
    }
}

