/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.wizards;

import com.nvidia.common.wizards.ContextPropertyStore;
import com.nvidia.common.wizards.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class WizardContext
implements IRunnableContext {
    private final IWizardContainer container;
    private final ContextPropertyStore sessionPropertyStore;

    public WizardContext(IWizardContainer container) {
        this.container = container;
        Realm realm = SWTObservables.getRealm((Display)container.getShell().getDisplay());
        this.sessionPropertyStore = new ContextPropertyStore(realm);
    }

    public <K> K getProperty(PropertyDescriptor<K> name) {
        return this.sessionPropertyStore.getProperty(name);
    }

    public Shell getShell() {
        return this.container.getShell();
    }

    public synchronized <K> IObservableValue observeProperty(PropertyDescriptor<K> name) {
        return this.sessionPropertyStore.observeProperty(name);
    }

    public <K> void setProperty(PropertyDescriptor<K> name, K value) {
        this.sessionPropertyStore.setProperty(name, value);
    }

    public ContextPropertyStore getPropertiesStore() {
        return this.sessionPropertyStore;
    }

    public Realm getRealm() {
        return this.sessionPropertyStore.getRealm();
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.container.run(fork, cancelable, runnable);
    }
}

