/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.BaseSaveAction;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;

public class SaveAsAction
extends BaseSaveAction {
    public SaveAsAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.SaveAs_text, window);
        this.setActionDefinitionId("org.eclipse.ui.file.saveAs");
        this.setText(WorkbenchMessages.SaveAs_text);
        this.setToolTipText(WorkbenchMessages.SaveAs_toolTip);
        this.setId("saveAs");
        window.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.save_as_action_context");
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_SAVEAS_EDIT"));
        this.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_SAVEAS_EDIT_DISABLED"));
    }

    public void run() {
        if (this.getWorkbenchWindow() == null) {
            return;
        }
        ISaveablePart saveView = this.getSaveableView();
        if (saveView != null) {
            saveView.doSaveAs();
            return;
        }
        IEditorPart editor = this.getActiveEditor();
        if (editor != null) {
            editor.doSaveAs();
        }
    }

    @Override
    protected void updateState() {
        ISaveablePart saveView = this.getSaveableView();
        if (saveView != null) {
            this.setEnabled(saveView.isSaveAsAllowed());
            return;
        }
        IEditorPart editor = this.getActiveEditor();
        this.setEnabled(editor != null && editor.isSaveAsAllowed());
    }
}

