/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.core;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.build.core.CudaSyncExceptionHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.ptp.internal.rdt.sync.cdt.core.remotemake.SyncCommandLauncher;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.handlers.ISyncExceptionHandler;

public final class CudaBuildCommandLauncher
implements ICommandLauncher {
    private final ICommandLauncher localLauncherDelegate = new CommandLauncher();
    private IProject project;
    private final ICommandLauncher syncLauncherDelegate = new SyncCommandLauncher();

    private static String[] filterWithDots(String[] env) {
        int j = 0;
        int i = 0;
        while (i < env.length) {
            if (!CudaBuildCommandLauncher.hasDotInName(env[i])) {
                env[j++] = env[i];
            }
            ++i;
        }
        if (j < env.length) {
            String[] res = new String[j];
            System.arraycopy(env, 0, res, 0, j);
            return res;
        }
        return env;
    }

    private static boolean hasDotInName(String string) {
        int indexOfDot = string.indexOf(".");
        int indexOfEquals = string.indexOf("=");
        return indexOfDot >= 0 && (indexOfEquals < 0 || indexOfEquals > indexOfDot);
    }

    private String[] appendBuildPathArgument(IPath commandPath, String[] args, IPath workingDirectory) {
        if (commandPath != null && "make".equals(commandPath.lastSegment())) {
            int indexOf = CoreUtil.indexOf((Object[])args, (Object)"-C");
            if (indexOf < 0) {
                IPath pathString = this.getRemoteTargetPath(workingDirectory);
                return (String[])CoreUtil.append((Object[])args, (Object[])new String[]{"-C", pathString.toString()});
            }
            return args;
        }
        return args;
    }

    public Process execute(IPath commandPath, String[] args, String[] env, IPath workingDirectory, IProgressMonitor monitor) throws CoreException {
        Process rc;
        if (this.isLocal()) {
            return this.localLauncherDelegate.execute(commandPath, args, env, workingDirectory, monitor);
        }
        ISyncExceptionHandler prevHandler = SyncManager.getDefaultSyncExceptionHandler();
        CudaSyncExceptionHandler handler = new CudaSyncExceptionHandler();
        SyncManager.setDefaultSyncExceptionHandler((ISyncExceptionHandler)handler);
        try {
            try {
                rc = this.syncLauncherDelegate.execute(commandPath, this.appendBuildPathArgument(commandPath, args, workingDirectory), CudaBuildCommandLauncher.filterWithDots(env), workingDirectory, monitor);
                if (handler.getLastException() != null) {
                    throw handler.getLastException();
                }
            }
            catch (JGitInternalException e) {
                if (e.getCause() != null && e.getCause() instanceof IOException) {
                    throw CoreUtil.coreException((Throwable)e, (String)"%s (due to io error %s )", (Object[])new Object[]{e.getMessage(), e.getCause().getMessage()});
                }
                throw CoreUtil.coreException((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
        finally {
            SyncManager.setDefaultSyncExceptionHandler((ISyncExceptionHandler)prevHandler);
        }
        return rc;
    }

    public String[] getCommandArgs() {
        if (this.isLocal()) {
            return this.localLauncherDelegate.getCommandArgs();
        }
        return this.syncLauncherDelegate.getCommandArgs();
    }

    public String getCommandLine() {
        if (this.isLocal()) {
            return this.localLauncherDelegate.getCommandLine();
        }
        return this.syncLauncherDelegate.getCommandLine();
    }

    public Properties getEnvironment() {
        Properties env = this.isLocal() ? this.localLauncherDelegate.getEnvironment() : this.syncLauncherDelegate.getEnvironment();
        return env;
    }

    public String getErrorMessage() {
        if (this.isLocal()) {
            return this.localLauncherDelegate.getErrorMessage();
        }
        return this.syncLauncherDelegate.getErrorMessage();
    }

    private IPath getRemoteTargetPath(IPath workingDirectory) {
        IPath path = this.project.getLocation();
        if (path != null && path.isPrefixOf(workingDirectory)) {
            SyncConfig active = SyncConfigManager.getActive((IProject)this.project);
            Path remoteProjectLocation = new Path(active.getLocation());
            if (remoteProjectLocation != null && remoteProjectLocation.segmentCount() > 0) {
                IPath projectRelativePath = workingDirectory.removeFirstSegments(path.segmentCount());
                return remoteProjectLocation.append(projectRelativePath);
            }
            return workingDirectory;
        }
        return workingDirectory;
    }

    public IProject getProject() {
        return this.project;
    }

    private boolean isLocal() {
        if (this.project != null) {
            SyncConfig active = SyncConfigManager.getActive((IProject)this.project);
            boolean isLocal = active == null || SyncConfigManager.isLocal((SyncConfig)active);
            return isLocal;
        }
        return false;
    }

    public void setErrorMessage(String error) {
        this.localLauncherDelegate.setErrorMessage(error);
        this.syncLauncherDelegate.setErrorMessage(error);
    }

    public void setProject(IProject project) {
        this.project = project;
        this.localLauncherDelegate.setProject(project);
        this.syncLauncherDelegate.setProject(project);
    }

    public void showCommand(boolean show) {
        this.localLauncherDelegate.showCommand(show);
        this.syncLauncherDelegate.showCommand(show);
    }

    @Deprecated
    public int waitAndRead(OutputStream out, OutputStream err) {
        if (this.isLocal()) {
            return this.localLauncherDelegate.waitAndRead(out, err);
        }
        return this.syncLauncherDelegate.waitAndRead(out, err);
    }

    public int waitAndRead(OutputStream output, OutputStream err, IProgressMonitor monitor) {
        if (this.isLocal()) {
            return this.localLauncherDelegate.waitAndRead(output, err, monitor);
        }
        return this.syncLauncherDelegate.waitAndRead(output, err, monitor);
    }
}

