/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.nvccsupport;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.core.Cpu;
import com.nvidia.cuda.ide.build.project.BuildUtils;
import com.nvidia.cuda.ide.build.project.ICubinModule;
import com.nvidia.cuda.ide.build.project.ICudaModule;
import com.nvidia.cuda.ide.build.project.ICudaProjectConfiguration;
import com.nvidia.cuda.ide.build.project.ProjectMetaManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineGenerator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class CompilerCommandlineGenerator
extends ManagedCommandLineGenerator {
    private static final String FLAG_COMPILE = "--compile";

    private String[] addFileSwitches(IResourceConfiguration parent) throws CoreException {
        ICubinModule[] modules;
        IResourceConfiguration resConfig = parent;
        IResource configOwner = resConfig.getOwner();
        IFile file = configOwner.isAccessible() && configOwner.getType() == 4 ? ((IProject)configOwner).getFile(parent.getPath()) : (IFile)configOwner;
        ICudaProjectConfiguration cudaConfig = ProjectMetaManager.load(ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)resConfig.getParent()));
        int virtual = 0;
        int physical = 0;
        boolean separateCompilation = false;
        ICudaModule executable = cudaConfig.getExecutable();
        ICubinModule[] iCubinModuleArray = modules = executable.includes(file) ? (ICudaModule[])CoreUtil.join((Object[])new ICudaModule[0], (Object[])new Object[]{cudaConfig.getModules(file), executable}) : cudaConfig.getModules(file);
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            ICubinModule module = iCubinModuleArray[n2];
            int v = module.getVirtualArchitectures();
            boolean dlink = module.isDeviceLinkingEnabled();
            separateCompilation |= dlink;
            virtual |= v != 0 || !dlink ? v : Architecture.get(2, 0).getBit();
            physical |= module.getPhysicalArchitectures();
            ++n2;
        }
        return (String[])CoreUtil.join((Object[])new String[]{BuildUtils.getRDCFlag(separateCompilation)}, (Object[])new Object[]{Architecture.convertToCommandLineOptions(false, virtual), Architecture.convertToCommandLineOptions(true, physical)});
    }

    private String[] addWildcardRuleSwitches(IToolChain parent) throws CoreException {
        IConfiguration configuration = parent.getParent();
        ICConfigurationDescription cfg = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)configuration);
        ICudaProjectConfiguration cudaConfig = ProjectMetaManager.load(cfg);
        ICudaModule executable = cudaConfig.getExecutable();
        return BuildUtils.getSMVersionFlags(executable, false);
    }

    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        try {
            Object[] newFlags;
            if (" -x cu -o".equals(outputFlag)) {
                String[] switches;
                IBuildObject parent = tool.getParent();
                if (parent instanceof IToolChain) {
                    switches = this.addWildcardRuleSwitches((IToolChain)parent);
                } else if (parent instanceof IResourceConfiguration) {
                    switches = this.addFileSwitches((IResourceConfiguration)parent);
                } else {
                    throw new IllegalArgumentException();
                }
                newFlags = (String[])CoreUtil.join((Object[])flags, (Object[])new Object[]{FLAG_COMPILE, switches});
            } else if (" -x c++ -o".equals(outputFlag) || " -x c -o".equals(outputFlag)) {
                newFlags = new String[flags.length + 1];
                System.arraycopy(flags, 0, newFlags, 0, flags.length);
                newFlags[flags.length] = FLAG_COMPILE;
            } else {
                newFlags = flags;
            }
            Cpu cpu = BuildUtils.getCpu(tool);
            newFlags = (String[])CoreUtil.join((Object[])newFlags, (Object[])cpu.getNvccFlags());
            newFlags = BuildUtils.addCcbinSwitch((String[])newFlags, cpu);
            return super.generateCommandLineInfo(tool, BuildUtils.getNvccPath(tool), (String[])newFlags, outputFlag, outputPrefix, outputName, inputResources, commandLinePattern);
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
            return null;
        }
    }
}

