/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.project;

import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.project.IArchitectureObject;
import com.nvidia.cuda.ide.build.project.ICudaModule;
import com.nvidia.cuda.ide.build.project.MultiConfiguration;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public abstract class AbstractMultiModule
implements IArchitectureObject {
    protected final MultiConfiguration multiConfiguration;

    public AbstractMultiModule(MultiConfiguration multiConfiguration) {
        this.multiConfiguration = multiConfiguration;
    }

    @Override
    public final void disableArchitecture(Architecture architecture, boolean isPhysical) {
        for (ICudaModule iCudaModule : this.getModules()) {
            iCudaModule.disableArchitecture(architecture, isPhysical);
        }
    }

    @Override
    public final void enableArchitecture(Architecture architecture, boolean isPhysical) {
        for (ICudaModule iCudaModule : this.getModules()) {
            iCudaModule.enableArchitecture(architecture, isPhysical);
        }
    }

    public final void exclude(IFile file) throws CoreException {
        for (ICudaModule iCudaModule : this.getModules()) {
            iCudaModule.exclude(file);
        }
    }

    private int getArchsInAllConfigurations(boolean phys) {
        Collection<? extends ICudaModule> modules = this.getModules();
        if (modules.isEmpty()) {
            return 0;
        }
        int mask = -1;
        for (ICudaModule iCudaModule : modules) {
            mask &= phys ? iCudaModule.getPhysicalArchitectures() : iCudaModule.getVirtualArchitectures();
        }
        return mask;
    }

    private int getArchsInSomeConfigurations(boolean phys) {
        int mask = 0;
        for (ICudaModule iCudaModule : this.getModules()) {
            mask |= phys ? iCudaModule.getPhysicalArchitectures() : iCudaModule.getVirtualArchitectures();
        }
        return mask & ~this.getArchsInAllConfigurations(phys);
    }

    protected abstract Collection<? extends ICudaModule> getModules();

    public final MultiConfiguration getParentConfiguration() {
        return this.multiConfiguration;
    }

    @Override
    public final int getPhysicalArchitecturesForAllConfigurations() {
        return this.getArchsInAllConfigurations(true);
    }

    @Override
    public final int getPhysicalArchitecturesForSomeConfigurations() {
        return this.getArchsInSomeConfigurations(true);
    }

    public abstract Collection<ICudaModule.Type> getTypesFromConfigurations();

    @Override
    public final int getVirtualArchitecturesForAllConfigurations() {
        return this.getArchsInAllConfigurations(false);
    }

    @Override
    public final int getVirtualArchitecturesForSomeConfigurations() {
        return this.getArchsInSomeConfigurations(false);
    }

    public final void include(IFile file) throws CoreException {
        for (ICudaModule iCudaModule : this.getModules()) {
            iCudaModule.include(file);
        }
    }

    public final Boolean includes(IFile file) {
        Boolean result = null;
        for (ICudaModule iCudaModule : this.getModules()) {
            boolean includes = iCudaModule.includes(file);
            if (result == null) {
                result = includes;
                continue;
            }
            if (includes == result) continue;
            return null;
        }
        return result;
    }

    @Override
    public final Boolean isDeviceLinking() {
        Boolean result = null;
        Collection<? extends ICudaModule> modules = this.getModules();
        for (ICudaModule iCudaModule : modules) {
            boolean isDLModule = iCudaModule.isDeviceLinkingEnabled();
            if (result == null) {
                result = isDLModule;
                continue;
            }
            if (result == isDLModule) continue;
            return null;
        }
        return result;
    }

    @Override
    public final void setDeviceLinkingEnabled(boolean enable) {
        for (ICudaModule iCudaModule : this.getModules()) {
            iCudaModule.setDeviceLinkerEnabled(enable);
        }
    }

    public final void setPhysicalArchitectures(int arch) {
        for (ICudaModule iCudaModule : this.getModules()) {
            iCudaModule.setPhysicalArchitectures(arch);
        }
    }

    public final void setVirtualArchitectures(int arch) {
        for (ICudaModule iCudaModule : this.getModules()) {
            iCudaModule.setVirtualArchitectures(arch);
        }
    }
}

