/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.index;

import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.util.CudaProjectUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.build.core.scannerconfig.ScannerConfigBuilder;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class TargetRuntimeListener
implements ICProjectDescriptionListener {
    protected final AtomicBoolean queryReadying = new AtomicBoolean(false);

    protected boolean askToUpdate(ICProjectDescription projectDescription) {
        if (projectDescription != null) {
            IConfiguration c;
            ICConfigurationDescription configuration = projectDescription.getActiveConfiguration();
            if (configuration != null && (c = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)configuration)) != null) {
                new RediscoverJob(c).schedule();
                return true;
            }
            this.queryReadying.set(false);
        }
        return false;
    }

    public void handleEvent(CProjectDescriptionEvent event) {
        ICProjectDescription oldDesc = event.getOldCProjectDescription();
        if (oldDesc != null) {
            Architecture oldArch = CudaProjectUtil.getEditorArch(oldDesc);
            Architecture newArch = CudaProjectUtil.getEditorArch(event.getNewCProjectDescription());
            if (newArch != null && !newArch.equals(oldArch) && this.queryReadying.compareAndSet(false, true) && !this.askToUpdate(event.getNewCProjectDescription())) {
                this.queryReadying.set(false);
            }
        }
    }

    private final class RediscoverJob
    extends Job {
        private final IConfiguration configuration;

        public RediscoverJob(IConfiguration configuration) {
            super(String.format("Rediscover scanner settings for project %s", configuration.getOwner().getName()));
            this.setRule((ISchedulingRule)configuration.getOwner().getWorkspace().getRoot());
            this.setUser(false);
            this.configuration = configuration;
        }

        protected IStatus run(IProgressMonitor monitor) {
            ScannerConfigBuilder.build((IConfiguration)this.configuration, (int)1, (IProgressMonitor)monitor);
            TargetRuntimeListener.this.queryReadying.set(false);
            return new Status(0, "com.nvidia.cuda.ide.build", "");
        }
    }
}

