/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.SubmoduleAddCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.TeamException;

public class SubmoduleAddOperation
implements IEGitOperation {
    private final Repository repo;
    private final String path;
    private final String uri;

    public SubmoduleAddOperation(Repository repo, String path, String uri) {
        this.repo = repo;
        this.path = path;
        this.uri = uri;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                SubmoduleAddCommand add = Git.wrap((Repository)SubmoduleAddOperation.this.repo).submoduleAdd();
                add.setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer(pm));
                add.setPath(SubmoduleAddOperation.this.path);
                add.setURI(SubmoduleAddOperation.this.uri);
                try {
                    Repository subRepo = add.call();
                    if (subRepo != null) {
                        subRepo.close();
                        SubmoduleAddOperation.this.repo.notifyIndexChanged();
                    }
                }
                catch (GitAPIException e) {
                    throw new TeamException(e.getLocalizedMessage(), e.getCause());
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

