/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.launch;

import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.IFocus;

public class CudaFocus
implements IFocus {
    private final CudaCoord blockId;
    private final short device;
    private final long kernelId;
    private final short lane;
    private final int sm;
    private final CudaCoord threadId;
    private final short warp;

    public CudaFocus(long kernelId, CudaCoord blockId, CudaCoord threadId, short device, int sm, short warp, short lane) {
        this.kernelId = kernelId;
        this.blockId = blockId;
        this.threadId = threadId;
        this.device = device;
        this.sm = sm;
        this.warp = warp;
        this.lane = lane;
    }

    @Override
    public CudaCoord getBlockIdx() {
        return this.blockId;
    }

    public short getDevice() {
        return this.device;
    }

    @Override
    public long getKernelId() {
        return this.kernelId;
    }

    public short getLane() {
        return this.lane;
    }

    public int getSM() {
        return this.sm;
    }

    @Override
    public CudaCoord getThreadIdx() {
        return this.threadId;
    }

    public short getWarp() {
        return this.warp;
    }

    public String toString() {
        return String.format("%d:%s:%s", this.getKernelId(), this.getBlockIdx(), this.getThreadIdx());
    }
}

