/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.filters;

import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ICoordSorter;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.ICudaVisitor;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.Lane;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import com.nvidia.cuda.ide.debug.model.Warp;
import com.nvidia.cuda.ide.debug.model.query.IElementQuery;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.CountChildren;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.ICudaElementFilter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class QueryFilter
implements ICudaElementFilter {
    private static final IDMContext[] EMPTY_DM_ARRAY = new IDMContext[0];
    private final ICudaElementFilter delegate;
    private final IElementQuery query;

    public QueryFilter(DsfServicesTracker tracker, IElementQuery query, ICudaElementFilter delegate) {
        this.query = query;
        this.delegate = delegate;
    }

    @Override
    public void updateChildren(final boolean inLogicalMode, final ICudaRuntimeObject object, final int offset, final int length, final ICoordSorter sorter, final DataRequestMonitor<IDMContext[]> rm) {
        ICudaApplication application = (ICudaApplication)DMContexts.getAncestorOfType((IDMContext)object, ICudaApplication.class);
        application.prepareQuery(this.query, inLogicalMode, new DataRequestMonitor<IElementQuery>(application.getExecutor(), rm){

            protected void handleSuccess() {
                FilterChildren visitor = new FilterChildren((IElementQuery)this.getData(), offset, length, inLogicalMode, sorter, (DataRequestMonitor<IDMContext[]>)rm);
                object.accept(visitor);
            }
        });
    }

    @Override
    public void updateChildrenCount(final boolean isLogical, final ICudaRuntimeObject object, final ICoordSorter sorter, final DataRequestMonitor<Integer> drm) {
        DataRequestMonitor<Integer> dataRequestMonitor = new DataRequestMonitor<Integer>(((ICudaApplication)DMContexts.getAncestorOfType((IDMContext)object, ICudaApplication.class)).getExecutor(), drm){

            protected void handleSuccess() {
                Integer data = (Integer)this.getData();
                if (data != null) {
                    drm.setData((Object)data);
                    drm.done();
                } else {
                    QueryFilter.this.delegate.updateChildrenCount(isLogical, object, sorter, (DataRequestMonitor<Integer>)drm);
                }
            }
        };
        this.countChildren(isLogical, object, dataRequestMonitor);
    }

    private void countChildren(final boolean isLogical, final ICudaRuntimeObject object, final DataRequestMonitor<Integer> drm) {
        ICudaApplication application = (ICudaApplication)DMContexts.getAncestorOfType((IDMContext)object, ICudaApplication.class);
        application.prepareQuery(this.query, isLogical, new DataRequestMonitor<IElementQuery>(application.getExecutor(), drm){

            protected void handleSuccess() {
                object.accept(new CountChildren((IElementQuery)this.getData(), (DataRequestMonitor<Integer>)drm, isLogical));
            }
        });
    }

    @Override
    public void updateHasChildren(final boolean isLogical, final ICudaRuntimeObject object, final DataRequestMonitor<Boolean> drm) {
        this.countChildren(isLogical, object, new DataRequestMonitor<Integer>(((ICudaApplication)DMContexts.getAncestorOfType((IDMContext)object, ICudaApplication.class)).getExecutor(), drm){

            protected void handleSuccess() {
                Integer data = (Integer)this.getData();
                if (data != null) {
                    drm.setData((Object)(data > 0 ? 1 : 0));
                    drm.done();
                } else {
                    QueryFilter.this.delegate.updateHasChildren(isLogical, object, (DataRequestMonitor<Boolean>)drm);
                }
            }
        });
    }

    private final class FilterChildren
    implements ICudaVisitor {
        private final boolean isLogicalMode;
        private final IElementQuery query;
        private final DataRequestMonitor<IDMContext[]> rm;
        private final int offset;
        private final int length;
        private final ICoordSorter sorter;

        public FilterChildren(IElementQuery query, int offset, int length, boolean isLogicalMode, ICoordSorter sorter, DataRequestMonitor<IDMContext[]> rm) {
            this.query = query;
            this.offset = offset;
            this.length = length;
            this.isLogicalMode = isLogicalMode;
            this.sorter = sorter;
            this.rm = rm;
        }

        private IDMContext[] createArray(ICudaRuntimeObject object, Object array) {
            assert (array == null || array.getClass().isArray());
            if (array != null) {
                int offset = this.offset > 0 ? this.offset : 0;
                int count = Math.min(Array.getLength(array) - (offset < 0 ? 0 : offset), this.length >= 0 ? this.length : Integer.MAX_VALUE);
                if (count <= 0) {
                    return EMPTY_DM_ARRAY;
                }
                return new IDMContext[count];
            }
            return null;
        }

        @Override
        public void visitApplication(ICudaApplication application) {
            if (this.isLogicalMode) {
                application.getKernels((DataRequestMonitor<? super Kernel[]>)new DataRequestMonitor<Kernel[]>(application.getExecutor(), this.rm){

                    protected void handleSuccess() {
                        ArrayList<Kernel> kernels = new ArrayList<Kernel>(((Kernel[])this.getData()).length);
                        Kernel[] kernelArray = (Kernel[])this.getData();
                        int n = kernelArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Kernel kernel = kernelArray[n2];
                            if (FilterChildren.this.query.match(kernel)) {
                                kernels.add(kernel);
                            }
                            ++n2;
                        }
                        FilterChildren.this.rm.setData((Object)kernels.toArray(new Kernel[kernels.size()]));
                        FilterChildren.this.rm.done();
                    }
                });
            } else {
                application.getDevices(new DataRequestMonitor<Device[]>(application.getExecutor(), this.rm){

                    protected void handleSuccess() {
                        ArrayList<Device> devices = new ArrayList<Device>(((Device[])this.getData()).length);
                        Device[] deviceArray = (Device[])this.getData();
                        int n = deviceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Device device = deviceArray[n2];
                            if (FilterChildren.this.query.match(device)) {
                                devices.add(device);
                            }
                            ++n2;
                        }
                        FilterChildren.this.rm.setData((Object)devices.toArray(new Device[devices.size()]));
                        FilterChildren.this.rm.done();
                    }
                });
            }
        }

        @Override
        public void visitBlock(Block block) {
            CudaCoord[] threads = this.query.filterThreads(block);
            if (threads == null) {
                QueryFilter.this.delegate.updateChildren(this.isLogicalMode, block, this.offset, this.length, this.sorter, this.rm);
            } else {
                try {
                    int offset = this.offset > 0 ? this.offset : 0;
                    IDMContext[] array = this.createArray(block, threads);
                    int i = 0;
                    while (i < array.length) {
                        array[i] = block.getThread(threads[offset + i]);
                        ++i;
                    }
                    this.rm.setData((Object)array);
                }
                catch (CudaException e) {
                    this.rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
                }
                this.rm.done();
            }
        }

        @Override
        public void visitDevice(Device device) {
            byte[] sms = this.query.filterSMs(device);
            if (sms == null) {
                QueryFilter.this.delegate.updateChildren(this.isLogicalMode, device, this.offset, this.length, this.sorter, this.rm);
            } else {
                try {
                    int offset = this.offset > 0 ? this.offset : 0;
                    IDMContext[] array = this.createArray(device, sms);
                    int i = 0;
                    while (i < array.length) {
                        array[i] = device.getSm(sms[offset + i]);
                        ++i;
                    }
                    this.rm.setData((Object)array);
                }
                catch (CudaException e) {
                    this.rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
                }
                this.rm.done();
            }
        }

        @Override
        public void visitKernel(Kernel kernel) {
            CudaCoord[] blocks = this.query.filterBlocks(kernel);
            IDMContext[] array = this.createArray(kernel, blocks);
            if (array == null) {
                QueryFilter.this.delegate.updateChildren(this.isLogicalMode, kernel, this.offset, this.length, this.sorter, this.rm);
            } else {
                int offset = this.offset > 0 ? this.offset : 0;
                try {
                    int i = 0;
                    while (i < array.length) {
                        array[i] = kernel.getBlock(blocks[offset + i]);
                        ++i;
                    }
                    this.rm.setData((Object)array);
                }
                catch (CudaException e) {
                    this.rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
                }
                this.rm.done();
            }
        }

        @Override
        public void visitLane(Lane lane) {
            this.rm.setData((Object)new IDMContext[0]);
            this.rm.done();
        }

        @Override
        public void visitSM(StreamingMultiprocessor sm) {
            byte[] warps = this.query.filterWarps(sm);
            IDMContext[] array = this.createArray(sm, warps);
            if (array == null) {
                QueryFilter.this.delegate.updateChildren(this.isLogicalMode, sm, this.offset, this.length, this.sorter, this.rm);
            } else {
                try {
                    int offset = this.offset > 0 ? this.offset : 0;
                    int i = 0;
                    while (i < array.length) {
                        array[i] = sm.getWarp(warps[offset + i]);
                        ++i;
                    }
                    this.rm.setData((Object)array);
                }
                catch (CudaException e) {
                    this.rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
                }
                this.rm.done();
            }
        }

        @Override
        public void visitThread(DeviceThread deviceThread) {
            this.rm.setData((Object)new IDMContext[0]);
            this.rm.done();
        }

        @Override
        public void visitWarp(Warp warp) {
            byte[] lanes = this.query.filterLanes(warp);
            IDMContext[] array = this.createArray(warp, lanes);
            if (array == null) {
                QueryFilter.this.delegate.updateChildren(this.isLogicalMode, warp, this.offset, this.length, this.sorter, this.rm);
            } else {
                try {
                    int offset = this.offset > 0 ? this.offset : 0;
                    int i = 0;
                    while (i < array.length) {
                        array[i] = warp.getLane(lanes[offset + i]);
                        ++i;
                    }
                    this.rm.setData((Object)array);
                }
                catch (CudaException e) {
                    this.rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
                }
                this.rm.done();
            }
        }
    }
}

