/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.ibm.icu.text.MessageFormat;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.debug.core.CudaDebugImages;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.RangeContext;
import com.nvidia.cuda.ide.debug.model.events.ElementPinnedStatusEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.ICudaUIConstants;
import com.nvidia.cuda.ide.debug.ui.viewmodel.IDataContextProvider;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.AbstractCudaDMVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.KernelVMNode;
import com.nvidia.cuda.ide.debug.util.ConditionalLabelColors;
import com.nvidia.cuda.ide.debug.util.ConditionalLabelFont;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import com.nvidia.cuda.ide.debug.util.IffAttribute;
import com.nvidia.cuda.ide.debug.util.RIRequestMonitor;
import com.nvidia.cuda.ide.debug.util.ResourceIcon;
import com.nvidia.cuda.ide.debug.util.ThreadImage;
import java.util.Map;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IMemento;

public final class DeviceThreadVMNode
extends AbstractCudaDMVMNode<DeviceThread> {
    private final boolean selectPinnedThreads;

    protected void getTopStackFrame(Object element, DataRequestMonitor<IStack.IFrameDMContext> dataRequestMonitor) {
        IStack stackService = (IStack)this.getServicesTracker().getService(IStack.class);
        IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)this.findDmcInPath(element, new TreePath(new Object[]{element}), IRunControl.IExecutionDMContext.class);
        if (stackService == null || execDmc == null) {
            dataRequestMonitor.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", "Debugger is not ready"));
            dataRequestMonitor.done();
        } else {
            stackService.getTopFrame((IDMContext)execDmc, dataRequestMonitor);
        }
    }

    public DeviceThreadVMNode(AbstractDMVMProvider provider, DsfSession session, boolean selectPinnedThreads) {
        super(provider, session, DeviceThread.class);
        this.selectPinnedThreads = selectPinnedThreads;
    }

    @Override
    public void getContextsForEvent(VMDelta parentDelta, Object event, DataRequestMonitor<IVMContext[]> rm) {
        if (event instanceof ElementPinnedStatusEvent) {
            DeviceThread dmc = ((ElementPinnedStatusEvent)event).getDMContext();
            rm.setData((Object)this.dmcs2vmcs(new IDMContext[]{dmc}));
            rm.done();
            return;
        }
        super.getContextsForEvent(parentDelta, event, rm);
    }

    @Override
    public void buildDelta(Object event, VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        if (event instanceof ElementPinnedStatusEvent) {
            DeviceThread dmc = ((ElementPinnedStatusEvent)event).getDMContext();
            parent.addNode((Object)this.createVMContext(dmc), 2048);
            requestMonitor.done();
            return;
        }
        if (event instanceof DoubleClickEvent) {
            DebugUtil.togglePinOnDoubleclick(((DoubleClickEvent)event).getSelection(), (IVMNode)this, this.getServicesTracker());
            requestMonitor.done();
        } else {
            super.buildDelta(event, parent, nodeOffset, requestMonitor);
        }
    }

    @Override
    public int getDeltaFlags(Object event) {
        if (event instanceof ElementPinnedStatusEvent) {
            return 2048;
        }
        if (event instanceof DoubleClickEvent) {
            return 2048;
        }
        return super.getDeltaFlags(event);
    }

    @Override
    protected boolean compareElement(DeviceThread object, IMemento memento) {
        Kernel kernel = (Kernel)DMContexts.getAncestorOfType((IDMContext)object, Kernel.class);
        boolean same = false;
        if (KernelVMNode.isSameKernel(kernel, memento)) {
            same = DebugUtil.compare(object.getBlockIdx(), memento, "MEMENTO_BLOCK_IDX");
            same &= DebugUtil.compare(object.getThreadIdx(), memento, "MEMENTO_THREAD_IDX");
        }
        return same;
    }

    private LabelColumnInfo createLabelColumnInfo() {
        return new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0}", new String[]{"name"}), new IffAttribute("cuda_object_pinned", new ThreadImage(CudaDebugImages.PINNED_THREAD, CudaDebugImages.PINNED_THREAD_DIVERGED, CudaDebugImages.PINNED_THREAD_INACTIVE), new ThreadImage(CudaDebugImages.THREAD, CudaDebugImages.THREAD_DIVERGED, CudaDebugImages.THREAD_INACTIVE)), new ConditionalLabelColors(DebugUtil.getRGBColor(33), "cuda_object_active", false), new ConditionalLabelFont(true, false, "cuda_object_pinned")});
    }

    private LabelColumnInfo createLabelNoColumnInfo() {
        return new LabelColumnInfo(new LabelAttribute[]{new ThreadLabel(), new ThreadImage(CudaDebugImages.THREAD, CudaDebugImages.THREAD_DIVERGED, CudaDebugImages.THREAD_INACTIVE), new ConditionalLabelColors(DebugUtil.getRGBColor(33), "cuda_object_active", false), new ConditionalLabelFont(true, false, "cuda_object_pinned")});
    }

    @Override
    protected IElementLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__NAME", this.createLabelColumnInfo());
        provider.setColumnInfo(ICudaUIConstants.COLUMN_ID__WARP, new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0,choice,0#|1#{2}}", new String[]{"is_active_i", "sm_id", "warp_id", "lane_id"})}));
        provider.setColumnInfo(ICudaUIConstants.COLUMN_ID__LANE, new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0,choice,0#|1#{3}}", new String[]{"is_active_i", "sm_id", "warp_id", "lane_id"})}));
        provider.setColumnInfo(ICudaUIConstants.COLUMN_ID__HARDWARE, new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0,choice,0#|1#Warp {2} Lane {3}}", new String[]{"is_active_i", "sm_id", "warp_id", "lane_id"})}));
        provider.setColumnInfo(ICudaUIConstants.COLUMN_ID__DETAILS, new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0,choice,0#Not running|1#{1}:{2} ({3})|2#{3}}", new String[]{"has_source", "source_file", "source_line", "pc_formatted"}), new ResourceIcon("source_resource")}));
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", this.createLabelNoColumnInfo());
        return provider;
    }

    @Override
    protected void encodeElement(DeviceThread object, IMemento memento) {
        KernelVMNode.store((Kernel)DMContexts.getAncestorOfType((IDMContext)object, Kernel.class), memento);
        memento.putString("MEMENTO_BLOCK_IDX", object.getBlockIdx().toString());
        memento.putString("MEMENTO_THREAD_IDX", object.getThreadIdx().toString());
    }

    @Override
    protected void updatePropertiesInSessionThread(DeviceThread thread, IPropertiesUpdate update) {
        update.setProperty("name", (Object)thread.getThreadIdx().toString());
        RIRequestMonitor.fill(update, this.getExecutor(), thread, (ISourceLookup)this.getServicesTracker().getService(ISourceLookup.class));
    }

    @Override
    protected boolean isLogicalNode() {
        return true;
    }

    public String toString() {
        return "ThreadsVM";
    }

    @Override
    protected String getInactiveElementRangeStateLabel(RangeContext rangeContext) {
        return MessageFormat.format((String)"{0} Inactive Threads", (Object[])new Object[]{rangeContext.getEnd() - rangeContext.getStart() + 1L});
    }

    protected IDMVMContext createVMContext(IDMContext dmc) {
        return new ThreadVMContext(dmc);
    }

    @Override
    protected CudaDebugImages getInactiveImageDescriptor() {
        return CudaDebugImages.THREAD_INACTIVE;
    }

    @Override
    protected void buildSelectionDelta(DeviceThread element, VMDelta delta, int nodeOffset, boolean select, boolean collapseTheRest, RequestMonitor rm) {
        if (this.selectPinnedThreads || !DebugUtil.isPinnedOrRemembered(element)) {
            super.buildSelectionDelta(element, delta, nodeOffset, select, collapseTheRest, rm);
        } else {
            rm.done();
        }
    }

    private static final class ThreadLabel
    extends LabelAttribute {
        private static LabelText ACTIVE_THREAD_TEXT = new LabelText("CUDA Thread {0} {5,choice,0#|1#[warp: {6} lane: {7}]} {1,choice,0#|1#({2}:{3})|2#{4}}", new String[]{"name", "has_source", "source_file", "source_line", "pc_formatted", "is_active_i", "warp_id", "lane_id"});
        private static LabelText INACTIVE_THREAD_TEXT = new LabelText("CUDA Thread {0}", new String[]{"name"});

        private ThreadLabel() {
        }

        public void updateAttribute(ILabelUpdate update, int columnIndex, IStatus status, Map<String, Object> properties) {
            Object isActive = properties.get("is_active_i");
            if (CoreUtil.equals((Object)isActive, (Object)1)) {
                ACTIVE_THREAD_TEXT.updateAttribute(update, columnIndex, status, properties);
            } else {
                INACTIVE_THREAD_TEXT.updateAttribute(update, columnIndex, status, properties);
            }
        }

        public String[] getPropertyNames() {
            return ACTIVE_THREAD_TEXT.getPropertyNames();
        }

        public boolean isEnabled(IStatus status, Map<String, Object> properties) {
            return true;
        }
    }

    public class ThreadVMContext
    extends AbstractDMVMNode.DMVMContext
    implements IDMVMContext {
        public ThreadVMContext(IDMContext dmc) {
            super((AbstractDMVMNode)DeviceThreadVMNode.this, dmc);
        }

        public Object getAdapter(Class adapter) {
            if (IDataContextProvider.class.equals((Object)adapter)) {
                return new IDataContextProvider(){

                    @Override
                    public void getDataContext(Object element, final DataRequestMonitor<IDMVMContext> rm) {
                        DeviceThreadVMNode.this.getTopStackFrame(element, new DataRequestMonitor<IStack.IFrameDMContext>(DeviceThreadVMNode.this.getExecutor(), rm){

                            protected void handleSuccess() {
                                if (this.getData() != null) {
                                    rm.setData((Object)new AbstractDMVMNode.DMVMContext((AbstractDMVMNode)DeviceThreadVMNode.this, (IDMContext)this.getData()));
                                }
                                rm.done();
                            }
                        });
                    }
                };
            }
            return super.getAdapter(adapter);
        }
    }
}

