/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;

public final class MultiDataRequestMonitor<T>
extends DataRequestMonitor<T> {
    private final Queue<DataRequestMonitor<T>> children = new ConcurrentLinkedQueue<DataRequestMonitor<T>>();
    private final AtomicBoolean done = new AtomicBoolean(false);

    public MultiDataRequestMonitor() {
        super(ImmediateExecutor.getInstance(), null);
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    protected void handleCompleted() {
        if (this.done.compareAndSet(false, true)) {
            this.flushQueue();
        }
    }

    private synchronized void flushQueue() {
        while (!this.children.isEmpty()) {
            DataRequestMonitor<T> child = this.children.poll();
            if (this.isCanceled()) {
                child.cancel();
            } else if (this.isSuccess()) {
                child.setStatus(this.getStatus());
                child.setData(this.getData());
            } else {
                child.setStatus(this.getStatus());
            }
            child.done();
        }
    }

    public void enqueue(DataRequestMonitor<T> child) {
        this.children.add(child);
        if (this.done.get()) {
            this.flushQueue();
        }
    }
}

