/*################################################################################
# Linux Management Providers (LMP), DHCP provider package
# Copyright (C) 2009 Khahramon NURIDDINOV, qahramon0786@gmail.com,TUIT
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################*/

#include "OpenDRIM_RegisteredDHCPProfileAccess.h"

string InstanceID="OpenDRIM:DHCP:1.0.1";

int DHCP_OpenDRIM_RegisteredDHCPProfile_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int DHCP_OpenDRIM_RegisteredDHCPProfile_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int DHCP_OpenDRIM_RegisteredDHCPProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RegisteredDHCPProfile>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_RegisteredDHCPProfile instance;
	instance.setInstanceID(InstanceID);

	if(discriminant=="ei")
		CF_assert(DHCP_OpenDRIM_RegisteredDHCPProfile_populate(instance, errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int DHCP_OpenDRIM_RegisteredDHCPProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RegisteredDHCPProfile& instance, const char** properties, string& errorMessage) {
	_E_;
	if(instance.InstanceID!=InstanceID)
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}
	CF_assert(DHCP_OpenDRIM_RegisteredDHCPProfile_populate(instance, errorMessage));
	_L_;
	return OK;
}

int DHCP_OpenDRIM_RegisteredDHCPProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredDHCPProfile& newInstance, const OpenDRIM_RegisteredDHCPProfile& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DHCP_OpenDRIM_RegisteredDHCPProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredDHCPProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DHCP_OpenDRIM_RegisteredDHCPProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredDHCPProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DHCP_OpenDRIM_RegisteredDHCPProfile_populate(OpenDRIM_RegisteredDHCPProfile& instance, string& errorMessage) {
	_E_;
	vector<unsigned short> AdvertiseTypes;
	
	//Registred name of profile which is listed in Standard
	instance.setRegisteredName("DHCP Client");
	
	//Registred version of Profile
	instance.setRegisteredVersion("1.0.1");
	
	// Profile Registred organization - 2 (DMTF)
	instance.setRegisteredOrganization(2);

	// Advertise Types - 2 (Not Advertised)
	AdvertiseTypes.push_back(2); 
	instance.setAdvertiseTypes(AdvertiseTypes);
	_L_;
	return OK;
}

