#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Harry Potter and the Mysterious Thief - Part 2
# send your bug reports to contact@dotslashplay.it
###

script_version=20240912.2

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='harry-potter-and-the-mysterious-thief-part-2'
GAME_NAME='Harry Potter and the Mysterious Thief - Part 2'

ARCHIVE_BASE_0_NAME='HPatMTp2-linux.tar.bz2'
ARCHIVE_BASE_0_MD5='e3505e2a2ba06f645092c6e53c344ca2'
ARCHIVE_BASE_0_SIZE='120000'
ARCHIVE_BASE_0_VERSION='1.0-itch.2020.12.01'
ARCHIVE_BASE_0_URL='https://rivarsstudio.itch.io/harry-potter-and-the-mysterious-thief-part-ii'

CONTENT_PATH_DEFAULT='HPatMTp2-linux/game'
CONTENT_GAME_MAIN_FILES='
cache
archive.rpa
script_version.txt'

APP_MAIN_TYPE='renpy'

## Ensure easy upgrades from packages generated with pre-20240912.2 game scripts
PKG_MAIN_PROVIDES="${PKG_MAIN_PROVIDES:-}
harry-potter-and-the-mysterious-thief-part2
harry-potter-and-the-mysterious-thief-part2-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Write launchers

## Use the default Ren'Py icon if it is available
desktop_field_icon() {
	printf 'renpy'
}

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
