#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Dark Eye: Chains of Satinav
# send your bug reports to contact@dotslashplay.it
###

script_version=20250110.4

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='the-dark-eye-chains-of-satinav'
GAME_NAME='The Dark Eye: Chains of Satinav'

ARCHIVE_BASE_1_NAME='the_dark_eye_chains_of_satinav_3_0_351_5509_79138.sh'
ARCHIVE_BASE_1_MD5='4e7b0723a18d57154279808f230d6523'
ARCHIVE_BASE_1_SIZE='2449354'
ARCHIVE_BASE_1_VERSION='3.0.351.5509-gog79138'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/the_dark_eye_chains_of_satinav'

ARCHIVE_BASE_0_NAME='the_dark_eye_chains_of_satinav_3_0_351_5499_78872.sh'
ARCHIVE_BASE_0_MD5='56fb3b52b8bfa983bf983c9a77d0901c'
ARCHIVE_BASE_0_SIZE='2449352'
ARCHIVE_BASE_0_VERSION='3.0.351.5499-gog78872'

VISIONAIRE_NAME='satinav'

CONTENT_PATH_DEFAULT='data/noarch/game'
## The shipped build of OpenAL must be used, to avoid a missing symbol error:
## symbol lookup error: ./satinav: undefined symbol: SelectResampler
CONTENT_LIBS0_BIN_RELATIVE_PATH='libs64'
CONTENT_LIBS0_BIN_FILES='
libopenal.so'

APP_MAIN_ICON='../support/icon.png'

PKG_BIN_ARCH='64'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
