#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A Hat in Time
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220727.1

GAME_ID='a-hat-in-time'
GAME_NAME='A Hat in Time'

ARCHIVE_BASE_0='setup_a_hat_in_time_nyakuza_metro_1.12_(64bit)_(35607).exe'
ARCHIVE_BASE_0_MD5='b488a803f372891556adde2589b87643'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_a_hat_in_time_nyakuza_metro_1.12_(64bit)_(35607)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='c0b7186f04d9d07baa835cd4186a5fb9'
ARCHIVE_BASE_0_PART2='setup_a_hat_in_time_nyakuza_metro_1.12_(64bit)_(35607)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='7ce5f0d9d40007cb4c12e9312f0cfc57'
ARCHIVE_BASE_0_SIZE='8000000'
ARCHIVE_BASE_0_VERSION='1.12-gog35607'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/a_hat_in_time'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN_FILES='
binaries
engine'
ARCHIVE_GAME_DATA_FILES='
hatintimegame'
ARCHIVE_GAME0_BIN_PATH='app'
ARCHIVE_GAME0_BIN_FILES='
engine'
ARCHIVE_GAME0_DATA_PATH='app'
ARCHIVE_GAME0_DATA_FILES='
hatintimegame'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='binaries/win64/hatintimegame.exe'
APP_MAIN_ICON="${CONTENT_PATH_DEFAULT}/binaries/win64/hatintimegame.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# .NET Framework 4 is required for controller support

PKG_BIN_DEPS="$PKG_BIN_DEPS winetricks"
APP_WINETRICKS="$APP_WINETRICKS dotnet40"
APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Do not disable mscoree.dll
# This game relies on .NET framework for controller support
export WINEDLLOVERRIDES=winemenubuilder.exe,mshtml=d'

# Load common functions

target_version='2.17'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icon

PKG='PKG_DATA'
icons_get_from_workdir 'APP_MAIN'

# Include game data

prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
