#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Golden Treasure
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220208.4

# Set game-specific variables

GAME_ID='golden-treasure'
GAME_NAME='Golden Treasure'

ARCHIVE_BASE_0='gt1-pc-release.zip'
ARCHIVE_BASE_0_MD5='97006803c1293df85b9ffe553b5785ff'
ARCHIVE_BASE_0_SIZE='2400000'
ARCHIVE_BASE_0_VERSION='1.1.3.190711-itch'
ARCHIVE_BASE_0_URL='https://dreaming-door.itch.io/gt1'

UNITY3D_NAME='Golden Treasure - The Great Green'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN_FILES='
UnityPlayer.dll
Golden?Treasure?-?The?Great?Green.exe
Golden?Treasure?-?The?Great?Green_Data/Plugins
MonoBleedingEdge'
ARCHIVE_GAME_DATA_FILES='
Golden?Treasure?-?The?Great?Green_Data'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE="${UNITY3D_NAME}.exe"
APP_MAIN_ICON="${UNITY3D_NAME}.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Use persistent storage for user data

APP_WINE_LINK_DIRS='
userdata:users/${USER}/AppData/LocalLow/Dreaming Door Studios/Golden Treasure - The Great Green'
DATA_DIRS='userdata/Saves'

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Include game icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'

# Delete temporary directories

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
