#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 macaron
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Indiana Jones and the Last Crusade
# send your bug reports to contact@dotslashplay.it
###

script_version=20231004.1

PLAYIT_COMPATIBILITY_LEVEL='2.26'

GAME_ID='indiana-jones-and-the-last-crusade'
GAME_NAME='Indiana Jones and the Last Crusade'

ARCHIVE_BASE_0_NAME='indiana_jones_and_the_last_crusade_en_gog_2_20145.sh'
ARCHIVE_BASE_0_MD5='b00d2c5498376718caad19db54265b29'
ARCHIVE_BASE_0_SIZE='90000'
ARCHIVE_BASE_0_VERSION='1.0-gog20145'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/indiana_jones_and_the_last_crusade'

CONTENT_PATH_DEFAULT='data/noarch/data'
CONTENT_GAME_MAIN_FILES='
*.lfl'
CONTENT_DOC_MAIN_PATH="${CONTENT_PATH_DEFAULT}/../docs"
CONTENT_DOC_MAIN_FILES='
*.txt'

APP_MAIN_SCUMMID='scumm:indy3'
APP_MAIN_ICON='../support/icon.png'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

icons_inclusion
content_inclusion_default

# Write launchers

launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
