#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Pirates Gold
# send your bug reports to contact@dotslashplay.it
###

script_version=20221217.4

GAME_ID='pirates-gold'
GAME_NAME='Pirates Gold'

ARCHIVE_BASE_1='gog_pirates_gold_2.0.0.9.sh'
ARCHIVE_BASE_1_MD5='1eec642e9d7337b9456775d110760a80'
ARCHIVE_BASE_1_TYPE='mojosetup'
ARCHIVE_BASE_1_SIZE='39000'
ARCHIVE_BASE_1_VERSION='1.0-gog2.0.0.9'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/pirates_gold_plus'

ARCHIVE_BASE_0='gog_pirates_gold_2.0.0.8.sh'
ARCHIVE_BASE_0_MD5='ea602d91950cffa615abae567f498989'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='39000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.8'

CONTENT_PATH_DEFAULT='data/noarch/data'
CONTENT_GAME_MAIN_FILES='
DATA.DAT
MPS
PIRATESC
PIRATESG.CD'
CONTENT_DOC_MAIN_PATH='data/noarch/docs'
CONTENT_DOC_MAIN_FILES='
flags.pdf
manual.pdf'

GAME_IMAGE='DATA.DAT'
GAME_IMAGE_TYPE='iso'

APP_MAIN_TYPE='dosbox'
APP_MAIN_PRERUN='d:
cd PIRATESG.CD
lh cdpatch %1'
APP_MAIN_EXE='PIRATESG.EXE'
APP_MAIN_OPTION='%2 %3 %4 %5'
APP_MAIN_POSTRUN='cdpatch x'
APP_MAIN_ICON='../support/icon.png'

PKG_MAIN_DEPS='dosbox'

# Load common functions

target_version='2.19'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

## Bypass the binary presence check,
## the game binary is included in the disk image.
launcher_target_presence_check() { true ; }
launchers_write

# Build package

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
