#!/bin/sh

oneTimeSetUp() {
	# Load the ./play.it library
	export LIB_ONLY=1
	. lib/libplayit2.sh
}

test_persistent_list_directories() {
	local \
		persistent_directories persistent_directories_expected \
		USER_PERSISTENT_DIRECTORIES \
		CONFIG_DIRS DATA_DIRS PLAYIT_COMPATIBILITY_LEVEL

	USER_PERSISTENT_DIRECTORIES='
mods
users'
	persistent_directories=$(persistent_list_directories)
	persistent_directories_expected='mods
users'
	assertEquals "$persistent_directories_expected" "$persistent_directories"
	unset USER_PERSISTENT_DIRECTORIES

	# Check support for legacy variables
	PLAYIT_COMPATIBILITY_LEVEL='2.16'
	CONFIG_DIRS='./drivers'
	DATA_DIRS='./badges ./banners ./playback ./profiles ./screenshots ./stats'
	persistent_directories=$(persistent_list_directories)
	persistent_directories_expected='./drivers
./badges
./banners
./playback
./profiles
./screenshots
./stats'
	assertEquals "$persistent_directories_expected" "$persistent_directories"
	unset CONFIG_DIRS DATA_DIRS

	# Check that empty values do not trigger an error
	assertTrue 'persistent_list_directories'
}

test_persistent_list_files() {
	local \
		persistent_files persistent_files_expected \
		USER_PERSISTENT_FILES \
		CONFIG_FILES DATA_FILES PLAYIT_COMPATIBILITY_LEVEL

	USER_PERSISTENT_FILES='
*.cfg
*.dat
player-data.json'
	persistent_files=$(persistent_list_files)
	persistent_files_expected='*.cfg
*.dat
player-data.json'
	assertEquals "$persistent_files_expected" "$persistent_files"
	unset USER_PERSISTENT_FILES

	# Check support for legacy variables
	PLAYIT_COMPATIBILITY_LEVEL='2.16'
	CONFIG_FILES='./userdata/*.ini'
	DATA_FILES='./userdata/*.sav ./userdata/*.png'
	persistent_files=$(persistent_list_files)
	persistent_files_expected='./userdata/*.ini
./userdata/*.sav
./userdata/*.png'
	assertEquals "$persistent_files_expected" "$persistent_files"
	unset CONFIG_FILES DATA_FILES

	# Check that empty values do not trigger an error
	assertTrue 'persistent_list_files'
}
