=begin
= Ruby/PGPLOT

A Ruby interface to the
((<PGPLOT|URL:http://astro.caltech.edu/~tjp/pgplot/>))
graphics library.

* ((<Repository(GitHub)|URL:https://github.com/masa16/ruby-pgplot>))

== Requirement

* ((<PGPLOT Library|URL:http://www.astro.caltech.edu/~tjp/pgplot/>))
* GNU FORTRAN compiler
* ((<NArray|URL:http://narray.rubyforge.org/>)) version 0.5/0.6

== Download

* ((<version 0.1.6|URL:https://github.com/masa16/ruby-pgplot/tarball/0.1.6>))

== Installation

* PGPLOT
  * ((<in Japanese|URL:install.html.ja>))
  * ((<original site|URL:http://www.astro.caltech.edu/~tjp/pgplot/install.html>))
* Install Ruby/PGPLOT
  * ((<in English|URL:README>))
  * ((<in Japanese|URL:README.ja>))

== Examples

* ((<(({pgline})) : Line plot|URL:pgline.html>))
* ((<(({pghist})) : Histogram plot|URL:pghist.html>))
* ((<(({pgcont})) : Contour map|URL:pgcont.html>))
* ((<(({pgimag})) : Image map|URL:pgimag.html>))

== Manual

* ((<Method index Categorized|URL:rbpg-ind.html>))
* ((<Method index and Description|URL:rbpgplot.html>))
* ((<Tutorial|URL:tutorial-01.html.ja>)) (in Japanese)
* ((<Reference|URL:method.html.ja>)) (in Japanese)

== Link

* ((<Rongo|URL:http://jun.artcompsci.org/softwares/rongo/>))
  - simple mongo-like plotting library using Ruby/PGPLOT.

=end
